/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelAccumulationRate;
import jsbchart.panel.PanelAgeCurve;
import jsbchart.panel.PanelBiocoms;
import jsbchart.panel.PanelBiozones;
import jsbchart.panel.PanelBlank;
import jsbchart.panel.PanelCasing;
import jsbchart.panel.PanelChromalog;
import jsbchart.panel.PanelCompositeStandard;
import jsbchart.panel.PanelCoreImages;
import jsbchart.panel.PanelCores;
import jsbchart.panel.PanelEnv;
import jsbchart.panel.PanelEvents;
import jsbchart.panel.PanelIntLith;
import jsbchart.panel.PanelIntcoms;
import jsbchart.panel.PanelLithostratScheme;
import jsbchart.panel.PanelMarkers;
import jsbchart.panel.PanelRange;
import jsbchart.panel.PanelSQPicks;
import jsbchart.panel.PanelSampleLithology;
import jsbchart.panel.PanelSamples;
import jsbchart.panel.PanelScale;
import jsbchart.panel.PanelSurfaces;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelWellDepthAge;
import jsbchart.panel.PanelWellVS;
import jsbchart.panel.PanelWirelineLog;
import jsbchart.panel.PanelZones;
import jsbchart.panel.SBPanel;
import jsbchart.panel.panelIGDScheme.PanelIGDScheme;
import jsbchart.panel.spatial.LayerAccumulationRate;
import jsbchart.panel.spatial.LayerDataCoverage;
import jsbchart.panel.spatial.LayerEnv;
import jsbchart.panel.spatial.LayerLithology;
import jsbchart.panel.spatial.LayerPresenceAbsence;
import jsbchart.panel.spatial.LayerShape;
import jsbchart.panel.spatial.LayerSuCrop;
import jsbchart.panel.spatial.LayerTaxon;
import jsbchart.panel.spatial.LayerWellLocation;
import jsbchart.panel.spatial.SidetrackLayer;
import util.SBException;

public class PanelFactory {
    private PanelFactory() {
    }

    public static ChartPanel createPanel(ChartBlockBase block, PanelTemplate template, PanelOcc occ) throws SQLException, SBException {
        assert (template != null);
        assert (template.getType().canPlot(block.getBlockType()));
        switch (template.getType()) {
            case SCALE: {
                return new PanelScale(template, (ChartBlock)block, occ);
            }
            case SAMPLES: {
                return new PanelSamples(template, (WellBlock)block, occ);
            }
            case BIOCOMS: {
                return new PanelBiocoms(template, (WellBlock)block, occ);
            }
            case SQPICK: {
                return new PanelSQPicks(template, (WellBlock)block, occ);
            }
            case SURFACE: {
                return new PanelSurfaces(template, (SchemeBlock)block, occ);
            }
            case CHRONOSCHEME: 
            case BIOSCHEME: 
            case SEQUENCE: 
            case MAGNETOSCHEME: {
                return new PanelIGDScheme(template, (SchemeBlock)block, occ);
            }
            case LITHOSCHEME: {
                return new PanelLithostratScheme(template, (SchemeBlock)block, occ);
            }
            case EVENT: {
                return new PanelEvents(template, occ, (WellBlock)block);
            }
            case CMPSTD: {
                return new PanelCompositeStandard(template, occ, (SchemeBlock)block);
            }
            case CHRONOZONE: 
            case LITHOZONE: {
                return new PanelZones(template, occ, (WellBlock)block);
            }
            case MICROZONE: 
            case PALYZONE: 
            case NANNOZONE: 
            case MACROZONE: {
                return new PanelBiozones(template, occ, (WellBlock)block);
            }
            case SAMPLELITH: {
                return new PanelSampleLithology(template, (WellBlock)block, occ);
            }
            case INTLITH: {
                return new PanelIntLith(template, (WellBlock)block, occ);
            }
            case DEPTHAGE: 
            case SUBSIDENCE: {
                return new PanelWellDepthAge((WellBlock)block, template, occ);
            }
            case ACCUMRATE: {
                return new PanelAccumulationRate((WellBlock)block, template, occ);
            }
            case MICRO: 
            case PALY: 
            case NANNO: 
            case MACRO: {
                return new PanelTaxonGroup((WellBlock)block, template, occ);
            }
            case VS: {
                return new PanelWellVS((WellBlock)block, template, occ);
            }
            case RANGE: {
                return new PanelRange((SchemeBlock)block, template, occ);
            }
            case AGECURVE: {
                return new PanelAgeCurve(template, (SchemeBlock)block, occ);
            }
            case ENV: {
                return new PanelEnv(template, (WellBlock)block, occ);
            }
            case CASING: {
                return new PanelCasing(template, (WellBlock)block, occ);
            }
            case MARKERS: {
                return new PanelMarkers(template, (WellBlock)block, occ);
            }
            case CORES: {
                return new PanelCores(template, (WellBlock)block, occ);
            }
            case COREIMAGES: {
                return new PanelCoreImages(template, (WellBlock)block, occ);
            }
            case WLOG: {
                return new PanelWirelineLog(template, (WellBlock)block, occ);
            }
            case INTCOM: {
                return new PanelIntcoms(template, (WellBlock)block, occ);
            }
            case CHROMALOG: {
                return new PanelChromalog(template, (WellBlock)block, occ);
            }
            case BLANK: {
                return new PanelBlank(template, (ChartBlock)block, occ);
            }
            case PIN: {
                return new LayerWellLocation(template, occ, (MapBlock)block);
            }
            case SHAPE: {
                return new LayerShape(template, occ, (MapBlock)block);
            }
            case ENVLAYER: {
                return new LayerEnv(template, occ, (MapBlock)block);
            }
            case LITHLAYER: {
                return new LayerLithology(template, occ, (MapBlock)block);
            }
            case SETLAYER: {
                return new LayerTaxon(template, occ, (MapBlock)block);
            }
            case COVERAGE: {
                return new LayerDataCoverage(template, occ, (MapBlock)block);
            }
            case S_CROP_LAYER: {
                return new LayerSuCrop(template, occ, (MapBlock)block);
            }
            case PRESABSLAYER: {
                return new LayerPresenceAbsence(template, occ, (MapBlock)block);
            }
            case ACCUMRATELAYER: {
                return new LayerAccumulationRate(template, occ, (MapBlock)block);
            }
            case SIDETRACKLAYER: {
                return new SidetrackLayer(template, occ, (MapBlock)block);
            }
        }
        throw new IllegalStateException("Cannot create panel type: " + String.valueOf(template.getType()));
    }

    public static SBPanel createBlankPanel(ChartBlock block) {
        return new PanelBlank(block);
    }
}

