/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

public class PanelIntLithProperties
extends PanelProperties {
    float width = 40.0f;
    boolean drawQualifiers = true;
    boolean dunham = true;
    PanelProperties.ColumnWidth grainSizeColumn = new PanelProperties.ColumnWidth(40.0f, false);
    static final float DEFAULT_COLUMN_WIDTH = 40.0f;
    boolean scaleIntervals = false;
    private static final int PROP_WIDTH = 0;
    private static final int PROP_QUALIFIERS = 1;
    private static final int PROP_GRAIN_SIZE = 2;
    private static final int PROP_DUNHAM = 3;
    private static final int PROP_SCALE_INTERVALS = 4;
    private static final String[] propNames = new String[]{"Panel width", "Qualifiers", "Grain size", "Dunham scale", "Filter intervals to scale"};

    PanelIntLithProperties(String props) {
        super(PanelType.INTLITH);
        if (props == null) {
            return;
        }
        String[] split = props.split("\\|");
        block7: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    this.width = Float.parseFloat(split[i]);
                    continue block7;
                }
                case 1: {
                    this.grainSizeColumn = new PanelProperties.ColumnWidth(Float.parseFloat(split[i]), 40.0f, true);
                    continue block7;
                }
                case 2: {
                    this.drawQualifiers = Integer.parseInt(split[i]) > 0;
                    continue block7;
                }
                case 3: {
                    this.dunham = Integer.parseInt(split[i]) > 0;
                    continue block7;
                }
                case 4: {
                    this.scaleIntervals = Integer.parseInt(split[i]) > 0;
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[]{"" + this.width, "" + this.grainSizeColumn.width(), "" + (this.drawQualifiers ? 1 : 0), "" + (this.dunham ? 1 : 0), "" + (this.scaleIntervals ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 2: {
                return this.grainSizeColumn;
            }
            case 1: {
                return this.drawQualifiers;
            }
            case 3: {
                return this.dunham;
            }
            case 4: {
                return this.scaleIntervals;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 2: {
                    PanelProperties.ColumnWidth w = (PanelProperties.ColumnWidth)prop;
                    if (w.width() == 0.0f || w.width() >= 5.0f && w.width() <= 100.0f) {
                        this.grainSizeColumn = w;
                        return true;
                    }
                    return false;
                }
                case 1: {
                    this.drawQualifiers = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.dunham = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.scaleIntervals = (Boolean)prop;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 5.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    public boolean isScaleIntervals() {
        return this.scaleIntervals;
    }

    public String getScaleIntervalsPropertyName() {
        return this.getPropertyName(4);
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            default: {
                return Integer.class;
            }
            case 2: {
                return PanelProperties.ColumnWidth.class;
            }
            case 1: 
            case 3: 
            case 4: 
        }
        return Boolean.class;
    }

    @Override
    public PanelProperties copy() {
        return PanelIntLithProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelIntLithProperties)) {
            throw new IllegalArgumentException("PanelIntLithProperties cannot copy " + String.valueOf(pp));
        }
        PanelIntLithProperties rhs = (PanelIntLithProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public static PanelIntLithProperties createCopy(PanelIntLithProperties rhs) {
        PanelIntLithProperties p = new PanelIntLithProperties(null);
        p.copy(rhs);
        return p;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 3: {
                return this.grainSizeColumn.show();
            }
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        switch (nProp) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Float.floatToIntBits(this.width);
        hash = 37 * hash + (this.drawQualifiers ? 1 : 0);
        hash = 37 * hash + (this.dunham ? 1 : 0);
        hash = 37 * hash + Objects.hashCode(this.grainSizeColumn);
        hash = 37 * hash + (this.scaleIntervals ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelIntLithProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelIntLithProperties rhs = (PanelIntLithProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block4;
                    return false;
                }
                case 2: {
                    if (this.grainSizeColumn.isSimilarTo(rhs.grainSizeColumn)) continue block4;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

