/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextResizer;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextWrapper;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.panel.PanelIntcomsProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanel;
import model3.Intcom;
import model3.InterpHdr;
import model3.SBdb;
import model3.WellInterp;
import model3.WsWell;
import util.DepthUtils;
import util.SB;
import util.SBException;

class PanelIntcoms
extends SBPanel {
    private final WellBlock block;
    private PanelIntcomsProperties p;
    private static final float COMMENT_PADDING = 1.5f;
    private static final float COMMENT_OUTER_PADDING_TOP_BASE = 0.9f;
    private static final float COMMENT_OUTER_PADDING_LEFT_RIGHT = 1.0f;
    private static final float MIN_COMMENT_FONT_SIZE = 2.0f;
    private static List<Intcom.Builder> TEMPLATE_DATA;

    PanelIntcoms(PanelTemplate template, WellBlock block, PanelOcc occ) throws SBException, SQLException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelIntcomsProperties)template.getProperties();
        this.init();
    }

    private void init() throws SBException, SQLException {
        if (this.block.getWell() != null) {
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        float panelY = (bp == this.block.getProp() ? 0.0f : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode);
        boolean panelVisible = g.isVisible(x, panelY, this.getWidth(bp), bp.getHeight());
        if (!panelVisible && cp.key == null) {
            return x + this.getWidth(bp);
        }
        try {
            this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
            WellInterp interp = null;
            if (this.block.getWell() != null) {
                this.block.getWell().loadInterps();
                interp = this.block.getWell().getInterp(this.getInterpID(this.block));
                this.block.getWell().loadInterp(interp);
            }
            g.setStroke(0.2f);
            float fontSize = cp.getFontSize(this.p.fontSize);
            g.setFont(cp.font, 0, fontSize);
            Iterator<Object> it = interp != null ? interp.getIntcoms().iterator() : PanelIntcoms.getTemplateData().iterator();
            g.setColor(cp.foreground);
            PanelIntcoms.drawCommentColumn(it, g, this.block, cp, bp, this.p, x, y + this.getPanelHeaderHeight(cp, mode));
        }
        catch (Exception sbe) {
            this.handleException(g, x, y, cp, bp, sbe);
        }
        return x + this.getWidth(bp);
    }

    static void drawCommentColumn(Iterator it, SBGraphics g, WellBlock block, ChartProperties cp, BlockProperties bp, PanelIntcomsProperties p, float x, float colTop) {
        float blockTop = bp == block.getProp() ? block.getTopDepth() : bp.getMin();
        float blockBase = bp == block.getProp() ? block.getBaseDepth() : bp.getMax();
        g.setStroke(0.1f);
        g.setColor(cp.foreground);
        while (it.hasNext()) {
            float baseY;
            boolean showBaseDepth;
            String comment;
            double intcomBaseDepth;
            double intcomTopDepth;
            Object o = it.next();
            if (o instanceof Intcom) {
                Intcom intcom = (Intcom)o;
                intcomTopDepth = intcom.getTopDepth();
                intcomBaseDepth = intcom.getBaseDepth();
                comment = intcom.getComments();
            } else {
                Intcom.Builder builder = (Intcom.Builder)o;
                intcomTopDepth = builder.getTopDepth();
                intcomBaseDepth = builder.getBaseDepth();
                comment = builder.getComment();
            }
            if (intcomBaseDepth < (double)blockTop || intcomTopDepth > (double)blockBase) continue;
            boolean showTopDepth = p.showDepths && intcomTopDepth >= (double)blockTop;
            boolean bl = showBaseDepth = p.showDepths && intcomBaseDepth <= (double)blockBase;
            float topY = colTop + (intcomTopDepth > (double)blockTop ? block.scaleDepth((float)intcomTopDepth) : (bp == block.getProp() ? 0.0f : block.scaleDepth(bp.getMin())));
            if (g.isVisible(x, Math.min(topY, baseY = colTop + (intcomBaseDepth > (double)blockBase ? block.scaleDepth(blockBase) : block.scaleDepth((float)intcomBaseDepth))), p.panelWidth, Math.abs(baseY - topY))) {
                g.drawLine(x, topY, x + p.panelWidth, topY);
                g.drawLine(x, baseY, x + p.panelWidth, baseY);
                PanelIntcoms.plotComment(g, cp, x, topY, baseY, intcomTopDepth, intcomBaseDepth, comment, p, showTopDepth, showBaseDepth, block.getProp().getUnits(), block.getWellType(), true);
                continue;
            }
            if (cp.key == null) continue;
            PanelIntcoms.plotComment(g, cp, x, topY, baseY, intcomTopDepth, intcomBaseDepth, comment, p, showTopDepth, showBaseDepth, block.getProp().getUnits(), block.getWellType(), false);
        }
    }

    static void plotComment(SBGraphics g, ChartProperties cp, float x, float intcomTopY, float intcomBaseY, double topDepth, double baseDepth, String comment, PanelIntcomsProperties panelProps, boolean showTopDepth, boolean showBaseDepth, char units, char wellType, boolean isVisible) {
        String[] l;
        String remaining;
        float initialCommentFontSize = cp.getFontSize(panelProps.fontSize);
        ITextMeasurer m = g.getTextMeasurer();
        SBFont depthFont = new SBFont(g.getFont().getFontName(), g.getFont().getStyle(), PanelIntcoms.getDepthFontSize(cp));
        float depthLineHeight = m.calculateHorizontalLineHeight(depthFont);
        SBFont initialCommentFont = new SBFont(g.getFont().getFontName(), g.getFont().getStyle(), initialCommentFontSize);
        float commentLineHeight = m.calculateHorizontalLineHeight(initialCommentFont);
        String depthStringAtTopY = "";
        if (showTopDepth) {
            double depthValueAtTopY = intcomTopY < intcomBaseY ? topDepth : baseDepth;
            depthStringAtTopY = SB.floatString((double)DepthUtils.convFromM((double)depthValueAtTopY, (char)units, (char)wellType), (int)2).trim();
        }
        String depthStringAtBaseY = "";
        if (showBaseDepth) {
            double depthValueAtBaseY = intcomTopY < intcomBaseY ? baseDepth : topDepth;
            depthStringAtBaseY = SB.floatString((double)DepthUtils.convFromM((double)depthValueAtBaseY, (char)units, (char)wellType), (int)2).trim();
        }
        Rectangle2D.Float totalArea = PanelIntcoms.calculateTotalCommentArea(x, intcomTopY, panelProps.panelWidth, intcomBaseY);
        boolean drawDepth = panelProps.showDepths;
        if (totalArea.height < depthLineHeight) {
            drawDepth = false;
        }
        Rectangle2D.Float commentArea = drawDepth ? PanelIntcoms.drawCommentDepths(depthFont, showTopDepth, g, depthStringAtTopY, totalArea, showBaseDepth, depthStringAtBaseY, commentLineHeight, m, isVisible) : new Rectangle2D.Float(totalArea.x + 1.5f, totalArea.y, totalArea.width - 3.0f, totalArea.height);
        SBFont minCommentFont = new SBFont(g.getFont().getFontName(), g.getFont().getStyle(), 2.0f);
        float minCommentLineHeight = m.calculateHorizontalLineHeight(minCommentFont);
        if (!panelProps.shrinkText && commentArea.height < commentLineHeight || commentArea.height < minCommentLineHeight) {
            int key = cp.getKeyData().putText(comment);
            String unplacedKey = "*" + String.valueOf(cp.key != null ? Integer.valueOf(key) : "");
            Rectangle2D.Float a = new Rectangle2D.Float(x, totalArea.y - initialCommentFontSize, panelProps.panelWidth, initialCommentFontSize);
            TextSettings settings = new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Bottom, TextDirection.Horizontal, initialCommentFont);
            g.renderLinesWithinBox(unplacedKey, a, settings);
            return;
        }
        TextSettings initialSettings = PanelIntcoms.calculateInitialCommentTextSettings(panelProps.aligmnet, initialCommentFont);
        TextWrapper wrapper = new TextWrapper(m);
        wrapper.setTruncateAtWord(true);
        TextResizer resizer = new TextResizer(m, wrapper, initialSettings);
        float minSize = initialCommentFontSize;
        if (panelProps.shrinkText) {
            minSize = 2.0f;
        }
        if (!(remaining = resizer.getRemainingText(comment, l = resizer.resizeLinesToFit(comment, new DimensionF(commentArea.width, commentArea.height), minSize, true))).isEmpty()) {
            int key = cp.getKeyData().putText(remaining);
            int n = l.length - 1;
            l[n] = l[n] + "*" + String.valueOf(cp.key != null ? Integer.valueOf(key) : "");
        }
        if (isVisible) {
            g.renderLinesWithinBox(l, commentArea, resizer.getUpdatedSettings());
        }
    }

    private static TextSettings calculateInitialCommentTextSettings(PanelIntcomsProperties.TextAligmnet alignment, SBFont initialCommentFont) {
        HorizontalAlignment hoz = HorizontalAlignment.Centre;
        switch (alignment) {
            case CENTRE: {
                hoz = HorizontalAlignment.Centre;
                break;
            }
            case LEFT: {
                hoz = HorizontalAlignment.Left;
                break;
            }
            case RIGHT: {
                hoz = HorizontalAlignment.Right;
            }
        }
        TextSettings initialSettings = new TextSettings(hoz, VerticalAlignment.Middle, TextDirection.Horizontal, initialCommentFont);
        return initialSettings;
    }

    private static Rectangle2D.Float drawCommentDepths(SBFont depthFont, boolean showTopDepth, SBGraphics g, String depthStringAtTopY, Rectangle2D.Float totalArea, boolean showBaseDepth, String depthStringAtBaseY, float commentLineHeight, ITextMeasurer m, boolean isVisible) {
        boolean drawBetweenVertically;
        Rectangle2D.Float commentArea = new Rectangle2D.Float(totalArea.x, totalArea.y, totalArea.width, totalArea.height);
        DimensionF depthAtTopDrawn = null;
        if (showTopDepth) {
            TextSettings settings = new TextSettings(HorizontalAlignment.Left, VerticalAlignment.Top, TextDirection.Horizontal, depthFont);
            depthAtTopDrawn = m.calculateTextDimensions(depthStringAtTopY, settings);
            if (isVisible) {
                g.renderLinesWithinBox(depthStringAtTopY, totalArea, settings);
            }
        }
        DimensionF depthAtBaseDrawn = null;
        if (showBaseDepth) {
            TextSettings settings = new TextSettings(HorizontalAlignment.Right, VerticalAlignment.Bottom, TextDirection.Horizontal, depthFont);
            depthAtBaseDrawn = m.calculateTextDimensions(depthStringAtBaseY, settings);
            if (isVisible) {
                g.renderLinesWithinBox(depthStringAtBaseY, totalArea, settings);
            }
        }
        boolean bl = drawBetweenVertically = commentArea.height > 3.0f * commentLineHeight;
        if (drawBetweenVertically) {
            if (depthAtTopDrawn != null) {
                commentArea.y += depthAtTopDrawn.getHeight();
                commentArea.height -= depthAtTopDrawn.getHeight();
            }
            if (depthAtBaseDrawn != null) {
                commentArea.height -= depthAtBaseDrawn.getHeight();
            }
            commentArea.x += 1.5f;
            commentArea.width -= 3.0f;
        } else {
            if (depthAtTopDrawn != null) {
                commentArea.x += depthAtTopDrawn.getWidth();
                commentArea.width -= depthAtTopDrawn.getWidth();
                if (depthAtBaseDrawn == null) {
                    commentArea.width -= depthAtTopDrawn.getWidth();
                }
            }
            if (depthAtBaseDrawn != null) {
                commentArea.width -= depthAtBaseDrawn.getWidth();
                if (depthAtTopDrawn == null) {
                    commentArea.x += depthAtBaseDrawn.getWidth();
                    commentArea.width -= depthAtBaseDrawn.getWidth();
                }
            }
        }
        return commentArea;
    }

    private static Rectangle2D.Float calculateTotalCommentArea(float x, float intcomTopY, float panelWidth, float intcomBaseY) {
        float topY = Math.min(intcomTopY, intcomBaseY);
        float baseY = Math.max(intcomTopY, intcomBaseY);
        Rectangle2D.Float totalArea = new Rectangle2D.Float(x, topY, panelWidth, baseY - topY);
        totalArea.x += 1.0f;
        totalArea.width -= 2.0f;
        totalArea.y += 0.9f;
        totalArea.height -= 1.8f;
        return totalArea;
    }

    private static float getDepthFontSize(ChartProperties cp) {
        return cp.getFontSizeTiny();
    }

    static void plotCommentOriginal(SBGraphics g, ChartProperties cp, float x, float intcomTopY, float intcomBaseY, double topDepth, double baseDepth, String comment, float panelWidth, boolean showTopDepth, boolean showBaseDepth, boolean shrinkText, ChartProperties.FontSize fontSize, PanelIntcomsProperties.TextAligmnet alignment, char units, char wellType) {
        LinkedList<Object> lines;
        float PAD = 1.5f;
        boolean SHOW_DEPTHS = showTopDepth || showBaseDepth;
        float DEPTHS_FONT_SIZE = cp.getFontSizeTiny();
        float fs = cp.getFontSize(fontSize);
        boolean NORMAL = intcomTopY < intcomBaseY;
        String depthStringAtTopY = "";
        String depthStringAtBaseY = "";
        if (SHOW_DEPTHS) {
            depthStringAtTopY = SB.floatString((double)DepthUtils.convFromM((double)(NORMAL ? topDepth : baseDepth), (char)units, (char)wellType), (int)2).trim();
            depthStringAtBaseY = SB.floatString((double)DepthUtils.convFromM((double)(NORMAL ? baseDepth : topDepth), (char)units, (char)wellType), (int)2);
        }
        float widthAvailable = panelWidth - 3.75f;
        float heightAvailable = Math.abs(intcomTopY - intcomBaseY) - 3.0f;
        if (SHOW_DEPTHS && (heightAvailable -= g.stringHeight() * 2.0f) < g.stringHeight()) {
            g.setFontSize(DEPTHS_FONT_SIZE);
            widthAvailable -= g.stringWidth(depthStringAtTopY);
            widthAvailable -= g.stringWidth(depthStringAtBaseY);
            g.setFontSize(fs);
            if (widthAvailable < 0.0f) {
                return;
            }
            heightAvailable += g.stringHeight() * 2.0f;
        }
        g.setFontSize(fs);
        float heightRequired = 0.0f;
        boolean fits = false;
        do {
            lines = new LinkedList<Object>();
            if (g.stringWidth(comment) > widthAvailable) {
                StringTokenizer tokeniser = new StringTokenizer(comment, " ");
                Object lineText = "";
                while (tokeniser.hasMoreTokens()) {
                    boolean tokUsed = false;
                    String tok = tokeniser.nextToken();
                    if (g.stringWidth((String)lineText + tok) < widthAvailable) {
                        lineText = (String)lineText + tok + " ";
                        continue;
                    }
                    if (((String)lineText).trim().isEmpty() || g.stringWidth(((String)lineText).trim()) > widthAvailable) {
                        if (((String)lineText).trim().isEmpty()) {
                            lineText = tok;
                            tokUsed = true;
                        }
                        while (g.stringWidth((String)lineText) > widthAvailable) {
                            int i = ((String)lineText).length() - 2;
                            String substring = ((String)lineText).substring(0, i);
                            while (g.stringWidth(substring) > widthAvailable) {
                                substring = ((String)lineText).substring(0, --i);
                            }
                            lines.add(substring);
                            lineText = ((String)lineText).substring(i, ((String)lineText).length());
                        }
                    }
                    lines.add(lineText);
                    if (!tokUsed) {
                        lineText = tok + " ";
                        continue;
                    }
                    lineText = "";
                }
                lines.add(lineText);
            } else {
                lines.add(comment);
            }
            heightRequired = g.stringHeight() * (float)lines.size();
            if (shrinkText && heightAvailable < heightRequired && fs > 1.0f) {
                fs -= 0.5f;
            } else {
                fits = true;
            }
            g.setFontSize(fs);
        } while (!fits);
        if (SHOW_DEPTHS) {
            float depthStringYPos;
            float depthStringYPos2;
            g.setFontSize(DEPTHS_FONT_SIZE);
            assert (topDepth < baseDepth);
            if ((NORMAL && showTopDepth || !NORMAL && showBaseDepth) && (depthStringYPos2 = (NORMAL ? intcomTopY : intcomBaseY) + g.stringHeight()) < Math.max(intcomBaseY, intcomTopY)) {
                g.drawString(depthStringAtTopY, x + 1.0f, depthStringYPos2);
            }
            if ((NORMAL && showBaseDepth || !NORMAL && showTopDepth) && (depthStringYPos = (NORMAL ? intcomBaseY : intcomTopY) - (g.stringHeight() - g.stringHeightSB())) - g.stringHeight() > Math.min(intcomBaseY, intcomTopY)) {
                g.drawString(depthStringAtBaseY, x + panelWidth - g.stringWidth(depthStringAtBaseY) - 1.0f, depthStringYPos);
            }
        }
        float MIN_Y = Math.min(intcomTopY, intcomBaseY);
        float MAX_Y = Math.max(intcomTopY, intcomBaseY);
        float TOTAL_HEIGHT = MAX_Y - MIN_Y;
        float TOP_AVAILABLE_DRAWING_HEIGHT = MIN_Y + (TOTAL_HEIGHT - heightAvailable) / 2.0f;
        float TOP_REQUIRED_DRAWING_HEIGHT = MIN_Y + (TOTAL_HEIGHT - heightRequired) / 2.0f;
        float yPos = Math.max(TOP_AVAILABLE_DRAWING_HEIGHT, TOP_REQUIRED_DRAWING_HEIGHT);
        g.setFontSize(fs);
        if ((yPos += g.stringHeightSB()) > MAX_Y || yPos < MIN_Y) {
            int key = cp.getKeyData().putText(comment);
            String unplacedKey = "*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : "");
            g.drawString(unplacedKey, x, MIN_Y + TOTAL_HEIGHT / 2.0f, panelWidth, 0, true);
            return;
        }
        float yBase = MAX_Y - 1.5f;
        Iterator lineIterator = lines.iterator();
        while (lineIterator.hasNext()) {
            Object line = (String)lineIterator.next();
            if (yPos + g.stringHeight() > yBase && lineIterator.hasNext()) {
                line = ((String)line).trim() + "...";
                Object remainingText = "";
                while (lineIterator.hasNext()) {
                    remainingText = (String)remainingText + (String)lineIterator.next() + " ";
                }
                int key = cp.getKeyData().putText(((String)remainingText).trim());
                line = (String)line + "*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : "");
            }
            g.drawString((String)line, x, yPos, panelWidth, 0, true);
            if (!((yPos += g.stringHeight()) > yBase)) continue;
            break;
        }
    }

    public int getInterpID() {
        return this.getInterpID(this.block);
    }

    public String toString() {
        Object name = "Interval Comments";
        try {
            WellInterp wellInterp = this.block.getWell().getInterp(this.getInterpID());
            if (wellInterp != null) {
                name = "Interval Comments : " + wellInterp.getHeader().getDescription();
            }
        }
        catch (SBException sBException) {
            // empty catch block
        }
        return name;
    }

    @Override
    protected String getCaption() {
        return "Interval Comments";
    }

    @Override
    protected String getSubCaption() {
        InterpHdr hdr = this.block.getVersion(this.getInterpID(this.block));
        if (hdr != null && hdr.getInterpID() > 0) {
            return hdr.toString();
        }
        return null;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.panelWidth;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.block.getWell() == null) {
            return true;
        }
        try {
            ScaleConverter sc = this.block.getScaleConverter();
            for (Intcom intcom : this.block.getWell().getInterp(this.getInterpID(this.block)).getIntcoms()) {
                if (!sc.isWithinPlottableRange(intcom.getTopDepth(), intcom.getBaseDepth())) continue;
                return true;
            }
            return false;
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
            return false;
        }
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.block.getWell() == null) {
            return null;
        }
        float depth = this.block.getDepth(y);
        try {
            for (Intcom intcom : this.block.getWell().getInterp(this.getInterpID(this.block)).getIntcoms()) {
                if (!((double)depth > intcom.getTopDepth()) || !((double)depth < intcom.getBaseDepth())) continue;
                return intcom;
            }
        }
        catch (SBException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            Intcom intcom = (Intcom)o;
            String top = SB.floatString((double)DepthUtils.convFromM((double)intcom.getTopDepth(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType()), (int)2);
            String base = SB.floatString((double)DepthUtils.convFromM((double)intcom.getBaseDepth(), (char)this.block.getProp().getUnits(), (char)this.block.getWell().getType()), (int)2);
            return top + " - " + base;
        }
        return null;
    }

    @Override
    public void setProperties(PanelProperties pp) {
        if (!(pp instanceof PanelIntcomsProperties)) {
            throw new IllegalArgumentException("Attempt to set intcom panel properties to " + String.valueOf(pp));
        }
        this.p = (PanelIntcomsProperties)pp;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp) {
            if (((WellInterp)o).getHeader().getInterpID() == this.getInterpID(this.block)) {
                if (arg instanceof Intcom || arg instanceof Integer && (Integer)arg == 22) {
                    this.setDataChanged();
                    this.notifyListeners();
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    private static List<Intcom.Builder> getTemplateData() {
        if (TEMPLATE_DATA != null) {
            return TEMPLATE_DATA;
        }
        Intcom.Builder builder = new Intcom.Builder(null, 0, 25.0);
        builder.baseDepth(65.0);
        builder.comments("Interval comments are not based on samples and can be used to describe more general features of a section.");
        TEMPLATE_DATA = new LinkedList<Intcom.Builder>();
        TEMPLATE_DATA.add(builder);
        return TEMPLATE_DATA;
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.block.getWell() == null) {
            return null;
        }
        try {
            List intcoms = this.block.getWell().getInterp(this.getInterpID(this.block)).getIntcoms();
            if (intcoms.isEmpty()) {
                return null;
            }
            return Float.valueOf(upper ? (float)((Intcom)intcoms.get(0)).getTopDepth() : (float)((Intcom)intcoms.get(intcoms.size() - 1)).getBaseDepth());
        }
        catch (SBException sbe) {
            sbe.printStackTrace();
            return null;
        }
    }

    @Override
    public PanelIntcomsProperties getProperties() {
        return this.p;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        LinkedList<Intcom> toFill = new LinkedList<Intcom>();
        for (Intcom intcom : this.block.getWell().getInterp(this.getInterpID()).getIntcoms()) {
            if (intcom.getBaseDepth() < (double)this.block.getTopDepth() || intcom.getTopDepth() > (double)this.block.getBaseDepth()) continue;
            toFill.add(intcom);
        }
        if (!toFill.isEmpty()) {
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillIntcoms(wsWell, toFill);
            dataTypes.add(18);
        }
    }
}

