/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import jsbchart.core.ChartProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

public class PanelIntcomsProperties
extends PanelProperties {
    private static final int PROP_WIDTH = 0;
    private static final int PROP_DEPTHS = 1;
    private static final int PROP_FONT_SIZE = 2;
    private static final int PROP_TEXT_SHRINK = 3;
    private static final int PROP_ALIGNMENT = 4;
    private static final String[] PROP_NAMES = new String[]{"Panel width", "Show depths", "Font size", "Shrink text to fit", "Text Alignment"};
    float panelWidth = 70.0f;
    boolean showDepths = true;
    boolean shrinkText = false;
    ChartProperties.FontSize fontSize = ChartProperties.FontSize.TINY;
    TextAligmnet aligmnet = TextAligmnet.CENTRE;

    PanelIntcomsProperties(String prop) {
        super(PanelType.INTCOM);
        if (prop == null) {
            return;
        }
        String[] s = prop.split("\\|");
        block7: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.panelWidth = Float.parseFloat(s[i]);
                    continue block7;
                }
                case 1: {
                    this.showDepths = Integer.parseInt(s[i]) == 1;
                    continue block7;
                }
                case 2: {
                    this.fontSize = ChartProperties.FontSize.valueOf(s[i]);
                    continue block7;
                }
                case 3: {
                    this.shrinkText = Integer.parseInt(s[i]) == 1;
                    continue block7;
                }
                case 4: {
                    this.aligmnet = TextAligmnet.valueOf(s[i]);
                }
            }
        }
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return Float.valueOf(this.panelWidth);
            }
            case 1: {
                return this.showDepths;
            }
            case 2: {
                return this.fontSize;
            }
            case 3: {
                return this.shrinkText;
            }
            case 4: {
                return this.aligmnet;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    return this.setPanelWidth(prop);
                }
                case 1: {
                    this.showDepths = (Boolean)prop;
                    break;
                }
                case 2: {
                    this.fontSize = (ChartProperties.FontSize)((Object)prop);
                    break;
                }
                case 3: {
                    this.shrinkText = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.aligmnet = (TextAligmnet)((Object)prop);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(Object o) {
        float w = o instanceof Float ? ((Float)o).floatValue() : Float.parseFloat(o.toString());
        if (w > 10.0f && Math.abs((int)this.panelWidth - (int)w) >= 1) {
            this.panelWidth = w;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 3: {
                return Boolean.class;
            }
            case 2: {
                return ChartProperties.FontSize.class;
            }
            case 4: {
                return TextAligmnet.class;
            }
        }
        assert (false);
        return null;
    }

    public static PanelIntcomsProperties createCopy(PanelIntcomsProperties rhs) {
        PanelIntcomsProperties p = new PanelIntcomsProperties(null);
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelIntcomsProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelIntcomsProperties)) {
            throw new IllegalArgumentException("PanelIntcomsProperties cannot copy " + String.valueOf(pp));
        }
        PanelIntcomsProperties rhs = (PanelIntcomsProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public String getPropertiesString() {
        Object string = new String();
        String[] props = new String[]{"" + this.panelWidth, "" + (this.showDepths ? 1 : 0), this.fontSize.name(), "" + (this.shrinkText ? 1 : 0), this.aligmnet.name()};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Float.floatToIntBits(this.panelWidth);
        hash = 67 * hash + (this.showDepths ? 1 : 0);
        hash = 67 * hash + (this.shrinkText ? 1 : 0);
        hash = 67 * hash + Objects.hashCode((Object)this.fontSize);
        hash = 67 * hash + Objects.hashCode((Object)this.aligmnet);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelIntcomsProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelIntcomsProperties rhs = (PanelIntcomsProperties)comp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.panelWidth - rhs.panelWidth) > 3.0f)) continue block3;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public static enum TextAligmnet {
        LEFT("Left"),
        CENTRE("Centre"),
        RIGHT("Right");

        String stringName;

        private TextAligmnet(String stringName) {
            this.stringName = stringName;
        }

        public String toString() {
            return this.stringName;
        }
    }
}

