/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.panelIGDScheme.PanelIGDSchemeProperties;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;

public class PanelLithostratSchemeProperties
extends PanelProperties {
    private static final String[] propNames = new String[]{"Scheme", "Width", "Use abbrs.", "Key", "Lithology", "Colour", "Label Colours", "West label", "East label"};
    private static final String[] propNames2 = new String[]{"West", "East"};
    public static final int PROP_SCH = 0;
    public static final int PROP_WIDTH = 1;
    public static final int PROP_ABR = 2;
    public static final int PROP_KEY = 3;
    public static final int PROP_LITH = 4;
    public static final int PROP_COLOUR = 5;
    public static final int PROP_LABEL_COLOURS = 6;
    public static final int PROP_W_LABEL = 7;
    public static final int PROP_E_LABEL = 8;
    public static final int PROP_COLWIDTH_MIN = 9;
    public static final int PROP_W_LABEL_COL_MIN = 9 + IGDIntervalZone.getNHier((int)2, (boolean)true);
    public static final int PROP_E_LABEL_COL_MIN = PROP_W_LABEL_COL_MIN + IGDIntervalZone.getNHier((int)2, (boolean)true) + 1;
    private static final int[] titleRows = new int[]{PROP_W_LABEL_COL_MIN};
    private static final String[] titleNames = new String[]{"Label Columns"};
    private static final float DEFAULT_KEY_WIDTH = 30.0f;
    IGDScheme scheme;
    float columnWidth = 100.0f;
    boolean useAbrs = false;
    boolean lithology = true;
    boolean colours = true;
    boolean labelColours = false;
    PanelProperties.ColumnWidth keyWidth = new PanelProperties.ColumnWidth(30.0f, false);
    boolean[] plotCols;
    PanelIGDSchemeProperties labelWest;
    PanelIGDSchemeProperties labelEast;
    String W = "W";
    String E = "E";

    protected PanelLithostratSchemeProperties() {
        super(PanelType.LITHOSCHEME);
    }

    public PanelLithostratSchemeProperties(IGDScheme scheme, String props) throws SQLException {
        super(PanelType.LITHOSCHEME);
        if (scheme != null) {
            assert (scheme.getIGDType() == 2);
            this.scheme = scheme;
            scheme.loadUnits();
        }
        this.plotCols = new boolean[8];
        for (int i = 0; i < this.plotCols.length; ++i) {
            this.plotCols[i] = true;
        }
        if (props == null || props.isEmpty()) {
            if (scheme != null) {
                this.initLabel(true, null);
            }
            return;
        }
        String[] s = props.split("\\|");
        block19: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.useAbrs = Integer.parseInt(s[i]) == 1;
                    continue block19;
                }
                case 1: {
                    this.columnWidth = Float.parseFloat(s[i]);
                    continue block19;
                }
                case 2: {
                    this.keyWidth = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 30.0f, true);
                    continue block19;
                }
                case 3: {
                    this.lithology = Integer.parseInt(s[i]) == 1;
                    continue block19;
                }
                case 4: {
                    this.colours = Integer.parseInt(s[i]) == 1;
                    continue block19;
                }
                case 5: {
                    this.W = s[i];
                    continue block19;
                }
                case 6: {
                    this.E = s[i];
                    continue block19;
                }
                case 7: {
                    if (s[i].isEmpty()) continue block19;
                    this.initLabel(true, s[i]);
                    continue block19;
                }
                case 8: {
                    if (s[i].isEmpty()) continue block19;
                    this.initLabel(false, s[i]);
                    continue block19;
                }
                case 9: {
                    if (s[i].isEmpty()) continue block19;
                    boolean bl = this.labelColours = Integer.parseInt(s[i]) == 1;
                    if (this.labelEast != null) {
                        this.labelEast.colours = this.labelColours;
                    }
                    if (this.labelWest == null) continue block19;
                    this.labelWest.colours = this.labelColours;
                    continue block19;
                }
                case 10: 
                case 11: {
                    continue block19;
                }
                default: {
                    if (s.length < 16) {
                        switch (i - 11) {
                            case 1: {
                                plotColIndex = 2;
                                break;
                            }
                            default: {
                                plotColIndex = 4;
                                break;
                            }
                            case 3: {
                                plotColIndex = 5;
                                break;
                            }
                            case 4: {
                                plotColIndex = 8;
                            }
                        }
                        --plotColIndex;
                    } else {
                        plotColIndex = i - 12;
                    }
                    this.plotCols[plotColIndex] = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    private void initLabel(boolean west, String propsToCopy) throws SQLException {
        if (propsToCopy != null) {
            propsToCopy = propsToCopy.replace(',', '|');
        }
        PanelIGDSchemeProperties label = new PanelIGDSchemeProperties(this.scheme, 0.0f, 0.0f, propsToCopy != null ? propsToCopy : null);
        label.spanEmptyHiers = false;
        label.colours = this.labelColours;
        label.setProperty(4, new PanelProperties.ColumnWidth(10.0f, false));
        label.setProperty(5, new PanelProperties.ColumnWidth(10.0f, false));
        if (propsToCopy == null) {
            for (int i = 10; i < 10 + IGDIntervalZone.getNHier((int)2, (boolean)true); ++i) {
                label.setProperty(i, new PanelProperties.ColumnWidth(10.0f, true));
            }
        }
        if (west) {
            label.lithostratIsWest = true;
            this.labelWest = label;
        } else {
            label.lithostratIsWest = false;
            this.labelEast = label;
        }
    }

    float calcWidth() {
        return this.columnWidth + (this.labelWest != null ? this.labelWest.getWidth() : 0.0f) + (this.labelEast != null ? this.labelEast.getWidth() : 0.0f);
    }

    public static PanelLithostratSchemeProperties createCopy(PanelLithostratSchemeProperties rhs) {
        PanelLithostratSchemeProperties p = new PanelLithostratSchemeProperties();
        p.copy(rhs);
        return p;
    }

    public boolean key() {
        return this.keyWidth.show();
    }

    public float getKeyWidth() {
        return this.keyWidth.width();
    }

    public boolean plotHier(int hier) {
        return this.plotCols[hier - 1];
    }

    public int nHier() {
        return this.plotCols.length;
    }

    public IGDScheme getScheme() {
        return this.scheme;
    }

    @Override
    public int getIGDSchemeID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return 0;
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[PROP_E_LABEL_COL_MIN + this.plotCols.length + 3];
        int propNo = 0;
        props[propNo++] = "" + (this.useAbrs ? 1 : 0);
        props[propNo++] = "" + this.columnWidth;
        props[propNo++] = "" + this.keyWidth.width();
        props[propNo++] = "" + (this.lithology ? 1 : 0);
        props[propNo++] = "" + (this.colours ? 1 : 0);
        props[propNo++] = this.W;
        props[propNo++] = this.E;
        props[propNo++] = this.labelWest != null ? this.labelWest.getPrefs(',') : "";
        props[propNo++] = this.labelEast != null ? this.labelEast.getPrefs(',') : "";
        props[propNo++] = "" + (this.labelColours ? 1 : 0);
        ++propNo;
        ++propNo;
        for (boolean plot : this.plotCols) {
            props[propNo++] = "" + (plot ? 1 : 0);
        }
        for (String prop : props) {
            string = (String)string + (prop != null ? prop : "") + "|";
        }
        return string;
    }

    public int getMaxHier() {
        return this.plotCols.length;
    }

    @Override
    public int getnProps() {
        return propNames.length + this.plotCols.length + propNames2.length + this.plotCols.length * 2;
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp < propNames.length) {
            return propNames[nProp];
        }
        int nHier = IGDIntervalZone.getNHier((int)2, (boolean)true);
        if ((nProp -= 9) < nHier) {
            return IGDIntervalZone.getHierName((int)2, (int)(nProp + 1));
        }
        boolean west = true;
        if ((nProp -= nHier) > nHier) {
            nProp -= nHier + 1;
            west = false;
        }
        if (nProp == 0) {
            return propNames2[west ? 0 : 1];
        }
        return "   " + IGDIntervalZone.getHierName((int)2, (int)nProp);
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.scheme;
            }
            case 1: {
                return (int)this.columnWidth;
            }
            case 2: {
                return this.useAbrs;
            }
            case 3: {
                return this.keyWidth;
            }
            case 5: {
                return this.colours;
            }
            case 4: {
                return this.lithology;
            }
            case 7: {
                return this.W;
            }
            case 8: {
                return this.E;
            }
            case 6: {
                return this.labelColours;
            }
        }
        if (nProp == PROP_W_LABEL_COL_MIN) {
            return this.labelWest != null;
        }
        if (nProp == PROP_E_LABEL_COL_MIN) {
            return this.labelEast != null;
        }
        if (nProp >= 9 && nProp < 9 + this.plotCols.length) {
            return this.plotCols[nProp - 9];
        }
        if (nProp > PROP_W_LABEL_COL_MIN && nProp < PROP_E_LABEL_COL_MIN) {
            return this.labelWest != null ? this.labelWest.hierWidths[nProp - PROP_W_LABEL_COL_MIN - 1] : Boolean.valueOf(false);
        }
        if (nProp > PROP_E_LABEL_COL_MIN) {
            return this.labelEast != null ? this.labelEast.hierWidths[nProp - PROP_E_LABEL_COL_MIN - 1] : Boolean.valueOf(false);
        }
        assert (false);
        return true;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    IGDScheme sch = (IGDScheme)prop;
                    if (sch == null) {
                        throw new IllegalArgumentException("Attempt to set null scheme for PanelLithostratSchemeProperties");
                    }
                    if (sch.getIGDType() != 2) {
                        throw new IllegalArgumentException("Attempt to set wrong scheme type for PanelLithostratSchemeProperties");
                    }
                    this.scheme = sch;
                    if (this.labelWest != null) {
                        this.labelWest.scheme = sch;
                    }
                    if (this.labelEast == null) break;
                    this.labelEast.scheme = sch;
                    break;
                }
                case 1: {
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 2: {
                    this.useAbrs = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.keyWidth = (PanelProperties.ColumnWidth)prop;
                    break;
                }
                case 5: {
                    this.colours = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.lithology = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.labelColours = (Boolean)prop;
                    if (this.labelWest != null) {
                        this.labelWest.colours = this.labelColours;
                    }
                    if (this.labelEast == null) break;
                    this.labelEast.colours = this.labelColours;
                    break;
                }
                case 7: {
                    if (prop == null) {
                        this.W = "";
                        break;
                    }
                    this.W = ((String)prop).trim();
                    break;
                }
                case 8: {
                    if (prop == null) {
                        this.E = "";
                        break;
                    }
                    this.E = ((String)prop).trim();
                    break;
                }
                default: {
                    if (nProp == PROP_W_LABEL_COL_MIN || nProp == PROP_E_LABEL_COL_MIN) {
                        boolean isWest;
                        boolean show = (Boolean)prop;
                        boolean bl = isWest = nProp == PROP_W_LABEL_COL_MIN;
                        if (show) {
                            if ((isWest ? this.labelWest : this.labelEast) != null) break;
                            try {
                                this.initLabel(isWest, null);
                            }
                            catch (SQLException sql) {
                                sql.printStackTrace();
                            }
                            break;
                        }
                        if (isWest) {
                            this.labelWest = null;
                            break;
                        }
                        this.labelEast = null;
                        break;
                    }
                    if (nProp >= 9 && nProp < 9 + this.plotCols.length) {
                        this.plotCols[nProp - 9] = (Boolean)prop;
                        break;
                    }
                    if (nProp > PROP_W_LABEL_COL_MIN && nProp < PROP_E_LABEL_COL_MIN) {
                        if (this.labelWest == null) break;
                        this.labelWest.hierWidths[nProp - PanelLithostratSchemeProperties.PROP_W_LABEL_COL_MIN - 1] = (PanelProperties.ColumnWidth)prop;
                        break;
                    }
                    if (nProp > PROP_E_LABEL_COL_MIN) {
                        if (this.labelEast == null) break;
                        this.labelEast.hierWidths[nProp - PanelLithostratSchemeProperties.PROP_E_LABEL_COL_MIN - 1] = (PanelProperties.ColumnWidth)prop;
                        break;
                    }
                    assert (false);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 0.0f && Math.abs((int)this.columnWidth - (int)panelWidth) > 0) {
            this.columnWidth = panelWidth;
            return true;
        }
        return false;
    }

    @Override
    public boolean showRow(int row) {
        if (row > PROP_W_LABEL_COL_MIN && row < PROP_E_LABEL_COL_MIN) {
            return this.labelWest != null;
        }
        if (row > PROP_E_LABEL_COL_MIN) {
            return this.labelEast != null;
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        return nProp == PROP_E_LABEL_COL_MIN || nProp == PROP_W_LABEL_COL_MIN;
    }

    @Override
    public PanelProperties copy() {
        return PanelLithostratSchemeProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelLithostratSchemeProperties)) {
            throw new IllegalArgumentException("PanelLithostratSchemeProperties cannot copy " + String.valueOf(pp));
        }
        PanelLithostratSchemeProperties rhs = (PanelLithostratSchemeProperties)pp;
        this.plotCols = new boolean[rhs.plotCols.length];
        System.arraycopy(rhs.plotCols, 0, this.plotCols, 0, this.plotCols.length);
        this.labelWest = rhs.labelWest != null ? PanelIGDSchemeProperties.createCopy(rhs.labelWest) : null;
        this.labelEast = rhs.labelEast != null ? PanelIGDSchemeProperties.createCopy(rhs.labelEast) : null;
        for (int i = 0; i < 9; ++i) {
            Object property = rhs.getProperty(i);
            if (property instanceof PanelProperties.ColumnWidth) {
                property = new PanelProperties.ColumnWidth((PanelProperties.ColumnWidth)property);
            }
            switch (i) {
                default: 
            }
            this.setProperty(i, property);
        }
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return IGDScheme.class;
            }
            case 1: {
                return Integer.class;
            }
            case 3: {
                return PanelProperties.ColumnWidth.class;
            }
            case 7: 
            case 8: {
                return String.class;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return Boolean.class;
            }
        }
        if (nProp > PROP_W_LABEL_COL_MIN && nProp < PROP_E_LABEL_COL_MIN) {
            return PanelProperties.ColumnWidth.class;
        }
        if (nProp > PROP_E_LABEL_COL_MIN) {
            return PanelProperties.ColumnWidth.class;
        }
        return Boolean.class;
    }

    @Override
    public DataType getDataType() {
        return DataType.LITHOSTRAT;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelLithostratSchemeProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelLithostratSchemeProperties rhs = (PanelLithostratSchemeProperties)comp;
        if (rhs.getnProps() != this.getnProps()) {
            return false;
        }
        for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp1 = this.getProperty(i);
            Object iProp2 = rhs.getProperty(i);
            if (!(iProp1 instanceof PanelProperties.ColumnWidth ? !((PanelProperties.ColumnWidth)iProp1).isSimilarTo((PanelProperties.ColumnWidth)iProp2) : !Objects.equals(iProp1, iProp2))) continue;
            return false;
        }
        return true;
    }
}

