/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import jsbchart.panel.PanelType;
import model3.DataType;

public abstract class PanelProperties {
    private final PanelType panelType;
    protected static final int SIMILAR_WIDTH_TOLERANCE = 3;
    public static final String PROP_NAME_PANEL_WIDTH = "Panel width";
    public static final String PROP_NAME_DISCS = "Disciplines";
    public static final String PROP_NAME_COLOURS = "Use colours";
    public static final String PROP_NAME_ABRS = "Use abbrs.";
    public static final String PROP_NAME_DEPTHS = "Show depths";
    public static final String PROP_NAME_CMPSTD = "Composite Standard";
    public static final String PROP_NAME_TXSET = "Group Set";
    public static final String PROP_NAME_FONTSIZE = "Font size";
    public static final String PROP_NAME_COMMENTS = "Comments";

    public abstract String getPropertiesString();

    public abstract String getPrefs();

    public abstract int getnProps();

    public abstract String getPropertyName(int var1);

    public abstract Object getProperty(int var1);

    public abstract boolean setProperty(int var1, Object var2);

    public abstract Class<?> getPropertyClass(int var1);

    public abstract PanelProperties copy();

    public abstract void copy(PanelProperties var1);

    public PanelType getPanelType() {
        return this.panelType;
    }

    protected PanelProperties(PanelType panelType) {
        this.panelType = panelType;
    }

    protected PanelProperties() {
        this.panelType = null;
    }

    public Collection getAnalystList() {
        return null;
    }

    public int getIGDSchemeID() {
        return 0;
    }

    public int getCmpStdID() {
        return 0;
    }

    public int getEnvSchID() {
        return 0;
    }

    public int getSynSchID() {
        return 0;
    }

    public int getGrpSetID() {
        return 0;
    }

    public int getAgeCurveID() {
        return 0;
    }

    public int getBlockMbrTemplateID() {
        return 0;
    }

    public HashMap<String, String> getLogDefs() {
        return null;
    }

    public int getShapeStoreID() {
        return 0;
    }

    public boolean allowNull(int nProp) {
        return false;
    }

    public String getNullText(int nProp) {
        return null;
    }

    public boolean showRow(int row) {
        return true;
    }

    public boolean hasShowRowDependencies(int nProp) {
        return false;
    }

    public int[] getTitleRows() {
        return null;
    }

    public String getTitleName(int titleNo) {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PanelProperties)) {
            return false;
        }
        PanelProperties rhs = (PanelProperties)obj;
        for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp2;
            Object iProp1 = this.getProperty(i);
            if (iProp1 == null ^ (iProp2 = rhs.getProperty(i)) == null) {
                return false;
            }
            if (Objects.equals(iProp1, iProp2)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isSimilarTo(PanelProperties var1);

    public boolean equalsLegacyPanelProperties(PanelProperties legacyProperties) {
        return this.equals(legacyProperties);
    }

    public DataType getDataType() {
        return null;
    }

    public String getToolTipText(int nProp) {
        return null;
    }

    public static class ColumnWidth {
        private int width;
        private int defaultWidth;

        public ColumnWidth(float width, boolean show) {
            this.defaultWidth = (int)width;
            this.width = show ? (int)width : 0;
        }

        public ColumnWidth(float width, float defaultWidth, boolean show) {
            if (show) {
                this.width = (int)width;
                this.defaultWidth = (int)defaultWidth;
            } else {
                this.defaultWidth = width > 0.0f ? (int)width : (int)defaultWidth;
                this.width = 0;
            }
        }

        public ColumnWidth(ColumnWidth rhs) {
            this.defaultWidth = rhs.defaultWidth;
            this.width = rhs.width;
        }

        public void setWidth(int width) {
            if (width > 0) {
                this.defaultWidth = width;
            }
            this.width = width;
        }

        public void showColumn(boolean show) {
            if (show) {
                if (this.width == 0) {
                    this.width = this.defaultWidth;
                }
            } else {
                this.defaultWidth = this.width;
                this.width = 0;
            }
        }

        public boolean show() {
            return this.width > 0;
        }

        public float width() {
            return this.width;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnWidth) {
                ColumnWidth rhs = (ColumnWidth)obj;
                return rhs.width == this.width && rhs.defaultWidth == this.defaultWidth;
            }
            return false;
        }

        public boolean isSimilarTo(ColumnWidth comp) {
            if (this.width == 0 && comp.width > 0 || comp.width == 0 && this.width > 0) {
                return false;
            }
            return Math.abs(this.width - comp.width) < 3;
        }
    }
}

