/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.util.Objects;
import java.util.Set;
import jsbchart.util.colour.ColourScale;
import jsbchart.util.colour.ColourSpectrum;
import util.ColourUtils;

public class PanelPropertyItem<T> {
    private static final Set<Class<?>> SIMPLE_TYPE_CLASSES = Set.of(String.class, Boolean.class, Integer.class, Float.class, Double.class, Color.class, ColourSpectrum.class, ColourScale.class, SimplePropertyTypeWrapper.class);
    private final String name;
    private T value;
    private final Class<T> type;
    private final boolean nullable;
    private String nullText;
    final PropertyType propertyType;

    public static <T> PanelPropertyItem<T> nullable(String name, T initialValue) {
        return new PanelPropertyItem(initialValue.getClass(), name, initialValue, true);
    }

    public static <T> PanelPropertyItem<T> nullable(String name, Class<T> propertyClass) {
        return new PanelPropertyItem<Object>(propertyClass, name, null, true);
    }

    public static <T> PanelPropertyItem<T> nonNullable(String name, T initialValue) {
        return new PanelPropertyItem(initialValue.getClass(), name, initialValue, false);
    }

    public PanelPropertyItem(Class<T> type, String name, T initialValue) {
        this(type, name, initialValue, false);
    }

    public PanelPropertyItem(Class<T> type, String name, T initialValue, boolean nullable) {
        this.name = name;
        this.value = initialValue;
        this.type = type;
        this.nullable = nullable;
        this.propertyType = this.inferPropertyType(type);
    }

    protected PropertyType inferPropertyType(Class c) {
        if (SIMPLE_TYPE_CLASSES.contains(c) || c.isEnum()) {
            return PropertyType.SIMPLE;
        }
        return PropertyType.TRACKED;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean setValueFromObject(Object value) {
        String stringValue;
        if (value instanceof String && "NULL".equals(stringValue = (String)value)) {
            value = null;
        }
        if (value == null && !this.nullable) {
            throw new IllegalArgumentException("Cannot set null value for property " + this.name);
        }
        Object newValue = value == null || value.getClass() == this.getPropertyClass() ? value : this.getValueFromString(value.toString(), this.type);
        if (!Objects.equals(newValue, this.value)) {
            this.setValue(newValue);
            return true;
        }
        return false;
    }

    public String getStringValue() {
        T t;
        if (this.type == Color.class) {
            return ColourUtils.DBColourString((Color)((Color)this.getValue()), (boolean)true, (boolean)false);
        }
        if (this.value == null) {
            return "";
        }
        if (this.type.isEnum() && (t = this.getValue()) instanceof Enum) {
            Enum enumValue = (Enum)t;
            return enumValue.name();
        }
        return this.getValue().toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Class<T> getPropertyClass() {
        return this.type;
    }

    public Object getValueFromString(String s, Class c) {
        if (s == null || s.isEmpty()) {
            if (!this.nullable) {
                throw new IllegalArgumentException("Illegal null value for property: " + this.name);
            }
            return null;
        }
        if (c == String.class) {
            return s;
        }
        if (c == Boolean.class) {
            return Boolean.parseBoolean(s);
        }
        if (c == Integer.class) {
            return Integer.parseInt(s);
        }
        if (c == Float.class) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (c == Double.class) {
            return Double.parseDouble(s);
        }
        if (c == Color.class) {
            return ColourUtils.getColour((String)s);
        }
        if (c == ColourSpectrum.class) {
            return ColourSpectrum.parse(s);
        }
        if (c == ColourScale.class) {
            return ColourScale.fromString(s);
        }
        if (c.isEnum()) {
            T[] values;
            for (Object value : values = c.getEnumConstants()) {
                Enum enumValue = (Enum)value;
                if (!enumValue.name().equals(s)) continue;
                return enumValue;
            }
            return Enum.valueOf(c, s);
        }
        throw new IllegalArgumentException("Unknown type to get value from " + String.valueOf(c));
    }

    public String toString() {
        return this.name + ":" + Objects.toString(this.value);
    }

    public String getNullText() {
        return this.nullText;
    }

    public void setNullText(String nullText) {
        this.nullText = nullText;
    }

    protected static enum PropertyType {
        SIMPLE,
        TRACKED;

    }

    public static class SimplePropertyTypeWrapper {
        Object value;
    }
}

