/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.CompositeStandard;
import model3.SBdb;
import model3.TxGroupSet;

public class PanelRangeProperties
extends PanelProperties {
    CompositeStandard std;
    TxGroupSet set = null;
    RangeSort sort = RangeSort.TOP;
    boolean groupGroups = false;
    boolean groupTaxa = true;
    boolean showGroupOutlines = true;
    EventSelection eventSelection = EventSelection.CROSS;
    boolean setExclusive = false;
    boolean showImages = false;
    boolean imageBorder = true;
    float evWidth = 7.5f;
    boolean plotProject = false;
    boolean abundance = false;
    boolean abundanceOverlay = false;
    private static final int PROP_STD = 0;
    private static final int PROP_COLWIDTH = 1;
    private static final int PROP_TAXA = 2;
    private static final int PROP_SORT = 3;
    private static final int PROP_EVENT_SELECTION = 4;
    private static final int PROP_IMAGES = 5;
    private static final int PROP_IMAGE_BORDER = 6;
    private static final int PROP_WELLDATA = 7;
    private static final int PROP_ABN = 8;
    private static final int PROP_ABN_OVERLAY = 9;
    private static final int PROP_TXSET = 10;
    private static final int PROP_FILTERSET = 11;
    private static final int PROP_CLUSTER = 12;
    private static final int PROP_GROUP_OUTLINES = 13;
    private static final String[] PROP_NAMES = new String[]{"Composite Standard", "Event column width", "Cluster by taxon", "Sorting", "Events to plot", "Images", "Image border", "Well/project events", "Abundance", "Abundance groups", "Group Set", "Exclude events not in set", "Cluster by group", "Group outlines"};
    private static final int[] TITLE_ROWS = new int[]{10};
    private static final String[] TITLE_NAMES = new String[]{"Taxon Group Set"};

    EventSelection getEventSelection(int n) {
        for (EventSelection e : EventSelection.values()) {
            if (n != e.getNum()) continue;
            return e;
        }
        return EventSelection.CROSS;
    }

    @Override
    public int[] getTitleRows() {
        return TITLE_ROWS;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > TITLE_NAMES.length - 1) {
            return null;
        }
        return TITLE_NAMES[titleNo];
    }

    @Override
    public String getToolTipText(int nProp) {
        switch (nProp) {
            case 4: {
                return "Plot: all events in composite, or only those crossing age range, or only events within range.";
            }
        }
        return null;
    }

    PanelRangeProperties(SBdb sbdb, String prop, CompositeStandard std, TxGroupSet set) throws SQLException {
        super(PanelType.RANGE);
        this.std = std;
        if (std != null) {
            std.loadEvents();
        }
        this.set = set;
        if (prop == null) {
            return;
        }
        String[] s = prop.split("\\|");
        block14: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.evWidth = Float.parseFloat(s[i]);
                    continue block14;
                }
                case 1: {
                    this.sort = RangeSort.valueOf(s[i]);
                    continue block14;
                }
                case 2: {
                    this.eventSelection = this.getEventSelection(Integer.parseInt(s[i]));
                    continue block14;
                }
                case 3: {
                    this.showImages = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 4: {
                    this.plotProject = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 5: {
                    this.setExclusive = Integer.parseInt(s[i]) == 1 && set != null;
                    continue block14;
                }
                case 6: {
                    this.groupGroups = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 7: {
                    this.showGroupOutlines = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 8: {
                    this.groupTaxa = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 9: {
                    this.abundance = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 10: {
                    this.abundanceOverlay = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 11: {
                    this.imageBorder = Integer.parseInt(s[i]) == 1;
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        return null;
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.std;
            }
            case 1: {
                return Float.valueOf(this.evWidth);
            }
            case 3: {
                return this.sort;
            }
            case 4: {
                return this.eventSelection;
            }
            case 5: {
                return this.showImages;
            }
            case 6: {
                return this.imageBorder;
            }
            case 7: {
                return this.plotProject;
            }
            case 10: {
                return this.set;
            }
            case 11: {
                return this.setExclusive;
            }
            case 12: {
                return this.groupGroups;
            }
            case 13: {
                return this.showGroupOutlines;
            }
            case 2: {
                return this.groupTaxa;
            }
            case 8: {
                return this.abundance;
            }
            case 9: {
                return this.abundanceOverlay;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.std = (CompositeStandard)prop;
                    break;
                }
                case 1: {
                    return this.setColWidth(prop);
                }
                case 3: {
                    this.sort = (RangeSort)((Object)prop);
                    break;
                }
                case 4: {
                    this.eventSelection = (EventSelection)((Object)prop);
                    break;
                }
                case 5: {
                    this.showImages = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.imageBorder = (Boolean)prop;
                    break;
                }
                case 7: {
                    this.plotProject = (Boolean)prop;
                    break;
                }
                case 10: {
                    this.set = (TxGroupSet)prop;
                    break;
                }
                case 11: {
                    this.setExclusive = (Boolean)prop;
                    break;
                }
                case 12: {
                    this.groupGroups = (Boolean)prop;
                    break;
                }
                case 13: {
                    this.showGroupOutlines = (Boolean)prop;
                    break;
                }
                case 2: {
                    this.groupTaxa = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.abundance = (Boolean)prop;
                    break;
                }
                case 9: {
                    this.abundanceOverlay = (Boolean)prop;
                    break;
                }
                default: {
                    assert (false);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setColWidth(Object prop) {
        float value = prop instanceof String ? Float.parseFloat((String)prop) : ((Float)prop).floatValue();
        if ((double)Math.abs(this.evWidth - value) > 0.1 && (double)value > 1.99 && (double)value < 20.01) {
            this.evWidth = value;
            return true;
        }
        return false;
    }

    @Override
    public PanelProperties copy() {
        return PanelRangeProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        String[] props = new String[]{"" + this.evWidth, this.sort.name(), "" + this.eventSelection.getNum(), "" + (this.showImages ? 1 : 0), "" + (this.plotProject ? 1 : 0), "" + (this.setExclusive ? 1 : 0), "" + (this.groupGroups ? 1 : 0), "" + (this.showGroupOutlines ? 1 : 0), "" + (this.groupTaxa ? 1 : 0), "" + (this.abundance ? 1 : 0), "" + (this.abundanceOverlay ? 1 : 0), "" + (this.imageBorder ? 1 : 0)};
        Object string = new String();
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelRangeProperties)) {
            throw new IllegalArgumentException("PanelRangeProperties cannot copy " + String.valueOf(pp));
        }
        PanelRangeProperties rhs = (PanelRangeProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                default: 
            }
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    private PanelRangeProperties() {
        super(PanelType.RANGE);
    }

    private static PanelRangeProperties createCopy(PanelRangeProperties rhs) {
        PanelRangeProperties p = new PanelRangeProperties();
        p.copy(rhs);
        return p;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return CompositeStandard.class;
            }
            case 1: {
                return Float.class;
            }
            case 3: {
                return RangeSort.class;
            }
            case 4: {
                return EventSelection.class;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                return Boolean.class;
            }
            case 10: {
                return TxGroupSet.class;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 11: 
            case 12: {
                return this.set != null;
            }
            case 13: {
                return this.set != null && this.groupGroups;
            }
            case 9: {
                return this.abundance;
            }
            case 6: {
                return this.showImages;
            }
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        switch (nProp) {
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getCmpStdID() {
        if (this.std != null) {
            return this.std.getStdID();
        }
        return super.getCmpStdID();
    }

    @Override
    public int getGrpSetID() {
        if (this.set != null) {
            return this.set.getID();
        }
        return super.getGrpSetID();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.std);
        hash = 37 * hash + Objects.hashCode(this.set);
        hash = 37 * hash + Objects.hashCode((Object)this.sort);
        hash = 37 * hash + (this.groupGroups ? 1 : 0);
        hash = 37 * hash + (this.groupTaxa ? 1 : 0);
        hash = 37 * hash + (this.showGroupOutlines ? 1 : 0);
        hash = 37 * hash + this.eventSelection.getNum();
        hash = 37 * hash + (this.setExclusive ? 1 : 0);
        hash = 37 * hash + (this.showImages ? 1 : 0);
        hash = 37 * hash + Float.floatToIntBits(this.evWidth);
        hash = 37 * hash + (this.plotProject ? 1 : 0);
        hash = 37 * hash + (this.abundance ? 1 : 0);
        hash = 37 * hash + (this.abundanceOverlay ? 1 : 0);
        hash = 37 * hash + (this.imageBorder ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PanelRangeProperties)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        return this.equals(comp);
    }

    public static enum EventSelection {
        CROSS("In, or crossing", 0),
        ALL("All", 1),
        INRANGE("Event in range", 2);

        String name;
        int number;

        private EventSelection(String name, int n2) {
            this.name = name;
            this.number = n2;
        }

        public String toString() {
            return this.name;
        }

        public int getNum() {
            return this.number;
        }
    }

    public static enum RangeSort {
        TOP("Top of range"),
        BASE("Base of range"),
        ALPHA("Alphabetical");

        String name;

        private RangeSort(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

