/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.sample.SampleType;
import java.util.EnumSet;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.Lastval;
import model3.SBdb;

public class PanelSamplesProperties
extends PanelProperties {
    public static final String PREF_STRING = "SAMPPPREF";
    public static final String PREF_STRING_TAXON = "TAXSAMPREF";
    private static final String[] PROP_NAMES = new String[]{"Display symbols", "Show depths", "Show labels", "Show unshifted depths", "Show depth range"};
    public static final int PROP_SYMBOLS = 0;
    public static final int PROP_DEPTHS = 1;
    public static final int PROP_LABELS = 2;
    public static final int PROP_UNSHIFTED = 3;
    public static final int PROP_RANGE = 4;
    public static final int PROP_TYPE_CO = 5;
    public static final int PROP_TYPE_CU = 6;
    public static final int PROP_TYPE_LOG = 7;
    public static final int PROP_TYPE_OC = 8;
    public static final int PROP_TYPE_SC = 9;
    public static final int PROP_TYPE_SP = 10;
    public static final int PROP_TYPE_MIN = 5;
    boolean drawSymbols = false;
    private boolean drawLabels = false;
    private boolean drawUnshifted = false;
    boolean drawRange = true;
    private boolean drawDepths = true;
    private final EnumSet<SampleType> types = EnumSet.of(SampleType.CO, SampleType.CU, SampleType.SC, SampleType.SP, SampleType.OC);

    public PanelSamplesProperties() {
        super(PanelType.SAMPLES);
    }

    public PanelSamplesProperties(String props) {
        super(PanelType.SAMPLES);
        if (props != null) {
            this.decode(props);
        }
    }

    public PanelSamplesProperties(PanelSamplesProperties rhs) {
        this.drawSymbols = rhs.drawSymbols;
        this.drawLabels = rhs.drawLabels;
        this.drawUnshifted = rhs.drawUnshifted;
        this.drawRange = rhs.drawRange;
        this.drawDepths = rhs.drawDepths;
        this.types.clear();
        this.types.addAll(rhs.types);
    }

    public static PanelSamplesProperties createCopy(PanelSamplesProperties rhs) {
        PanelSamplesProperties p = new PanelSamplesProperties();
        p.copy(rhs);
        return p;
    }

    public void encode(SBdb sbdb, String key) {
        String string = this.getPrefs();
        try {
            Lastval.putString((SBdb)sbdb, (String)key, (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean useType(SampleType type) {
        return this.types.contains(type);
    }

    private void decode(String props) {
        String[] s = props.split("\\|");
        this.types.clear();
        boolean parsedSP = false;
        block13: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 2: {
                    this.drawLabels = Integer.parseInt(s[i]) == 1;
                    continue block13;
                }
                case 1: {
                    this.drawDepths = Integer.parseInt(s[i]) == 1;
                    continue block13;
                }
                case 4: {
                    this.drawRange = Integer.parseInt(s[i]) == 1;
                    continue block13;
                }
                case 3: {
                    this.drawUnshifted = Integer.parseInt(s[i]) == 1;
                    continue block13;
                }
                case 0: {
                    this.drawSymbols = Integer.parseInt(s[i]) == 1;
                    continue block13;
                }
                case 5: {
                    if (Integer.parseInt(s[i]) != 1) continue block13;
                    this.types.add(SampleType.CO);
                    continue block13;
                }
                case 6: {
                    if (Integer.parseInt(s[i]) != 1) continue block13;
                    this.types.add(SampleType.CU);
                    continue block13;
                }
                case 7: {
                    if (Integer.parseInt(s[i]) != 1) continue block13;
                    this.types.add(SampleType.LOG);
                    continue block13;
                }
                case 8: {
                    if (Integer.parseInt(s[i]) != 1) continue block13;
                    this.types.add(SampleType.OC);
                    continue block13;
                }
                case 9: {
                    if (Integer.parseInt(s[i]) != 1) continue block13;
                    this.types.add(SampleType.SC);
                    continue block13;
                }
                case 10: {
                    parsedSP = true;
                    if (Integer.parseInt(s[i]) != 1) continue block13;
                    this.types.add(SampleType.SP);
                }
            }
        }
        if (!parsedSP && this.types.contains(SampleType.CU)) {
            this.types.add(SampleType.SP);
        }
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[]{"" + (this.drawSymbols ? 1 : 0), "" + (this.drawDepths ? 1 : 0), "" + (this.drawLabels ? 1 : 0), "" + (this.drawUnshifted ? 1 : 0), "" + (this.drawRange ? 1 : 0), "" + (this.types.contains(SampleType.CO) ? 1 : 0), "" + (this.types.contains(SampleType.CU) ? 1 : 0), "" + (this.types.contains(SampleType.LOG) ? 1 : 0), "" + (this.types.contains(SampleType.OC) ? 1 : 0), "" + (this.types.contains(SampleType.SC) ? 1 : 0), "" + (this.types.contains(SampleType.SP) ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length + SampleType.values().length;
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp >= 5) {
            return "Include " + SampleType.values()[nProp - 5].getAbr();
        }
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        if (nProp >= 5) {
            return this.types.contains(SampleType.values()[nProp - 5]);
        }
        switch (nProp) {
            case 0: {
                return this.drawSymbols;
            }
            case 1: {
                return this.drawDepths;
            }
            case 4: {
                return this.drawRange;
            }
            case 2: {
                return this.drawLabels;
            }
            case 3: {
                return this.drawUnshifted;
            }
        }
        throw new IllegalArgumentException("Unknown property: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (!prop.equals(this.getProperty(nProp))) {
            if (nProp >= 5) {
                SampleType type = SampleType.values()[nProp - 5];
                if (((Boolean)prop).booleanValue()) {
                    this.types.add(type);
                } else {
                    this.types.remove(type);
                }
            } else {
                switch (nProp) {
                    case 0: {
                        this.drawSymbols = (Boolean)prop;
                        break;
                    }
                    case 1: {
                        this.drawDepths = (Boolean)prop;
                        break;
                    }
                    case 4: {
                        this.drawRange = (Boolean)prop;
                        break;
                    }
                    case 2: {
                        this.drawLabels = (Boolean)prop;
                        break;
                    }
                    case 3: {
                        this.drawUnshifted = (Boolean)prop;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown property: " + nProp);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public PanelProperties copy() {
        return PanelSamplesProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelSamplesProperties)) {
            return;
        }
        PanelSamplesProperties rhs = (PanelSamplesProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.drawSymbols ? 1 : 0);
        hash = 29 * hash + (this.drawLabels ? 1 : 0);
        hash = 29 * hash + (this.drawUnshifted ? 1 : 0);
        hash = 29 * hash + (this.drawRange ? 1 : 0);
        hash = 29 * hash + (this.drawDepths ? 1 : 0);
        hash = 29 * hash + Objects.hashCode(this.types);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        return this.equals(comp);
    }

    public boolean drawSymbols() {
        return this.drawSymbols;
    }

    public boolean drawLabels() {
        return this.drawLabels;
    }

    public boolean drawUnshifted() {
        return this.drawUnshifted;
    }

    public boolean drawRange() {
        return this.drawRange;
    }

    public boolean isDrawDepths() {
        return this.drawDepths;
    }

    public boolean draw(SampleType type) {
        return this.types.contains(type);
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        return Boolean.class;
    }

    @Override
    public String getToolTipText(int nProp) {
        if (nProp >= 5) {
            return "Show " + SampleType.values()[nProp - 5].getLongName() + "s";
        }
        return null;
    }
}

