/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellDatum;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.ProjectBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelScaleProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import jsbchart.util.ChartDatumOffsetCalculator;
import jsbchart.util.TickScheme;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import util.ColourUtils;
import util.DepthUnits;
import util.DepthUtils;
import util.FloatRange;
import util.SB;
import util.SBException;

public class PanelScale
extends SBPanel {
    private final ChartBlock block;
    private final TickScheme scheme = new TickScheme();
    private PanelScaleProperties p;
    private FloatRange surveyRange = null;
    private boolean noDeviationSurvey;

    public PanelScale(PanelTemplate template, ChartBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.SCALE);
        this.block = block;
        this.p = (PanelScaleProperties)template.getProperties();
    }

    public PanelScale(ChartBlock block, PanelScaleProperties p) {
        this.block = block;
        this.p = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        boolean firstOrOnly;
        ScaleConverter sc = this.block.getScaleConverter(this.block.getWell());
        float topY = y + this.block.getPanelHeaderHeight(cp, mode);
        boolean bl = firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        if (!firstOrOnly) {
            topY += this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc);
        }
        if (!g.isVisible(x, topY, this.getWidth(this.block.getProp(), cp.drawEmptyPanels), bp.getHeight())) {
            return x + this.p.width;
        }
        g.setClip(x, topY, this.getWidth(this.block.getProp(), cp.drawEmptyPanels), bp.getHeight());
        g.setStroke(0.15f);
        this.drawScaleChanges(g, x, y, cp, mode, bp);
        g.setFont(cp.font, 0, cp.getFontSize());
        g.setColor(cp.foreground);
        try {
            PanelScaleProperties.ScaleType scale2;
            PanelScaleProperties.ScaleType scale1 = this.getScale(true);
            if (scale1 != null) {
                this.drawScale(scale1, true, g, cp, bp, mode, x, y);
            }
            if ((scale2 = this.getScale(false)) != null && scale2 != scale1) {
                this.drawScale(scale2, false, g, cp, bp, mode, x + this.p.width, y);
            }
            this.drawExtras(g, x, y, cp, mode, bp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            g.setClip(null);
        }
        if (this.getPanelOcc() == null || this.getPanelOcc().getCapOrient() != BlockTemplate.CaptionOrientation.VERT) {
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    if (bp != this.block.getProp()) break;
                    this.drawSubHeader(g, x, y, cp, bp);
                }
            }
        }
        return x + this.p.width;
    }

    @Override
    public void drawSubHeader(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        Pair<String, String> headers = this.getHeaders(cp, bp);
        g.setColor(cp.foreground);
        g.setFont(cp.font, 0, cp.getFontSize());
        if (headers.getLeft() != null) {
            this.drawSubHeader(g, x, x + this.p.width, y, cp, bp, (String)headers.getLeft());
        }
        if (headers.getRight() != null) {
            this.drawSubHeader(g, x + this.p.width, x + this.p.width * 2.0f, y, cp, bp, (String)headers.getRight());
        }
    }

    private Pair<String, String> getHeaders(ChartProperties cp, BlockProperties bp) {
        String header1 = null;
        String header2 = null;
        try {
            if (this.getPanelOcc() != null && this.getPanelOcc().getCapOrient() == BlockTemplate.CaptionOrientation.VERT) {
                header1 = this.getTemplatedCaption(cp, bp);
                PanelScaleProperties.ScaleType scale2 = this.getScale(false, false);
                if (scale2 != null && scale2 != this.getScale(true, false)) {
                    header2 = this.getTemplatedSubCaption(cp);
                }
            }
            if (header1 == null || header1.isEmpty()) {
                PanelScaleProperties.ScaleType scale2;
                PanelScaleProperties.ScaleType scale1 = this.getScale(true, true);
                if (scale1 != null) {
                    header1 = this.getSubHeaderString(scale1, cp);
                }
                if ((scale2 = this.getScale(false, false)) != null && scale2 != scale1) {
                    header2 = this.getSubHeaderString(scale2, cp);
                }
                if (header1 == null && header2 == null) {
                    header1 = this.p.primaryType == null ? PanelScaleProperties.getScaleType(this.block.getProp().getScaleType()).toString() : this.p.primaryType.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ImmutablePair((Object)header1, header2);
    }

    private String getSubHeaderString(PanelScaleProperties.ScaleType scale, ChartProperties cp) {
        float headerHeight = this.getBlock().getHeaderHeight(cp);
        if (this.getPanelOcc() == null || this.getPanelOcc().getCapOrient() == BlockTemplate.CaptionOrientation.TOP) {
            headerHeight -= PanelScale.getPanelCaptionHeight(cp, Chart.Mode.NORMAL, true);
        }
        Object header = scale.toString(headerHeight < 55.0f);
        if (this.block.getWell() != null && scale != PanelScaleProperties.ScaleType._AGE) {
            if (scale == PanelScaleProperties.ScaleType._TWT) {
                header = (String)header + " (msec)";
            } else {
                if (this.block.getWell().getType() == 'O') {
                    header = "Elevation";
                }
                String datumSuffix = "";
                if (this.p.showDatum && this.block.getWell() != null) {
                    if (this.p.datum == PanelScaleProperties.DatumType.WELL || cp.getChartDatum() == ChartProperties.ChartDatum.NONE) {
                        if (scale == PanelScaleProperties.ScaleType._TVD && this.block.getTVDList() != null && this.block.getTVDList().isIsTVDSS()) {
                            datumSuffix = " BSL";
                        } else {
                            datumSuffix = switch (this.block.getWell().getHeader().getDepthDatum()) {
                                default -> " BRT";
                                case WellDatum.ROTARY_TABLE -> " BRT";
                                case WellDatum.SEA_BED -> " BSB";
                                case WellDatum.SEA_LEVEL -> " BSL";
                            };
                        }
                    } else {
                        switch (cp.getChartDatum()) {
                            default: {
                                datumSuffix = " BRT";
                                break;
                            }
                            case SL: {
                                datumSuffix = " BSL";
                                break;
                            }
                            case SB: {
                                datumSuffix = " BSB";
                            }
                        }
                    }
                }
                switch (this.getUnits()) {
                    case 'M': 
                    case 'm': {
                        header = (String)header + " (m" + datumSuffix + ")";
                        break;
                    }
                    default: {
                        header = (String)header + " (ft" + datumSuffix + ")";
                    }
                }
            }
        }
        return header;
    }

    private void drawScale(PanelScaleProperties.ScaleType type, boolean onLeft, SBGraphics g, ChartProperties cp, BlockProperties bp, Chart.Mode mode, float x, float y) {
        float max;
        float min;
        Float bpMin = null;
        Float bpMax = null;
        if (bp != this.block.getProp()) {
            bpMin = Float.valueOf(bp.getMin());
            bpMax = Float.valueOf(bp.getMax());
        }
        ScaleConverter sc = this.block.getScaleConverter(this.block.getWell());
        if (type == PanelScaleProperties.ScaleType._MD) {
            min = bpMin != null ? bpMin.floatValue() : sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(0.0).floatValue();
            max = bpMax != null ? bpMax.floatValue() : sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0).floatValue();
        } else {
            Double maxLimit;
            BlockProperties.ScaleType destinationType = PanelScaleProperties.getScaleType(type);
            Double minLimit = sc.convert(bp.getMin(), bp.getScaleType(), destinationType);
            if (minLimit == null && (minLimit = sc.convertAndTrim(bp.getMin(), bp.getScaleType(), destinationType)) == null) {
                minLimit = sc.convertAndTrim(bp.getMin() + 1.0f, bp.getScaleType(), destinationType);
            }
            if ((maxLimit = sc.convert(bp.getMax(), bp.getScaleType(), destinationType)) == null && (maxLimit = sc.convertAndTrim(bp.getMax(), bp.getScaleType(), destinationType)) == null) {
                maxLimit = sc.convertAndTrim(bp.getMax() - 1.0f, bp.getScaleType(), destinationType);
            }
            if (minLimit == null || maxLimit == null) {
                return;
            }
            min = (float)Math.min(minLimit, maxLimit);
            max = (float)Math.max(minLimit, maxLimit);
        }
        min += this.getChartDatumShift(cp, type);
        max += this.getChartDatumShift(cp, type);
        if (type == PanelScaleProperties.ScaleType._AGE) {
            this.scheme.calcScaleLabels(min, this.block.getAgeScale(), max);
        } else {
            this.scheme.calcScaleLabels(min, this.block.getScale(), type == PanelScaleProperties.ScaleType._TWT ? (char)'M' : (char)this.getUnits());
        }
        float value = this.scheme.getStart();
        value -= this.scheme.getTickInterval();
        float left = onLeft ? x : x + this.p.width;
        float h = g.stringHeight();
        float SMALL = 1.0E-6f;
        Double TD = null;
        if (this.block.getWell() != null && this.p.TD) {
            double td = this.block.getWell().getHeader().getTD();
            TD = sc.convertMeasuredDepth(td);
        }
        float colTop = y + this.getPanelHeaderHeight(cp, mode);
        this.calculateDevSurveyRange(type, colTop, cp, bpMin, bpMax, sc);
        if (this.p.showTicks) {
            while (value > min) {
                if (value < max) {
                    this.drawTicksForValue(type, colTop, value, cp, left, onLeft, g, 1, sc);
                }
                if ((double)this.scheme.getTickInterval() < 1.0E-4) break;
                value -= this.scheme.getTickInterval();
            }
        }
        ArrayList<TickLabel> labels = new ArrayList<TickLabel>();
        value = this.scheme.getStart();
        char wellType = this.block.getWell() != null ? (char)this.block.getWell().getType() : (char)'W';
        float yPreviousLabel = -1.0f;
        float maxLabelWidth = 0.0f;
        while (value <= max + 1.0E-6f) {
            String labelText = this.getLabelText(type, value, wellType);
            this.drawTicksForValue(type, colTop, value, cp, left, onLeft, g, 2, sc);
            float[] ypos = this.calcYPosOfShiftedValue(type, colTop, value, cp, sc);
            for (int i = 0; i < ypos.length; ++i) {
                TickLabel label = new TickLabel(labelText, ypos[i], value);
                if ((double)Math.abs(this.scheme.getStart()) < 1.0E-4 && (double)Math.abs(value) < 1.0E-4) {
                    if (!((double)g.stringHeight() * 0.4 < (double)(ypos[i] - colTop))) continue;
                    labels.add(label);
                    maxLabelWidth = Math.max(maxLabelWidth, g.stringWidth(labelText));
                    continue;
                }
                labels.add(label);
                maxLabelWidth = Math.max(maxLabelWidth, g.stringWidth(labelText));
            }
            if ((double)this.scheme.getLabelInterval() < 1.0E-4) break;
            float nextValue = value + this.scheme.getLabelInterval();
            if (TD != null && (double)nextValue > TD && this.block.getProp().getScaleType() != BlockProperties.ScaleType.SUBSIDENCE) break;
            if (this.p.showTicks) {
                value += this.scheme.getTickInterval();
                while (value < nextValue && value <= max) {
                    this.drawTicksForValue(type, colTop, value, cp, left, onLeft, g, 1, sc);
                    if ((double)this.scheme.getTickInterval() < 1.0E-4) break;
                    value += this.scheme.getTickInterval();
                }
            }
            value = nextValue;
        }
        this.drawScaleLabels(labels, type, left, onLeft, maxLabelWidth, g, yPreviousLabel, h, bp, cp);
    }

    private void calculateDevSurveyRange(PanelScaleProperties.ScaleType type, float colTop, ChartProperties cp, Float bpMin, Float bpMax, ScaleConverter cachedScaleConverter) {
        this.surveyRange = null;
        this.noDeviationSurvey = true;
        if (type == PanelScaleProperties.ScaleType._TVD) {
            Float highlightFrom = null;
            Float highlightTo = null;
            PanelScaleProperties.ScaleType highlightScale = PanelScaleProperties.ScaleType._MD;
            if (this.block instanceof ProjectBlock) {
                FloatRange devSurveyTVDRange = this.block.getDeviationSurveyTVDLimits();
                if (devSurveyTVDRange != null) {
                    this.noDeviationSurvey = false;
                    float[] tvdLimits = this.block.getTVDLimits(null, null);
                    float minTVD = Math.min(tvdLimits[0], tvdLimits[1]);
                    highlightFrom = Float.valueOf(Math.max(minTVD, devSurveyTVDRange.getMin()));
                    float maxTVD = Math.max(tvdLimits[1], tvdLimits[0]);
                    highlightTo = Float.valueOf(Math.min(maxTVD, devSurveyTVDRange.getMax()));
                }
            } else {
                FloatRange devSurveyMDRange = this.block.getDeviationSurveyDDLimits();
                if (devSurveyMDRange != null) {
                    this.noDeviationSurvey = false;
                    float mdMin = bpMin != null ? bpMin.floatValue() : this.block.getMDLimit(true);
                    float mdMax = bpMax != null ? bpMax.floatValue() : this.block.getMDLimit(false);
                    FloatRange mdRange = new FloatRange(mdMin, mdMax);
                    mdRange = mdRange.shiftRange(this.getChartDatumShift(cp, type));
                    devSurveyMDRange = devSurveyMDRange.shiftRange(this.getChartDatumShift(cp, type));
                    highlightFrom = Float.valueOf(Math.max(mdRange.getMin(), devSurveyMDRange.getMin()));
                    highlightTo = Float.valueOf(Math.min(mdRange.getMax(), devSurveyMDRange.getMax()));
                }
            }
            if (highlightFrom != null && highlightTo != null) {
                float[] yPosStart = this.calcYPosOfShiftedValue(highlightScale, colTop, highlightFrom.floatValue(), cp, cachedScaleConverter);
                float[] yPosEnd = this.calcYPosOfShiftedValue(highlightScale, colTop, highlightTo.floatValue(), cp, cachedScaleConverter);
                if (yPosStart.length == 1 && yPosEnd.length == 1) {
                    this.surveyRange = new FloatRange(yPosStart[0], yPosEnd[0]);
                }
            }
        }
    }

    private String getLabelText(PanelScaleProperties.ScaleType type, float value, char wellType) {
        return switch (type) {
            case PanelScaleProperties.ScaleType._AGE, PanelScaleProperties.ScaleType._TWT -> SB.floatString((float)value, (int)this.scheme.getPrecision());
            default -> SB.floatString((float)DepthUtils.convFromM((float)value, (char)this.getUnits(), (char)wellType), (int)this.scheme.getPrecision());
        };
    }

    private void drawTicksForValue(PanelScaleProperties.ScaleType type, float colTop, float value, ChartProperties cp, float left, boolean onLeft, SBGraphics g, int tickSize, ScaleConverter cachedScaleConverter) {
        float[] ypos = this.calcYPosOfShiftedValue(type, colTop, value, cp, cachedScaleConverter);
        float x1 = left;
        float x2 = left + (float)(onLeft ? 1 * tickSize : -1 * tickSize);
        for (int i = 0; i < ypos.length; ++i) {
            this.updateGraphicsColourForTicksAndLabels(g, type, ypos[i], cp);
            g.drawLine(x1, ypos[i], x2, ypos[i]);
        }
    }

    private void drawScaleLabels(ArrayList<TickLabel> labels, PanelScaleProperties.ScaleType type, float left, boolean onLeft, float maxLabelWidth, SBGraphics g, float yPreviousLabel, float h, BlockProperties bp, ChartProperties cp) {
        Collections.sort(labels);
        float x2 = left + (float)(onLeft ? 2 : -2);
        for (TickLabel label : labels) {
            float textPos;
            float f = textPos = onLeft ? x2 + maxLabelWidth - g.stringWidth(label.label) : x2 - g.stringWidth(label.label);
            if (!(Math.abs(label.ypos - yPreviousLabel) > h)) continue;
            this.updateGraphicsColourForTicksAndLabels(g, type, label.ypos, cp);
            g.drawString(label.label, textPos, label.ypos + g.stringHeightSB() / 2.0f, this.getWidth(bp, cp.drawEmptyPanels) - 2.0f, 1, true);
            yPreviousLabel = label.ypos;
        }
    }

    private void updateGraphicsColourForTicksAndLabels(SBGraphics g, PanelScaleProperties.ScaleType type, float yPos, ChartProperties cp) {
        Color c = this.calculateTickAndLabelColour(type, yPos, cp);
        if (g.getColor() != c) {
            g.setColor(c);
        }
    }

    private Color calculateTickAndLabelColour(PanelScaleProperties.ScaleType type, float yPos, ChartProperties cp) {
        if (type == PanelScaleProperties.ScaleType._TVD) {
            if (this.noDeviationSurvey || this.surveyRange == null || !this.surveyRange.isInRange(yPos)) {
                return ColourUtils.getLighterColour((Color)cp.foreground);
            }
            return cp.foreground;
        }
        return cp.foreground;
    }

    private float[] calcYPosOfShiftedValue(PanelScaleProperties.ScaleType type, float colTop, float value, ChartProperties cp, ScaleConverter cachedScaleConverter) {
        return this.calcPlotPosition(colTop, value - this.getChartDatumShift(cp, type), type, cachedScaleConverter);
    }

    private float getChartDatumShift(ChartProperties cp, PanelScaleProperties.ScaleType scaleType) {
        ChartDatumOffsetCalculator calculator = new ChartDatumOffsetCalculator();
        if (this.block.getWell() == null || this.p.datum != PanelScaleProperties.DatumType.CHART) {
            return 0.0f;
        }
        switch (scaleType) {
            case _MD: {
                return calculator.calculateMDOffset(cp.getChartDatum(), this.block.getWell().getHeader());
            }
            case _TVD: {
                return calculator.calculateTVDOffset(cp.getChartDatum(), this.block.getWell().getHeader(), this.block.getTVDList());
            }
        }
        return 0.0f;
    }

    private float[] calcPlotPosition(float colTop, float value, PanelScaleProperties.ScaleType scale, ScaleConverter cachedScaleConverter) {
        float[] yPos = this.block.scaleToAll(value, PanelScaleProperties.getScaleType(scale), cachedScaleConverter);
        int i = 0;
        while (i < yPos.length) {
            int n = i++;
            yPos[n] = yPos[n] + colTop;
        }
        return yPos;
    }

    @Override
    public float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        float xpos;
        try {
            if (this.getScale(true) != PanelScaleProperties.ScaleType._AGE && this.getScale(false) != PanelScaleProperties.ScaleType._AGE) {
                return this.getWidth(bp);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return this.getWidth(bp);
        }
        g.setClip(x, y, PanelScale.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp), this.p.width);
        g.setColor(cp.foreground);
        float minAge = this.block.getAgeLimit(true);
        float maxAge = this.block.getAgeLimit(false);
        g.setFont(cp.font, 0, cp.getFontSize());
        this.scheme.calcScaleLabels(minAge, this.block.getAgeScale());
        float age = this.scheme.getStart();
        age -= this.scheme.getTickInterval();
        float SMALL = 1.0E-6f;
        float y1 = y + this.p.width;
        float y2 = y1 - 1.0f;
        float h = g.stringHeightSB();
        while (age > minAge) {
            if (age < maxAge) {
                xpos = x + PanelScale.getXPos(age, bp);
                g.drawLine(xpos, y1, xpos, y2);
            }
            age -= this.scheme.getTickInterval();
        }
        age = this.scheme.getStart();
        Float xPreviousLabel = null;
        while (age <= maxAge + 1.0E-6f) {
            String buffer = SB.floatString((float)age, (int)this.scheme.getPrecision());
            xpos = x + PanelScale.getXPos(age, bp);
            y2 = y1 - 2.0f;
            g.drawLine(xpos, y1, xpos, y2);
            float ypos = y2;
            if (xPreviousLabel == null || bp.getAgeLeftToRight() && xpos > xPreviousLabel.floatValue() + h || !bp.getAgeLeftToRight() && xpos < xPreviousLabel.floatValue()) {
                g.drawStringVertical(buffer, xpos + h / 2.0f, ypos);
                xPreviousLabel = Float.valueOf(xpos);
            }
            float nextDepth = age + this.scheme.getLabelInterval();
            age += this.scheme.getTickInterval();
            while (age < nextDepth && age <= maxAge) {
                xpos = x + PanelScale.getXPos(age, bp);
                y2 = y1 - 1.0f;
                g.drawLine(xpos, y1, xpos, y2);
                age += this.scheme.getTickInterval();
            }
            age = nextDepth;
        }
        g.setClip(null);
        this.drawHorzOutline(g, x, y, cp, bp);
        return this.getWidth(bp);
    }

    private void drawExtras(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp) {
        double tdepth;
        float seaLevel;
        float rotaryTable;
        float seabed;
        boolean showSB = true;
        boolean showRT = true;
        if (this.block.getWell() != null) {
            seabed = this.block.getWell().getHeader().getSBDepth();
            rotaryTable = this.block.getWell().getHeader().getRTDepth();
            seaLevel = this.block.getWell().getHeader().getSLDepth();
            tdepth = this.block.getWell().getHeader().getTD();
            if (this.block.getWell().getHeader().getSBValue() <= 0.0 || this.block.getWell().getSectionType() == SectionType.OUTCROP) {
                showSB = false;
            }
            if (this.block.getWell().getSectionType() == SectionType.OUTCROP) {
                showRT = false;
            }
        } else if (this.block instanceof WellBlock) {
            seabed = 30.0f;
            rotaryTable = 10.0f;
            seaLevel = 20.0f;
            tdepth = 90.0;
        } else {
            return;
        }
        if (this.p.seaBed && showSB) {
            float sb = this.block.scale(seabed, BlockProperties.ScaleType.MD) + y + this.getPanelHeaderHeight(cp, mode);
            this.drawAccent(g, x, sb, "SB", cp, bp);
        }
        if (this.p.TD && tdepth > (double)this.block.getMDLimit(true) && DepthUtils.ltOrEqWithinTolerance((double)tdepth, (double)this.block.getMDLimit(false))) {
            float td = this.block.scale((float)tdepth, BlockProperties.ScaleType.MD) + this.getPanelHeaderHeight(cp, mode) + y;
            this.drawAccent(g, x, td, "TD", cp, bp);
        }
        if (this.p.showRotartyTableDepth && showRT) {
            float rt = this.block.scale(rotaryTable, BlockProperties.ScaleType.MD) + y + this.getPanelHeaderHeight(cp, mode);
            this.drawAccent(g, x, rt, "RT", cp, bp);
        }
        if (this.p.showSeaLevelDepth) {
            float sl = this.block.scale(seaLevel, BlockProperties.ScaleType.MD) + y + this.getPanelHeaderHeight(cp, mode);
            this.drawAccent(g, x, sl, "SL", cp, bp);
        }
    }

    private void drawAccent(SBGraphics g, float x, float accentPos, String text, ChartProperties cp, BlockProperties bp) {
        g.setColor(cp.accent);
        g.setStroke(0.2f);
        g.drawLine(x, accentPos, x + this.getWidth(bp, cp.drawEmptyPanels), accentPos);
        g.setFont(cp.font, 1, cp.getFontSizePanel());
        g.drawString(text, x + (this.getWidth(bp, cp.drawEmptyPanels) > this.p.width ? this.p.width * 1.5f : this.getWidth(bp, cp.drawEmptyPanels)) - g.stringWidth("TD") - 1.0f, accentPos - 1.0f);
    }

    private void drawScaleChanges(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp) {
        if (this.block.getProp().getnScaleSections() == 1) {
            return;
        }
        g.setColor(cp.accent);
        g.setFontSize(cp.getFontSizeTiny());
        float centre = x + this.getWidth(this.block.getProp(), cp.drawEmptyPanels) / 2.0f;
        float symbolSize = 4.0f;
        float bigWiggleHeight = 1.3333334f;
        float smallWiggleHeight = 0.44444445f;
        for (int i = 1; i < this.block.getProp().getnScaleSections(); ++i) {
            float belowScale;
            float aboveScale = this.block.getProp().getScale(i - 1);
            if (Math.abs(aboveScale - (belowScale = this.block.getProp().getScale(i))) == 0.0f) continue;
            float ypos = y + this.getPanelHeaderHeight(cp, mode) + this.block.scale(this.block.getProp().getMin(i), this.block.getProp().getScaleType());
            g.drawLine(x, ypos, x + this.getWidth(bp, cp.drawEmptyPanels), ypos);
            boolean biggerWigglesAbove = this.block.getProp().getScaleType() == BlockProperties.ScaleType.AGE ? aboveScale > belowScale : aboveScale < belowScale;
            float aypos = ypos;
            boolean onTheLeft = true;
            while (aypos > ypos - 4.0f) {
                g.drawLine(centre - 1.0f * (float)(onTheLeft ? 1 : -1), aypos, centre - 1.0f * (float)(onTheLeft ? -1 : 1), aypos -= biggerWigglesAbove ? 1.3333334f : 0.44444445f);
                onTheLeft = !onTheLeft;
            }
            String scaleAboveString = "" + Float.valueOf(aboveScale).intValue();
            g.drawStringVertical(scaleAboveString, x + this.p.width - 1.0f, ypos - 1.0f);
            float bypos = ypos;
            onTheLeft = true;
            while (bypos < ypos + 4.0f) {
                g.drawLine(centre - 1.0f * (float)(onTheLeft ? 1 : -1), bypos, centre - 1.0f * (float)(onTheLeft ? -1 : 1), bypos += biggerWigglesAbove ? 0.44444445f : 1.3333334f);
                onTheLeft = !onTheLeft;
            }
            String scaleBelowString = "" + Float.valueOf(belowScale).intValue();
            g.drawStringVertical(scaleBelowString, x + this.p.width - 1.0f, ypos + g.stringWidth(scaleBelowString) + 1.0f);
        }
    }

    private PanelScaleProperties.ScaleType getScale(boolean primary) throws SQLException {
        return this.getScale(primary, false);
    }

    private PanelScaleProperties.ScaleType getScale(boolean primary, boolean forColumnHeader) throws SQLException {
        PanelScaleProperties.ScaleType scale = this.p.primaryType;
        if (scale == null) {
            scale = PanelScaleProperties.getScaleType(this.block.getProp().getScaleType());
        }
        if (primary && (forColumnHeader || this.canPlot(scale))) {
            return scale;
        }
        if (!this.p.alternative) {
            return null;
        }
        PanelScaleProperties.ScaleType scale2 = this.p.alternativeType;
        if (scale2 == null) {
            scale2 = PanelScaleProperties.getScaleType(this.block.getProp().getScaleType());
        }
        if (scale2 == scale || !this.canPlot(scale2)) {
            return null;
        }
        return scale2;
    }

    private boolean canPlot(PanelScaleProperties.ScaleType type) throws SQLException {
        if (this.block instanceof WellBlock && this.block.getWell() == null) {
            return true;
        }
        switch (type) {
            default: {
                assert (false);
            }
            case _MD: {
                if (this.block.getWell() != null) {
                    switch (this.block.getProp().getScaleType()) {
                        case AGE: {
                            return this.block.getInterp().getLOC() != null;
                        }
                        case TVD: {
                            return true;
                        }
                        case TWT: {
                            return this.block.getTWTList() != null;
                        }
                    }
                    return true;
                }
                return false;
            }
            case _AGE: {
                switch (this.block.getProp().getScaleType()) {
                    case AGE: {
                        return true;
                    }
                    default: {
                        assert (false);
                    }
                    case MD: {
                        return this.block.getWell() != null && this.block.getInterp().getLOC() != null;
                    }
                    case TVD: 
                    case SUBSIDENCE: {
                        return this.block.getWell() != null && this.block.getTVDList() != null;
                    }
                    case TWT: 
                }
                return this.block.getWell() != null && this.block.getTWTList() != null;
            }
            case _TVD: {
                switch (this.block.getProp().getScaleType()) {
                    case TVD: {
                        return this.block.getWell() != null;
                    }
                    case TWT: {
                        return this.block.getWell() != null && this.block.getTWTList() != null;
                    }
                    default: {
                        assert (false);
                    }
                    case MD: {
                        return this.block.getWell() != null && this.block.getTVDList() != null;
                    }
                    case SUBSIDENCE: {
                        return true;
                    }
                    case AGE: 
                }
                return this.block.getWell() != null && this.block.getInterp().getLOC() != null;
            }
            case _TWT: 
        }
        if (this.block.getProp().getScaleType() == BlockProperties.ScaleType.TWT) {
            return true;
        }
        return this.block.getTWTList() != null;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.getWidth(bp, true);
    }

    @Override
    public float getWidth(BlockProperties bp, boolean drawEmptyPanels) {
        try {
            return this.p.width * (float)(this.getScale(false) != null && this.getScale(false) != this.getScale(true) ? 2 : (this.getScale(true) != null || drawEmptyPanels ? 1 : 0));
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return this.p.width * 2.0f;
        }
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() == null || this.getPanelOcc().getCapOrient() == BlockTemplate.CaptionOrientation.TOP) {
            return "Scale";
        }
        return "";
    }

    @Override
    public void setProperties(PanelProperties pp) {
        if (!(pp instanceof PanelScaleProperties)) {
            throw new IllegalArgumentException("PanelScale cannot set properties to " + String.valueOf(pp));
        }
        this.p = (PanelScaleProperties)pp;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        if ((this.p.primaryType == PanelScaleProperties.ScaleType._AGE || this.p.alternative && this.p.alternativeType == PanelScaleProperties.ScaleType._AGE) && this.block.getInterp() != null) {
            this.block.getInterp().loadLOC(this.block.getWellID());
        }
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        try {
            if (this.getScale(true) != null) {
                return true;
            }
            return this.getScale(false) != null;
        }
        catch (SQLException sql) {
            sql.printStackTrace();
            return true;
        }
    }

    public String toString() {
        return "Scale Panel";
    }

    @Override
    public PanelScaleProperties getProperties() {
        return this.p;
    }

    @Override
    public boolean pipe() {
        try {
            boolean hasMD;
            boolean bl = hasMD = this.getScale(true) == PanelScaleProperties.ScaleType._MD || this.getScale(false) == PanelScaleProperties.ScaleType._MD;
            if (hasMD) {
                return this.block.getProp().getScaleType() != BlockProperties.ScaleType.MD;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    private char getUnits() {
        DepthUnits units = DepthUnits.getUnits((char)this.block.getProp().getUnits());
        if (this.p.alternativeUnits) {
            units = DepthUnits.getAltUnits((DepthUnits)units);
        }
        return units.getChar();
    }

    private static class TickLabel
    implements Comparable<TickLabel> {
        final String label;
        final float ypos;
        final float value;

        TickLabel(String label, float ypos, float value) {
            this.label = label;
            this.ypos = ypos;
            this.value = value;
        }

        @Override
        public int compareTo(TickLabel o) {
            if (this.ypos < o.ypos) {
                return -1;
            }
            if (this.ypos > o.ypos) {
                return 1;
            }
            return 0;
        }
    }
}

