/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

public class PanelScaleProperties
extends PanelProperties {
    private static final String[] propNames = new String[]{"Panel width", "Primary scale", "Alternative scale", "", "Show TD", "Show sea bed", "Alternative units", "Show RT", "Show sea level", "Panel datum", "Show datum", "Show scale tick marks"};
    public static final int PROP_WIDTH = 0;
    public static final int PROP_PRIMARY = 1;
    public static final int PROP_PLOT_ALT = 2;
    public static final int PROP_ALT = 3;
    public static final int PROP_TD = 4;
    public static final int PROP_SEABED = 5;
    public static final int PROP_UNITS = 6;
    public static final int PROP_RT = 7;
    public static final int PROP_SL = 8;
    public static final int PROP_DATUM = 9;
    public static final int PROP_SHOW_DATUM = 10;
    public static final int PROP_SHOW_TICKS = 11;
    float width = 12.0f;
    ScaleType primaryType = ScaleType._MD;
    ScaleType alternativeType = null;
    boolean alternative;
    boolean TD = false;
    boolean seaBed = false;
    boolean showRotartyTableDepth = false;
    boolean showSeaLevelDepth = false;
    boolean showDatum = false;
    boolean showTicks = true;
    boolean alternativeUnits = false;
    private static final Logger LOGGER = Logger.getLogger(PanelScaleProperties.class.getName());
    public DatumType datum = DatumType.WELL;

    private static PanelScaleProperties createCopy(PanelScaleProperties rhs) {
        PanelScaleProperties p = new PanelScaleProperties(null);
        p.copy(rhs);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelScaleProperties)) {
            throw new IllegalArgumentException("PanelScaleProperties cannot copy " + String.valueOf(pp));
        }
        PanelScaleProperties rhs = (PanelScaleProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public PanelScaleProperties copy() {
        return PanelScaleProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[propNames.length];
        props[0] = "" + this.width;
        props[1] = this.primaryType != null ? this.primaryType.name() : "";
        props[2] = "" + (this.alternative ? 1 : 0);
        props[3] = this.alternativeType != null ? this.alternativeType.name() : "";
        props[4] = "" + (this.TD ? 1 : 0);
        props[5] = "" + (this.seaBed ? 1 : 0);
        props[6] = "" + (this.alternativeUnits ? 1 : 0);
        props[7] = "" + (this.showRotartyTableDepth ? 1 : 0);
        props[8] = "" + (this.showSeaLevelDepth ? 1 : 0);
        props[9] = this.datum.name();
        props[10] = "" + (this.showDatum ? 1 : 0);
        props[11] = "" + (this.showTicks ? 1 : 0);
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    public PanelScaleProperties(String props) {
        super(PanelType.SCALE);
        if (props == null || props.isEmpty()) {
            return;
        }
        String[] split = props.split("\\|");
        block18: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    this.width = Float.parseFloat(split[i]);
                    continue block18;
                }
                case 1: {
                    try {
                        this.primaryType = split[i].isEmpty() ? null : ScaleType.valueOf(split[i]);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.WARNING, "Can't parse TWT scale type, exception: " + ex.getMessage(), ex);
                        this.primaryType = ScaleType._MD;
                    }
                    continue block18;
                }
                case 2: {
                    this.alternative = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 3: {
                    this.alternativeType = split[i].isEmpty() ? null : ScaleType.valueOf(split[i]);
                    continue block18;
                }
                case 4: {
                    this.TD = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 5: {
                    this.seaBed = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 6: {
                    this.alternativeUnits = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 7: {
                    this.showRotartyTableDepth = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 8: {
                    this.showSeaLevelDepth = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 9: {
                    try {
                        this.datum = DatumType.valueOf(split[i]);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Can't parse DatumType value " + split[i] + ", exception: " + ex.getMessage(), ex);
                        this.datum = DatumType.WELL;
                    }
                    continue block18;
                }
                case 10: {
                    this.showDatum = Integer.parseInt(split[i]) == 1;
                    continue block18;
                }
                case 11: {
                    this.showTicks = Integer.parseInt(split[i]) == 1;
                }
            }
        }
    }

    public void setWidth(float panelWidth) {
        this.setPanelWidth(panelWidth);
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 3: {
                return this.alternativeType;
            }
            case 2: {
                return this.alternative;
            }
            case 1: {
                return this.primaryType;
            }
            case 4: {
                return this.TD;
            }
            case 5: {
                return this.seaBed;
            }
            case 6: {
                return this.alternativeUnits;
            }
            case 7: {
                return this.showRotartyTableDepth;
            }
            case 8: {
                return this.showSeaLevelDepth;
            }
            case 9: {
                return this.datum;
            }
            case 10: {
                return this.showDatum;
            }
            case 11: {
                return this.showTicks;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (prop != this.getProperty(nProp)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 1: {
                    this.primaryType = (ScaleType)((Object)prop);
                    break;
                }
                case 3: {
                    this.alternativeType = (ScaleType)((Object)prop);
                    break;
                }
                case 2: {
                    this.alternative = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.TD = (Boolean)prop;
                    break;
                }
                case 5: {
                    this.seaBed = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.alternativeUnits = (Boolean)prop;
                    break;
                }
                case 7: {
                    this.showRotartyTableDepth = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.showSeaLevelDepth = (Boolean)prop;
                    break;
                }
                case 9: {
                    this.datum = (DatumType)((Object)prop);
                    break;
                }
                case 10: {
                    this.showDatum = (Boolean)prop;
                    break;
                }
                case 11: {
                    this.showTicks = (Boolean)prop;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth > 4.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 3: {
                return this.alternative;
            }
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int row) {
        return row == 2;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Float.floatToIntBits(this.width);
        hash = 89 * hash + Objects.hashCode((Object)this.primaryType);
        hash = 89 * hash + Objects.hashCode((Object)this.alternativeType);
        hash = 89 * hash + (this.alternative ? 1 : 0);
        hash = 89 * hash + (this.TD ? 1 : 0);
        hash = 89 * hash + (this.seaBed ? 1 : 0);
        hash = 89 * hash + (this.alternativeUnits ? 1 : 0);
        hash = 89 * hash + (this.showRotartyTableDepth ? 1 : 0);
        hash = 89 * hash + (this.showSeaLevelDepth ? 1 : 0);
        hash = 89 * hash + Objects.hashCode((Object)this.datum);
        hash = 89 * hash + (this.showDatum ? 1 : 0);
        hash = 89 * hash + (this.showTicks ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelScaleProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelScaleProperties rhs = (PanelScaleProperties)comp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp1 = this.getProperty(i);
            Object iProp2 = rhs.getProperty(i);
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block3;
                    return false;
                }
                default: {
                    if (Objects.equals(iProp1, iProp2)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 3: {
                return ScaleType.class;
            }
            case 9: {
                return DatumType.class;
            }
        }
        return Boolean.class;
    }

    static ScaleType getScaleType(BlockProperties.ScaleType bpScaleType) {
        switch (bpScaleType) {
            default: {
                assert (false);
            }
            case MD: {
                return ScaleType._MD;
            }
            case TVD: 
            case SUBSIDENCE: {
                return ScaleType._TVD;
            }
            case AGE: 
        }
        return ScaleType._AGE;
    }

    static BlockProperties.ScaleType getScaleType(ScaleType panelScaleType) {
        switch (panelScaleType.ordinal()) {
            default: {
                assert (false);
            }
            case 0: {
                return BlockProperties.ScaleType.MD;
            }
            case 3: {
                return BlockProperties.ScaleType.TWT;
            }
            case 2: {
                return BlockProperties.ScaleType.TVD;
            }
            case 1: 
        }
        return BlockProperties.ScaleType.AGE;
    }

    public static enum ScaleType {
        _MD("Measured depth", "Depth"),
        _AGE("Age", null),
        _TVD("True vertical depth", "TVD"),
        _TWT("Two-way time", "TWT");

        final String name;
        final String abr;

        private ScaleType(String name, String abr) {
            this.name = name;
            this.abr = abr;
        }

        public String toString() {
            return this.name;
        }

        public String toString(boolean useAbr) {
            return useAbr && this.abr != null ? this.abr : this.name;
        }
    }

    public static enum DatumType {
        WELL("Well"),
        CHART("Chart");

        final String name;

        private DatumType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

