/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.well.analysis.SpeciesType;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.ImageIcon;
import jsbchart.core.CaptionTemplate;
import jsbchart.panel.PanelDendrogramProperties;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.panel.PanelTaxonSamplesProperties;
import jsbchart.panel.PanelTaxonType;
import model3.CompositeStandard;
import model3.IGDScheme;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import util.SBException;

public class PanelTaxonOcc {
    final PanelTaxonType type;
    private String caption;
    private PanelTaxonPropertiesBase panelProperties;
    private boolean isDefaultProps;
    private boolean overplot;
    private Filter filter = null;
    public static final int PROP_CAPTION = 0;
    public static final int PROP_FILTER = 1;
    public static final int PROP_SUBCATS = 2;
    public static final int PROP_DEFAULT = 3;
    public static final int PROP_OVERPLOT = 4;
    private final PanelTaxonOcc original;

    public PanelTaxonOcc(PanelTaxonType type, boolean isDefault, String props, CompositeStandard std, boolean overplot) {
        this.type = type;
        this.isDefaultProps = isDefault;
        this.overplot = overplot;
        this.original = null;
        this.setProperties(props, std);
    }

    public PanelTaxonOcc(PanelTaxonType type, PanelTaxonPropertiesBase props, boolean isDefault, boolean overplot) {
        this.type = type;
        if (props == null) {
            this.setProperties(null, null);
        } else {
            switch (type) {
                case SAMPLES: {
                    assert (props instanceof PanelTaxonSamplesProperties);
                    break;
                }
                case TAXON: {
                    assert (props instanceof PanelTaxonProperties);
                    break;
                }
                case DENDRO: {
                    assert (props instanceof PanelDendrogramProperties);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.panelProperties = props;
        }
        this.isDefaultProps = isDefault;
        this.overplot = overplot;
        this.original = null;
    }

    private void setProperties(String props, CompositeStandard std) {
        switch (this.type) {
            case SAMPLES: {
                this.panelProperties = new PanelTaxonSamplesProperties(props);
                break;
            }
            case TAXON: {
                this.panelProperties = new PanelTaxonProperties(props, std);
                break;
            }
            case DENDRO: {
                this.panelProperties = new PanelDendrogramProperties(props);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void setOccProps(String occProps, CompositeStandard std) {
        if (occProps == null || occProps.isEmpty()) {
            return;
        }
        String[] splits = occProps.split("\\|");
        block4: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: {
                    if (this.filter == null) continue block4;
                    this.filter.setFilter(this.filter.filter, Integer.parseInt(splits[i]) == 1);
                    continue block4;
                }
                case 1: {
                    if (Integer.parseInt(splits[i]) != 1 || std == null) continue block4;
                    this.filter = new Filter(std, false);
                }
            }
        }
    }

    public PanelTaxonOcc(PanelTaxonOcc rhs) {
        this.original = rhs;
        this.type = rhs.type;
        this.caption = rhs.caption;
        this.filter = Filter.createCopy(rhs.filter);
        this.panelProperties = rhs.panelProperties.createCopy();
        this.isDefaultProps = rhs.isDefaultProps;
        this.overplot = rhs.overplot;
    }

    private PanelTaxonOcc(PanelTaxonType type) {
        this.type = type;
        this.original = null;
    }

    public static PanelTaxonOcc copyToDb(PanelTaxonOcc wsOcc, SBdb ws, SBdb db) throws SQLException, SBException {
        PanelTaxonOcc dbOcc = new PanelTaxonOcc(wsOcc.type);
        dbOcc.caption = wsOcc.caption;
        dbOcc.isDefaultProps = wsOcc.isDefaultProps;
        dbOcc.overplot = wsOcc.overplot;
        PanelTaxonPropertiesBase wsPropertiesCopy = wsOcc.panelProperties.createCopy();
        if (wsPropertiesCopy instanceof PanelTaxonProperties) {
            PanelTaxonProperties wsProp = (PanelTaxonProperties)wsPropertiesCopy;
            if (wsProp.hdrScheme != null) {
                wsProp.hdrScheme = wsProp.hdrScheme.getLink();
                assert (wsProp.hdrScheme != null);
            }
            if (wsProp.cmpStd != null) {
                wsProp.cmpStd = wsProp.cmpStd.getLink();
                assert (wsProp.cmpStd != null);
            }
            if (wsProp.exclGroup != null) {
                wsProp.exclGroup = wsProp.exclGroup.getLink();
                assert (wsProp.exclGroup != null);
            }
            if (wsProp.subTypes != null) {
                HashSet<Integer> dbSubTypes = new HashSet<Integer>();
                for (Integer wsSpecTypeID : wsProp.subTypes) {
                    String specType = ws.getSpeciesTypeService().getSpeciesType(wsSpecTypeID.intValue()).map(SpeciesType::description).orElseThrow();
                    dbSubTypes.add(db.getSpeciesTypeService().getAddSpeciesType(specType).specTypeID());
                }
                wsProp.subTypes = dbSubTypes;
            }
        }
        dbOcc.panelProperties = wsPropertiesCopy;
        dbOcc.filter = Filter.createCopy(wsOcc.filter);
        if (wsOcc.getFilterSpec() != null) {
            dbOcc.specID(wsOcc.getFilterSpec().getLink().getSpecID(), db);
        }
        if (wsOcc.getFilterGroup() != null) {
            dbOcc.setFilterGroup(wsOcc.getFilterGroup().getLink());
        }
        if (wsOcc.getFilterSet() != null) {
            dbOcc.setID(wsOcc.getFilterSet().getLink().getID(), db);
        }
        if (wsOcc.getFilterCmpStd() != null) {
            dbOcc.setFilter(new Filter(wsOcc.getFilterCmpStd().getLink(), true));
        }
        if (wsOcc.getFilterCat() != null) {
            Category dbCat = db.getCategoryService().findCategory(wsOcc.getFilterCat().getMnemonic()).orElse(null);
            if (dbCat != null) {
                dbOcc.setFilterCat(dbCat);
            } else {
                dbCat = db.getCategoryService().findCategoryOrSuperCategory(wsOcc.getFilterCat().getMnemonic()).orElse(null);
                if (dbCat != null) {
                    dbOcc.setFilterCat(dbCat);
                } else {
                    System.out.println("Warning: could not set filter category for ws cat: " + wsOcc.getFilterCat().getMnemonic());
                    dbOcc.filter = null;
                }
            }
        }
        return dbOcc;
    }

    public boolean wasCopiedFrom(PanelTaxonOcc original) {
        return this.original == original;
    }

    public void specID(int specID, SBdb sbdb) throws SQLException {
        if (this.type == PanelTaxonType.TAXON && specID > 0) {
            this.filter = new Filter(sbdb.getTaxon(specID), false);
        }
    }

    public void groupID(int groupID, SBdb sbdb) throws SQLException {
        if (groupID > 0) {
            this.setFilterGroup(sbdb.getTxGroup(groupID));
        }
    }

    void setFilterGroup(TxGroup group) {
        this.filter = new Filter(group, false);
    }

    public void setID(int setID, SBdb sbdb) throws SQLException {
        if (setID > 0) {
            this.filter = new Filter(sbdb.getTxGroupSet(setID), false);
        }
    }

    public void catMnem(String mnem, SBdb sbdb) throws SQLException {
        if (mnem != null && !mnem.isEmpty()) {
            this.setFilterCat(sbdb.getCategoryService().findCategory(mnem).orElse(null));
        }
    }

    public void forEach(int forEachInt) {
        if (forEachInt == Filter.FOR_EACH_CAT) {
            this.filter = new Filter(Filter.FOR_EACH_CAT, false);
        } else if (forEachInt == Filter.FOR_EACH_GROUP) {
            this.filter = new Filter(Filter.FOR_EACH_GROUP, false);
        }
    }

    void setFilterCat(Category cat) {
        this.filter = new Filter(cat, false);
    }

    public PanelTaxonPropertiesBase getProperties() {
        return this.panelProperties;
    }

    public String getCaption() {
        return this.caption;
    }

    public boolean isDefault() {
        return this.isDefaultProps;
    }

    public boolean isOverplot() {
        return this.overplot;
    }

    public void setPropertiesObj(PanelTaxonPropertiesBase props) {
        this.panelProperties = props;
    }

    public Object getFilter() {
        if (this.filter != null) {
            return this.filter.filter;
        }
        return null;
    }

    public Filter getFilterObj() {
        return this.filter;
    }

    public boolean getIncludeSubCats() {
        if (this.filter != null && this.filter.filter instanceof Category) {
            return this.filter.includeSubCats;
        }
        return false;
    }

    public Taxon getFilterSpec() {
        return this.filter != null && this.filter.filter instanceof Taxon ? (Taxon)this.filter.filter : null;
    }

    public TxGroup getFilterGroup() {
        return this.filter != null && this.filter.filter instanceof TxGroup ? (TxGroup)this.filter.filter : null;
    }

    public TxGroupSet getFilterSet() {
        return this.filter != null && this.filter.filter instanceof TxGroupSet ? (TxGroupSet)this.filter.filter : null;
    }

    public Category getFilterCat() {
        return this.filter != null && this.filter.filter instanceof Category ? Category.copy((Category)((Category)this.filter.filter)) : null;
    }

    public Integer getForEachInt() {
        return this.filter != null && this.filter.filter instanceof Integer ? (Integer)this.filter.filter : null;
    }

    public CompositeStandard getFilterCmpStd() {
        return this.filter != null && this.filter.filter instanceof CompositeStandard ? (CompositeStandard)this.filter.filter : null;
    }

    public void highlightGroup(int groupID, SBdb sbdb) throws SQLException {
        if (this.type != PanelTaxonType.TAXON || groupID <= 0) {
            return;
        }
        TxGroup group = sbdb.getTxGroup(groupID);
        ((PanelTaxonProperties)this.getProperties()).setProperty(46, group);
    }

    public void hdrScheme(int schID, SBdb sbdb) throws SQLException {
        if (this.type != PanelTaxonType.TAXON || schID <= 0) {
            return;
        }
        IGDScheme scheme = sbdb.getIGDScheme(schID);
        ((PanelTaxonProperties)this.getProperties()).setProperty(49, scheme);
    }

    public void exclGrp(int exclGrpID, SBdb sbdb) throws SQLException {
        if (this.type != PanelTaxonType.TAXON || exclGrpID <= 0) {
            return;
        }
        TxGroup txGroup = sbdb.getTxGroup(exclGrpID);
        ((PanelTaxonProperties)this.getProperties()).setProperty(5, txGroup);
    }

    public Integer getStdID() {
        if (this.getFilterCmpStd() != null) {
            return this.getFilterCmpStd().getID();
        }
        return this.panelProperties.getStdID();
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.type);
        hash = 97 * hash + Objects.hashCode(this.caption);
        hash = 97 * hash + Objects.hashCode(this.panelProperties);
        hash = 97 * hash + (this.isDefaultProps ? 1 : 0);
        hash = 97 * hash + Objects.hashCode(this.filter);
        hash = 97 * hash + Objects.hashCode(this.overplot);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelTaxonOcc other = (PanelTaxonOcc)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.isDefaultProps != other.isDefaultProps) {
            return false;
        }
        if (this.overplot != other.overplot) {
            return false;
        }
        if (this.caption == null ? other.caption != null : !this.caption.equals(other.caption)) {
            return false;
        }
        if (!(this.panelProperties == other.panelProperties || this.panelProperties != null && this.panelProperties.equals(other.panelProperties))) {
            return false;
        }
        return this.filter == other.filter || this.filter != null && this.filter.equals(other.filter);
    }

    public ImageIcon getIcon() {
        return this.type.getIcon();
    }

    public boolean setCaption(String caption) {
        if (this.caption == null ^ caption == null || this.caption != null && caption != null && !this.caption.equals(caption)) {
            this.caption = caption;
            return true;
        }
        return false;
    }

    public boolean setFilter(Filter filter) {
        Object thisFilter = this.getFilter();
        if (thisFilter == filter) {
            return false;
        }
        if (thisFilter != null && filter == null) {
            this.filter = null;
            return true;
        }
        this.filter = filter;
        if (this.filter.filter instanceof CompositeStandard && this.type == PanelTaxonType.TAXON && ((PanelTaxonProperties)this.panelProperties).cmpStd != null) {
            ((PanelTaxonProperties)this.panelProperties).cmpStd = (CompositeStandard)this.filter.filter;
        }
        return true;
    }

    public boolean setIncludeSubCats(boolean includeSubCats) {
        if (this.filter == null || !(this.filter.filter instanceof Category)) {
            return false;
        }
        if (includeSubCats != this.filter.includeSubCats) {
            this.filter.includeSubCats = includeSubCats;
            return true;
        }
        return false;
    }

    public boolean setIsDefault(boolean isDefault) {
        if (this.isDefaultProps != isDefault) {
            this.isDefaultProps = isDefault;
            return true;
        }
        return false;
    }

    public boolean setOverplot(boolean overplot) {
        if (this.overplot != overplot) {
            this.overplot = overplot;
            return true;
        }
        return false;
    }

    public static Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return CaptionTemplate.class;
            }
            case 1: {
                return Filter.class;
            }
            case 2: 
            case 3: 
            case 4: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public String getPropertiesString() {
        String propString = this.panelProperties.getPropertiesString();
        Object filterString = "";
        filterString = this.filter != null ? (String)filterString + (this.filter.includeSubCats ? 1 : 0) : (String)filterString + "0";
        filterString = (String)filterString + "|" + (this.getFilterCmpStd() != null ? 1 : 0);
        return (String)filterString + "^" + propString;
    }

    public PanelTaxonType getType() {
        return this.type;
    }

    public static class Filter {
        public static final Integer FOR_EACH_CAT = 1;
        public static final Integer FOR_EACH_GROUP = 2;
        Object filter;
        boolean includeSubCats;
        private static final String FE_CAT_STRG = "category";
        private static final String FE_GRP_STRG = "group";

        void setFilter(Object filter, boolean includeSubCats) {
            assert (filter != null);
            this.filter = filter;
            this.includeSubCats = filter instanceof Category || filter instanceof Category[] ? includeSubCats : false;
        }

        public String toString() {
            return this.toString(true);
        }

        String toString(boolean abr) {
            if (this.filter instanceof Category) {
                if (abr) {
                    return ((Category)this.filter).getMnemonic();
                }
                return ((Category)this.filter).getName();
            }
            if (this.filter instanceof Category[]) {
                Object s = "";
                for (Category cat : (Category[])this.filter) {
                    if (!((String)s).isEmpty()) {
                        s = (String)s + ", ";
                    }
                    s = (String)s + (abr ? cat.getMnemonic() : cat.getName());
                }
                return s;
            }
            if (this.filter instanceof TxGroup) {
                return ((TxGroup)this.filter).getName();
            }
            if (this.filter instanceof TxGroupSet) {
                return ((TxGroupSet)this.filter).getName();
            }
            if (this.filter instanceof Taxon) {
                return ((Taxon)this.filter).toString(false, false);
            }
            if (this.filter == FOR_EACH_CAT) {
                return "<panel per category>";
            }
            if (this.filter == FOR_EACH_GROUP) {
                return "<panel per group>";
            }
            return this.filter.toString();
        }

        public Filter(Object filter, boolean includeSubCats) {
            assert (filter != null);
            if (!(filter instanceof Taxon || filter instanceof Category || filter instanceof Category[] || filter instanceof TxGroup || filter instanceof TxGroupSet || filter instanceof CompositeStandard || filter == FOR_EACH_CAT || filter == FOR_EACH_GROUP)) {
                throw new IllegalArgumentException("Attempt to create filter from " + String.valueOf(filter));
            }
            this.filter = filter;
            if (filter instanceof Category) {
                this.includeSubCats = includeSubCats;
            }
        }

        public static Filter createCopy(Filter rhs) {
            if (rhs == null || rhs.filter == null) {
                return null;
            }
            Filter filter = new Filter(rhs.filter, rhs.includeSubCats);
            return filter;
        }

        public Object getFilter() {
            return this.filter;
        }

        public boolean includeSubCats() {
            return this.includeSubCats;
        }

        public boolean isForEach() {
            return this.filter == FOR_EACH_CAT || this.filter == FOR_EACH_GROUP;
        }

        public int hashCode() {
            int hash = 3;
            hash = 47 * hash + (this.filter != null ? this.filter.hashCode() : 0);
            hash = 47 * hash + (this.includeSubCats ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Filter other = (Filter)obj;
            if (!(this.filter == other.filter || this.filter != null && this.filter.equals(other.filter))) {
                return false;
            }
            return this.includeSubCats == other.includeSubCats;
        }

        static String getForEachString(Integer forEachInt) {
            if (Objects.equals(forEachInt, FOR_EACH_CAT)) {
                return FE_CAT_STRG;
            }
            if (Objects.equals(forEachInt, FOR_EACH_GROUP)) {
                return FE_GRP_STRG;
            }
            throw new IllegalArgumentException("Unrecognised forEachInt: " + forEachInt);
        }

        public static Integer parseForEachString(String forEachString) {
            switch (forEachString.toLowerCase()) {
                case "category": {
                    return FOR_EACH_CAT;
                }
                case "group": {
                    return FOR_EACH_GROUP;
                }
            }
            return null;
        }
    }
}

