/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jsbchart.panel.PanelDendrogramProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonType;
import model3.TxGroup;

public abstract class PanelTaxonPropertiesBase
extends PanelProperties {
    Boolean includeTr;
    Boolean includeRw;
    Boolean includeCv;
    Boolean includeCn;
    Boolean includeQ;
    Set<Integer> subTypes = null;
    TxGroup exclGroup = null;
    int thresholdCount = 0;
    boolean useSplits = false;
    boolean normaliseWeight = false;
    float normalWeight = 100.0f;
    static final String PROP_NAME_TR = "Transported";
    static final String PROP_NAME_RW = "Reworked";
    static final String PROP_NAME_CV = "Caved";
    static final String PROP_NAME_CN = "Contamination";
    static final String PROP_NAME_Q = "Questionable";
    static final String PROP_NAME_EXCLGRP = "Exclude group";
    static final String PROP_NAME_SUBTYPES = "Include sub-types";
    static final String PROP_NAME_INHERIT_COLOURS = "Inherit colours";
    static final String PROP_NAME_MIN_COUNT = "Minimum count";

    PanelTaxonPropertiesBase() {
    }

    PanelTaxonPropertiesBase(PanelTaxonPropertiesBase rhs) {
        this.includeTr = rhs.includeTr;
        this.includeRw = rhs.includeRw;
        this.includeCv = rhs.includeCv;
        this.includeCn = rhs.includeCn;
        this.includeQ = rhs.includeQ;
        this.useSplits = rhs.useSplits;
        this.normaliseWeight = rhs.normaliseWeight;
        this.normalWeight = rhs.normalWeight;
        this.subTypes = rhs.subTypes == null ? null : new HashSet<Integer>(rhs.subTypes);
        this.exclGroup = rhs.exclGroup;
        this.thresholdCount = rhs.thresholdCount;
    }

    public abstract PanelTaxonPropertiesBase createCopy();

    public int hashCode() {
        int hash = 5;
        hash = 29 * hash + Objects.hashCode(this.includeRw);
        hash = 29 * hash + Objects.hashCode(this.includeQ);
        hash = 29 * hash + Objects.hashCode(this.includeCv);
        hash = 29 * hash + Objects.hashCode(this.includeTr);
        hash = 29 * hash + Objects.hashCode(this.includeCn);
        hash = 29 * hash + Objects.hashCode(this.subTypes);
        hash = 29 * hash + (this.useSplits ? 1 : 0);
        hash = 29 * hash + (this.normaliseWeight ? 1 : 0);
        hash = 29 * hash + Float.floatToIntBits(this.normalWeight);
        hash = 29 * hash + (this.exclGroup != null ? this.exclGroup.hashCode() : 0);
        hash = 29 * hash + this.thresholdCount;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PanelTaxonPropertiesBase other = (PanelTaxonPropertiesBase)obj;
        if (!(this.subTypes == other.subTypes || this.subTypes != null && this.subTypes.equals(other.subTypes))) {
            return false;
        }
        if (!Objects.equals(this.includeTr, other.includeTr)) {
            return false;
        }
        if (!Objects.equals(this.includeRw, other.includeRw)) {
            return false;
        }
        if (!Objects.equals(this.includeQ, other.includeQ)) {
            return false;
        }
        if (!Objects.equals(this.includeCv, other.includeCv)) {
            return false;
        }
        if (!Objects.equals(this.includeCn, other.includeCn)) {
            return false;
        }
        if (!Objects.equals(this.exclGroup, other.exclGroup)) {
            return false;
        }
        if (this.useSplits != other.useSplits) {
            return false;
        }
        if (this.normaliseWeight != other.normaliseWeight) {
            return false;
        }
        if (this.thresholdCount != other.thresholdCount) {
            return false;
        }
        return Float.floatToIntBits(this.normalWeight) == Float.floatToIntBits(other.normalWeight);
    }

    static PanelTaxonPropertiesBase getDefaultProperties(PanelTaxonType type) {
        switch (type) {
            case TAXON: {
                return new PanelTaxonProperties(null, null);
            }
            case DENDRO: {
                return new PanelDendrogramProperties((String)null);
            }
            case SAMPLES: {
                return null;
            }
        }
        assert (false);
        return null;
    }

    public void addSubType(int specType) {
        if (this.subTypes == null) {
            this.subTypes = new HashSet<Integer>();
        }
        this.subTypes.add(specType);
    }

    public Integer getFilterGrpID() {
        return null;
    }

    public Integer getSchID() {
        return null;
    }

    Integer getStdID() {
        return null;
    }

    public Integer getExclGrpID() {
        return this.exclGroup != null ? Integer.valueOf(this.exclGroup.getID()) : null;
    }

    public Set<Integer> getSubTypes() {
        if (this.subTypes != null) {
            return new HashSet<Integer>(this.subTypes);
        }
        return null;
    }
}

