/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelSamples;
import jsbchart.panel.PanelTaxonBase;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.panel.PanelTaxonSamplesProperties;
import jsbchart.panel.PanelTaxonType;
import model3.Sample;
import util.SBException;

public class PanelTaxonSamples
extends PanelTaxonBase {
    private String[][] sampleString;
    private float width;
    private boolean hasDogLegs = true;
    private PanelTaxonGroup.AnalysisInfo[] analysisInfo;
    float analystWidth = 10.0f;
    float analysisLabelWidth = 0.0f;

    private PanelTaxonSamplesProperties p() {
        return (PanelTaxonSamplesProperties)this.getPanelTaxonOcc().getProperties();
    }

    PanelTaxonSamples(PanelTaxonGroup parent, String props) {
        super(parent, null);
    }

    PanelTaxonSamples(PanelTaxonGroup parent, PanelTaxonOcc occ) {
        super(parent, occ == null ? new PanelTaxonOcc(PanelTaxonType.SAMPLES, true, null, null, false) : occ);
    }

    void setSampleStrings(int size, List<Sample> samples, ChartProperties cp) {
        String[][] newSampleStrings = new String[size][2];
        float newWidth = 0.0f;
        int nSample = 0;
        for (Sample sample : samples) {
            String[] sampleString = PanelSamples.getSampleString(sample, cp, this.getBlock(), this.p().panelSamplesProperties);
            newSampleStrings[nSample] = sampleString;
            float currentSampleWidth = SBGraphics.stringWidth(sampleString[0], cp.getFontSizeSmall()) + 2.0f;
            newWidth = Math.max(currentSampleWidth += 9.5f + (cp.getFontSizeSmall() + 0.85f) * 0.6f, newWidth);
            ++nSample;
        }
        this.sampleString = newSampleStrings;
        this.width = newWidth;
    }

    void completeSampleString(boolean hasDogLegs) {
        if (!hasDogLegs) {
            if (this.p().plotBarren) {
                for (Boolean b : this.parent.barren) {
                    if (!b.booleanValue()) continue;
                    this.width += 4.0f;
                    break;
                }
            }
            this.width -= 8.0f;
        }
        if (this.width < 0.0f) {
            this.width = 0.0f;
        }
        this.hasDogLegs = hasDogLegs;
    }

    void setAnalystStrings(PanelTaxonGroup.AnalysisInfo[] analysisInfo, ChartProperties cp) {
        this.analysisInfo = analysisInfo;
        this.analystWidth = Arrays.stream(analysisInfo).map(info -> info.analystString()).map(analystString -> Float.valueOf(SBGraphics.stringWidthWithFontMetrics(analystString, cp.font, 0, cp.getFontSizeSmall()) + 2.0f)).max(Float::compareTo).orElseGet(() -> Float.valueOf(SBGraphics.fontHeightWithFontMetrics(cp.font, 0, cp.getFontSizeHeader()) + 2.0f)).floatValue();
        this.analysisLabelWidth = Arrays.stream(analysisInfo).map(info -> info.analysisLabel()).filter(Objects::nonNull).map(analystString -> Float.valueOf(SBGraphics.stringWidthWithFontMetrics(analystString, cp.font, 0, cp.getFontSizeSmall()) + 2.0f)).max(Float::compareTo).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    PanelTaxonPropertiesBase getPanelTaxonProperties() {
        return this.p();
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample, Integer iKey, HashSet<CorrelationPoint> cLines, List<String> overplotStackSubHeaders, float headerKeyHeight) throws SBException {
        if (!g.isVisible(x, (bp == this.parent.getBlock().getProp() ? 0.0f : this.parent.getBlock().scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y, this.getWidth(bp), bp.getHeight() + (bp == this.getBlock().getProp() ? this.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        g.setColor(cp.foreground);
        if (this.sampleString != null && this.parent.samplePosition.length == this.sampleString.length) {
            if (this.getBlock().getProp() == bp) {
                PanelSamples.drawSamples(g, y, x, cp, mode, this.p().panelSamplesProperties, this.parent.samplePosition, this.parent.origSamplePosition, this.sampleString, Float.valueOf(this.width), this.getBlock(), this.hasDogLegs);
            } else {
                PanelSamples.drawSamples(g, y, x, cp, mode, this.p().panelSamplesProperties, Arrays.copyOfRange(this.parent.samplePosition, firstSample, lastSample), Arrays.copyOfRange(this.parent.origSamplePosition, firstSample, lastSample), (String[][])Arrays.copyOfRange(this.sampleString, firstSample, lastSample), Float.valueOf(this.width), this.getBlock(), this.hasDogLegs);
            }
        }
        float boxsize = cp.getFontSizeSmall() * 0.6f;
        boolean hasBarren = false;
        for (int j = firstSample; j < lastSample; ++j) {
            if (!this.p().plotBarren || !this.parent.barren[j].booleanValue()) continue;
            float yPos = y + this.getPanelHeaderHeight(cp, mode) + this.parent.samplePosition[j];
            g.fillRect(x + this.width - (this.hasDogLegs ? 3.5f : 1.0f) - boxsize, yPos - boxsize / 2.0f, boxsize, boxsize, cp.foreground);
            hasBarren = true;
        }
        if (hasBarren) {
            g.setFontSize(cp.getFontSizeSmall());
            float yPos = y + this.getPanelHeaderHeight(cp, mode) - 1.0f;
            g.fillRect(x + this.width - 1.0f - boxsize, yPos - boxsize, boxsize, boxsize, cp.foreground);
            g.drawStringVertical("Barren", x + this.width - 1.0f, yPos - boxsize - 1.0f, cp.panelSubHeaderHeight, false, false, true);
        }
        float xpos = x + this.width;
        if (mode != Chart.Mode.NO_HEADER && (this.getBlock().getProp() == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) < 0.01) && this.parent.getnSamples() > 0) {
            Object subHeader = this.getCaption();
            if (subHeader == null) {
                subHeader = "Samples" + (this.getBlock().getProp().getUnits() == 'F' ? " (ft)" : " (m)");
                if (this.parent.getProperties().getProperty(4) == PanelTaxonGroupProperties.AnalysisTypeFilter.PREPARED_ONLY) {
                    subHeader = (String)subHeader + " - prepared";
                }
            }
            this.drawSubHeader(g, x, xpos, y, cp, bp, (String)subHeader);
            g.drawLine(xpos, y + cp.panelCaptionHeight + headerKeyHeight, xpos, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
        } else {
            float topy = Math.min(this.getBlock().scaleDepth(bp.getMin()), this.getBlock().scaleDepth(bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos, topy, xpos, topy + bp.getHeight());
        }
        if ((this.p().analystPanel || this.p().analysisLabels) && this.analysisInfo != null) {
            float fontSize = cp.getFontSizeSmall();
            g.setFont(cp.font, 0, fontSize);
            for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                if (nSample < firstSample || nSample >= lastSample) continue;
                float ypos1 = y + this.getPanelHeaderHeight(cp, mode) + this.parent.samplePosition[nSample];
                float xposColumn = xpos;
                if (this.p().analysisLabels) {
                    if (this.analysisInfo[nSample].analysisLabel() != null) {
                        g.drawString(this.analysisInfo[nSample].analysisLabel(), xposColumn + 1.0f, ypos1 + fontSize * 2.0f / 5.0f);
                    }
                    xposColumn += this.analysisLabelWidth;
                }
                if (!this.p().analystPanel) continue;
                if (this.p().analystColours) {
                    g.setColor(this.analysisInfo[nSample].analystColor());
                }
                g.drawString(this.analysisInfo[nSample].analystString(), xposColumn + 1.0f, ypos1 + fontSize * 2.0f / 5.0f);
            }
            float xposLabels = x + this.width;
            float xposAnalysts = xposLabels + (this.p().analysisLabels ? this.analysisLabelWidth : 0.0f);
            g.setColor(cp.foreground);
            if (mode != Chart.Mode.NO_HEADER && (this.getBlock().getProp() == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) < 0.01) && this.parent.getnSamples() > 0) {
                if (this.p().analystPanel) {
                    this.drawSubHeader(g, xposAnalysts, xposAnalysts + this.analystWidth, y, cp, bp, "Analyst");
                }
                if (this.p().analysisLabels) {
                    g.drawLine(xposAnalysts, y + cp.panelCaptionHeight + headerKeyHeight, xposAnalysts, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
                }
                g.drawLine(xposLabels, y + cp.panelCaptionHeight + headerKeyHeight, xposLabels, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
            } else {
                float topy = Math.min(this.getBlock().scaleDepth(bp.getMin()), this.getBlock().scaleDepth(bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode);
                if (this.p().analysisLabels) {
                    g.drawLine(xposAnalysts, topy, xposAnalysts, topy + bp.getHeight());
                }
                g.drawLine(xposLabels, topy, xposLabels, topy + bp.getHeight());
            }
        }
        return x + this.getWidth(bp);
    }

    @Override
    int getnKeyTracks() {
        return 0;
    }

    @Override
    String getDataProps() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.width + (this.p().analystPanel ? this.analystWidth : 0.0f) + (this.p().analysisLabels ? this.analysisLabelWidth : 0.0f);
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return this.parent.getDiscID().getAbr(true) + " samples";
    }

    @Override
    void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
    }

    @Override
    boolean drawInnerCaption(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        return false;
    }

    @Override
    public void update(Observable o, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    String getText(int nSample, String delim) {
        Object s = this.parent.plotSmpdtl[nSample].getSample().toString(this.parent.getBlock().getProp().getUnits(), (Boolean)this.p().getProperty(0) == false, (Boolean)this.p().getProperty(2) == false);
        if (this.p().analystPanel) {
            s = (String)s + delim + this.analysisInfo[nSample].analystString();
        }
        return s;
    }

    @Override
    String getTextTitle(String delim) {
        Object s = "Samples";
        if (this.p().analystPanel) {
            s = (String)s + delim + "Analyst";
        }
        return s;
    }
}

