/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jsbchart.block.BlockType;
import jsbchart.core.TemplateType;
import model3.DataType;

public final class PanelType
extends Enum<PanelType>
implements TemplateType {
    public static final /* enum */ PanelType SCALE = new PanelType("Scale", Set.of(BlockType.WELL, BlockType.PROJECT, BlockType.SCHEME), false, false, "Scale.png", null, true, false, false, true);
    public static final /* enum */ PanelType SAMPLES = new PanelType("Samples", Set.of(BlockType.WELL), false, true, "samples.png", null, true, false, false, true);
    public static final /* enum */ PanelType MICRO = new PanelType(Discipline.MICRO.getNoun(), Set.of(BlockType.WELL, BlockType.PROJECT), true, true, "micro.png", "dialogpaneltaxon.html", false, false, false, false);
    public static final /* enum */ PanelType NANNO = new PanelType(Discipline.NANNO.getNoun(), Set.of(BlockType.WELL, BlockType.PROJECT), true, true, "nanno.png", "dialogpaneltaxon.html", false, false, false, false);
    public static final /* enum */ PanelType PALY = new PanelType(Discipline.PALY.getNoun(), Set.of(BlockType.WELL, BlockType.PROJECT), true, true, "paly.png", "dialogpaneltaxon.html", false, false, false, false);
    public static final /* enum */ PanelType MACRO = new PanelType(Discipline.MACRO.getNoun(), Set.of(BlockType.WELL, BlockType.PROJECT), true, true, "macro.png", "dialogpaneltaxon.html", false, false, false, false);
    public static final /* enum */ PanelType BIOCOMS = new PanelType("Biostratigraphic Comments", Set.of(BlockType.WELL), true, false, "Biocoms.png", null, true, false, false, true);
    public static final /* enum */ PanelType EVENT = new PanelType("Events", Set.of(BlockType.WELL), true, false, "Events.png", null, true, false, false, true);
    public static final /* enum */ PanelType SQPICK = new PanelType("Sequence Picks", Set.of(BlockType.WELL), true, false, "Sequence.png", null, false, true, false, false);
    public static final /* enum */ PanelType CHRONOZONE = new PanelType("Chronostratigraphy", Set.of(BlockType.WELL), true, false, "Zone.png", null, false, true, false, false);
    public static final /* enum */ PanelType LITHOZONE = new PanelType("Lithostratigraphy", Set.of(BlockType.WELL), true, false, "Zone.png", null, false, true, false, false);
    public static final /* enum */ PanelType MICROZONE = new PanelType("Biozone (" + Discipline.MICRO.getAbr(true) + ")", Set.of(BlockType.WELL), true, false, "Zone.png", null, false, true, true, false);
    public static final /* enum */ PanelType NANNOZONE = new PanelType("Biozone (" + Discipline.NANNO.getAbr(true) + ")", Set.of(BlockType.WELL), true, false, "Zone.png", null, false, true, true, false);
    public static final /* enum */ PanelType PALYZONE = new PanelType("Biozone (" + Discipline.PALY.getAbr(true) + ")", Set.of(BlockType.WELL), true, false, "Zone.png", null, false, true, true, false);
    public static final /* enum */ PanelType MACROZONE = new PanelType("Biozone (" + Discipline.MACRO.getAbr(true) + ")", Set.of(BlockType.WELL), true, false, "Zone.png", null, false, true, true, false);
    public static final /* enum */ PanelType ENV = new PanelType("Palaeoenvironments", Set.of(BlockType.WELL), true, false, "env.png", null, false, false, false, false);
    public static final /* enum */ PanelType INTCOM = new PanelType("Interval Comments", Set.of(BlockType.WELL), true, false, "intcoms.png", null, true, false, false, false);
    public static final /* enum */ PanelType WLOG = new PanelType("Wireline Logs", Set.of(BlockType.WELL), false, false, "curve.png", "howtowireline.html#panel", false, false, false, false);
    public static final /* enum */ PanelType INTLITH = new PanelType("Interpreted Lithology", Set.of(BlockType.WELL), false, true, "intLith.png", null, true, false, false, true);
    public static final /* enum */ PanelType SAMPLELITH = new PanelType("Sample Lithology", Set.of(BlockType.WELL), false, true, "SampleLith.png", null, true, false, false, true);
    public static final /* enum */ PanelType DEPTHAGE = new PanelType("Depth/Age", Set.of(BlockType.WELL), true, true, "depthAge.png", null, false, false, false, false);
    public static final /* enum */ PanelType ACCUMRATE = new PanelType("Accumulation Rate", Set.of(BlockType.WELL, BlockType.PROJECT), true, true, "depthAge.png", null, false, false, false, false);
    public static final /* enum */ PanelType SUBSIDENCE = new PanelType("Subsidence", Set.of(BlockType.PROJECT), false, false, "depthAge.png", null, false, false, false, false);
    public static final /* enum */ PanelType VS = new PanelType("Vertical Section", Set.of(BlockType.WELL), true, true, "vs.png", "dialogtvdoffsetchart.html", true, false, false, false);
    public static final /* enum */ PanelType CASING = new PanelType("Casing", Set.of(BlockType.WELL), false, true, "casing.png", null, true, false, false, true);
    public static final /* enum */ PanelType CORES = new PanelType("Cored Intervals", Set.of(BlockType.WELL), false, true, "cores.png", null, false, false, false, true);
    public static final /* enum */ PanelType COREIMAGES = new PanelType("Core Images", Set.of(BlockType.WELL), false, true, "coreImages.png", null, true, false, false, true);
    public static final /* enum */ PanelType MARKERS = new PanelType("Seismic Markers", Set.of(BlockType.WELL), false, true, "markers.png", null, true, false, false, true);
    public static final /* enum */ PanelType CHROMALOG = new PanelType("Chromatic Log", Set.of(BlockType.WELL), false, false, "curve.png", null, false, false, false, false);
    public static final /* enum */ PanelType CHRONOSCHEME = new PanelType("Chronostratigraphy Scheme", Set.of(BlockType.SCHEME), false, false, "Zone.png", null, false, true, false, false);
    public static final /* enum */ PanelType LITHOSCHEME = new PanelType("Lithostratigraphy Scheme", Set.of(BlockType.SCHEME), false, false, "Zone.png", null, false, true, false, false);
    public static final /* enum */ PanelType BIOSCHEME = new PanelType("Biozone Scheme", Set.of(BlockType.SCHEME), false, false, "Zone.png", null, false, true, false, false);
    public static final /* enum */ PanelType SURFACE = new PanelType("Surfaces", Set.of(BlockType.SCHEME), false, false, "Sequence.png", null, false, true, false, false);
    public static final /* enum */ PanelType SEQUENCE = new PanelType("Sequences", Set.of(BlockType.SCHEME), false, false, "Zone.png", null, false, true, false, false);
    public static final /* enum */ PanelType CMPSTD = new PanelType("Composite Standard", Set.of(BlockType.SCHEME), false, false, "Events.png", null, true, false, false, false);
    public static final /* enum */ PanelType RANGE = new PanelType("Stratigraphic Range", Set.of(BlockType.SCHEME), false, false, "range.png", "rangechart.html", false, false, false, false);
    public static final /* enum */ PanelType AGECURVE = new PanelType("Age Curve", Set.of(BlockType.SCHEME), false, false, "curve.png", null, false, false, false, false);
    public static final /* enum */ PanelType MAGNETOSCHEME = new PanelType("Magnetostratigraphy", Set.of(BlockType.SCHEME), false, false, "chron.png", "magnetostrat.html", false, true, false, false);
    public static final /* enum */ PanelType BLANK = new PanelType("Blank", Set.of(BlockType.WELL, BlockType.PROJECT, BlockType.SCHEME), false, false, "blank.png", null, true, false, false, false);
    public static final /* enum */ PanelType PIN = new PanelType("Well Marker", Set.of(BlockType.MAP), false, true, "layer_location.png");
    public static final /* enum */ PanelType SIDETRACKLAYER = new PanelType("Sidetracks", Set.of(BlockType.MAP), true, true, "layer_location.png");
    public static final /* enum */ PanelType SHAPE = new PanelType("Shape", Set.of(BlockType.MAP), false, false, "layer_shape.png");
    public static final /* enum */ PanelType COVERAGE = new PanelType("Data Coverage", Set.of(BlockType.MAP), true, true, "layer_coverage.png");
    public static final /* enum */ PanelType SETLAYER = new PanelType("Taxa", Set.of(BlockType.MAP), false, true, "layer_pie.png");
    public static final /* enum */ PanelType ENVLAYER = new PanelType("Palaeoenvironments", Set.of(BlockType.MAP), true, true, "layer_pie.png");
    public static final /* enum */ PanelType LITHLAYER = new PanelType("Lithology", Set.of(BlockType.MAP), false, true, "layer_pie.png");
    public static final /* enum */ PanelType S_CROP_LAYER = new PanelType("Sub-crop/Supra-crop", Set.of(BlockType.MAP), true, true, "layer_sucrop.png");
    public static final /* enum */ PanelType PRESABSLAYER = new PanelType("Presence/Absence", Set.of(BlockType.MAP), true, true, "layer_presabs.png");
    public static final /* enum */ PanelType ACCUMRATELAYER = new PanelType("Accumulation Rate/Thickness", Set.of(BlockType.MAP), true, true, "layer_pie.png");
    private static final String ICON_ROOT = "/icon/panel/";
    private final String name;
    private final Set<BlockType> supportedBlockTypes;
    private final ImageIcon icon;
    private final boolean isInterp;
    private final boolean wellObserver;
    private final String html;
    public final boolean allowCaptionOrientationChange;
    public final boolean allowExtendedCaption;
    public final boolean allowOverplot;
    public final boolean captionPreference;
    private static final EnumMap<BlockType, List<PanelType>> blockTypeMap;
    private static final /* synthetic */ PanelType[] $VALUES;

    public static PanelType[] values() {
        return (PanelType[])$VALUES.clone();
    }

    public static PanelType valueOf(String name) {
        return Enum.valueOf(PanelType.class, name);
    }

    private PanelType(String name, Set<BlockType> supportedTypes, boolean isInterp, boolean wellObserver, String iconLocation) {
        this(name, supportedTypes, isInterp, wellObserver, iconLocation, null, false, false, false, false);
    }

    private PanelType(String name, Set<BlockType> supportedTypes, boolean isInterp, boolean wellObserver, String iconLocation, String html, boolean allowCaptionOrientationChange, boolean allowExtendedCaption, boolean allowOverplot, boolean captionPreference) {
        ImageIcon imageIcon;
        this.name = name;
        this.supportedBlockTypes = supportedTypes;
        this.isInterp = isInterp;
        this.wellObserver = wellObserver;
        try {
            imageIcon = new ImageIcon(PanelType.class.getResource(ICON_ROOT + iconLocation));
        }
        catch (Exception e) {
            imageIcon = null;
        }
        this.icon = imageIcon;
        this.html = html;
        this.allowCaptionOrientationChange = allowCaptionOrientationChange;
        this.allowExtendedCaption = allowExtendedCaption;
        this.allowOverplot = allowOverplot;
        this.captionPreference = captionPreference;
    }

    public String toString() {
        return this.name;
    }

    public boolean canPlot(BlockType type) {
        return this.supportedBlockTypes.contains(type);
    }

    public String typeString() {
        if (this.canPlot(BlockType.MAP)) {
            return "Layer";
        }
        return "Panel";
    }

    public static int getnPanels(BlockType type) {
        int nPanels = 0;
        for (PanelType t : PanelType.values()) {
            if (!t.canPlot(type)) continue;
            ++nPanels;
        }
        return nPanels;
    }

    public boolean isInterpPanel() {
        return this.isInterp;
    }

    public boolean isWellObserver() {
        return this.wellObserver;
    }

    public static boolean isTaxonPanel(PanelType t) {
        return t == MICRO || t == NANNO || t == PALY || t == MACRO;
    }

    public static boolean isBiozonePanel(PanelType t) {
        return t == MICROZONE || t == NANNOZONE || t == PALYZONE || t == MACROZONE;
    }

    public static boolean isAnalystPanel(PanelType t) {
        switch (t.ordinal()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    public static List<PanelType> getPanelTypes(BlockType blockType) {
        List<PanelType> panelTypes = blockTypeMap.get(blockType);
        if (panelTypes == null) {
            panelTypes = new ArrayList<PanelType>();
            for (PanelType t : PanelType.values()) {
                if (!t.canPlot(blockType)) continue;
                panelTypes.add(t);
            }
            blockTypeMap.put(blockType, panelTypes);
        }
        return panelTypes;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Discipline getDiscipine() {
        switch (this.ordinal()) {
            case 2: 
            case 11: {
                return Discipline.MICRO;
            }
            case 3: 
            case 12: {
                return Discipline.NANNO;
            }
            case 4: 
            case 13: {
                return Discipline.PALY;
            }
            case 5: 
            case 14: {
                return Discipline.MACRO;
            }
        }
        return null;
    }

    public String getHtml() {
        assert (this.html == null || this.html.endsWith(".html") || this.html.contains(".html#"));
        return this.html;
    }

    public static PanelType getDiscType(Discipline d) {
        switch (d) {
            case MICRO: {
                return MICRO;
            }
            case PALY: {
                return PALY;
            }
            case NANNO: {
                return NANNO;
            }
            case MACRO: {
                return MACRO;
            }
        }
        assert (false);
        return null;
    }

    public static PanelType getBiozoneType(Discipline d) {
        switch (d) {
            case MICRO: {
                return MICROZONE;
            }
            case PALY: {
                return PALYZONE;
            }
            case NANNO: {
                return NANNOZONE;
            }
            case MACRO: {
                return MACROZONE;
            }
        }
        assert (false);
        return null;
    }

    public static boolean requiresScheme(PanelType type) {
        switch (type.ordinal()) {
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public static DataType getDataType(PanelType type) {
        switch (type.ordinal()) {
            case 9: 
            case 29: {
                return DataType.CHRONOSTRAT;
            }
            case 10: 
            case 30: {
                return DataType.LITHOSTRAT;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 31: {
                return DataType.BIOZONE;
            }
        }
        return null;
    }

    public static PanelType getSchemeType(int igdType) {
        switch (igdType) {
            case 3: {
                return CHRONOSCHEME;
            }
            case 2: {
                return LITHOSCHEME;
            }
            case 4: {
                return BIOSCHEME;
            }
            case 10: {
                return SEQUENCE;
            }
        }
        return null;
    }

    @Override
    public String getNoun() {
        return this.name + " " + this.typeString();
    }

    public static boolean canOverplot(PanelType under, PanelType over) {
        return PanelType.isBiozonePanel(under) && PanelType.isBiozonePanel(over);
    }

    private static /* synthetic */ PanelType[] $values() {
        return new PanelType[]{SCALE, SAMPLES, MICRO, NANNO, PALY, MACRO, BIOCOMS, EVENT, SQPICK, CHRONOZONE, LITHOZONE, MICROZONE, NANNOZONE, PALYZONE, MACROZONE, ENV, INTCOM, WLOG, INTLITH, SAMPLELITH, DEPTHAGE, ACCUMRATE, SUBSIDENCE, VS, CASING, CORES, COREIMAGES, MARKERS, CHROMALOG, CHRONOSCHEME, LITHOSCHEME, BIOSCHEME, SURFACE, SEQUENCE, CMPSTD, RANGE, AGECURVE, MAGNETOSCHEME, BLANK, PIN, SIDETRACKLAYER, SHAPE, COVERAGE, SETLAYER, ENVLAYER, LITHLAYER, S_CROP_LAYER, PRESABSLAYER, ACCUMRATELAYER};
    }

    static {
        $VALUES = PanelType.$values();
        blockTypeMap = new EnumMap(BlockType.class);
    }
}

