/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.util.LogInfo;
import model3.DataType;
import model3.IGDColMap;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.LogDef;
import model3.SBdb;
import util.SBException;

public class PanelWellVSProperties
extends PanelProperties {
    float curveWeight = 3.0f;
    final float curveWeightPlan = 1.5f;
    final Color plainColor = Color.DARK_GRAY;
    final Color plainColorPlan = Color.LIGHT_GRAY;
    boolean coverSurveyRange;
    boolean drawSamples = false;
    boolean drawFaults = false;
    boolean drawPlan = false;
    boolean drawGridLines = true;
    boolean drawIGD = false;
    VSInterpretationType igdType = null;
    IGDScheme biozoneScheme = null;
    int col = -1;
    boolean drawUnitNames = false;
    boolean useAbrs = false;
    boolean drawEvents = false;
    EventLabelStyle eventLabelStyle = EventLabelStyle.KEY;
    public static final int PROP_RANGE = 0;
    public static final int PROP_WEIGHT = 1;
    public static final int PROP_SAMPLES = 2;
    public static final int PROP_FAULTS = 3;
    public static final int PROP_PLAN = 4;
    public static final int PROP_GRIDLINES = 5;
    public static final int PROP_IGD = 6;
    public static final int PROP_IGD_TYPE = 7;
    public static final int PROP_SCHID = 8;
    public static final int PROP_COL = 9;
    public static final int PROP_UNITNAMES = 10;
    public static final int PROP_ABRS = 11;
    public static final int PROP_EVENTS = 12;
    public static final int PROP_EV_LABEL = 13;
    public static final int PROP_L1_DEF = 14;
    public static final int PROP_L1_WIDTH = 15;
    public static final int PROP_l1_OFFSET = 16;
    public static final int PROP_l1_SHIFT = 17;
    public static final int PROP_L1_LINE = 18;
    public static final int PROP_L2_DEF = 19;
    public static final int PROP_L2_WIDTH = 20;
    public static final int PROP_l2_OFFSET = 21;
    public static final int PROP_l2_SHIFT = 22;
    public static final int PROP_L2_LINE = 23;
    private static final String[] propNames = new String[]{"Restrict to survey range", "Curve weight", "Samples", "Faults", "Plan", "Grid lines", "Intervals", "Type", "Scheme", "Column", "Unit names", "Use abrs", "Events", "Event label style"};
    private static final int[] titleRows = new int[]{0, 2, 8, 17};
    private static final String[] titleNames = new String[]{"Horizontal Scale", "Style", "Interpretations", "Wireline Logs"};
    LogInfo logInfo1 = new LogInfo();
    LogInfo logInfo2 = new LogInfo();

    @Override
    public int getnProps() {
        return propNames.length + 10;
    }

    @Override
    public String getPropertyName(int nProp) {
        switch (nProp) {
            default: 
        }
        if (nProp < propNames.length) {
            return propNames[nProp];
        }
        if (nProp == 14) {
            return "Trace 1";
        }
        if (nProp == 19) {
            return "Trace 2";
        }
        if (nProp > this.getnProps()) {
            throw new IllegalArgumentException("No property for PanelWirelineLogs at " + nProp);
        }
        nProp -= propNames.length;
        while (nProp > LogInfo.PROP_NAMES.length - 1) {
            nProp -= 5;
        }
        return "   " + LogInfo.PROP_NAMES[nProp];
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    @Override
    public int getIGDSchemeID() {
        if (this.biozoneScheme != null) {
            return this.biozoneScheme.getID();
        }
        return super.getIGDSchemeID();
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.coverSurveyRange;
            }
            case 1: {
                return Float.valueOf(this.curveWeight);
            }
            case 2: {
                return this.drawSamples;
            }
            case 3: {
                return this.drawFaults;
            }
            case 4: {
                return this.drawPlan;
            }
            case 5: {
                return this.drawGridLines;
            }
            case 6: {
                return this.drawIGD;
            }
            case 7: {
                return this.igdType;
            }
            case 8: {
                return this.biozoneScheme;
            }
            case 9: {
                return this.col;
            }
            case 10: {
                return this.drawUnitNames;
            }
            case 11: {
                return this.useAbrs;
            }
            case 12: {
                return this.drawEvents;
            }
            case 13: {
                return this.eventLabelStyle;
            }
            case 14: {
                return this.logInfo1.getLogDef();
            }
            case 15: {
                return Float.valueOf(this.logInfo1.getLogColWidth());
            }
            case 16: {
                return Float.valueOf(this.logInfo1.getLogTraceOffset());
            }
            case 17: {
                return this.logInfo1.getLogShift();
            }
            case 18: {
                return this.logInfo1.getLogScaleLine();
            }
            case 19: {
                return this.logInfo2.getLogDef();
            }
            case 20: {
                return Float.valueOf(this.logInfo2.getLogColWidth());
            }
            case 21: {
                return Float.valueOf(this.logInfo2.getLogTraceOffset());
            }
            case 22: {
                return this.logInfo2.getLogShift();
            }
            case 23: {
                return this.logInfo2.getLogScaleLine();
            }
        }
        return null;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                return this.drawIGD;
            }
            case 8: {
                return this.drawIGD & this.igdType == VSInterpretationType.BIOZONE;
            }
            case 13: {
                return this.drawEvents;
            }
        }
        if (row > propNames.length - 1 && row != 14 && row != 19) {
            if ((row -= propNames.length) > 5) {
                return this.logInfo2.getLogDef() != null;
            }
            return this.logInfo1.getLogDef() != null;
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        switch (nProp) {
            case 0: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.coverSurveyRange = (Boolean)prop;
                    break;
                }
                case 1: {
                    return this.setWeight(prop);
                }
                case 2: {
                    this.drawSamples = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.drawFaults = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.drawPlan = (Boolean)prop;
                    break;
                }
                case 5: {
                    this.drawGridLines = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.drawIGD = (Boolean)prop;
                    if (!this.drawIGD) break;
                    if (this.igdType == null) {
                        this.igdType = VSInterpretationType.CHRONO;
                    }
                    this.setDefaultHier();
                    break;
                }
                case 7: {
                    this.igdType = (VSInterpretationType)((Object)prop);
                    if (this.igdType != VSInterpretationType.BIOZONE) {
                        this.biozoneScheme = null;
                    }
                    this.setDefaultHier();
                    break;
                }
                case 8: {
                    this.biozoneScheme = (IGDScheme)prop;
                    if (this.biozoneScheme.getIGDType() == 4) break;
                    this.biozoneScheme = null;
                    break;
                }
                case 9: {
                    this.col = (Integer)prop;
                    break;
                }
                case 10: {
                    this.drawUnitNames = (Boolean)prop;
                    break;
                }
                case 11: {
                    this.useAbrs = (Boolean)prop;
                    break;
                }
                case 12: {
                    this.drawEvents = (Boolean)prop;
                    break;
                }
                case 13: {
                    this.eventLabelStyle = (EventLabelStyle)((Object)prop);
                    break;
                }
                case 14: {
                    this.logInfo1.setLogDef((LogDef)prop);
                    break;
                }
                case 19: {
                    this.logInfo2.setLogDef((LogDef)prop);
                    break;
                }
                case 18: {
                    this.logInfo1.setLogScaleLine((Boolean)prop);
                    break;
                }
                case 23: {
                    this.logInfo2.setLogScaleLine((Boolean)prop);
                    break;
                }
                case 15: {
                    return this.logInfo1.setColWidth(prop);
                }
                case 20: {
                    return this.logInfo2.setColWidth(prop);
                }
                case 16: {
                    return this.logInfo1.setTraceOffset(prop);
                }
                case 21: {
                    return this.logInfo2.setTraceOffset(prop);
                }
                case 17: {
                    return this.logInfo1.setShift(prop);
                }
                case 22: {
                    return this.logInfo2.setShift(prop);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setWeight(Object prop) {
        float value = prop instanceof String ? Float.parseFloat((String)prop) : ((Float)prop).floatValue();
        if ((double)Math.abs(this.curveWeight - value) > 0.001 && (double)value > 0.01 && (double)value < 10.1) {
            this.curveWeight = value;
            return true;
        }
        return false;
    }

    private void setDefaultHier() {
        try {
            this.col = IGDIntervalZone.getDefaultHier((int)this.igdType.getIGDType());
        }
        catch (SBException e) {
            e.printStackTrace();
            this.col = -1;
        }
    }

    @Override
    public PanelProperties copy() {
        return PanelWellVSProperties.createCopy(this);
    }

    private PanelWellVSProperties() {
        super(PanelType.VS);
    }

    private static PanelWellVSProperties createCopy(PanelWellVSProperties rhs) {
        PanelWellVSProperties p = new PanelWellVSProperties();
        p.copy(rhs);
        return p;
    }

    @Override
    public DataType getDataType() {
        if (this.igdType != null) {
            return this.igdType.getDataType();
        }
        return null;
    }

    @Override
    public String getPropertiesString() {
        String[] props = new String[]{"" + (this.coverSurveyRange ? 1 : 0), "", "", "", "" + this.curveWeight, "" + (this.drawSamples ? 1 : 0), "" + (this.drawFaults ? 1 : 0), "" + (this.drawPlan ? 1 : 0), "" + (this.drawGridLines ? 1 : 0), "" + (this.drawIGD ? 1 : 0), this.igdType != null ? this.igdType.name() : "", "" + this.col, "" + (this.drawUnitNames ? 1 : 0), "" + (this.useAbrs ? 1 : 0), "" + (this.drawEvents ? 1 : 0), this.eventLabelStyle.name()};
        Object string = "";
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelWellVSProperties)) {
            throw new IllegalArgumentException("PanelWellVSProperties cannot copy " + String.valueOf(pp));
        }
        PanelWellVSProperties rhs = (PanelWellVSProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                default: 
            }
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 1: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                return Float.class;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 23: {
                return Boolean.class;
            }
            case 8: {
                return IGDScheme.class;
            }
            case 9: {
                return IGDColMap.class;
            }
            case 7: {
                return VSInterpretationType.class;
            }
            case 13: {
                return EventLabelStyle.class;
            }
            case 14: 
            case 19: {
                return LogInfo.class;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public HashMap<String, String> getLogDefs() {
        LogInfo[] arr;
        if (this.logInfo1.getLogDef() == null && this.logInfo2.getLogDef() == null) {
            return null;
        }
        HashMap<String, String> defStrings = new HashMap<String, String>();
        for (LogInfo arr1 : arr = new LogInfo[]{this.logInfo1, this.logInfo2}) {
            if (arr1.getLogDef() == null) continue;
            defStrings.put(arr1.getLogDef().getAbr(), arr1.getPropertiesString());
        }
        return defStrings;
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[]{String.valueOf((Object)this.igdType), "" + (this.biozoneScheme != null ? this.biozoneScheme.getID() : -1), "" + (this.drawSamples ? 1 : 0), "" + (this.drawFaults ? 1 : 0), "" + (this.drawIGD ? 1 : 0), "" + (this.drawPlan ? 1 : 0), "" + (this.drawUnitNames ? 1 : 0), "" + (this.useAbrs ? 1 : 0), "" + this.col, "" + this.logInfo1.getLogColWidth(), "" + this.logInfo1.getLogTraceOffset(), "" + (this.logInfo1.getLogScaleLine() ? 1 : 0), this.logInfo1.getLogDef() != null ? this.logInfo1.getLogDef().getAbr() : "0", "" + this.logInfo2.getLogColWidth(), "" + this.logInfo2.getLogTraceOffset(), "" + (this.logInfo2.getLogScaleLine() ? 1 : 0), this.logInfo2.getLogDef() != null ? this.logInfo2.getLogDef().getAbr() : "0", "" + (this.drawEvents ? 1 : 0), String.valueOf((Object)this.eventLabelStyle), "" + (this.drawGridLines ? 1 : 0), "" + this.curveWeight};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public boolean allowNull(int row) {
        switch (row) {
            case 14: 
            case 19: {
                return true;
            }
        }
        return super.allowNull(row);
    }

    PanelWellVSProperties(SBdb sbdb, String prop, IGDScheme scheme, HashMap<String, String> logInfo) throws SQLException {
        super(PanelType.VS);
        int i;
        if (logInfo != null) {
            LogInfo[] logArr = new LogInfo[]{this.logInfo1, this.logInfo2};
            i = 0;
            for (Map.Entry<String, String> entry : logInfo.entrySet()) {
                String[] data = entry.getValue().split("\\^");
                logArr[i].setLogDef(new LogDef(data[0]));
                String[] logDefData = data[1].split("\\|");
                block25: for (int j = 0; j < logDefData.length; ++j) {
                    switch (j) {
                        case 0: {
                            logArr[i].setLogColWidth(Float.parseFloat(logDefData[j]));
                            continue block25;
                        }
                        case 1: {
                            logArr[i].setLogTraceOffset(Float.parseFloat(logDefData[j]));
                            continue block25;
                        }
                        case 2: {
                            logArr[i].setLogShift(Float.parseFloat(logDefData[j]));
                            continue block25;
                        }
                        case 3: {
                            logArr[i].setLogScaleLine(Integer.parseInt(logDefData[j]) == 1);
                        }
                    }
                }
                ++i;
            }
        }
        if (prop != null) {
            String[] splits = prop.split("\\|");
            block26: for (i = 0; i < splits.length; ++i) {
                switch (i) {
                    case 0: {
                        this.coverSurveyRange = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 1: {
                        continue block26;
                    }
                    case 2: {
                        continue block26;
                    }
                    case 3: {
                        continue block26;
                    }
                    case 4: {
                        this.curveWeight = Float.parseFloat(splits[i]);
                        continue block26;
                    }
                    case 5: {
                        this.drawSamples = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 6: {
                        this.drawFaults = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 7: {
                        this.drawPlan = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 8: {
                        this.drawGridLines = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 9: {
                        this.drawIGD = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 10: {
                        this.igdType = splits[i].isEmpty() ? null : VSInterpretationType.valueOf(splits[i]);
                        continue block26;
                    }
                    case 11: {
                        this.col = Integer.parseInt(splits[i]);
                        continue block26;
                    }
                    case 12: {
                        this.drawUnitNames = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 13: {
                        this.useAbrs = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 14: {
                        this.drawEvents = Integer.parseInt(splits[i]) == 1;
                        continue block26;
                    }
                    case 15: {
                        this.eventLabelStyle = EventLabelStyle.valueOf(splits[i]);
                    }
                }
            }
        }
        this.biozoneScheme = scheme;
        if (this.biozoneScheme != null && this.biozoneScheme.getIGDType() != 4) {
            this.biozoneScheme = null;
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Float.floatToIntBits(this.curveWeight);
        hash = 89 * hash + (this.coverSurveyRange ? 1 : 0);
        hash = 89 * hash + (this.drawSamples ? 1 : 0);
        hash = 89 * hash + (this.drawFaults ? 1 : 0);
        hash = 89 * hash + (this.drawPlan ? 1 : 0);
        hash = 89 * hash + (this.drawGridLines ? 1 : 0);
        hash = 89 * hash + (this.drawIGD ? 1 : 0);
        hash = 89 * hash + Objects.hashCode((Object)this.igdType);
        hash = 89 * hash + Objects.hashCode(this.biozoneScheme);
        hash = 89 * hash + this.col;
        hash = 89 * hash + (this.drawUnitNames ? 1 : 0);
        hash = 89 * hash + (this.useAbrs ? 1 : 0);
        hash = 89 * hash + (this.drawEvents ? 1 : 0);
        hash = 89 * hash + Objects.hashCode((Object)this.eventLabelStyle);
        hash = 89 * hash + Objects.hashCode(this.logInfo1);
        hash = 89 * hash + Objects.hashCode(this.logInfo2);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelWellVSProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelWellVSProperties rhs = (PanelWellVSProperties)comp;
        block3: for (int i = 0; i < propNames.length; ++i) {
            switch (i) {
                case 1: {
                    if (!(Math.abs(this.curveWeight - rhs.curveWeight) > 0.5f)) continue block3;
                    return false;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block3;
                    return false;
                }
            }
        }
        if (!Objects.equals(this.logInfo1, rhs.logInfo1)) {
            if (this.logInfo1.getLogDef() == null ^ this.logInfo1.getLogDef() == null) {
                return false;
            }
            if (!this.logInfo1.isSimilarTo(rhs.logInfo1)) {
                return false;
            }
        }
        if (!Objects.equals(this.logInfo2, rhs.logInfo2)) {
            if (this.logInfo2.getLogDef() == null ^ this.logInfo2.getLogDef() == null) {
                return false;
            }
            if (!this.logInfo2.isSimilarTo(rhs.logInfo2)) {
                return false;
            }
        }
        return true;
    }

    public static enum VSInterpretationType {
        CHRONO("Chronostrat.", 3, DataType.CHRONOSTRAT),
        LITHO("Lithostrat.", 2, DataType.LITHOSTRAT),
        BIOZONE("Biozone", 4, DataType.BIOZONE);

        private String name;
        private int igdType;
        private DataType dataType;

        private VSInterpretationType(String name, int igdType, DataType dataType) {
            this.name = name;
            this.igdType = igdType;
            this.dataType = dataType;
        }

        public String toString() {
            return this.name;
        }

        public int getIGDType() {
            return this.igdType;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }

    public static enum EventLabelStyle {
        HORZ("Horizontal"),
        KEY("Key"),
        NONE("None");

        private String name;

        private EventLabelStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

