/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrDrawUtils;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextWrapper;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.panel.PanelIntcoms;
import jsbchart.panel.PanelIntcomsProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelZoneBoundary;
import jsbchart.panel.PanelZonesProperties;
import jsbchart.panel.SBPanel;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.ChartObject;
import jsbchart.util.DrawZone;
import jsbchart.util.DrawingUtils;
import model3.Fault;
import model3.IGDColMap;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.Intcom;
import model3.InterpHdr;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import model3.exception.SuppressedSQLException;
import org.apache.commons.lang3.StringUtils;
import util.ColourUtils;
import util.DepthUtils;
import util.RectUtils;
import util.SBException;
import util.exception.StackError;

public class PanelZones
extends SBPanelHTML {
    private final WellBlock block;
    private PanelZonesProperties p;
    public static final String BND_PREFIX = "Bnd: ";
    private static final Logger LOGGER = Logger.getLogger(PanelZones.class.getName());
    private static final float SMALL_ZONE_EXPANSION = 2.5f;
    private static final float CORR_TICK_SIZE = 3.0f;
    private static final float MIN_DEPTH_FONT_SIZE = 1.1f;
    private static final float INTERVAL_BOX_PADDING = 0.1f;
    private static final float HATCH_SIZE = 1.0f;
    private final List<ChartObject> disconformities = new LinkedList<ChartObject>();
    private final List<PanelData> panelDataList = new LinkedList<PanelData>();

    private Stream<DrawColumn> allDrawColumns() {
        return this.panelDataList.stream().flatMap(panelData -> panelData.columns.stream());
    }

    private Stream<DrawZone> allDrawZones() {
        return this.allDrawColumns().flatMap(drawColumn -> drawColumn.drawZones.stream());
    }

    public PanelZones(PanelTemplate template, PanelOcc occ, WellBlock block) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelZonesProperties)template.getProperties();
        this.init();
    }

    private void init() throws SQLException, SBException {
        if (this.block.getWell() != null) {
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object obj = this.getObject(x, y, cp, bp, zoom);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String toString() {
        Object string = IGDInterval.getIGDName((int)this.getIGDType());
        String interpString = this.getInterpString();
        string = (String)string + (String)(interpString != null ? " : " + interpString : "");
        return string;
    }

    String getInterpString() {
        String interpString = null;
        try {
            interpString = this.block.getWell() != null ? String.valueOf(this.block.getWell().getInterp(this.getInterpID(this.block))) : String.valueOf(this.getDb().getInterp(this.getInterpID()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return interpString;
    }

    public Sample getSample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        try {
            return this.block.getWell().getSampleNearest((double)depth, 2500.0f / zoom, cp.correctDepths, cp.correctCuttings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Sample getNearestSampleWithinBounds(float y, ChartProperties cp) {
        float depth = this.block.getDepth(y, this.block.getProp());
        float minDepth = this.block.getMDLimit(true);
        float maxDepth = this.block.getMDLimit(false);
        if (depth < minDepth || depth > maxDepth) {
            return null;
        }
        try {
            return this.block.getWell().getSampleNearestWithinRange((double)depth, cp.correctDepths, cp.correctCuttings, minDepth, maxDepth);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Sample getBoundarySample(float x, float y, float zoom, ChartProperties cp, BlockProperties bp) {
        try {
            Object o = this.getObject(x, y, cp, bp, zoom);
            if (o instanceof PanelZoneBoundary) {
                return ((PanelZoneBoundary)o).getSample();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    List<IGDIntervalZone> getIGDList() throws SBException, SQLException {
        WellInterp wellInterp = this.block.getWell().getInterp(this.getInterpID(this.block));
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelZones");
        }
        return wellInterp.getIGDList(this.getIGDType());
    }

    List<IGDIntervalZone> getIGDList(int column) throws SBException, SQLException {
        return this.getIGDList(column, 0);
    }

    List<IGDIntervalZone> getIGDList(int column, int schID) throws SBException, SQLException {
        WellInterp wellInterp = this.block.getWell().getInterp(this.getInterpID(this.block));
        IGDColMap colmap = this.block.getWell().getInterp(this.getInterpID(this.block)).getColMap(this.block.getWell().getWellID(), this.getIGDType());
        if (wellInterp == null) {
            throw new SBException("Well interp null in PanelZones");
        }
        if (PanelType.isBiozonePanel(this.getPanelType())) {
            return wellInterp.getBiozones(schID, this.getProperties().getDisc(), colmap.getMinhier(column), colmap.getMaxhier(column));
        }
        return wellInterp.getIGDList(this.getIGDType(), schID, colmap.getMinhier(column), colmap.getMaxhier(column));
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.panelDataList.isEmpty()) {
            return null;
        }
        float depth = this.block.getDepth(y, bp);
        float depthBracket = this.block.getBracket(2.5f, zoom, depth);
        float smallZoneDepthBracket = this.block.getDepth(y + 2.5f, bp) - depth;
        float BRACKET = 2.5f / zoom;
        float SMALL_BRACKET = 2.5f;
        float columnXMax = 0.0f;
        Object returnObject = null;
        block0: for (DrawColumn column : this.allDrawColumns().collect(Collectors.toList())) {
            List<DrawZone> list = column.drawZones;
            float xMin = columnXMax;
            columnXMax += this.getColumnWidth();
            if (!(x > xMin) || !(x <= columnXMax)) continue;
            Iterator<DrawZone> it = list.iterator();
            ArrayList<DrawZone> zones = new ArrayList<DrawZone>();
            while (it.hasNext()) {
                DrawZone zone = it.next();
                if (zone.getObject() == null) continue;
                zones.add(zone);
            }
            Collections.sort(zones, new Comparator<DrawZone>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public int compare(DrawZone z1, DrawZone z2) {
                    return Double.compare(z2.getBaseDepth(), z1.getBaseDepth());
                }
            });
            for (DrawZone zone : zones) {
                float bracket = BRACKET;
                float toppos = bp.getNormal() ? zone.getYTop() : zone.getYBase();
                float basepos = bp.getNormal() ? zone.getYBase() : zone.getYTop();
                boolean small = PanelZones.getSmall(zone, cp.getFontSize(this.p.fontSize));
                if (small) {
                    bracket += 2.5f;
                }
                if (!(y > toppos - bracket) || !(y < basepos + bracket) || bp != this.block.getProp() && ((double)depth > zone.getBaseDepth() || (double)depth < zone.getTopDepth())) continue;
                if (zone.getObject() != null) {
                    IGDIntervalZone z = (IGDIntervalZone)zone.getObject();
                    float upperBoundaryTopY = (float)(zone.getTopDepth() - (double)depthBracket - (double)(small ? smallZoneDepthBracket : 0.0f));
                    float upperBoundaryBaseY = (float)(zone.getTopDepth() + (double)depthBracket - (double)(small ? smallZoneDepthBracket : 0.0f));
                    float lowerBoundaryTopY = (float)(zone.getBaseDepth() - (double)depthBracket + (double)(small ? smallZoneDepthBracket : 0.0f));
                    float lowerBoundaryBaseY = (float)(zone.getBaseDepth() + (double)depthBracket + (double)(small ? smallZoneDepthBracket : 0.0f));
                    if (upperBoundaryTopY < depth && upperBoundaryBaseY > depth) {
                        returnObject = new PanelZoneBoundary(z, z.getTopSample(), BND_PREFIX + z.getTopSample().toString(bp.getUnits()) + " " + z.getTopBnd());
                        break block0;
                    }
                    if (lowerBoundaryTopY < depth && lowerBoundaryBaseY > depth) {
                        returnObject = new PanelZoneBoundary(z, z.getBaseSample(), BND_PREFIX + z.getBaseSample().toString(bp.getUnits()) + " " + z.getBaseBnd());
                        break block0;
                    }
                }
                returnObject = zone.getObject();
                break block0;
            }
        }
        if (returnObject == null && this.p.commentsCol.show() && x > columnXMax && this.block.getInterp() != null) {
            for (Intcom intcom : this.block.getInterp().getIntcoms(this.getIGDType())) {
                if (!((double)depth > intcom.getTopDepth()) || !((double)depth < intcom.getBaseDepth())) continue;
                returnObject = intcom;
                break;
            }
        }
        return returnObject;
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        boolean firstOrOnly;
        ScaleConverter sc = this.block.getScaleConverter();
        if (bp != this.block.getProp()) {
            sc.setSubScaleProperties(bp.getMin(), bp.getMax());
        }
        boolean bl = firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        if (!cp.keyIsVisible() && !this.isVisible(g, x, y, bp, cp, mode, sc)) {
            return x + this.getWidth(bp);
        }
        float totalIntervalColumnsWidth = 0.0f;
        if (cp.drawEmptyPanels) {
            totalIntervalColumnsWidth = this.panelDataList.stream().collect(Collectors.summingDouble(pd -> pd.getWidth(bp))).floatValue();
        } else {
            for (PanelData pd2 : this.panelDataList) {
                totalIntervalColumnsWidth += pd2.isEmpty() ? 0.0f : pd2.getWidth(bp);
            }
        }
        float xpos = x;
        try {
            if (!this.isOverplot()) {
                this.drawCorrelationLines(g, xpos, y, cLines, cp, mode);
            }
            float topy = y + this.block.getPanelHeaderHeight(cp, mode);
            if (!firstOrOnly) {
                topy += this.block.scaleMeasuredDepth(Math.min(bp.getMin(), bp.getMax()), sc);
            }
            this.drawSeaBed(g, cp, bp, this.block, sc, x, topy);
            if (this.panelDataList.stream().allMatch(PanelData::isEmpty) && this.disconformities.isEmpty()) {
                return x + this.getWidth(bp);
            }
            if (this.p.disconformities) {
                this.drawDisconformities(g, x, totalIntervalColumnsWidth, y + this.block.getPanelHeaderHeight(cp, mode), bp, cp);
            }
            Float lastxpos = null;
            g.setColor(cp.foreground);
            for (PanelData pd3 : this.panelDataList) {
                if (lastxpos != null) {
                    this.drawColumnDivider(g, lastxpos.floatValue(), y, topy, firstOrOnly, cp, bp, mode);
                }
                xpos = this.drawPanelData(g, xpos, y, topy, cp, bp, mode, cLines, firstOrOnly, pd3);
                lastxpos = Float.valueOf(xpos);
            }
            if (this.p.commentsCol.show() && this.hasComments()) {
                if (lastxpos == null) {
                    lastxpos = Float.valueOf(x);
                }
                if (mode != Chart.Mode.NO_HEADER && firstOrOnly) {
                    g.drawStringVertical("Comments", lastxpos.floatValue() + this.p.commentsCol.width() / 2.0f, y + this.block.getPanelHeaderHeight(cp, mode) - cp.getFontSizeHeader(), this.getMaxSubheaderStringHeight(cp), true, false, true);
                    this.drawColumnDivider(g, lastxpos.floatValue(), y, topy, firstOrOnly, cp, bp, mode);
                } else {
                    g.drawLine(lastxpos.floatValue(), topy, lastxpos.floatValue(), topy + bp.getHeight());
                }
                this.drawComments(g, lastxpos.floatValue(), y + this.getPanelHeaderHeight(cp, mode), bp, cp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    float drawPanelData(SBGraphics g, float xpos, float y, float topy, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines, boolean firstOrOnly, PanelData panelData) throws SBException, SQLException {
        if (panelData.isEmpty()) {
            return xpos + (cp.drawEmptyPanels ? this.getColumnWidth() : 0.0f);
        }
        Float lastxpos = null;
        for (DrawColumn column : panelData.columns) {
            float newxpos = this.drawColumn(g, xpos, y, topy, cp, mode, bp, column.drawZones, true, true, false);
            if (!this.isOverplot()) {
                g.setFont(cp.font, 0, cp.getFontSizeHeader());
                if (mode != Chart.Mode.NO_HEADER && firstOrOnly && !StringUtils.isBlank((CharSequence)column.colTitle)) {
                    g.drawStringVertical(column.colTitle, xpos + this.getColumnWidth() / 2.0f, y + this.block.getPanelHeaderHeight(cp, mode) - cp.getFontSizeHeader(), this.getMaxSubheaderStringHeight(cp), true, false, true);
                }
                if (lastxpos != null) {
                    this.drawColumnDivider(g, lastxpos.floatValue(), y, topy, firstOrOnly, cp, bp, mode);
                }
            }
            lastxpos = Float.valueOf(newxpos);
            xpos = lastxpos.floatValue();
        }
        return xpos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawCorrelationLines(SBGraphics g, float xpos, float y, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines, ChartProperties cp, Chart.Mode mode) {
        Set<Map.Entry<CorrelationType, HashSet<CorrelationPoint>>> entrySet = cLines.entrySet();
        for (Map.Entry<CorrelationType, HashSet<CorrelationPoint>> entry : entrySet) {
            if (!this.drawsLines(entry.getKey()) || entry.getValue() == null || entry.getValue().isEmpty()) continue;
            if (!CorrelationType.isUnitType(entry.getKey()) || entry.getKey().getDataType() != PanelType.getDataType(this.getPanelType())) {
                this.getBlock().drawCorrelationLines(g, xpos + this.getWidth(null) - 3.0f, xpos + this.getWidth(null), y, cp, mode, entry.getValue());
                this.getBlock().drawCorrelationLines(g, xpos, xpos + 3.0f, y, cp, mode, entry.getValue());
                continue;
            }
            float ypos = y + this.block.getPanelHeaderHeight(cp, mode);
            List allColumns = this.allDrawColumns().collect(Collectors.toList());
            ArrayList<CorrelationPoint> toDraw = new ArrayList<CorrelationPoint>();
            for (CorrelationPoint corrP2 : entry.getValue()) {
                block20: {
                    block21: {
                        float x = xpos;
                        Boundary lineBnd = corrP2.line().getStyle().getBnd();
                        if (lineBnd == null) {
                            lineBnd = corrP2.bnd();
                        }
                        if (!lineBnd.isUnconformable()) break block20;
                        boolean[] drawCol = null;
                        block7: for (int column = 0; column < allColumns.size(); ++column) {
                            try {
                                for (DrawZone dZone : ((DrawColumn)allColumns.get((int)column)).drawZones) {
                                    if (dZone.getObject() == null) continue;
                                    if ((double)Math.abs(dZone.getYTop() - corrP2.ypos()) < 0.01) {
                                        if (!dZone.getTopBoundary().isUnconformable()) continue;
                                        g.setColor(corrP2.line().getColour());
                                        DrawingUtils.drawBoundary(dZone.getTopBoundary().getBndInt(), x, x + this.getColumnWidth(), ypos + corrP2.ypos(), g, corrP2.line().getStyle().getWeight());
                                        if (drawCol == null) {
                                            drawCol = new boolean[allColumns.size()];
                                        }
                                        drawCol[column] = true;
                                        continue block7;
                                    }
                                    if (!((double)Math.abs(dZone.getYBase() - corrP2.ypos()) < 0.01) || !dZone.getBaseBoundary().isUnconformable()) continue;
                                    g.setColor(corrP2.line().getColour());
                                    DrawingUtils.drawBoundary(dZone.getBaseBoundary().getBndInt(), x, x + this.getColumnWidth(), ypos + corrP2.ypos(), g, corrP2.line().getStyle().getWeight());
                                    if (drawCol == null) {
                                        drawCol = new boolean[allColumns.size()];
                                    }
                                    drawCol[column] = true;
                                    continue block7;
                                }
                                continue;
                            }
                            finally {
                                x += this.getColumnWidth();
                            }
                        }
                        if (drawCol == null) break block21;
                        float xStart = xpos;
                        float xEnd = xpos + this.getColumnWidth();
                        int i = 0;
                        while (i < drawCol.length) {
                            block23: {
                                block22: {
                                    if (drawCol[i] != false) break block22;
                                    if (i < drawCol.length - 1 && drawCol[i + 1] == false) break block23;
                                    if (i == drawCol.length - 1 && this.hasComments() && this.p.commentsCol.show()) {
                                        xEnd += this.p.commentsCol.width();
                                    }
                                    CorrDrawUtils.drawCorrelationLine(g, corrP2.line(), xStart, xEnd, ypos + corrP2.ypos(), ypos + corrP2.ypos(), false, null, corrP2.bnd());
                                }
                                xStart += this.getColumnWidth();
                            }
                            ++i;
                            xEnd += this.getColumnWidth();
                        }
                        continue;
                    }
                    toDraw.add(corrP2);
                    continue;
                }
                toDraw.add(corrP2);
            }
            toDraw.forEach(corrP -> CorrDrawUtils.drawCorrelationLine(g, corrP.line(), xpos, xpos + this.getWidth(null), ypos + corrP.ypos(), ypos + corrP.ypos(), false, null, corrP.bnd()));
        }
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        boolean firstOrOnly;
        ScaleConverter sc = this.block.getScaleConverter();
        boolean bl = firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        if (!this.isVisible(g, x, y, bp, cp, mode, sc)) {
            return;
        }
        if (this.panelDataList.stream().allMatch(PanelData::isEmpty)) {
            return;
        }
        float xpos = x;
        float topy = y + this.block.getPanelHeaderHeight(cp, mode);
        if (!firstOrOnly) {
            topy += this.block.scaleMeasuredDepth(Math.min(bp.getMin(), bp.getMax()), sc);
        }
        try {
            for (PanelData pd : this.panelDataList) {
                if (pd.isEmpty() && cp.drawEmptyPanels) {
                    xpos += this.getColumnWidth();
                    continue;
                }
                for (DrawColumn column : pd.columns) {
                    xpos = this.drawColumn(g, xpos, y, topy, cp, mode, bp, column.drawZones, true, false, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException(g, x, y, cp, bp, e);
        }
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        try {
            return this.getDefaultPanelCaption();
        }
        catch (SQLException sql) {
            return "Zones";
        }
    }

    protected String getDefaultPanelCaption() throws SQLException {
        switch (this.getPanelType()) {
            case CHRONOZONE: {
                return "Chrono\\stratigraphy";
            }
            case LITHOZONE: {
                return "Litho\\stratigraphy";
            }
        }
        return IGDIntervalZone.getIGDName((int)this.getIGDType());
    }

    @Override
    protected String getSubCaption() {
        InterpHdr hdr = this.block.getVersion(this.getInterpID(this.block));
        if (hdr != null && hdr.getInterpID() > 0) {
            return hdr.toString();
        }
        return null;
    }

    private float drawColumn(SBGraphics g, float xpos, float y, float topy, ChartProperties cp, Chart.Mode mode, BlockProperties bp, List<DrawZone> column, boolean showSampleGaps, boolean foreground, boolean background) throws SBException, SQLException {
        LinkedList<DrawZone> list = new LinkedList<DrawZone>(column);
        if (bp != this.block.getProp()) {
            LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
            for (DrawZone zone : list) {
                if (!((float)zone.getBaseDepth() <= bp.getMin()) && !((float)zone.getTopDepth() >= bp.getMax())) continue;
                toKill.add(zone);
            }
            for (DrawZone zone : toKill) {
                list.remove(zone);
            }
        }
        if (cp.key != null && cp.key.bndKey && cp.keyIsVisible()) {
            for (DrawZone zone : list) {
                cp.getKeyData().putBnd(zone.getTopBoundary());
            }
        }
        PanelZones.drawColumnIntervals(g, xpos, y, topy, list, this.getColumnWidth(), bp, cp, this.p.drawBndDepths, this.p.vertPref, mode, foreground, background, this.block, this.p.fontSize, this.p.boldFont, this.isOverplot(), this.p.uppercase);
        g.setColor(cp.foreground);
        g.setStroke(0.2f);
        return xpos += this.getColumnWidth();
    }

    static void drawColumnIntervals(SBGraphics g, float xpos, float y, float blockTop, List<DrawZone> intervalList, float columnWidth, BlockProperties bp, ChartProperties cp, boolean drawBndDepths, boolean vertPref, Chart.Mode mode, boolean foreground, boolean background, ChartBlock block, ChartProperties.FontSizeExtended fontSize, boolean boldFont, boolean overplot, boolean allCaps) {
        if (intervalList.size() == 1) {
            // empty if block
        }
        LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
        float colTop = y + block.getPanelHeaderHeight(cp, mode);
        for (DrawZone zone : intervalList) {
            if (zone.getUppColour() != null) continue;
            if (background && !overplot) {
                float topVal = Math.min(zone.getYTop(), zone.getYBase()) + colTop;
                float baseVal = Math.max(zone.getYTop(), zone.getYBase()) + colTop;
                PanelZones.fillGap(g, xpos, topVal, xpos + columnWidth, baseVal, cp);
            }
            toKill.add(zone);
        }
        for (DrawZone zone : toKill) {
            intervalList.remove(zone);
        }
        toKill.clear();
        for (DrawZone zone : intervalList) {
            if (PanelZones.getSmall(zone, cp.getFontSize(fontSize)) || zone.getTopBoundary().isUnconformable() || zone.getBaseBoundary().isUnconformable()) continue;
            PanelZones.drawInterval(g, xpos, y, blockTop, zone, columnWidth, bp, cp, mode, drawBndDepths, vertPref, foreground, background, colTop, fontSize, boldFont, allCaps);
            toKill.add(zone);
        }
        for (DrawZone zone : toKill) {
            intervalList.remove(zone);
        }
        toKill.clear();
        for (DrawZone zone : intervalList) {
            if (PanelZones.getSmall(zone, cp.getFontSize(fontSize)) || !zone.getTopBoundary().isUnconformable() && !zone.getBaseBoundary().isUnconformable()) continue;
            PanelZones.drawInterval(g, xpos, y, blockTop, zone, columnWidth, bp, cp, mode, drawBndDepths, vertPref, foreground, background, colTop, fontSize, boldFont, allCaps);
            toKill.add(zone);
        }
        for (DrawZone zone : toKill) {
            intervalList.remove(zone);
        }
        toKill.clear();
        for (DrawZone zone : intervalList) {
            PanelZones.drawInterval(g, xpos, y, blockTop, zone, columnWidth, bp, cp, mode, drawBndDepths, vertPref, foreground, background, colTop, fontSize, boldFont, allCaps);
        }
    }

    private static void drawInterval(SBGraphics g, float xpos, float y, float blockTop, DrawZone zone, float columnWidth, BlockProperties bp, ChartProperties cp, Chart.Mode mode, boolean drawBndDepths, boolean vertPref, boolean foreground, boolean background, float colTop, ChartProperties.FontSizeExtended fontSize, boolean boldFont, boolean allCaps) {
        boolean hasLowZone;
        boolean small = PanelZones.getSmall(zone, cp.getFontSize(fontSize));
        float indent = 1.75f;
        float zoneYtop = Math.min(zone.getYTop(), zone.getYBase());
        float zoneYbase = Math.max(zone.getYTop(), zone.getYBase());
        float zoneExpansionInstance = 2.5f - Math.abs(zoneYbase - zoneYtop) / 2.0f;
        if (zoneExpansionInstance < 0.0f) {
            small = false;
        }
        float leftX = small ? xpos + indent : xpos;
        float topY = (small ? zoneYtop - zoneExpansionInstance : zoneYtop) + colTop;
        float trueTop = zone.getYTop() + colTop;
        float rightX = small ? xpos + columnWidth - indent : xpos + columnWidth;
        float baseY = (small ? zoneYbase + zoneExpansionInstance : zoneYbase) + colTop;
        float trueBase = zone.getYBase() + colTop;
        GeneralPath path = SBGraphics.createGeneralPath(xpos, trueTop);
        if (small) {
            if (topY < blockTop) {
                topY = blockTop;
            }
            if (baseY > blockTop + bp.getHeight()) {
                baseY = blockTop + bp.getHeight();
            }
        }
        if (small) {
            SBGraphics.appendLine(path, xpos, trueTop, leftX, topY);
        }
        if (zone.getTopBoundary().isUnconformable()) {
            g.appendUnconf(path, leftX, rightX, topY, zone.getTopBoundary() == Boundary.QUNCF, true, true, false);
        } else {
            SBGraphics.appendLine(path, leftX, topY, rightX, topY);
        }
        if (small) {
            SBGraphics.appendLine(path, rightX, topY, xpos + columnWidth, trueTop);
        }
        SBGraphics.appendLine(path, xpos + columnWidth, trueTop, xpos + columnWidth, trueBase);
        if (small) {
            SBGraphics.appendLine(path, xpos + columnWidth, trueBase, rightX, baseY);
        }
        if (zone.getBaseBoundary().isUnconformable()) {
            g.appendUnconf(path, rightX, leftX, baseY, zone.getBaseBoundary() == Boundary.QUNCF, true, true, false);
        } else {
            SBGraphics.appendLine(path, rightX, baseY, leftX, baseY);
        }
        if (small) {
            SBGraphics.appendLine(path, leftX, baseY, xpos, trueBase);
        }
        SBGraphics.appendLine(path, xpos, trueBase, xpos, trueTop);
        if (background || small) {
            g.fillShape(path, zone.getUppColour());
        }
        boolean bl = hasLowZone = zone.getLowColour() != null && zone.getLowColour() != zone.getUppColour();
        if (hasLowZone && (background || small)) {
            float f = columnWidth * 0.05f;
            float[] yPoints = new float[]{topY - f, topY - f, baseY + f, baseY + f};
            float[] xPoints = new float[]{xpos + columnWidth - f, xpos + columnWidth, xpos + columnWidth, xpos + f};
            BasicStroke stroke = g.getStroke();
            g.setStroke(0.0f);
            g.setClip(path);
            g.setColor(zone.getLowColour());
            g.fillPolygon(xPoints, yPoints, 4);
            g.setClip(null);
            g.setStroke(stroke);
            g.setColor(cp.foreground);
        }
        if (!foreground) {
            return;
        }
        g.setColor(cp.foreground);
        g.setStroke(0.15f);
        if (small) {
            g.drawLine(xpos, trueTop, leftX, topY);
            g.drawLine(rightX, topY, xpos + columnWidth, trueTop);
            g.drawLine(xpos + columnWidth, trueBase, rightX, baseY);
            g.drawLine(leftX, baseY, xpos, trueBase);
        } else {
            g.drawLine(xpos + columnWidth, trueTop, xpos + columnWidth, trueBase);
            g.drawLine(xpos, trueBase, xpos, trueTop);
        }
        DrawingUtils.drawBoundary(zone.getTopBoundary().getBndInt(), leftX, rightX, topY, g, 0.15f);
        DrawingUtils.drawBoundary(zone.getBaseBoundary().getBndInt(), leftX, rightX, baseY, g, 0.15f);
        float padding = small ? 0.0f : 0.3f;
        float boxX = leftX + padding;
        float boxY = Math.min(topY, baseY) + padding;
        float boxWidth = rightX - leftX - padding * 2.0f;
        float boxHeight = Math.abs(baseY - topY) - padding * 2.0f;
        float fontSizeDepths = Math.max(cp.getFontSizeXS(), 1.1f);
        if (ColourUtils.isSimilarColour((Color)cp.foreground, (Color)zone.getUppColour())) {
            g.setColor(cp.background);
        }
        String hozName = zone.getHorzName();
        String vertName = zone.getVertName();
        if (hozName == null && vertName == null) {
            hozName = "";
        }
        if (allCaps) {
            hozName = hozName.toUpperCase();
            vertName = vertName.toUpperCase();
        }
        Rectangle2D.Float intervalBox = new Rectangle2D.Float(boxX, boxY, boxWidth, boxHeight);
        intervalBox = RectUtils.makeSmallerRect((Rectangle2D.Float)intervalBox, (float)0.1f);
        intervalBox.width -= 0.2f;
        intervalBox.x += 0.1f;
        if (drawBndDepths && !small && boxHeight < fontSizeDepths * 2.0f) {
            drawBndDepths = false;
        }
        ArrayList<Rectangle2D.Float> depthAreas = new ArrayList();
        if (drawBndDepths) {
            depthAreas = PanelZones.getDepthRenderingAreas(g, zone, intervalBox, cp, fontSizeDepths);
        }
        Rectangle2D.Float drawnArea = PanelZones.drawMaximizedHozOrVertText(g, cp, boldFont, hozName, vertName, intervalBox, fontSize, vertPref, depthAreas);
        if (drawBndDepths) {
            TextSettings topSettings = PanelZones.getTopDepthSettings(zone, cp, fontSizeDepths);
            TextSettings baseSettings = PanelZones.getBaseDepthSettings(zone, cp, fontSizeDepths);
            Rectangle2D.Float topArea = g.calculateRenderArea(zone.getTopDepthString(), intervalBox, topSettings);
            Rectangle2D.Float baseArea = g.calculateRenderArea(zone.getBaseDepthString(), intervalBox, baseSettings);
            if (!topArea.intersects(drawnArea) && !baseArea.intersects(drawnArea) && topArea.width < intervalBox.width && baseArea.width < intervalBox.width) {
                if (zone.getTopDepthString() != null) {
                    g.renderLinesWithinBox(zone.getTopDepthString(), intervalBox, topSettings);
                }
                if (zone.getBaseDepthString() != null && !zone.areDepthStringsEqual()) {
                    g.renderLinesWithinBox(zone.getBaseDepthString(), intervalBox, baseSettings);
                }
            }
        }
    }

    @Override
    public void drawFrame(SBGraphics g, float x, float y, ChartProperties cp, ChartBlock block, BlockProperties bp, String caption, String subCaption) {
        if (this.panelDataList.size() > 1 && cp.panelExtCaptionHeight > cp.panelCaptionHeight) {
            super.drawFrame(g, x, y, cp, block, bp, true, cp.panelCaptionHeight);
            float widthForDivider = this.getWidth(bp, cp.drawEmptyPanels) - (this.p.commentsCol.show() && this.hasComments() ? this.p.commentsCol.width() : 0.0f);
            g.drawLine(x, y + cp.panelExtCaptionHeight, x + widthForDivider, y + cp.panelExtCaptionHeight);
            SBFont captionFont = new SBFont(cp.font, 1, cp.getFontSizePanel());
            SBFont subCaptionFont = new SBFont(cp.font, 0, cp.getFontSize());
            TextLayoutPreferences captionLayout = new TextLayoutPreferences().setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Top).setFont(captionFont).truncateText().wrapText();
            TextLayoutPreferences subCaptionLayout = captionLayout.copy().setFont(subCaptionFont).hideOnOverflow();
            Rectangle2D.Float captionBox = new Rectangle2D.Float(x, y + 0.4f, this.getWidth(bp, cp.drawEmptyPanels), cp.panelCaptionHeight - 0.4f);
            Rectangle2D.Float drawnCaptionArea = g.drawStringWithinBox(caption, captionBox, captionLayout);
            if (subCaption != null && !subCaption.isEmpty()) {
                captionBox.y = drawnCaptionArea.y + drawnCaptionArea.height;
                captionBox.height -= drawnCaptionArea.height;
                g.drawStringWithinBox(subCaption, captionBox, subCaptionLayout);
            }
            captionLayout.setVerticalAlignment(VerticalAlignment.Middle);
            float xpos = x;
            float ytop = y + cp.panelCaptionHeight + 0.4f;
            float ybase = y + cp.panelExtCaptionHeight - 0.4f;
            for (PanelData pd : this.panelDataList) {
                if (!cp.drawEmptyPanels && pd.columns.isEmpty()) continue;
                Rectangle2D.Float schemeNameBox = new Rectangle2D.Float(xpos, ytop, pd.getWidth(bp), ybase - ytop);
                g.drawStringWithinBox(pd.schemeName, schemeNameBox, captionLayout);
                g.drawLine(xpos += pd.getWidth(bp), ytop, xpos, ybase);
            }
            return;
        }
        super.drawFrame(g, x, y, cp, block, bp, caption, subCaption);
    }

    private static TextSettings getTopDepthSettings(DrawZone zone, ChartProperties cp, float fontSizeDepths) {
        SBFont f = new SBFont(cp.font, 0, fontSizeDepths);
        if (zone.areDepthStringsEqual()) {
            return new TextSettings(HorizontalAlignment.Left, VerticalAlignment.Middle, TextDirection.Horizontal, f);
        }
        return new TextSettings(HorizontalAlignment.Left, VerticalAlignment.Top, TextDirection.Horizontal, f);
    }

    private static TextSettings getBaseDepthSettings(DrawZone zone, ChartProperties cp, float fontSizeDepths) {
        SBFont f = new SBFont(cp.font, 0, fontSizeDepths);
        if (zone.areDepthStringsEqual()) {
            return new TextSettings(HorizontalAlignment.Right, VerticalAlignment.Middle, TextDirection.Horizontal, f);
        }
        return new TextSettings(HorizontalAlignment.Right, VerticalAlignment.Bottom, TextDirection.Horizontal, f);
    }

    private static Rectangle2D.Float drawMaximizedHozOrVertText(SBGraphics g, ChartProperties cp, boolean boldFont, String hozText, String vertText, Rectangle2D.Float box, ChartProperties.FontSizeExtended fontSize, boolean prefferedVerticalText, List<Rectangle2D.Float> depthAreas) {
        TextDirection alternateDirection;
        TextDirection preferredDirection;
        ITextMeasurer tm = g.getTextMeasurer();
        TextSettings settings = null;
        if (!prefferedVerticalText) {
            preferredDirection = TextDirection.Horizontal;
            alternateDirection = TextDirection.Vertical;
        } else {
            preferredDirection = TextDirection.Vertical;
            alternateDirection = TextDirection.Horizontal;
        }
        ArrayList<Float> sizes = new ArrayList<Float>();
        switch (fontSize) {
            case XXL: {
                sizes.add(Float.valueOf(cp.getFontSize(ChartProperties.FontSizeExtended.XXL)));
            }
            case XL: {
                sizes.add(Float.valueOf(cp.getFontSize(ChartProperties.FontSizeExtended.XL)));
            }
            default: {
                sizes.add(Float.valueOf(cp.getFontSize(ChartProperties.FontSizeExtended.PANEL)));
            }
            case SMALL: {
                sizes.add(Float.valueOf(cp.getFontSize(ChartProperties.FontSizeExtended.SMALL)));
            }
            case TINY: 
        }
        sizes.add(Float.valueOf(cp.getFontSize(ChartProperties.FontSizeExtended.TINY)));
        TextWrapper w = new TextWrapper(tm);
        w.setHyphenateText(false);
        w.setTruncateAtWord(true);
        boolean fit = false;
        String text = null;
        Iterator iterator = sizes.iterator();
        block6: while (iterator.hasNext()) {
            float s = ((Float)iterator.next()).floatValue();
            SBFont f = new SBFont(cp.font, boldFont ? 1 : 0, s);
            TextSettings preferredSettings = new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Middle, preferredDirection, f);
            TextSettings alternateSettings = new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Middle, alternateDirection, f);
            for (TextSettings testSettings : Arrays.asList(preferredSettings, alternateSettings)) {
                String[] wrappedText;
                text = hozText;
                if (hozText == null && vertText != null) {
                    text = vertText;
                }
                if (testSettings.getTextDirection() == TextDirection.Vertical && vertText != null) {
                    text = vertText;
                }
                if (!PanelZones.doesTextFit(box, text, wrappedText = PanelZones.calcWrappedText(box, text, testSettings, w), testSettings, tm, w) || !(fit = !PanelZones.doesTargetIntersectWithAny(g.calculateRenderArea(wrappedText, box, testSettings), depthAreas))) continue;
                settings = testSettings;
                break block6;
            }
        }
        if (settings == null) {
            SBFont f = new SBFont(cp.font, boldFont ? 1 : 0, cp.getFontSize(ChartProperties.FontSizeExtended.TINY));
            settings = box.width > box.height ? new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Middle, TextDirection.Horizontal, f) : new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Middle, TextDirection.Vertical, f);
            text = hozText;
            if (hozText == null && vertText != null) {
                text = vertText;
            }
            if (settings.getTextDirection() == TextDirection.Vertical && vertText != null) {
                text = vertText;
            }
        }
        if (cp.key != null && cp.key.text) {
            w.setTruncationMarker("...*" + cp.getKeyData().getNextTextKey());
        } else {
            w.setTruncationMarker("...");
        }
        String[] lines = w.wrapTextAndTruncate(text, new DimensionF(box.width, box.height), settings);
        String remaining = w.getRemainingText(text, lines);
        if (remaining != null && !remaining.isEmpty() && cp.key != null && cp.key.text) {
            cp.getKeyData().putText(remaining, true);
        }
        return g.renderLinesWithinBox(lines, box, settings);
    }

    private static List<Rectangle2D.Float> getDepthRenderingAreas(SBGraphics g, DrawZone zone, Rectangle2D.Float intervalBox, ChartProperties cp, float fontSizeDepths) {
        ArrayList<Rectangle2D.Float> areas = new ArrayList<Rectangle2D.Float>();
        areas.add(g.calculateRenderArea(zone.getTopDepthString(), intervalBox, PanelZones.getTopDepthSettings(zone, cp, fontSizeDepths)));
        if (!zone.areDepthStringsEqual()) {
            areas.add(g.calculateRenderArea(zone.getBaseDepthString(), intervalBox, PanelZones.getBaseDepthSettings(zone, cp, fontSizeDepths)));
        }
        return areas;
    }

    private static String[] calcWrappedText(Rectangle2D.Float box, String text, TextSettings settings, TextWrapper w) {
        DimensionF boxDims = new DimensionF(box.width, box.height);
        return w.wrapTextAndTruncate(text, boxDims, settings);
    }

    private static boolean doesTextFit(Rectangle2D.Float box, String text, String[] wrapped, TextSettings settings, ITextMeasurer m, TextWrapper w) {
        DimensionF boxDims = new DimensionF(box.width, box.height);
        return w.getRemainingText(text, wrapped).isEmpty() && m.calculateTextDimensions(wrapped, settings).fitsInside(boxDims);
    }

    private static boolean doesTargetIntersectWithAny(Rectangle2D.Float target, List<Rectangle2D.Float> other) {
        for (Rectangle2D.Float a : other) {
            if (!target.intersects(a)) continue;
            return true;
        }
        return false;
    }

    static boolean getSmall(float yTop, float yBase, float fontSize) {
        return (double)Math.abs(yBase - yTop) < (double)fontSize * 1.3;
    }

    static boolean getSmall(DrawZone zone, float fontSize) {
        return PanelZones.getSmall(zone.getYTop(), zone.getYBase(), fontSize);
    }

    public static boolean fillGap(SBGraphics g, float x, float y, float xRight, float yBot, ChartProperties cp) {
        if ((double)(yBot - y) < 0.01 || (double)(xRight - x) < 0.01) {
            return false;
        }
        g.setStroke(0.05f);
        g.setColor(cp.gapHatchColour);
        while (x < xRight) {
            g.drawLine(x += 1.0f, y, x, yBot);
        }
        return true;
    }

    private void drawDisconformities(SBGraphics g, float x, float width, float ypos, BlockProperties bp, ChartProperties cp) {
        if (this.disconformities == null || this.disconformities.isEmpty()) {
            return;
        }
        float rhs = x + width;
        g.setColor(ColourUtils.getLighterColour((Color)cp.foreground, (float)0.65f));
        g.setFontSize(cp.getFontSizeTiny());
        float padding = 0.3f;
        for (ChartObject obj : this.disconformities) {
            if (bp != this.block.getProp() && (obj.getCorrDepth() < (double)bp.getMin() || obj.getCorrDepth() > (double)bp.getMax())) continue;
            Fault f = (Fault)obj.getO();
            DrawingUtils.drawBoundary(f.getBnd().getBndInt(), x, rhs, ypos + obj.getyPos(), g, 0.15f);
            if (((Fault)obj.getO()).getLabel() != null) {
                g.drawString(f.getLabel(), x + 0.6f, ypos + obj.getyPos() + cp.getFontSizeTiny() + 0.3f);
            }
            if (cp.key == null || !cp.keyIsVisible()) continue;
            cp.getKeyData().putBnd(f.getBnd());
        }
    }

    private void drawComments(SBGraphics g, float x, float topY, BlockProperties bp, ChartProperties cp) {
        Iterator it;
        if (this.block.getWell() == null) {
            LinkedList<Intcom.Builder> list = new LinkedList<Intcom.Builder>();
            Intcom.Builder builder = new Intcom.Builder(this.getDb(), this.getIGDType(), this.block.getTemplateSamples().get(0).getDepth());
            builder.baseDepth(this.block.getTemplateSamples().get(3).getDepth());
            builder.comments("You can enter comments for " + IGDInterval.getIGDName((int)this.getIGDType()) + " in the Samples & Interpretations module.");
            list.add(builder);
            it = list.iterator();
        } else {
            it = this.block.getInterp().getIntcoms(this.getIGDType()).iterator();
        }
        PanelIntcomsProperties ip = new PanelIntcomsProperties(null);
        switch (this.p.fontSize) {
            default: {
                ip.fontSize = ChartProperties.FontSize.SMALL;
                break;
            }
            case TINY: {
                ip.fontSize = ChartProperties.FontSize.TINY;
            }
        }
        ip.shrinkText = false;
        ip.showDepths = this.p.drawBndDepths;
        ip.panelWidth = this.p.commentsCol.width();
        PanelIntcoms.drawCommentColumn(it, g, this.block, cp, bp, ip, x, topY);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.getWidth(bp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getWidth(BlockProperties bp, boolean drawEmptyPanels) {
        float width = 0.0f;
        if (this.p.commentsCol.show() && this.hasComments()) {
            width += this.p.commentsCol.width();
        }
        List<PanelData> list = this.panelDataList;
        synchronized (list) {
            if (this.panelDataList.isEmpty() || this.panelDataList.stream().allMatch(PanelData::isEmpty)) {
                return width > 0.0f ? width : this.getColumnWidth();
            }
            if (drawEmptyPanels) {
                return width + this.panelDataList.stream().collect(Collectors.summingDouble(pd -> pd.getWidth(bp))).floatValue();
            }
            float columnWiths = 0.0f;
            for (PanelData pd2 : this.panelDataList) {
                if (pd2.isEmpty()) continue;
                columnWiths += pd2.getWidth(bp);
            }
            return width + columnWiths;
        }
    }

    @Override
    public boolean drawsLines(CorrelationType corrType) {
        return true;
    }

    public static String roundSampleDepth(double corrDepth, SampleType type, Well well) {
        Object depth = Sample.roundSampleDepth((double)corrDepth, (SampleType)type);
        if (well != null && well.getHeader().getSectionType() == SectionType.OUTCROP) {
            if (((String)(depth = ((String)depth).trim())).charAt(0) == '-') {
                depth = ((String)depth).substring(1);
            } else if (!(((String)depth).equals("0.0") || ((String)depth).equals("0") || ((String)depth).equals("0.00"))) {
                depth = "-" + (String)depth;
            }
        }
        return depth;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        if (this.block.getWell() == null) {
            this.setTemplateData(cp);
            return;
        }
        this.disconformities.clear();
        this.panelDataList.clear();
        try {
            if (this.getIGDList().isEmpty()) {
                this.block.getWell().loadInterp(this.block.getInterp());
            }
        }
        catch (SBException se) {
            Logger.getLogger(PanelZones.class.getName()).log(Level.WARNING, "Attempt to fetch interp in PanelZones.setData() for version ", se);
            return;
        }
        HashSet disconfSamples = new HashSet();
        if (this.p.disconformities) {
            this.block.getInterp().getFaults().forEach(fault -> disconfSamples.add(fault.getSample()));
        }
        IGDColMap colmap = this.getColMap();
        LinkedList<Integer> schemeIDs = new LinkedList<Integer>();
        if (PanelType.isBiozonePanel(this.getPanelType())) {
            if (this.getPanelOcc().getSchID() > 0) {
                schemeIDs.add(this.getPanelOcc().getSchID());
            } else if (this.p.multiScheme) {
                schemeIDs.add(0);
            } else {
                WellInterp wellInterp = this.block.getWell().getInterp(this.getInterpID(this.block));
                schemeIDs.addAll(wellInterp.getBiozoneSchemes(this.getPanelType().getDiscipine()));
            }
        } else {
            schemeIDs.add(0);
        }
        ScaleConverter sc = this.block.getScaleConverter();
        for (Integer schID : schemeIDs) {
            PanelData panelData = new PanelData(this, schID);
            for (int column = 1; column <= colmap.getSize(); ++column) {
                LinkedList<DrawZone> intervalList = new LinkedList<DrawZone>();
                boolean plotColumn = this.p.plotColumn(colmap.getMinhier(column), colmap.getMaxhier(column));
                List<IGDIntervalZone> zonesForColumn = this.getIGDList(column, schID);
                if (plotColumn && !zonesForColumn.isEmpty()) {
                    ListIterator<IGDIntervalZone> it = zonesForColumn.listIterator();
                    float lastBot = 0.0f;
                    double lastBaseDepth = 0.0;
                    while (it.hasNext()) {
                        String topLabelString;
                        IGDIntervalZone zone = it.next();
                        double topSampleDepth = this.block.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                        double baseSampleDepth = this.block.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                        boolean includeUnit = Math.abs(baseSampleDepth - topSampleDepth) < (double)0.0029f ? sc.isWithinPlottableRange(topSampleDepth) : sc.isWithinPlottableRange(topSampleDepth, baseSampleDepth);
                        if (!includeUnit) continue;
                        float yTop = this.block.scaleMeasuredDepth(topSampleDepth, sc);
                        float yBot = this.block.scaleMeasuredDepth(baseSampleDepth, sc);
                        int topBndInt = zone.getTopBndInt();
                        if (!sc.isWithinPlottableRange(topSampleDepth)) {
                            topBndInt = 3;
                        }
                        int baseBndInt = zone.getBaseBndInt();
                        if (!sc.isWithinPlottableRange(baseSampleDepth)) {
                            baseBndInt = 3;
                        }
                        Color colour = cp.background;
                        IGDScheme scheme = this.getDb().getIGDScheme(zone.getSchID());
                        if (zone.getUppZone() > 0 && this.p.useColours) {
                            scheme.loadUnits();
                            IGDUnitBase unit = scheme.findUnitBase(zone.getUppZone());
                            if (unit != null) {
                                colour = unit.getColour();
                            }
                        }
                        Color colour2 = null;
                        if (zone.getLowZone() > 0 && this.p.useColours) {
                            scheme.loadUnits();
                            IGDUnitBase unit = scheme.findUnitBase(zone.getLowZone());
                            if (unit != null) {
                                colour2 = unit.getColour();
                            }
                        }
                        BlockProperties.ScaleType labelScaleType = this.block.getProp().getWorkingLabelScaleType();
                        String baseLabelString = switch (labelScaleType) {
                            default -> {
                                topLabelString = PanelZones.getDepthLabelString(topSampleDepth, zone.getTopSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                                yield PanelZones.getDepthLabelString(baseSampleDepth, zone.getBaseSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                            }
                            case BlockProperties.ScaleType.TVD -> {
                                topLabelString = PanelZones.getDepthLabelString(this.block.getWell().getTVDlist(false).getTVD(topSampleDepth).getTVDepth(), zone.getTopSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                                yield PanelZones.getDepthLabelString(this.block.getWell().getTVDlist(false).getTVD(baseSampleDepth).getTVDepth(), zone.getBaseSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                            }
                            case BlockProperties.ScaleType.TWT -> {
                                topLabelString = Integer.toString((int)Math.floor(this.block.getWell().getTWTlist().getTWT(topSampleDepth).getTWT()));
                                yield Integer.toString((int)Math.floor(this.block.getWell().getTWTlist().getTWT(baseSampleDepth).getTWT()));
                            }
                            case BlockProperties.ScaleType.AGE -> {
                                topLabelString = PanelZones.getAgeLabelString(this.block.getWell().getInterp(this.getInterpID()), topSampleDepth);
                                yield PanelZones.getAgeLabelString(this.block.getWell().getInterp(this.getInterpID()), baseSampleDepth);
                            }
                        };
                        if (it.hasNext()) {
                            IGDIntervalZone nextZone = it.next();
                            if (nextZone.getTopSample() == zone.getBaseSample()) {
                                baseLabelString = null;
                            }
                            it.previous();
                        }
                        DrawZone drawZone = new DrawZone(yTop, yBot, colour, colour2, topBndInt, baseBndInt, zone.toString(this.p.useAbrs), zone.toVertString(this.p.useAbrs), topLabelString, baseLabelString, topSampleDepth, baseSampleDepth);
                        drawZone.setObject(zone);
                        intervalList.add(drawZone);
                        disconfSamples.remove(zone.getTopSample());
                        disconfSamples.remove(zone.getBaseSample());
                        if ((double)Math.abs(yTop - lastBot) > 0.1) {
                            if (lastBot == 0.0f) {
                                if ((double)this.block.getWell().getHeader().getSBDepth() > sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).get()) {
                                    double sbDepth = this.block.getWell().getHeader().getSBDepth();
                                    lastBot = this.block.scaleMeasuredDepth(sbDepth, sc);
                                    lastBaseDepth = sbDepth;
                                } else {
                                    lastBot = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN);
                                    lastBaseDepth = sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).get();
                                }
                            }
                            intervalList.add(DrawZone.sampleGap(lastBot, yTop, lastBaseDepth, topSampleDepth));
                        }
                        lastBot = yBot;
                        lastBaseDepth = baseSampleDepth;
                    }
                    float baseY = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX);
                    double baseBaseDepth = sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0);
                    boolean addDummy = true;
                    if (lastBot == 0.0f) {
                        if (sections != null && sections.length > 2) {
                            lastBot = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN);
                        } else {
                            addDummy = false;
                        }
                    }
                    if (addDummy) {
                        if ((double)Math.abs(baseY - lastBot) > 0.1) {
                            intervalList.add(DrawZone.sampleGap(lastBot, baseY, lastBaseDepth, baseBaseDepth));
                        }
                        if (sections != null && sections.length > 2) {
                            intervalList = DrawZone.divideDrawZones(intervalList, sections);
                        }
                    }
                }
                boolean forceAdd = false;
                if (intervalList.isEmpty()) {
                    List<SBPanel> overplotPanels;
                    if (!this.isOverplot()) {
                        overplotPanels = this.getOverplotPanels(cp);
                    } else {
                        SBPanel underplotPanel = this.getUnderplotPanel();
                        overplotPanels = underplotPanel.getOverplotPanels(cp);
                        overplotPanels.add(underplotPanel);
                        overplotPanels.remove(this);
                    }
                    for (SBPanel over : overplotPanels) {
                        if (!(over instanceof PanelZones) || !((PanelZones)over).getProperties().plotColumn(colmap.getMinhier(column), colmap.getMaxhier(column)) || ((PanelZones)over).getIGDList(column).isEmpty()) continue;
                        forceAdd = true;
                        if (this.isOverplot()) break;
                        intervalList.add(DrawZone.sampleGap(this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN), this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX)));
                        break;
                    }
                }
                if (intervalList.isEmpty() && !forceAdd) continue;
                panelData.columns.add(new DrawColumn(intervalList, column, colmap.getColTitle(column)));
            }
            this.panelDataList.add(panelData);
        }
        if (!disconfSamples.isEmpty()) {
            for (Fault fault2 : this.block.getInterp().getFaults()) {
                double faultSampleDepth;
                if (!disconfSamples.contains(fault2.getSample()) || !sc.isWithinPlottableRange(faultSampleDepth = this.block.getWell().getDepth(fault2.getSample(), cp.correctDepths, cp.correctCuttings))) continue;
                float yVal = this.block.scaleMeasuredDepth(faultSampleDepth, sc);
                ChartObject<Fault> chartObject = new ChartObject<Fault>(fault2, yVal);
                chartObject.setCorrDepth(faultSampleDepth);
                this.disconformities.add(chartObject);
            }
            for (PanelData panelData : this.panelDataList) {
                if (this.disconformities.isEmpty() || !panelData.isEmpty()) continue;
                LinkedList<DrawZone> intervalList = new LinkedList<DrawZone>();
                intervalList.add(DrawZone.sampleGap(this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN), this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX)));
                if (sections != null && sections.length > 2) {
                    intervalList = DrawZone.divideDrawZones(intervalList, sections);
                }
                panelData.columns.add(new DrawColumn(intervalList, -1, ""));
            }
        }
    }

    public static String getDepthLabelString(double depth, SampleType sampleType, Well well, char units) {
        double depthInUnits = DepthUtils.convFromM((double)depth, (char)units);
        return PanelZones.roundSampleDepth(depthInUnits, sampleType, well);
    }

    private void setTemplateData(ChartProperties cp) {
        this.panelDataList.clear();
        PanelData panelData = new PanelData(this, 0);
        LinkedList<DrawZone> col1 = new LinkedList<DrawZone>();
        LinkedList<DrawZone> col2 = new LinkedList<DrawZone>();
        LinkedList<Sample> templateSamples = this.block.getTemplateSamples();
        ScaleConverter sc = this.block.getScaleConverter(null);
        int[] topSamples = new int[]{0, 0, 2};
        int[] baseSamples = new int[]{3, 2, 3};
        String[] topDepthStrings = new String[3];
        String[] baseDepthStrings = new String[3];
        String[] unitNames = new String[]{this.p.useAbrs ? "ZON" : "Zone", this.p.useAbrs ? "SZ1" : "Sub Zone 1", this.p.useAbrs ? "SZ2" : "Sub Zone 2"};
        Color[] unitColours = new Color[]{this.p.useColours ? new Color(0, 219, 197) : cp.background, this.p.useColours ? new Color(132, 207, 150) : cp.background, this.p.useColours ? new Color(132, 207, 150) : cp.background};
        float yTop = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN);
        float yBase = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX);
        DrawZone topGap = DrawZone.sampleGap(yTop, this.block.scaleMeasuredDepth((float)templateSamples.get(topSamples[0]).getDepth(), sc));
        col1.add(topGap);
        col2.add(topGap);
        DrawZone baseGap = DrawZone.sampleGap(this.block.scaleMeasuredDepth((float)templateSamples.get(baseSamples[0]).getDepth(), sc), yBase);
        col1.add(baseGap);
        col2.add(baseGap);
        for (int i = 0; i < topSamples.length; ++i) {
            if (this.p.drawBndDepths) {
                topDepthStrings[i] = PanelZones.roundSampleDepth(DepthUtils.convFromM((double)templateSamples.get(topSamples[i]).getDepth(), (char)this.block.getProp().getUnits()), templateSamples.get(topSamples[i]).getType(), this.block.getWell());
                baseDepthStrings[i] = PanelZones.roundSampleDepth(DepthUtils.convFromM((double)templateSamples.get(baseSamples[i]).getDepth(), (char)this.block.getProp().getUnits()), templateSamples.get(baseSamples[i]).getType(), this.block.getWell());
            }
            LinkedList<DrawZone> list = i == 0 ? col1 : col2;
            list.add(new DrawZone(this.block.scaleMeasuredDepth((float)templateSamples.get(topSamples[i]).getDepth(), sc), this.block.scaleMeasuredDepth((float)templateSamples.get(baseSamples[i]).getDepth(), sc), unitColours[i], null, 3, 3, unitNames[i], unitNames[i], topDepthStrings[i], baseDepthStrings[i], templateSamples.get(topSamples[i]).getDepth(), templateSamples.get(baseSamples[i]).getDepth()));
        }
        panelData.columns.add(new DrawColumn(col1, 1, "Column 1"));
        panelData.columns.add(new DrawColumn(col2, 2, "Column 2"));
        this.panelDataList.add(panelData);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp) {
            WellInterp wellInterp = (WellInterp)o;
            if (wellInterp.getHeader().getInterpID() == this.getInterpID()) {
                if (arg instanceof IGDIntervalZone && ((IGDIntervalZone)arg).getIGDType() == this.getIGDType() || arg instanceof Integer && ((Integer)arg).intValue() == this.getIGDType() || arg instanceof IGDColMap || arg instanceof Intcom) {
                    this.setDataChanged();
                    this.notifyListeners();
                }
            } else {
                wellInterp.deleteWeakObserver((Observer)this);
            }
            return;
        }
        super.update(o, arg);
    }

    @Override
    public final PanelZonesProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties p) {
        if (!(p instanceof PanelZonesProperties)) {
            throw new IllegalArgumentException("Wrong properties type for PanelZones");
        }
        this.p = (PanelZonesProperties)p;
    }

    public int getInterpID() {
        return this.getInterpID(this.block);
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        int nSamples = 0;
        ScaleConverter sc = this.block.getScaleConverter();
        try {
            IGDColMap colmap = this.block.getWell().getInterp(this.getInterpID(this.block)).getColMap(this.block.getWellID(), this.getIGDType());
            if (this.getIGDList().isEmpty()) {
                this.block.getWell().loadInterp(this.block.getInterp());
            }
            for (int column = 1; column <= colmap.getSize(); ++column) {
                if (this.getIGDList(column).isEmpty()) continue;
                ListIterator<IGDIntervalZone> it = this.getIGDList(column).listIterator();
                while (it.hasNext()) {
                    double baseSampleDepth;
                    IGDIntervalZone zone = it.next();
                    double topSampleDepth = this.block.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                    if (!sc.isWithinPlottableRange(topSampleDepth, baseSampleDepth = this.block.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings))) continue;
                    try {
                        ++nSamples;
                        Sample.insert(samples, (Sample)zone.getTopSample(), (char)this.block.getProp().getUnits());
                    }
                    catch (SBException sBException) {
                        // empty catch block
                    }
                    if (zone.getTopSample().equals((Object)zone.getBaseSample())) continue;
                    try {
                        ++nSamples;
                        Sample.insert(samples, (Sample)zone.getBaseSample(), (char)this.block.getProp().getUnits());
                    }
                    catch (SBException sBException) {}
                }
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            StackError.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return nSamples;
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Object rowString = "";
        Sample sample = samples.get(index);
        ScaleConverter sc = this.block.getScaleConverter();
        try {
            IGDColMap colmap = this.block.getWell().getInterp(this.getInterpID(this.block)).getColMap(this.block.getWellID(), this.getIGDType());
            if (this.getIGDList().isEmpty()) {
                this.block.getWell().loadInterp(this.block.getInterp());
            }
            for (int column = 1; column <= colmap.getSize(); ++column) {
                List<IGDIntervalZone> igdList;
                boolean found = false;
                for (PanelData pd : this.panelDataList) {
                    for (DrawColumn col : pd.columns) {
                        if (col.column != column) continue;
                        found = true;
                    }
                }
                if (!found || (igdList = this.getIGDList(column)).isEmpty()) continue;
                Object colString = "";
                Iterator<IGDIntervalZone> it = igdList.iterator();
                boolean inZone = false;
                while (it.hasNext() && !inZone) {
                    double baseSampleDepth;
                    IGDIntervalZone zone = it.next();
                    double topSampleDepth = this.block.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                    if (!sc.isWithinPlottableRange(topSampleDepth, baseSampleDepth = this.block.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings))) continue;
                    if (zone.getTopSample().equals((Object)sample)) {
                        if (!((String)colString).isEmpty()) {
                            colString = ((String)colString).substring(0, ((String)colString).lastIndexOf("<")) + "<br>";
                            colString = (String)colString + (String)(this.p.drawBndDepths ? zone.getTopSample().toString(this.block.getProp().getUnits(), false, false) + (String)(zone.isSpotZone() ? "" : " - " + zone.getBaseSample().toString(this.block.getProp().getUnits(), false, false)) + "<br>" : "");
                            colString = (String)colString + zone.toString(this.p.useAbrs) + "</td>";
                            break;
                        }
                        Color colour = Color.WHITE;
                        IGDScheme scheme = this.getDb().getIGDScheme(zone.getSchID());
                        if (zone.getUppZone() > 0 && this.p.useColours) {
                            scheme.loadUnits();
                            IGDUnitBase unit = scheme.findUnitBase(zone.getUppZone());
                            if (unit != null) {
                                colour = unit.getColour();
                            }
                        }
                        colString = colour != Color.WHITE ? (String)colString + "<td bgcolor=" + PanelZones.getHexColour(colour) : (String)colString + "<td";
                        if (zone.isSpotZone()) {
                            colString = (String)colString + ">";
                        } else {
                            int rowSpan = 0;
                            Sample nextSample = null;
                            ListIterator<Sample> sampleIt = samples.listIterator(index);
                            while (sampleIt.hasNext() && (nextSample == null || nextSample != zone.getBaseSample())) {
                                nextSample = (Sample)sampleIt.next();
                                ++rowSpan;
                            }
                            colString = (String)colString + " " + PanelZones.getHTMLRowspan(rowSpan - 1) + ">";
                        }
                        colString = (String)colString + (String)(this.p.drawBndDepths ? zone.getTopSample().toString(this.block.getProp().getUnits(), false, false) + (String)(zone.isSpotZone() ? "" : " - " + zone.getBaseSample().toString(this.block.getProp().getUnits(), false, false)) + "<br>" : "");
                        colString = (String)colString + zone.toString(this.p.useAbrs) + "</td>";
                        continue;
                    }
                    if (samples.indexOf(zone.getTopSample()) >= index || samples.indexOf(zone.getBaseSample()) <= index) continue;
                    inZone = true;
                    break;
                }
                if (((String)colString).isEmpty() && !inZone) {
                    colString = (String)colString + "<td></td>";
                }
                rowString = (String)rowString + (String)colString;
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            StackError.showStackError((String)"SQL Error", (SQLException)sql);
        }
        return rowString;
    }

    private int countColumns() {
        int nColumns = 0;
        for (PanelData panelData : this.panelDataList) {
            nColumns += panelData.columns.size();
        }
        return nColumns;
    }

    @Override
    protected int getColSpan() {
        return this.countColumns();
    }

    @Override
    protected String getSubCaptionString() {
        int nColumns = this.countColumns();
        if (nColumns > 1) {
            return "<th colspan=\"" + nColumns + "\">" + this.getSubCaption() + "</th>";
        }
        return super.getSubCaptionString();
    }

    @Override
    public String getSubHeaderString() {
        Object hdrs = "";
        for (PanelData panelData : this.panelDataList) {
            for (DrawColumn column : panelData.columns) {
                hdrs = (String)hdrs + "<td>" + column.colTitle + "</td>";
            }
        }
        return hdrs;
    }

    public int getSchID() {
        return this.allDrawZones().filter(drawZone -> drawZone.getObject() instanceof IGDIntervalZone).map(drawZone -> ((IGDIntervalZone)drawZone.getObject()).getSchID()).reduce((existingResult, schID) -> existingResult.intValue() != schID.intValue() ? 0 : schID).orElse(0);
    }

    public int getSchID(float xInPanel) {
        if (this.panelDataList.size() > 1) {
            int xpos = 0;
            for (PanelData pd : this.panelDataList) {
                if (!(xInPanel < (float)(xpos = (int)((float)xpos + pd.getWidth(this.block.getProp()))))) continue;
                return pd.schID;
            }
        }
        return this.getSchID();
    }

    public int getColumn(float xInPanel) {
        int pdLeft = 0;
        int pdRight = 0;
        for (PanelData pd : this.panelDataList) {
            if (xInPanel < (float)(pdRight = (int)((float)pdRight + pd.getWidth(this.block.getProp())))) {
                int col = 0;
                while (xInPanel > (float)pdLeft + (float)(col + 1) * this.getColumnWidth()) {
                    ++col;
                }
                if (col < pd.columns.size()) {
                    return pd.columns.get((int)col).column;
                }
                return -1;
            }
            pdLeft = pdRight;
        }
        return -1;
    }

    public int getIGDType() {
        switch (this.getPanelType()) {
            case CHRONOZONE: {
                return 3;
            }
            case LITHOZONE: {
                return 2;
            }
            case MICROZONE: 
            case NANNOZONE: 
            case PALYZONE: 
            case MACROZONE: {
                return 4;
            }
        }
        throw new IllegalStateException("PanelZones has no IGD type");
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.p.commentsCol.show() && this.hasComments()) {
            return true;
        }
        return !this.panelDataList.stream().allMatch(PanelData::isEmpty) || !this.disconformities.isEmpty();
    }

    @Override
    public boolean hasDataInInterval(BlockProperties bp) {
        if (this.p.commentsCol.show() && this.hasComments()) {
            return true;
        }
        ScaleConverter sc = this.block.getScaleConverter();
        return this.allDrawZones().filter(drawZone -> drawZone.getObject() != null).anyMatch(d -> sc.isWithinPlottableRange(d.getTopDepth(), d.getBaseDepth()));
    }

    private boolean hasComments() {
        if (this.block.getWell() == null) {
            return true;
        }
        return !this.block.getInterp().getIntcoms(this.getIGDType()).isEmpty();
    }

    @Override
    public Float getDataBound(boolean upper) {
        DoubleSummaryStatistics summaryStatistics = this.allDrawZones().filter(dz -> dz.getObject() != null).mapToDouble(dz -> upper ? dz.getTopDepth() : dz.getBaseDepth()).summaryStatistics();
        if (summaryStatistics.getCount() == 0L) {
            return null;
        }
        return Float.valueOf(upper ? (float)summaryStatistics.getMin() : (float)summaryStatistics.getMax());
    }

    public List<IGDScheme> getSchemesInWell() throws SBException, SQLException {
        if (this.getBlock() == null || this.getBlock().getWell() == null) {
            return null;
        }
        WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
        return interp.getIGDSchemes(4);
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        List<IGDIntervalZone> wsZones = this.allDrawZones().filter(dz -> dz.getObject() != null).map(dz -> (IGDIntervalZone)dz.getObject()).collect(Collectors.toList());
        if (!wsZones.isEmpty()) {
            dataTypes.add(IGDInterval.igdType2dType((int)this.getIGDType()));
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillIntervals(wsWell, true, wsZones.toArray(new IGDIntervalZone[wsZones.size()]));
        }
        if (this.p.commentsCol.show() && this.hasComments()) {
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillIntcoms(wsWell, this.block.getInterp().getIntcoms(this.getIGDType()));
            dataTypes.add(18);
        }
    }

    IGDColMap getColMap() throws SBException, SQLException {
        return this.block.getWell().getInterp(this.getInterpID(this.block)).getColMap(this.block.getWellID(), this.getIGDType());
    }

    private float getColumnWidth() {
        if (this.isOverplot()) {
            return ((PanelZonesProperties)this.getUnderplotPanel().getProperties()).columnWidth;
        }
        return this.p.columnWidth;
    }

    @Override
    public Set<Integer> getVisibleSchemes(int igdType) throws SBException, SQLException {
        if (this.getIGDType() != igdType || this.getBlock().getWell() == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> schIDs = new HashSet<Integer>();
        if (this.getSchID() > 0) {
            schIDs.add(this.getSchID());
        } else {
            for (IGDIntervalZone zone : this.getIGDList()) {
                schIDs.add(zone.getSchID());
            }
        }
        return schIDs;
    }

    static class DrawColumn {
        private final List<DrawZone> drawZones;
        private final int column;
        private final String colTitle;

        public DrawColumn(List<DrawZone> drawZones, int column, String colTitle) {
            Objects.requireNonNull(drawZones);
            this.drawZones = drawZones;
            this.column = column;
            this.colTitle = colTitle;
        }
    }

    class PanelData {
        final int schID;
        final String schemeName;
        private final List<DrawColumn> columns;
        final /* synthetic */ PanelZones this$0;

        public PanelData(PanelZones this$0, int schID) {
            PanelZones panelZones = this$0;
            Objects.requireNonNull(panelZones);
            this.this$0 = panelZones;
            this.columns = new LinkedList<DrawColumn>();
            this.schID = schID;
            if (schID > 0) {
                try {
                    IGDScheme igdScheme = this$0.getBlock().getDb().getIGDScheme(schID);
                    if (igdScheme == null) {
                        this.schemeName = "Hidden";
                    }
                    this.schemeName = igdScheme.getName();
                }
                catch (SQLException sqlex) {
                    throw SuppressedSQLException.withoutRollback((SQLException)sqlex);
                }
            } else {
                this.schemeName = "";
            }
        }

        boolean isEmpty() {
            return this.columns.isEmpty() || this.columns.stream().allMatch(column -> column.drawZones.isEmpty());
        }

        float getWidth(BlockProperties bp) {
            return (float)Math.max(1, this.columns.size()) * this.this$0.getColumnWidth();
        }
    }
}

