/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.SectionType;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.WellBlock;
import jsbchart.core.BlockTemplate;
import jsbchart.core.CaptionTemplate;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.ChartPanel;
import jsbchart.panel.PanelScale;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelZones;
import model3.InterpHdr;
import model3.SBdb;
import model3.WellInterp;
import util.ColourUtils;
import util.SB;
import util.SBException;

public abstract class SBPanel
extends ChartPanel {
    protected static final float BRACKET_BASE = 2.5f;
    private boolean outline = false;
    protected static final int colourDensity = 85;
    final float CAPTIONMARGIN = 0.4f;

    public abstract float draw(SBGraphics var1, float var2, float var3, ChartProperties var4, BlockProperties var5, Chart.Mode var6, EnumMap<CorrelationType, HashSet<CorrelationPoint>> var7);

    public abstract float getWidth(BlockProperties var1);

    public float getWidth(BlockProperties bp, boolean drawEmptyPanels) {
        return this.getWidth(bp);
    }

    public abstract Object getObject(float var1, float var2, ChartProperties var3, BlockProperties var4, float var5);

    public abstract String getTooltip(float var1, float var2, ChartProperties var3, BlockProperties var4, float var5);

    protected SBPanel() {
        super(null, null);
    }

    protected SBPanel(PanelTemplate template, PanelOcc panelOcc) {
        super(template, panelOcc);
    }

    public void drawBackground(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
    }

    void drawImageLayer(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp) {
    }

    public boolean drawsLines(CorrelationType corrType) {
        return false;
    }

    @Override
    public ChartBlock getBlock() {
        return null;
    }

    @Override
    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public boolean isOutline() {
        return this.outline;
    }

    public void drawFrame(SBGraphics g, float x, float y, ChartProperties p, ChartBlock block, String caption, String subCaption) {
        this.drawFrame(g, x, y, p, block, block.getProp(), caption, subCaption);
    }

    private boolean hasCaption(String caption, String subCaption) {
        return this.getEffectiveCapOrient() == BlockTemplate.CaptionOrientation.TOP && (caption != null && !caption.isEmpty() || subCaption != null && !subCaption.isEmpty());
    }

    private BlockTemplate.CaptionOrientation getEffectiveCapOrient() {
        BlockTemplate.CaptionOrientation capOrient = BlockTemplate.CaptionOrientation.getDefault();
        if (this.getPanelOcc() != null) {
            capOrient = this.getPanelOcc().getCapOrient();
        }
        if (this.getPanelType().allowOverplot && capOrient != BlockTemplate.CaptionOrientation.getDefault()) {
            capOrient = BlockTemplate.CaptionOrientation.getDefault();
        }
        return capOrient;
    }

    public void drawFrame(SBGraphics g, float x, float y, ChartProperties cp, ChartBlock block, BlockProperties bp, String caption, String subCaption) {
        if ((double)this.getWidth(bp, cp.drawEmptyPanels) <= 0.0) {
            return;
        }
        SBFont captionFont = new SBFont(cp.font, 1, cp.getFontSizePanel());
        SBFont subCaptionFont = new SBFont(cp.font, 0, cp.getFontSize());
        TextLayoutPreferences captionLayout = new TextLayoutPreferences().setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Top).setFont(captionFont).truncateText().wrapText();
        TextLayoutPreferences subCaptionLayout = captionLayout.copy().setFont(subCaptionFont).hideOnOverflow();
        if (this.getPanelType().allowExtendedCaption && cp.panelExtCaptionHeight > cp.panelCaptionHeight) {
            this.drawFrame(g, x, y, cp, block, bp, this.hasCaption(caption, subCaption), cp.panelExtCaptionHeight);
            Rectangle2D.Float box = new Rectangle2D.Float(x, y, this.getWidth(bp, cp.drawEmptyPanels), cp.panelExtCaptionHeight);
            if ((double)(this.getWidth(bp, cp.drawEmptyPanels) / cp.panelExtCaptionHeight) < 0.66) {
                captionLayout.setTextDirection(TextDirection.Vertical).setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Middle).singleLineOfText().minFontSize(Math.max(cp.getFontSizePanel() - 5.0f, 5.0f));
                if (subCaption != null && !subCaption.isEmpty()) {
                    Rectangle2D.Float captionArea = g.drawStringWithinBox(caption, box, captionLayout);
                    box.width = box.width - captionArea.width - (captionArea.x - box.x);
                    box.x = captionArea.x + captionArea.width;
                    subCaptionLayout.setTextDirection(TextDirection.Vertical).minFontSize(Math.max(cp.getFontSize() - 5.0f, 5.0f)).singleLineOfText().setHorizontalAlignment(HorizontalAlignment.Left).setVerticalAlignment(VerticalAlignment.Middle);
                    g.drawStringWithinBox(subCaption, box, subCaptionLayout);
                } else {
                    g.drawStringWithinBox(caption, box, captionLayout);
                }
            } else {
                captionLayout.setVerticalAlignment(VerticalAlignment.Middle);
                Rectangle2D.Float captionArea = g.drawStringWithinBox(caption, box, captionLayout);
                if (subCaption != null && !subCaption.isEmpty()) {
                    box.y = captionArea.y + captionArea.height;
                    box.height -= captionArea.height;
                    g.drawStringWithinBox(subCaption, box, subCaptionLayout);
                }
            }
            return;
        }
        this.drawFrame(g, x, y, cp, block, bp, this.hasCaption(caption, subCaption));
        Rectangle2D.Float captionBox = new Rectangle2D.Float(x, y + 0.4f, this.getWidth(bp, cp.drawEmptyPanels), cp.panelCaptionHeight - 0.4f);
        Rectangle2D.Float panelBox = new Rectangle2D.Float(x, y, this.getWidth(bp, cp.drawEmptyPanels), this.getBlock().getHeaderHeight(cp));
        Rectangle2D.Float drawnCaptionArea = null;
        BlockTemplate.CaptionOrientation capOrient = this.getEffectiveCapOrient();
        if (caption != null && !caption.isEmpty()) {
            switch (capOrient) {
                default: {
                    assert (false);
                }
                case TOP: {
                    drawnCaptionArea = g.drawStringWithinBox(caption, captionBox, captionLayout);
                    if (subCaption == null || subCaption.isEmpty()) break;
                    captionBox.y = drawnCaptionArea.y + drawnCaptionArea.height;
                    captionBox.height -= drawnCaptionArea.height;
                    g.drawStringWithinBox(subCaption, captionBox, subCaptionLayout);
                    break;
                }
                case VERT: {
                    if (this instanceof PanelScale) break;
                    panelBox.height -= cp.getFontSizeHeader();
                    captionLayout.setFont(new SBFont(cp.font, 0, cp.getFontSizeHeader())).setTextDirection(TextDirection.Vertical).setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Bottom);
                    drawnCaptionArea = g.drawStringWithinBox(caption, panelBox, captionLayout);
                    if (subCaption == null || subCaption.isEmpty()) break;
                    subCaptionLayout.setTextDirection(TextDirection.Vertical).setHorizontalAlignment(HorizontalAlignment.Left).setVerticalAlignment(VerticalAlignment.Bottom);
                    panelBox.width = panelBox.width - drawnCaptionArea.width - (drawnCaptionArea.x - panelBox.x);
                    panelBox.x = drawnCaptionArea.x + drawnCaptionArea.width;
                    g.drawStringWithinBox(subCaption, panelBox, subCaptionLayout);
                    break;
                }
                case CENTRE: {
                    captionLayout.setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Middle);
                    drawnCaptionArea = g.drawStringWithinBox(caption, panelBox, captionLayout);
                    if (subCaption == null || subCaption.isEmpty()) break;
                    panelBox.y = drawnCaptionArea.y + drawnCaptionArea.height;
                    panelBox.height -= drawnCaptionArea.height;
                    g.drawStringWithinBox(subCaption, panelBox, subCaptionLayout);
                }
            }
        }
    }

    private void drawFrame(SBGraphics g, float x, float y, ChartProperties p, ChartBlock block, BlockProperties bp, boolean lineUnderCaption) {
        this.drawFrame(g, x, y, p, block, bp, lineUnderCaption, p.panelCaptionHeight);
    }

    void drawFrame(SBGraphics g, float x, float y, ChartProperties p, ChartBlock block, BlockProperties bp, boolean lineUnderCaption, float captionHeight) {
        g.setColor(p.foreground);
        this.setOutlineStroke(g);
        Float height = Float.valueOf(bp.getHeight());
        if (height.isNaN()) {
            height = Float.valueOf(0.0f);
        }
        g.drawRect(x, y, this.getWidth(block.getProp(), p.drawEmptyPanels), block.getPanelHeaderHeight(p, null) + height.floatValue());
        g.setStroke(0.2f);
        if (lineUnderCaption) {
            g.drawLine(x, y + captionHeight, x + this.getWidth(block.getProp(), p.drawEmptyPanels), y + captionHeight);
        }
        g.drawLine(x, y + block.getPanelHeaderHeight(p, null), x + this.getWidth(block.getProp(), p.drawEmptyPanels), y + block.getPanelHeaderHeight(p, null));
    }

    public void drawOutline(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        Float height = Float.valueOf(bp.getHeight());
        if (height.isNaN()) {
            height = Float.valueOf(0.0f);
        }
        g.setColor(p.foreground);
        this.setOutlineStroke(g);
        g.drawRect(x, y + this.getPanelHeaderHeight(p, mode), this.getWidth(bp, p.drawEmptyPanels), height.floatValue());
    }

    private void setOutlineStroke(SBGraphics g) {
        SBPanel.setOutlineStroke(g, 0.4f, this.isPanelOccSelected(), this.isTemplateSelected());
    }

    static void setOutlineStroke(SBGraphics g, float basicStrokeWeight, boolean isPanelOccSelected, boolean isTemplateSelected) {
        if (isPanelOccSelected) {
            g.setStroke(basicStrokeWeight *= 4.0f);
        } else if (isTemplateSelected) {
            g.setDashStroke(basicStrokeWeight *= 3.0f, 3.5f);
        } else {
            g.setStroke(basicStrokeWeight);
        }
    }

    void drawSeaBed(SBGraphics g, ChartProperties cp, BlockProperties bp, ChartBlock block, ScaleConverter sc, float x, float topy) {
        if (block.getWell() != null && block.getWell().getHeader() != null && block.getWell().getSectionType() == SectionType.WELL && (double)block.getWell().getHeader().getSBDepth() > sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).get()) {
            g.setColor(cp.accent);
            g.setStroke(0.2f);
            float sbYPos = topy + block.scaleMeasuredDepth(block.getWell().getHeader().getSBDepth(), sc);
            g.drawLine(x, sbYPos, x + this.getWidth(bp, cp.drawEmptyPanels), sbYPos);
        }
    }

    public void drawSubHeader(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp) {
        String subHeader = this.getSubHeader();
        if (subHeader == null || subHeader.isEmpty() || this.getPanelOcc().getCapOrient() != BlockTemplate.CaptionOrientation.TOP) {
            return;
        }
        this.drawSubHeader(g, x, y, p, bp, subHeader);
    }

    private void drawSubHeader(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, String subHeader) {
        float fontSize = p.getFontSizeHeader();
        g.setFont(p.font, 0, fontSize);
        float headerHeight = this.getBlock().getHeaderHeight(p);
        g.drawStringVertical(subHeader, x, y + headerHeight - fontSize, this.getMaxSubheaderStringHeight(p), false, true, Float.valueOf(this.getWidth(bp)));
    }

    protected void drawSubHeader(SBGraphics g, float leftX, float rightX, float y, ChartProperties p, BlockProperties bp, String subHeader) {
        float fontSize = p.getFontSizeHeader();
        float x = leftX + (rightX - leftX) / 2.0f;
        float headerHeight = this.getBlock().getHeaderHeight(p);
        g.setFont(p.font, 0, fontSize);
        g.drawStringVertical(subHeader, x, y + headerHeight - fontSize, this.getMaxSubheaderStringHeight(p), true, false, true);
    }

    public float getMaxSubheaderStringHeight(ChartProperties p) {
        float headerHeight = this.getBlock().getHeaderHeight(p);
        if (this.getPanelOcc() == null || this.getPanelOcc().getCapOrient() == BlockTemplate.CaptionOrientation.TOP) {
            return headerHeight - (this.getPanelType().allowExtendedCaption ? p.panelExtCaptionHeight : p.panelCaptionHeight) - p.getFontSizeHeader();
        }
        return headerHeight - p.getFontSizeHeader();
    }

    protected void drawColumnDivider(SBGraphics g, float xpos, float y, float topy, boolean firstOrOnly, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (mode != Chart.Mode.NO_HEADER && firstOrOnly) {
            boolean hasCaptions = this.hasCaption(this.getTemplatedCaption(cp, bp), this.getTemplatedSubCaption(cp));
            float ypos = y;
            if (hasCaptions) {
                ypos = this.getPanelType().allowCaptionOrientationChange ? (ypos += SBPanel.getPanelCaptionHeight(cp, mode)) : (this.getPanelType().allowExtendedCaption ? (ypos += cp.panelExtCaptionHeight) : (ypos += cp.panelCaptionHeight));
            }
            g.drawLine(xpos, ypos, xpos, y + this.getPanelHeaderHeight(cp, mode) + (bp != null ? bp.getHeight() : 0.0f));
        } else {
            g.drawLine(xpos, topy, xpos, topy + (bp != null ? bp.getHeight() : 0.0f));
        }
    }

    protected static void moveSamplePositions(int nSamples, float[] samplePosition, float symbolSize, float hSampPosition, float lSampPosition) {
        if (nSamples < 2) {
            if (samplePosition[0] < hSampPosition) {
                samplePosition[0] = hSampPosition;
            }
            if (samplePosition[nSamples - 1] > lSampPosition) {
                samplePosition[nSamples - 1] = lSampPosition;
            }
            return;
        }
        float[] symbolSizes = new float[nSamples];
        for (int i = 0; i < nSamples; ++i) {
            symbolSizes[i] = symbolSize;
        }
        SBPanel.moveSamplePositions(nSamples, samplePosition, symbolSizes, hSampPosition, lSampPosition);
    }

    public static void moveSamplePositions(int nSamples, float[] samplePosition, float[] symbolSize, float hSampPosition, float lSampPosition) {
        int j;
        int i;
        if (nSamples < 2) {
            if (samplePosition.length > 0) {
                if (samplePosition[0] < hSampPosition) {
                    samplePosition[0] = hSampPosition;
                }
                if (samplePosition[nSamples - 1] > lSampPosition) {
                    samplePosition[nSamples - 1] = lSampPosition;
                }
            }
            return;
        }
        int ITMAX = 800;
        float MINMOVE = 1.0E-4f;
        float[] force = new float[nSamples];
        float[] SPP = new float[nSamples];
        if (samplePosition[0] < samplePosition[nSamples - 1]) {
            for (i = 0; i < nSamples; ++i) {
                SPP[i] = samplePosition[i];
            }
        } else {
            j = nSamples;
            for (i = 0; i < nSamples; ++i) {
                SPP[i] = samplePosition[--j];
            }
        }
        boolean finished = false;
        int itNumber = 0;
        while (!finished) {
            boolean moveCell = false;
            float overlap = SPP[1] - SPP[0];
            if (overlap < symbolSize[0]) {
                force[0] = -1.0f * (symbolSize[0] - overlap);
                if (Math.abs(force[0]) > 1.0E-4f) {
                    moveCell = true;
                }
            } else {
                force[0] = 0.0f;
            }
            if ((overlap = SPP[nSamples - 1] - SPP[nSamples - 2]) < symbolSize[nSamples - 2]) {
                force[nSamples - 1] = symbolSize[nSamples - 2] - overlap;
                if (Math.abs(force[nSamples - 1]) > 1.0E-4f) {
                    moveCell = true;
                }
            } else {
                force[nSamples - 1] = 0.0f;
            }
            if (nSamples > 2) {
                for (i = 1; i < nSamples - 1; ++i) {
                    overlap = SPP[i] - SPP[i - 1];
                    if (overlap < symbolSize[i - 1]) {
                        force[i] = symbolSize[i - 1] - overlap;
                        if (Math.abs(force[i]) > 1.0E-4f) {
                            moveCell = true;
                        }
                    } else {
                        force[i] = 0.0f;
                    }
                    if (!((overlap = SPP[i + 1] - SPP[i]) < symbolSize[i])) continue;
                    force[i] = force[i] - (symbolSize[i] - overlap);
                    if (!(Math.abs(force[i]) > 1.0E-4f)) continue;
                    moveCell = true;
                }
            }
            float alpha = 0.45f;
            for (i = 0; i < nSamples; ++i) {
                float p;
                SPP[i] = p = SPP[i] + alpha * force[i];
            }
            if (SPP[0] < hSampPosition) {
                SPP[0] = hSampPosition;
            }
            if (SPP[nSamples - 1] > lSampPosition) {
                SPP[nSamples - 1] = lSampPosition;
            }
            boolean bl = finished = !moveCell;
            if (++itNumber <= 800) continue;
            finished = true;
        }
        if (samplePosition[0] < samplePosition[nSamples - 1]) {
            for (i = 0; i < nSamples; ++i) {
                samplePosition[i] = SPP[i];
            }
        } else {
            j = nSamples;
            for (i = 0; i < nSamples; ++i) {
                samplePosition[i] = SPP[--j];
            }
        }
    }

    protected float getPanelHeaderHeight(ChartProperties cp, Chart.Mode mode) {
        if (this.getBlock() != null) {
            return SBPanel.getPanelHeaderHeight(cp, mode, this.getBlock());
        }
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.getPanelHeaderHeight();
    }

    protected static float getPanelHeaderHeight(ChartProperties cp, Chart.Mode mode, ChartBlock block) {
        if (block != null) {
            return block.getPanelHeaderHeight(cp, mode);
        }
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.getPanelHeaderHeight();
    }

    protected static float getPanelCaptionHeight(ChartProperties cp, Chart.Mode mode) {
        return SBPanel.getPanelCaptionHeight(cp, mode, false);
    }

    protected static float getPanelCaptionHeight(ChartProperties cp, Chart.Mode mode, boolean extended) {
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return extended ? cp.panelExtCaptionHeight : cp.panelCaptionHeight;
    }

    protected static float getPanelSubHeaderHeight(ChartProperties cp, Chart.Mode mode) {
        switch (mode) {
            case NO_HEADER: {
                return 0.0f;
            }
        }
        return cp.panelSubHeaderHeight;
    }

    public float drawHorz(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp) {
        return 0.0f;
    }

    void drawHorzOutline(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp) {
        g.setColor(p.foreground);
        g.setStroke(0.2f);
        g.drawRect(x, y, SBPanel.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp), this.getWidth(bp));
        g.drawLine(x, y, x, y + this.getWidth(bp));
    }

    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException, IOException {
    }

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        this.setData(update.getChartProperties(), update.getDataSections());
    }

    @Override
    public void prepareData(ChartUpdate update) {
    }

    protected static float getXPos(float age, BlockProperties bp) {
        float xpos = bp.getAgeLeftToRight() ? (age - bp.getMin()) * bp.getSingleScale() : (bp.getMax() - age) * bp.getSingleScale();
        return xpos;
    }

    protected abstract String getCaption();

    public String getTemplatedCaption(ChartProperties cp, BlockProperties bp) {
        LinkedList<String> overplotCaptions = new LinkedList<String>();
        if (!this.isOverplot()) {
            for (SBPanel overplotted : this.getBlock().getOverplotPanels(this)) {
                String templatedCaption;
                if (!overplotted.hasDataInInterval(bp) || (templatedCaption = overplotted.getTemplatedCaption(cp, bp)).isEmpty() || overplotCaptions.contains(templatedCaption)) continue;
                overplotCaptions.add(templatedCaption);
            }
        }
        String cap = null;
        if (this.getPanelOcc() != null) {
            cap = this.getPanelOcc().getCaption();
        }
        if (cap == null && (this.hasDataInInterval(bp) || !this.isOverplot() && overplotCaptions.isEmpty())) {
            cap = this.getCaption();
        }
        if (cap != null && this.getBlock() != null) {
            cap = this.convertCaption(cap, cp);
        }
        if (!overplotCaptions.contains(cap)) {
            overplotCaptions.add(0, cap);
        }
        cap = SB.joinStrings(overplotCaptions, (String)"; ");
        return cap;
    }

    public String getTemplatedSubCaption(ChartProperties cp) {
        String subcap = null;
        if (this.getPanelOcc() != null) {
            subcap = this.getPanelOcc().getSubCaption();
        }
        if (subcap == null) {
            return this.getSubCaption();
        }
        return this.convertCaption(subcap, cp);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    String convertCaption(String caption, ChartProperties cp) {
        if (caption.isEmpty()) {
            return caption;
        }
        for (CaptionTemplate el : CaptionTemplate.values()) {
            pattern = Pattern.compile(el.toPatternString());
            m = pattern.matcher(caption);
            if (!m.find()) continue;
            replacement = null;
            block2 : switch (1.$SwitchMap$jsbchart$core$CaptionTemplate[el.ordinal()]) {
                case 1: {
                    replacement = this.getTemplate() != null ? this.getTemplate().getName() : "";
                    break;
                }
                case 2: {
                    replacement = "<error>";
                    try {
                        hdr = this.getBlock().getDb().getInterp(this.getInterpID(this.getBlock()));
                        if (hdr == null) break;
                        replacement = hdr.getDescription();
                    }
                    catch (SQLException sql) {
                        sql.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    schID = 0;
                    cmpStdID = 0;
                    if (this.getPanelOcc().getSchID() <= 0) ** GOTO lbl28
                    schID = this.getPanelOcc().getSchID();
                    ** GOTO lbl39
lbl28:
                    // 1 sources

                    if (this.getTemplate().getProperties().getIGDSchemeID() <= 0) ** GOTO lbl31
                    schID = this.getTemplate().getProperties().getIGDSchemeID();
                    ** GOTO lbl39
lbl31:
                    // 1 sources

                    if (!(this instanceof PanelZones)) ** GOTO lbl37
                    if (((PanelZones)this).getSchID() > 0) {
                        schID = ((PanelZones)this).getSchID();
                    } else {
                        replacement = "(all schemes)";
                        break;
lbl37:
                        // 1 sources

                        if (this.getTemplate().getProperties().getCmpStdID() > 0) {
                            cmpStdID = this.getTemplate().getProperties().getCmpStdID();
                        }
                    }
lbl39:
                    // 6 sources

                    replacement = "";
                    if (schID <= 0 && cmpStdID <= 0) break;
                    try {
                        sch /* !! */  = schID > 0 ? this.getBlock().getDb().getIGDScheme(schID) : this.getBlock().getDb().getCompositeStandard(cmpStdID);
                        if (sch /* !! */  == null) break;
                        replacement = sch /* !! */ .toString();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    if (!(this instanceof PanelScale) || !((PanelScale)this).getProperties().alternativeUnits) break;
                    switch (this.getBlock().getProp().getUnits()) {
                        case 'F': 
                        case 'f': {
                            replacement = "m";
                            break block2;
                        }
                    }
                    replacement = "ft";
                    break;
                }
            }
            if (replacement == null) continue;
            caption = m.replaceAll(replacement);
        }
        return this.getBlock().convertCaption(caption.trim(), cp);
    }

    protected String getSubCaption() {
        return null;
    }

    protected String getSubHeader() {
        return "";
    }

    protected SBdb getDb() {
        if (this.getBlock() == null) {
            return null;
        }
        return this.getBlock().getDb();
    }

    public boolean pipe() {
        return true;
    }

    int size() {
        return 1;
    }

    protected static Map<AttributedCharacterIterator.Attribute, Object> getAttributes(SBGraphics g) {
        HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        Font font = g.getFont();
        atts.put(TextAttribute.FAMILY, font.getFamily());
        atts.put(TextAttribute.SIZE, Float.valueOf(font.getSize()));
        atts.put(TextAttribute.FOREGROUND, g.getColor());
        return atts;
    }

    protected void handleException(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Exception e) {
        Logger logger = Logger.getLogger(SBPanel.class.getName());
        logger.log(Level.SEVERE, "Error drawing panel: " + String.valueOf(this), e);
        g.setFontSize(cp.getFontSize());
        g.setClip(x, y, this.getWidth(bp), bp.getHeight());
        g.setColor(Color.BLACK);
        LinkedList<Object> lines = new LinkedList<Object>();
        StackTraceElement[] trace = e.getStackTrace();
        lines.add("Error drawing panel:");
        lines.add(e.toString());
        int numberedLines = 0;
        for (int i = 0; i < trace.length && numberedLines < 8; ++i) {
            lines.add(String.valueOf(trace[i]));
            if (trace[i].getLineNumber() > 0) {
                ++numberedLines;
            }
            if (trace[i].getClassName().startsWith("javax.swing.")) break;
        }
        float ypos = y;
        for (String string : lines) {
            g.drawString(string, x + 1.0f, ypos += cp.getFontSize());
        }
        g.setClip(null);
    }

    public int getInterpID(ChartBlock block) {
        if (this.getPanelOcc() != null && this.getPanelOcc().getInterpID() != null) {
            return this.getPanelOcc().getInterpID();
        }
        return block.getInterpID();
    }

    public boolean hasData(BlockProperties bp) {
        return true;
    }

    public boolean hasDataInInterval(BlockProperties bp) {
        return this.hasData(bp);
    }

    public Float getDataBound(boolean upper) {
        return null;
    }

    public List<Userdef> getAnalystsInWell() throws SQLException, SBException {
        return null;
    }

    public List<InterpHdr> getVersionsInWell() {
        if (!this.getPanelType().isInterpPanel() || this.getBlock() == null || this.getBlock().getWell() == null) {
            return null;
        }
        LinkedList<InterpHdr> hdrs = new LinkedList<InterpHdr>();
        Iterator interpIterator = this.getBlock().getWell().getInterpIterator();
        while (interpIterator.hasNext()) {
            hdrs.add(((WellInterp)interpIterator.next()).getHeader());
        }
        if (hdrs.isEmpty()) {
            hdrs = null;
        }
        return hdrs;
    }

    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        assert (!ws.isConnected() && this.getBlock().getDb().isConnected());
    }

    boolean shouldDraw(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, WellBlock block, boolean firstOrOnly, float width) {
        return cp.keyIsVisible() || g.isVisible(x, firstOrOnly ? y : block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax()) + y + block.getPanelHeaderHeight(cp, mode), width, bp.getHeight() + (firstOrOnly ? this.getBlock().getPanelHeaderHeight(cp, mode) : 0.0f));
    }

    public boolean isOverplot() {
        if (!this.isLogicalOverplot()) {
            return false;
        }
        List<SBPanel> panels = this.getBlock().getPanels();
        int index = panels.indexOf(this);
        if (index == 0) {
            return false;
        }
        for (int i = index - 1; i > -1; --i) {
            if (PanelType.canOverplot(panels.get(i).getPanelType(), this.getPanelType())) {
                return true;
            }
            if (!panels.get(i).isLogicalOverplot()) break;
        }
        return false;
    }

    boolean isLogicalOverplot() {
        if (this.getBlock().getWell() == null) {
            return false;
        }
        return this.getPanelType().allowOverplot && this.getPanelOcc() != null && this.getPanelOcc().getCapOrient() != BlockTemplate.CaptionOrientation.getDefault();
    }

    protected SBPanel getUnderplotPanel() {
        if (!this.isOverplot()) {
            return null;
        }
        List<SBPanel> panels = this.getBlock().getPanels();
        int index = panels.indexOf(this);
        for (int i = index - 1; i > -1; --i) {
            if (panels.get(i).isOverplot()) continue;
            return panels.get(i);
        }
        throw new IllegalStateException("No underplot panel!");
    }

    public List<SBPanel> getOverplotPanels(ChartProperties cp) {
        List<SBPanel> panels = this.getBlock().getPanels();
        int index = panels.indexOf(this);
        if (this.isOverplot() || index == panels.size() - 1 || !panels.get(index + 1).isOverplot()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<SBPanel> list = new LinkedList<SBPanel>();
        for (int i = index + 1; i < panels.size(); ++i) {
            SBPanel panel = panels.get(i);
            if (panel.isOverplot()) {
                if (!cp.drawEmptyPanels && !panel.hasData(this.getBlock().getProp())) continue;
                list.add(panel);
                continue;
            }
            return list;
        }
        return list;
    }

    public Color getConfidenceColor(Confidence confidence, Color c) {
        if (confidence.getDBint() > 0) {
            c = ColourUtils.getLighterColour((Color)c, (float)(1.0f - (float)confidence.getDBint() / 120.0f));
        }
        return c;
    }

    public float getConfidenceStroke(Confidence confidence, float basic) {
        if (confidence.getDBint() > 0) {
            return basic * (1.0f - (float)confidence.getDBint() / 120.0f);
        }
        return basic;
    }

    public boolean isVisible(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, ScaleConverter sc) {
        boolean isFirstOrOnlySubBlock;
        if (sc == null) {
            sc = this.getBlock().getScaleConverter(this.getBlock().getWell());
        }
        boolean bl = isFirstOrOnlySubBlock = bp == this.getBlock().getProp() || sc.isTopDepth(bp.getMin());
        float topOfBlock = isFirstOrOnlySubBlock ? 0.0f : this.getBlock().scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc);
        return g.isVisible(x, y + topOfBlock + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight());
    }

    public String getBoundaryLabel(BlockProperties bp, double depth, int precision, boolean restrictToMDorTVD) throws SQLException, SBException {
        BlockProperties.ScaleType labelScaleType = bp.getWorkingLabelScaleType();
        if (restrictToMDorTVD) {
            switch (labelScaleType) {
                case AGE: 
                case TWT: {
                    labelScaleType = BlockProperties.ScaleType.MD;
                }
            }
        }
        return switch (labelScaleType) {
            default -> SB.getDepthString((double)depth, (char)bp.getUnits(), (int)precision);
            case BlockProperties.ScaleType.TVD -> SB.getDepthString((double)this.getBlock().getWell().getTVDlist(false).getTVD(depth).getTVDepth(), (char)bp.getUnits(), (int)precision);
            case BlockProperties.ScaleType.TWT -> Integer.toString((int)Math.floor(this.getBlock().getWell().getTWTlist().getTWT(depth).getTWT()));
            case BlockProperties.ScaleType.AGE -> SBPanel.getAgeLabelString(this.getBlock().getWell().getInterp(this.getInterpID(this.getBlock())), depth);
        };
    }

    public static String getAgeLabelString(WellInterp wellInterp, double sampleDepth) {
        if (wellInterp.getLOC() != null) {
            int prec;
            double age = wellInterp.getLOC().getAge(sampleDepth, true);
            int n = prec = age < (double)0.0029f ? 2 : (int)Math.floor(Math.log10(age));
            if (prec <= 0) {
                prec = Math.abs(prec) + 2;
            } else if (prec == 1) {
                prec = 2;
            } else if (prec > 2) {
                prec = 1;
            } else if (Math.abs(prec) > 10) {
                prec = 2;
            }
            return SB.floatString((double)age, (int)prec);
        }
        return "";
    }
}

