/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.util.LinkedList;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.SBPanel;
import model3.Sample;

public abstract class SBPanelHTML
extends SBPanel {
    protected static final String TD = "<td>";
    protected static final String TD_END = "</td>";
    protected static final String BR = "<br>";
    protected static final String FONT_END = "</font>";

    protected SBPanelHTML() {
    }

    protected SBPanelHTML(PanelTemplate template, PanelOcc panelOcc) {
        super(template, panelOcc);
    }

    public abstract int addSamples(LinkedList<Sample> var1, ChartProperties var2);

    public abstract String getRowString(LinkedList<Sample> var1, int var2, ChartProperties var3);

    public String getCaptionString() {
        String cap = this.getColSpan() > 1 ? "<th colspan=\"" + this.getColSpan() + "\">" + this.getCaption() : "<th>" + this.getCaption();
        if (this.getSubCaption() != null) {
            cap = cap + BR + this.getSubCaption();
        }
        cap = cap + "</th>";
        return cap;
    }

    protected String getSubCaptionString() {
        return TD + (this.getSubCaption() != null ? this.getSubCaption() : "") + TD_END;
    }

    public String getSubHeaderString() {
        return "<th>" + (this.getSubHeader() != null ? this.getSubHeader() : "") + "</th>";
    }

    protected int getColSpan() {
        return 1;
    }

    protected static String getHTMLRowspan(int span) {
        return "rowspan=\"" + span + "\"";
    }

    protected static String getHTMLFontColour(Color colour) {
        return "<font color=" + SBPanelHTML.getHexColour(colour) + ">";
    }

    protected static String getHexColour(Color colour) {
        String[] rgb = new String[]{Integer.toHexString(colour.getRed()), Integer.toHexString(colour.getGreen()), Integer.toHexString(colour.getBlue())};
        Object hex = "#";
        for (int i = 0; i < rgb.length; ++i) {
            if (rgb[i].equals("0")) {
                rgb[i] = "00";
            }
            hex = (String)hex + rgb[i];
        }
        return hex;
    }
}

