/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.panelIGDScheme;

import com.stratadata.model3.scheme.Confidence;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.CopyToLegendTruncationHandler;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanel;
import jsbchart.panel.panelIGDScheme.PanelIGDSchemeProperties;
import jsbchart.panel.panelIGDScheme.RenderingSummary;
import jsbchart.panel.panelIGDScheme.SchemeUnitRenderer;
import jsbchart.panel.panelIGDScheme.SchemeUnitRenderingInfo;
import jsbchart.panel.panelIGDScheme.UnitZone;
import model3.Chron;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import model3.WellInterp;
import util.ColourUtils;
import util.DoubleRange;
import util.FloatRange;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class PanelIGDScheme
extends SBPanel {
    private static final float EXPANDED_ZONE_PADDING = 0.1f;
    private static final float EXPANDED_ZONE_HORIZONTAL_PADDING = 1.0f;
    private static final int MAX_FONT_SHRINK_ITERATIONS = 4;
    private static final float TEXT_PADDING = 0.5f;
    private static final float MAX_FONT_SHRINK_AMOUNT = 1.5f;
    private final SchemeBlock block;
    private PanelIGDSchemeProperties p;
    boolean refreshWidth = true;
    private float width;
    private boolean[] colHasData;

    public PanelIGDScheme(PanelTemplate template, SchemeBlock block, PanelOcc occ) throws SQLException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelIGDSchemeProperties)template.getProperties();
        this.setColHasData();
    }

    public PanelIGDScheme(IGDScheme scheme, SchemeBlock block) throws SQLException {
        if (scheme == null) {
            throw new IllegalArgumentException("Attempt to construct scheme panel with null scheme");
        }
        this.block = block;
        scheme.loadUnits();
        this.p = new PanelIGDSchemeProperties(scheme, block.getProp().getMin(), block.getProp().getMax());
    }

    private void setColHasData() {
        int maxHier = IGDIntervalZone.getNHier((int)this.p.scheme.getIGDType(), (boolean)true);
        if (maxHier != this.p.hierWidths.length) {
            throw new IllegalStateException("Scheme has changed in PanelIGDScheme");
        }
        this.colHasData = new boolean[maxHier];
        if (this.block.getProp().getScaleType() != BlockProperties.ScaleType.AGE) {
            for (int i = 0; i < this.colHasData.length; ++i) {
                this.colHasData[i] = true;
            }
            return;
        }
        for (IGDUnitBase unit : this.p.scheme.getUnitBases()) {
            if (!unit.hasAges() || !(unit.getLage() > (double)this.block.getProp().getMin() + 1.0E-6) || !(unit.getUage() < (double)this.block.getProp().getMax() - 1.0E-6)) continue;
            this.colHasData[unit.getHier() - 1] = true;
        }
    }

    public String toString() {
        Object strg = "Stratigraphic Scheme";
        if (this.p != null && this.p.getScheme() != null) {
            strg = IGDInterval.getIGDName((int)this.p.getScheme().getIGDType()) + " scheme";
            strg = (String)strg + " - " + this.p.getScheme().toString();
        }
        return strg;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return this.getUnit(x, y, bp);
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        IGDUnitBase unit = this.getUnit(x, y, bp);
        if (unit != null) {
            return unit.toString(true, cp.ageFormat);
        }
        return this.toString();
    }

    IGDUnitBase getUnit(float x, float y, BlockProperties bp) {
        if (this.p.getScheme() == null) {
            return null;
        }
        if (this.block.getProp().getScaleType() == BlockProperties.ScaleType.AGE) {
            for (IGDUnitBase unit : this.p.getScheme().getUnitBases()) {
                if (!unit.hasAges() || !(unit.getLage() > (double)bp.getMin()) || !(unit.getUage() < (double)bp.getMax()) || !this.plotHier(unit.getHier() - 1)) continue;
                int indent = 0;
                for (int i = 0; i < unit.getHier() - 1; ++i) {
                    if (!this.plotHier(i)) continue;
                    indent = (int)((float)indent + this.p.hierWidth(i));
                }
                float xLeft = indent;
                float yTop = bp.scaleAge((float)Math.max(unit.getUage(), (double)bp.getMin()));
                float yBot = bp.scaleAge((float)Math.min(unit.getLage(), (double)bp.getMax()));
                if (!(x >= xLeft) || !(x <= xLeft + this.p.hierWidth(unit.getHier() - 1)) || !(y >= yTop) || !(y <= yBot)) continue;
                return unit;
            }
        }
        return null;
    }

    public IGDScheme getScheme() {
        return this.p.getScheme();
    }

    void removeMaScale() {
        this.p.setProperty(4, null);
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (bp.getScaleType() == BlockProperties.ScaleType.AGE) {
            try {
                PanelIGDScheme.drawUnitsAge(g, x, y, bp, cp, mode, true, false, true, this.block, this.p, this.getWidth(bp), this.colHasData);
            }
            catch (Exception e) {
                this.handleException(g, x, y, cp, bp, e);
            }
        }
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        g.setStroke(0.2f);
        g.setColor(cp.foreground);
        float total = 0.0f;
        for (int i = 0; i < this.p.nHier(); ++i) {
            if (!this.plotHier(i)) continue;
            this.drawColumnDivider(g, x + (total += this.p.hierWidth(i)), y, y + this.getPanelHeaderHeight(cp, mode), true, cp, this.p.spanEmptyHiers() ? null : bp, mode);
        }
        if (bp.getScaleType() == BlockProperties.ScaleType.AGE && this.p.includeMaScale() && this.p.key()) {
            float xpos = x + this.width - this.p.getKeyWidth();
            this.drawColumnDivider(g, xpos, y, y + this.getPanelHeaderHeight(cp, mode), true, cp, this.p.spanEmptyHiers() ? null : bp, mode);
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                if (this.p.getScheme() != null) {
                    g.setStroke(0.1f);
                    try {
                        if (bp.getScaleType() != BlockProperties.ScaleType.AGE) {
                            this.drawUnitsDepth(g, x, y + this.getPanelHeaderHeight(cp, mode), cp, bp);
                            break;
                        }
                        PanelIGDScheme.drawUnitsAge(g, x, y + this.getPanelHeaderHeight(cp, mode), bp, cp, mode, true, true, false, this.block, this.p, this.getWidth(bp), this.colHasData);
                        this.drawSubheaders(g, x, y, cp, bp, mode);
                        break;
                    }
                    catch (Exception e) {
                        this.handleException(g, x, y, cp, bp, e);
                        return x + this.width;
                    }
                }
            }
            case HEADER_ONLY: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                this.drawColHeaders(g, x, y, cp, bp, mode);
            }
            case NO_HEADER: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return x + this.width;
    }

    public static List<RenderingSummary<IGDUnitBase>> drawUnitsAge(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, boolean vertical, boolean foreground, boolean background, SchemeBlock block, PanelIGDSchemeProperties p, float panelWidth, boolean[] colHasData) throws SQLException, SBException {
        Rectangle2D.Float chartBounds;
        List igdUnits = p.getScheme().getUnitBases();
        List<SchemeUnitRenderingInfo> zones = PanelIGDScheme.buildAgeZones2(igdUnits, block, p, x, y, vertical, bp, colHasData);
        TreeSet<BoundaryAge> boundaryAges = null;
        if (p.includeMaScale()) {
            boundaryAges = PanelIGDScheme.getBoundaryAges(block, igdUnits);
        }
        HashMap<Integer, FloatRange> heirBounds = new HashMap<Integer, FloatRange>();
        if (!foreground) {
            return new ArrayList<RenderingSummary<IGDUnitBase>>();
        }
        SchemeUnitRenderer r = new SchemeUnitRenderer();
        r.getTextPrefs().setFont(new SBFont(cp.font, 0, cp.getFontSize(p.fontSize)));
        r.getTextPrefs().setTruncationHandler(new CopyToLegendTruncationHandler(g.getTextMeasurer(), cp));
        r.setSpanEmptyHiers(p.spanEmptyHiers);
        if (p.vertPref) {
            r.getTextPrefs().setTextDirection(TextDirection.Vertical);
        } else {
            r.getTextPrefs().setTextDirection(TextDirection.Horizontal);
        }
        List<Object> renderedObjects = new ArrayList();
        if (!vertical) {
            FloatRange xRange = new FloatRange(x + PanelIGDScheme.getXPos(block.getAgeLimit(true), bp), x + PanelIGDScheme.getXPos(block.getAgeLimit(false), bp));
            float yMin = y;
            if (p.includeMaScale() && !boundaryAges.isEmpty()) {
                yMin += p.getMaWidth();
            }
            if (p.key()) {
                yMin += p.getKeyWidth();
            }
            float yStart = yMin;
            float yHighest = yMin;
            for (int i = 0; i < p.nHier(); ++i) {
                if (!p.plotHier(i) || !colHasData[i]) continue;
                float yEnd = yStart + p.hierWidth(i);
                heirBounds.put(i + 1, new FloatRange(yStart, yEnd));
                yStart = yEnd;
                yHighest = Math.max(yHighest, yEnd);
            }
            chartBounds = new Rectangle2D.Float(xRange.getMin(), yMin, xRange.getSize(), yHighest - yMin);
            if (p.getHideOverflow() && !(g.getGraphics() instanceof PdfBoxGraphics2D)) {
                g.setClip(chartBounds.x, chartBounds.y, chartBounds.width, chartBounds.height);
            }
            renderedObjects = !zones.isEmpty() ? r.drawSchemeUnitsHeirHorizontal(g, zones, chartBounds, heirBounds) : new ArrayList();
            if (p.getHideOverflow()) {
                g.setClip(null);
            }
        } else {
            FloatRange yRange = new FloatRange(y, y + bp.getHeight());
            float xStart = x;
            float xHighest = x;
            if (!p.lithostratIsWest) {
                for (int i = p.nHier() - 1; i >= 0; --i) {
                    if (!p.plotHier(i) || colHasData != null && !colHasData[i]) continue;
                    float xEnd = xStart + p.hierWidth(i);
                    heirBounds.put(i + 1, new FloatRange(xStart, xEnd));
                    xStart = xEnd;
                    xHighest = Math.max(xHighest, xEnd);
                }
            } else {
                for (int i = 0; i < p.nHier(); ++i) {
                    if (!p.plotHier(i) || colHasData != null && !colHasData[i]) continue;
                    float xEnd = xStart + p.hierWidth(i);
                    heirBounds.put(i + 1, new FloatRange(xStart, xEnd));
                    xStart = xEnd;
                    xHighest = Math.max(xHighest, xEnd);
                }
            }
            chartBounds = new Rectangle2D.Float(x, yRange.getMin(), xHighest - x, yRange.getSize());
            if (p.getHideOverflow() && !(g.getGraphics() instanceof PdfBoxGraphics2D)) {
                g.setClip(chartBounds.x, chartBounds.y, chartBounds.width, chartBounds.height);
            }
            r.setFallbackColour(cp.background);
            renderedObjects = !zones.isEmpty() ? r.drawSchemeUnitsHeirVertical(g, zones, chartBounds, heirBounds) : new ArrayList();
            if (p.getHideOverflow()) {
                g.setClip(null);
            }
        }
        if (foreground && p.includeMaScale()) {
            PanelIGDScheme.drawBoundaryAges(g, cp, p, boundaryAges, chartBounds.x + chartBounds.width, x, y, bp, vertical, block);
        }
        if (p.key()) {
            PanelIGDScheme.drawKeyColumn(g, cp, p, vertical, colHasData, bp, block, x, y, background, foreground, panelWidth);
        }
        return renderedObjects;
    }

    private static void sortZones(List<UnitZone> zones, SBGraphics g, ChartProperties cp, PanelIGDSchemeProperties p) {
        Collections.sort(zones, new Comparator<UnitZone>(){

            @Override
            public int compare(UnitZone a, UnitZone b) {
                int result = Float.compare(a.rect.x, b.rect.x);
                result = result != 0 ? result : Float.compare(a.rect.y, b.rect.y);
                result = result != 0 ? result : a.name.toUpperCase().compareTo(b.name.toUpperCase());
                return result;
            }
        });
    }

    private static boolean shouldExpandZone(UnitZone z, SBGraphics g, ChartProperties cp, PanelIGDSchemeProperties p) {
        float minimumPossibleFontSize = cp.getFontSize(p.fontSize) - 1.5f;
        SBFont f = new SBFont(g.getFont().getName(), g.getFont().getStyle(), minimumPossibleFontSize);
        TextSettings ts = new TextSettings(HorizontalAlignment.Centre, VerticalAlignment.Middle, TextDirection.Horizontal, f);
        DimensionF textSize = g.getTextMeasurer().calculateTextDimensions(z.name, ts);
        boolean doesntFitInZone = z.rect.height - 1.0f < textSize.getHeight() || z.rect.width - 1.0f < textSize.getWidth();
        boolean willFitInExpandedZone = textSize.getHeight() < PanelIGDScheme.calculateExpandedZoneHeight(textSize.getHeight()) && textSize.getWidth() < z.rect.width - 1.0f - 2.0f;
        return doesntFitInZone && willFitInExpandedZone;
    }

    private static float drawUnitZone(SBGraphics g, UnitZone z, boolean foreground, boolean background, float lastX, ChartProperties cp, PanelIGDSchemeProperties p) {
        GeneralPath path = null;
        Rectangle2D.Float stringRect = null;
        Point2D.Float[] points = null;
        boolean expandZone = false;
        if (PanelIGDScheme.shouldExpandZone(z, g, cp, p)) {
            expandZone = true;
            float minimumPossibleFontSize = cp.getFontSize(p.fontSize) - 1.5f;
            SBFont f = new SBFont(g.getFont().getName(), g.getFont().getStyle(), minimumPossibleFontSize);
            float lineHeight = g.getTextMeasurer().calculateHorizontalLineHeight(f);
            float expandedHeight = PanelIGDScheme.calculateExpandedZoneHeight(lineHeight);
            float verticalPadding = (float)((double)(expandedHeight - z.rect.height) / 2.0);
            points = new Point2D.Float[]{new Point2D.Float(z.rect.x, z.rect.y), new Point2D.Float(z.rect.x + 1.0f, z.rect.y - verticalPadding), new Point2D.Float(z.rect.x + z.rect.width - 1.0f, z.rect.y - verticalPadding), new Point2D.Float(z.rect.x + z.rect.width, z.rect.y), new Point2D.Float(z.rect.x + z.rect.width, z.rect.y + z.rect.height), new Point2D.Float(z.rect.x + z.rect.width - 1.0f, z.rect.y + z.rect.height + verticalPadding), new Point2D.Float(z.rect.x + 1.0f, z.rect.y + z.rect.height + verticalPadding), new Point2D.Float(z.rect.x, z.rect.y + z.rect.height)};
            stringRect = z.labelArea != null ? new Rectangle2D.Float(z.labelArea.x + 1.0f, z.labelArea.y - verticalPadding, z.labelArea.width - 2.0f, z.labelArea.height + 2.0f * verticalPadding) : new Rectangle2D.Float(z.rect.x + 1.0f, z.rect.y - verticalPadding, z.rect.width - 2.0f, z.rect.height + 2.0f * verticalPadding);
        } else {
            points = new Point2D.Float[]{new Point2D.Float(z.rect.x, z.rect.y), new Point2D.Float(z.rect.x + z.rect.width, z.rect.y), new Point2D.Float(z.rect.x + z.rect.width, z.rect.y + z.rect.height), new Point2D.Float(z.rect.x, z.rect.y + z.rect.height)};
            stringRect = z.labelArea != null ? new Rectangle2D.Float(z.labelArea.x, z.labelArea.y, z.labelArea.width, z.labelArea.height) : new Rectangle2D.Float(z.rect.x, z.rect.y, z.rect.width, z.rect.height);
        }
        if (background) {
            g.setColor(z.background);
            g.fillRect(z.rect.x, z.rect.y, z.rect.width, z.rect.height);
            if (z.drawInterval) {
                float boxWid = p.columnWidth / 10.0f;
                g.setColor(Color.RED);
                g.fillRect(z.rect.x + z.rect.width - boxWid - 0.15f, z.rect.y, boxWid, z.rect.height);
            }
        }
        if (foreground) {
            if (expandZone) {
                path = SBGraphics.createGeneralPath(points[0].x, points[0].y);
                for (int i = 1; i < points.length; ++i) {
                    SBGraphics.appendLine(path, points[i].x, points[i].y);
                }
                path.closePath();
                g.fillShape(path, z.background);
            }
            g.setColor(cp.foreground);
            g.setStroke(0.2f);
            for (int i = 0; i < points.length - 1; ++i) {
                g.drawLine(new Line2D.Float(points[i], points[i + 1]));
            }
            g.drawLine(new Line2D.Float(points[points.length - 1], points[0]));
            if (z.drawInterval) {
                float boxWid = p.columnWidth / 10.0f;
                g.setColor(cp.foreground);
                g.setStroke(0.1f);
                g.drawRect(z.rect.x + z.rect.width - boxWid - 0.15f, z.rect.y, boxWid, z.rect.height);
            }
            PanelIGDScheme.drawZoneString(g, z.name, stringRect, cp, p, z.background);
        }
        lastX = Math.max(lastX, z.rect.x + z.rect.width);
        return lastX;
    }

    private static float calculateExpandedZoneHeight(float lineHeight) {
        return lineHeight + 1.0f + 0.1f;
    }

    private static List<UnitZone> buildAgeZones(List<IGDUnitBase> igdUnits, float panelWidth, SchemeBlock block, PanelIGDSchemeProperties p, float x, float y, boolean vertical, BlockProperties bp, boolean[] colHasData) throws SBException {
        List wellList = null;
        if (block.getWell() != null) {
            WellInterp wellInterp = block.getWell().getInterp(block.getInterpID());
            try {
                block.getWell().loadInterp(wellInterp);
            }
            catch (SQLException ex) {
                Logger.getLogger(PanelIGDScheme.class.getName()).log(Level.SEVERE, null, ex);
            }
            wellList = wellInterp.getIGDList(p.getScheme().getIGDType(), p.getScheme().getID());
        }
        ArrayList<UnitZone> zones = new ArrayList<UnitZone>();
        for (IGDUnitBase unit : igdUnits) {
            if (!unit.hasAges()) continue;
            double uAge = unit.getUage();
            double lAge = unit.getLage();
            if (unit instanceof LithostratUnit) {
                uAge = ((LithostratUnit)unit).getAge(p.lithostratIsWest ? 0 : 1);
                lAge = ((LithostratUnit)unit).getAge(p.lithostratIsWest ? 3 : 2);
            }
            if (!((float)lAge > block.getAgeLimit(true)) || !((float)uAge < block.getAgeLimit(false)) || !PanelIGDScheme.plotHier(unit.getHier() - 1, colHasData, p)) continue;
            float hierIndent = PanelIGDScheme.getHierIndent(p, panelWidth, unit, colHasData);
            UnitZone zone = new UnitZone();
            zone.rect = vertical ? PanelIGDScheme.getVerticalAgeRect(uAge, lAge, x, y, unit, hierIndent, block, bp, p, colHasData) : PanelIGDScheme.getHorizontalAgeRect(uAge, lAge, x, y, unit, hierIndent, bp, p, colHasData);
            zone.background = unit.getColour();
            if (!p.colours) {
                zone.background = Color.WHITE;
            } else if (!p.spanEmptyHiers && unit instanceof Chron && ((Chron)unit).getHier() < IGDIntervalZone.getNHier((int)26, (boolean)true)) {
                zone.background = Color.WHITE;
            }
            zone.name = p.useAbrs() ? (unit instanceof Chron ? (unit.getHier() > 1 ? "" : unit.getName()) : (unit.getAbr() != null && !unit.getAbr().isEmpty() ? unit.getAbr() : unit.getName())) : unit.getName();
            zone.drawInterval = false;
            if (vertical && wellList != null && p.showWellIntervals) {
                for (IGDIntervalZone intervalZone : wellList) {
                    if (intervalZone.getUppZone() != unit.getUnitID() && intervalZone.getLowZone() != unit.getUnitID()) continue;
                    zone.drawInterval = true;
                    break;
                }
            }
            if (p.spanEmptyHiers()) {
                float tw = p.hierWidth(unit.getHier() - 1);
                DoubleRange thisAgeRange = new DoubleRange(lAge, uAge);
                block4: for (int h = unit.getHier() + 1; h <= p.getMaxHier(); ++h) {
                    if (!PanelIGDScheme.plotHier(h - 1, colHasData, p)) continue;
                    for (IGDUnit comp : p.getScheme().getUnitsX()) {
                        DoubleRange compRange;
                        if (!comp.hasAges() || comp.getHier() != h || !thisAgeRange.overlapsThisRange(compRange = new DoubleRange(comp.getLage().doubleValue(), comp.getUage().doubleValue()))) continue;
                        break block4;
                    }
                    tw += p.hierWidth(h - 1);
                }
                zone.labelArea = new Rectangle2D.Float(zone.rect.x, zone.rect.y, vertical ? tw : zone.rect.width, vertical ? zone.rect.height : tw);
            }
            zones.add(zone);
        }
        return zones;
    }

    private static List<SchemeUnitRenderingInfo> buildAgeZones2(List<IGDUnitBase> igdUnits, SchemeBlock block, PanelIGDSchemeProperties p, float x, float y, boolean vertical, BlockProperties bp, boolean[] colHasData) throws SBException {
        List wellIntervals = null;
        if (block.getWell() != null) {
            WellInterp wellInterp = block.getWell().getInterp(block.getInterpID());
            try {
                block.getWell().loadInterp(wellInterp);
            }
            catch (SQLException ex) {
                Logger.getLogger(PanelIGDScheme.class.getName()).log(Level.SEVERE, null, ex);
            }
            switch (p.getScheme().getIGDType()) {
                case 25: 
                case 26: {
                    break;
                }
                default: {
                    wellIntervals = wellInterp.getIGDList(p.getScheme().getIGDType(), p.getScheme().getID());
                }
            }
        }
        ArrayList<SchemeUnitRenderingInfo> unitsToRender = new ArrayList<SchemeUnitRenderingInfo>();
        ScaleConverter scaleConverter = block.getScaleConverter(block.getWell());
        double minScaleAge = scaleConverter.convert(block.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN), block.getProp().getScaleType(), BlockProperties.ScaleType.AGE);
        double maxScaleAge = scaleConverter.convert(block.getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX), block.getProp().getScaleType(), BlockProperties.ScaleType.AGE);
        for (IGDUnitBase unit : igdUnits) {
            FloatRange range;
            if (!unit.hasAges() || !PanelIGDScheme.plotHier(unit.getHier() - 1, colHasData, p)) continue;
            double uAge = unit.getUage();
            double lAge = unit.getLage();
            if (unit instanceof LithostratUnit) {
                uAge = ((LithostratUnit)unit).getAge(p.lithostratIsWest ? 0 : 1);
                lAge = ((LithostratUnit)unit).getAge(p.lithostratIsWest ? 3 : 2);
            }
            if (!scaleConverter.isWithinPlottableRange(uAge, lAge, BlockProperties.ScaleType.AGE)) continue;
            uAge = Math.max(uAge, minScaleAge);
            lAge = Math.min(lAge, maxScaleAge);
            if (vertical) {
                float uAgeYPos = y + block.scale(uAge, BlockProperties.ScaleType.AGE, scaleConverter);
                float lAgeYPos = y + block.scale(lAge, BlockProperties.ScaleType.AGE, scaleConverter);
                range = new FloatRange(uAgeYPos, lAgeYPos);
            } else {
                float x2;
                float maxW = PanelIGDScheme.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp);
                float x1 = PanelIGDScheme.getXPos((float)uAge, bp);
                if (x1 > (x2 = PanelIGDScheme.getXPos((float)lAge, bp))) {
                    float temp = x1;
                    x1 = x2;
                    x2 = temp;
                }
                if (x1 < 0.0f) {
                    x1 = 0.0f;
                }
                if (x2 > maxW) {
                    x2 = maxW;
                }
                range = new FloatRange(x + x1, x + x2);
            }
            Color background = unit.getColour();
            if (!p.colours) {
                background = Color.WHITE;
            } else if (!p.spanEmptyHiers && unit instanceof Chron && ((Chron)unit).getHier() < IGDIntervalZone.getNHier((int)26, (boolean)true)) {
                background = Color.WHITE;
            }
            Object name = p.useAbrs() ? (unit instanceof Chron ? (unit.getHier() > 1 ? "" : unit.getName()) : (unit.getAbr() != null && !unit.getAbr().isEmpty() ? unit.getAbr() : unit.getName())) : unit.getName();
            if (unit instanceof IGDUnit) {
                IGDUnit igdUnit = (IGDUnit)unit;
                if (p.plotComments() && igdUnit.getComments() != null && !igdUnit.getComments().isEmpty()) {
                    name = (String)name + "\n" + igdUnit.getComments();
                }
            }
            boolean drawInterval = false;
            if (vertical && wellIntervals != null && p.showWellIntervals) {
                for (IGDIntervalZone intervalZone : wellIntervals) {
                    if (intervalZone.getUppZone() != unit.getUnitID() && intervalZone.getLowZone() != unit.getUnitID()) continue;
                    drawInterval = true;
                    break;
                }
            }
            unitsToRender.add(new SchemeUnitRenderingInfo(range, unit.getHier(), (String)name, background, drawInterval, unit));
        }
        return unitsToRender;
    }

    private static void drawKeyColumn(SBGraphics g, ChartProperties cp, final PanelIGDSchemeProperties p, boolean vertical, boolean[] colHasData, BlockProperties bp, SchemeBlock block, float x, float y, boolean background, boolean foreground, float panelWidth) {
        float maxW = 0.0f;
        if (!vertical) {
            maxW = PanelIGDScheme.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp);
        }
        if (p.key()) {
            float boxWidth;
            float boxHeight;
            float xpos;
            List unitsX = p.getScheme().getUnitsX();
            Comparator<IGDUnit> comparator = new Comparator<IGDUnit>(){

                @Override
                public int compare(IGDUnit o1, IGDUnit o2) {
                    if (p.useAbrs()) {
                        return o1.getAbr().compareTo(o2.getAbr());
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(unitsX, comparator);
            ListIterator lit = unitsX.listIterator();
            while (lit.hasNext()) {
                IGDUnit u = (IGDUnit)lit.next();
                if (!PanelIGDScheme.plotHier(u.getHier() - 1, colHasData, p)) {
                    lit.remove();
                    continue;
                }
                if (u.hasAges() && !(u.getLage() < (double)bp.getMin()) && !(u.getUage() > (double)bp.getMax())) continue;
                lit.remove();
            }
            float ypos = y;
            float fontSize = cp.getFontSizePanel();
            if (vertical) {
                xpos = x + panelWidth - p.getKeyWidth();
                boxHeight = Math.min(fontSize * 2.0f, (block.scale(y + bp.getMax(), BlockProperties.ScaleType.AGE) - block.scale(y + bp.getMin(), BlockProperties.ScaleType.AGE)) / (float)unitsX.size());
                boxWidth = p.getKeyWidth();
            } else {
                xpos = x;
                boxWidth = Math.min(fontSize * 2.0f, maxW / (float)unitsX.size());
                boxHeight = p.getKeyWidth();
            }
            for (IGDUnit unit : unitsX) {
                if (background) {
                    g.setColor(unit.getColour());
                    g.fillRect(xpos, ypos, boxWidth, boxHeight);
                }
                if (foreground) {
                    g.setColor(cp.foreground);
                    g.drawRect(xpos, ypos, boxWidth, boxHeight);
                    Object s = p.useAbrs() ? unit.getAbr() : unit.getName();
                    s = (String)s + " " + SB.roundToSignificantFigures((double)unit.getUage(), (int)4) + " - " + SB.roundToSignificantFigures((double)unit.getLage(), (int)4);
                    if (ColourUtils.isSimilarColour((Color)unit.getColour(), (Color)cp.foreground)) {
                        g.setColor(cp.background);
                    }
                    PanelIGDScheme.drawString(g, (String)s, xpos + 0.5f, ypos + 0.5f, boxWidth - 1.0f, boxHeight - 1.0f, cp.font, 0, fontSize);
                    if (!g.getColor().equals(cp.foreground)) {
                        g.setColor(cp.foreground);
                    }
                }
                if (vertical) {
                    ypos += boxHeight;
                    continue;
                }
                xpos += boxWidth;
            }
        }
    }

    private static TreeSet<BoundaryAge> getBoundaryAges(SchemeBlock block, List<IGDUnitBase> igdUnits) {
        TreeSet<BoundaryAge> boundaryAges = new TreeSet<BoundaryAge>();
        for (IGDUnitBase unit : igdUnits) {
            if (!unit.hasAges()) continue;
            IGDUnit u = null;
            if (unit instanceof IGDUnit) {
                u = (IGDUnit)unit;
            }
            if ((u == null || !u.isAgeDerived(true) || u.getAgePercent(true) == 0 || u.getAgePercent(true) == 100 || u.getConfidence(true) == Confidence.CONFIDENT) && unit.getUage() >= (double)block.getAgeLimit(true) && unit.getUage() <= (double)block.getAgeLimit(false)) {
                boundaryAges.add(new BoundaryAge(unit.getUage().floatValue(), u != null && u.isAgeDerived(true)));
            }
            if (u != null && u.isAgeDerived(false) && u.getAgePercent(false) != 0 && u.getAgePercent(false) != 100 && u.getConfidence(false) != Confidence.CONFIDENT || !(unit.getLage() >= (double)block.getAgeLimit(true)) || !(unit.getLage() <= (double)block.getAgeLimit(false))) continue;
            boundaryAges.add(new BoundaryAge(unit.getLage().floatValue(), u != null && u.isAgeDerived(false)));
        }
        return boundaryAges;
    }

    static float drawBoundaryAges(SBGraphics g, ChartProperties cp, PanelIGDSchemeProperties p, TreeSet<BoundaryAge> boundaryAges, float lastX, float x, float y, BlockProperties bp, boolean vertical, SchemeBlock block) {
        float maxW = 0.0f;
        if (!vertical) {
            maxW = PanelIGDScheme.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp);
        }
        g.setFont(cp.font, 0, cp.getFontSizeSmall());
        if (p.includeMaScale() && !boundaryAges.isEmpty()) {
            LinkedList<BoundaryAge> toBeRemoved = new LinkedList<BoundaryAge>();
            Iterator<BoundaryAge> bndIt = boundaryAges.iterator();
            BoundaryAge last = null;
            while (bndIt.hasNext()) {
                BoundaryAge age = bndIt.next();
                if (last != null && (double)Math.abs(last.bndAge - age.bndAge) < 1.0E-6) {
                    if (age.derived) {
                        bndIt.remove();
                    } else {
                        toBeRemoved.add(last);
                    }
                    last = null;
                    continue;
                }
                last = age;
            }
            boundaryAges.removeAll(toBeRemoved);
            bndIt = boundaryAges.iterator();
            int i = 0;
            float[] agePosition = new float[boundaryAges.size()];
            String[] ageString = new String[boundaryAges.size()];
            while (bndIt.hasNext()) {
                BoundaryAge age = bndIt.next();
                Float yAge = Float.valueOf(age.bndAge);
                agePosition[i] = vertical ? y + bp.scaleAge(yAge.floatValue()) : x + PanelIGDScheme.getXPos(yAge.floatValue(), bp);
                ageString[i] = (age.derived ? "(" : "") + cp.ageFormat.toAgeString((double)yAge.floatValue(), 2, false) + (age.derived ? ")" : "");
                ++i;
            }
            float[] movedPositions = new float[agePosition.length];
            System.arraycopy(agePosition, 0, movedPositions, 0, agePosition.length);
            float hPosition = vertical ? y + block.scale(bp.getMin(), BlockProperties.ScaleType.AGE) + g.stringHeightSB() : x;
            float lPosition = vertical ? y + block.scale(bp.getMax(), BlockProperties.ScaleType.AGE) - g.stringHeightSB() : x + maxW;
            PanelIGDScheme.moveSamplePositions(boundaryAges.size(), movedPositions, cp.getFontSizeSmall(), hPosition, lPosition);
            float xLeft = lastX;
            for (int j = 0; j < agePosition.length; ++j) {
                if (vertical) {
                    g.drawLine(xLeft, agePosition[j], xLeft + 0.5f, agePosition[j]);
                    g.drawLine(xLeft + 0.5f, agePosition[j], xLeft + 1.0f, movedPositions[j]);
                    g.drawLine(xLeft + 1.0f, movedPositions[j], xLeft + 1.5f, movedPositions[j]);
                    g.drawString(ageString[j], xLeft + 1.7f, movedPositions[j] + g.stringHeightSB() / 2.0f);
                    continue;
                }
                float maBase = y + p.getMaWidth() + (p.key() ? p.getKeyWidth() : 0.0f);
                g.drawLine(agePosition[j], maBase, agePosition[j], maBase - 0.5f);
                g.drawLine(agePosition[j], maBase - 0.5f, movedPositions[j], maBase - 1.0f);
                g.drawLine(movedPositions[j], maBase - 1.0f, movedPositions[j], maBase - 1.5f);
                g.drawStringVertical(ageString[j], movedPositions[j] + g.stringHeightSB() / 2.0f, maBase - 2.0f);
            }
            lastX += p.getMaWidth();
            if (!vertical && !p.key()) {
                g.drawLine(x, y, x + maxW, y);
            }
        }
        return lastX;
    }

    static void drawZoneString(SBGraphics g, String name, Rectangle2D.Float stringRect, ChartProperties cp, PanelIGDSchemeProperties p, Color backgroundColor) {
        block6: {
            Rectangle2D.Float stringBox;
            block8: {
                block7: {
                    Color textColour = cp.foreground;
                    if (ColourUtils.isSimilarColour((Color)backgroundColor, (Color)cp.foreground)) {
                        textColour = cp.background;
                    }
                    g.setColor(textColour);
                    g.setFont(cp.font, 0, cp.getFontSizePanel());
                    if (name.isEmpty() || cp.key == null && !g.isVisible(stringRect.x, stringRect.y, stringRect.width, stringRect.height)) break block6;
                    g.setFontSize(cp.getFontSize(p.fontSize));
                    float pad = 0.5f;
                    stringBox = new Rectangle2D.Float(stringRect.x + 0.5f, stringRect.y + 0.5f, stringRect.width - 1.0f, stringRect.height - 1.0f);
                    if (g.drawStringBox(name, name, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 1, backgroundColor)) break block6;
                    if (name.indexOf(" ") <= 0) break block7;
                    g.setFontSize(cp.getFontSize(p.fontSize));
                    int spaceIndex = name.lastIndexOf(" ");
                    String splitName = name.substring(0, spaceIndex) + "\n" + name.substring(spaceIndex + 1);
                    if (g.drawStringBox(splitName, null, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 4, backgroundColor)) break block6;
                    g.setFontSize(cp.getFontSize(p.fontSize));
                    if (!g.drawStringBox(name, null, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 4, backgroundColor)) break block8;
                    break block6;
                }
                g.setFontSize(cp.getFontSize(p.fontSize));
                if (g.drawStringBox(name, null, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 4, backgroundColor)) break block6;
            }
            if (cp.getKeyData() != null) {
                int textNo = cp.getKeyData().putText(name);
                g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(textNo) : ""), stringBox.x, stringBox.y + stringBox.height / 2.0f + g.stringHeightSB() / 2.0f, stringBox.width, 0, true);
            }
        }
    }

    static Rectangle2D.Float getVerticalAgeRect(double uAge, double lAge, float x, float y, IGDUnitBase unit, float hierIndent, SchemeBlock block, BlockProperties bp, PanelIGDSchemeProperties p, boolean[] colHasData) {
        Rectangle2D.Float rect = new Rectangle2D.Float();
        rect.x = x + hierIndent + 0.01f;
        rect.y = y + block.scale((float)Math.max(uAge, (double)bp.getMin()), BlockProperties.ScaleType.AGE);
        float lowerAge = y + block.scale((float)Math.min(lAge, (double)bp.getMax()), BlockProperties.ScaleType.AGE);
        rect.height = lowerAge - rect.y;
        rect.width = p.spanEmptyHiers() ? p.getColumnsWidth(colHasData) - hierIndent - 0.02f : p.hierWidth(unit.getHier() - 1) - 0.02f;
        return rect;
    }

    static Rectangle2D.Float getHorizontalAgeRect(double uAge, double lAge, float x, float y, IGDUnitBase unit, float hierIndent, BlockProperties bp, PanelIGDSchemeProperties p, boolean[] colHasData) {
        float x2;
        Rectangle2D.Float rect = new Rectangle2D.Float();
        float maxW = PanelIGDScheme.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp);
        float x1 = PanelIGDScheme.getXPos((float)uAge, bp);
        if (x1 > (x2 = PanelIGDScheme.getXPos((float)lAge, bp))) {
            float temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (x1 < 0.0f) {
            x1 = 0.0f;
        }
        if (x2 > maxW) {
            x2 = maxW;
        }
        rect.x = x + x1;
        rect.width = x2 - x1;
        rect.y = y + hierIndent + (p.key() ? p.getKeyWidth() : 0.0f) + (p.includeMaScale() ? p.getMaWidth() : 0.0f);
        rect.height = p.spanEmptyHiers() ? p.getColumnsWidth(colHasData) - hierIndent : p.hierWidth(unit.getHier() - 1);
        return rect;
    }

    static float getHierIndent(PanelIGDSchemeProperties p, float panelWidth, IGDUnitBase unit, boolean[] colHasData) {
        float hierIndent = p.lithostratIsWest ? 0.0f : panelWidth - p.hierWidth(unit.getHier() - 1);
        for (int i = 0; i < unit.getHier() - 1; ++i) {
            if (!PanelIGDScheme.plotHier(i, colHasData, p)) continue;
            if (p.lithostratIsWest) {
                hierIndent += p.hierWidth(i);
                continue;
            }
            hierIndent -= p.hierWidth(i);
        }
        return hierIndent;
    }

    static float drawUnitsAgeOld(SBGraphics g, float x, float ytop, BlockProperties bp, ChartProperties cp, Chart.Mode mode, boolean vertical, boolean foreground, boolean background, SchemeBlock block, final PanelIGDSchemeProperties p, float panelWidth, boolean[] colHasData) throws SQLException, SBException {
        float maxW;
        float lastX;
        float y;
        block50: {
            y = mode != null ? ytop + PanelIGDScheme.getPanelHeaderHeight(cp, mode, block) : ytop;
            lastX = x;
            maxW = 0.0f;
            if (!vertical) {
                maxW = PanelIGDScheme.getXPos(bp.getAgeLeftToRight() ? bp.getMax() : bp.getMin(), bp);
            }
            g.setColor(cp.foreground);
            g.setFont(cp.font, 0, cp.getFontSizePanel());
            class BoundaryAge
            implements Comparable<BoundaryAge> {
                final float bndAge;
                final boolean derived;

                BoundaryAge(float bndAge, boolean derived) {
                    this.bndAge = bndAge;
                    this.derived = derived;
                }

                @Override
                public int compareTo(BoundaryAge comp) {
                    if ((double)Math.abs(this.bndAge - comp.bndAge) < 1.0E-6) {
                        if (this.derived != comp.derived) {
                            return this.derived ? 1 : -1;
                        }
                        return 0;
                    }
                    return Float.valueOf(this.bndAge).compareTo(Float.valueOf(comp.bndAge));
                }
            }
            TreeSet<BoundaryAge> boundaryAges = new TreeSet<BoundaryAge>();
            List wellList = null;
            if (block.getWell() != null) {
                WellInterp wellInterp = block.getWell().getInterp(block.getInterpID());
                wellList = wellInterp.getIGDList(p.getScheme().getIGDType(), p.getScheme().getID());
            }
            class UnitForeground {
                final IGDUnitBase unit;
                final Rectangle2D.Float stringRect;
                final /* synthetic */ PanelIGDSchemeProperties val$p;

                UnitForeground(IGDUnitBase stringRect, Rectangle2D.Float float_) {
                    this.val$p = float_;
                    this.unit = unit;
                    this.stringRect = stringRect;
                }

                Color getUnitColour() {
                    if (!this.val$p.colours) {
                        return Color.WHITE;
                    }
                    if (!this.val$p.spanEmptyHiers && this.unit instanceof Chron && ((Chron)this.unit).getHier() < IGDIntervalZone.getNHier((int)26, (boolean)true)) {
                        return Color.WHITE;
                    }
                    return this.unit.getColour();
                }
            }
            LinkedList<UnitForeground> foregrounds = new LinkedList<UnitForeground>();
            List igdUnits = p.getScheme().getUnitBases();
            Collections.sort(igdUnits, new Comparator<IGDUnitBase>(){

                @Override
                public int compare(IGDUnitBase a, IGDUnitBase b) {
                    int result = Integer.compare(a.getHier(), b.getHier());
                    result = result != 0 ? result : Double.compare(Optional.ofNullable(a.getUage()).orElse(0.0), Optional.ofNullable(b.getUage()).orElse(0.0));
                    result = result != 0 ? result : Double.compare(Optional.ofNullable(a.getLage()).orElse(0.0), Optional.ofNullable(b.getLage()).orElse(0.0));
                    result = result != 0 ? result : a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
                    return result;
                }
            });
            Iterator it = igdUnits.iterator();
            float totalWidth = p.getColumnsWidth(colHasData);
            while (it.hasNext()) {
                float w1;
                float h1;
                float yTop;
                float xLeft;
                IGDUnitBase unit = (IGDUnitBase)it.next();
                if (!unit.hasAges()) continue;
                double uAge = unit.getUage();
                double lAge = unit.getLage();
                if (unit instanceof LithostratUnit) {
                    uAge = ((LithostratUnit)unit).getAge(p.lithostratIsWest ? 0 : 1);
                    lAge = ((LithostratUnit)unit).getAge(p.lithostratIsWest ? 3 : 2);
                }
                if (Math.abs(uAge - lAge) < 0.001 || !((float)lAge > block.getAgeLimit(true)) || !((float)uAge < block.getAgeLimit(false)) || !PanelIGDScheme.plotHier(unit.getHier() - 1, colHasData, p)) continue;
                float hierIndent = p.lithostratIsWest ? 0.0f : panelWidth - p.hierWidth(unit.getHier() - 1);
                for (int i = 0; i < unit.getHier() - 1; ++i) {
                    if (!PanelIGDScheme.plotHier(i, colHasData, p)) continue;
                    if (p.lithostratIsWest) {
                        hierIndent += p.hierWidth(i);
                        continue;
                    }
                    hierIndent -= p.hierWidth(i);
                }
                if (vertical) {
                    xLeft = x + hierIndent;
                    yTop = y + block.scale((float)Math.max(uAge, (double)bp.getMin()), BlockProperties.ScaleType.AGE);
                    float yBot = y + block.scale((float)Math.min(lAge, (double)bp.getMax()), BlockProperties.ScaleType.AGE);
                    h1 = yBot - yTop;
                    w1 = p.spanEmptyHiers() ? totalWidth - hierIndent : p.hierWidth(unit.getHier() - 1);
                } else {
                    float x2;
                    float x1 = PanelIGDScheme.getXPos((float)uAge, bp);
                    if (x1 > (x2 = PanelIGDScheme.getXPos((float)lAge, bp))) {
                        float temp = x1;
                        x1 = x2;
                        x2 = temp;
                    }
                    if (x1 < 0.0f) {
                        x1 = 0.0f;
                    }
                    if (x2 > maxW) {
                        x2 = maxW;
                    }
                    w1 = x2 - x1;
                    xLeft = x1 + x;
                    yTop = y + hierIndent + (p.key() ? p.getKeyWidth() : 0.0f) + (p.includeMaScale() ? p.getMaWidth() : 0.0f);
                    h1 = p.spanEmptyHiers() ? totalWidth - hierIndent : p.hierWidth(unit.getHier() - 1);
                }
                float tw = p.hierWidth(unit.getHier() - 1);
                if (p.spanEmptyHiers()) {
                    block2: for (int h = unit.getHier() + 1; h <= p.getMaxHier(); ++h) {
                        if (!PanelIGDScheme.plotHier(h - 1, colHasData, p)) continue;
                        for (IGDUnit comp : p.getScheme().getUnitsX()) {
                            if (!comp.hasAges() || comp.getHier() != h || !(comp.getUage() >= uAge) || !(comp.getLage() <= lAge)) continue;
                            break block2;
                        }
                        tw += p.hierWidth(h - 1);
                    }
                }
                UnitForeground f = new UnitForeground(unit, new Rectangle2D.Float(xLeft, yTop, vertical ? tw : w1, vertical ? h1 : tw), p);
                foregrounds.add(f);
                if (background) {
                    g.setColor(f.getUnitColour());
                    g.fillRect(xLeft, yTop, w1, h1);
                }
                if (vertical && wellList != null && p.showWellIntervals) {
                    for (IGDIntervalZone zone : wellList) {
                        if (zone.getUppZone() != unit.getUnitID() && zone.getLowZone() != unit.getUnitID()) continue;
                        float xRight = xLeft + tw;
                        float boxWid = p.columnWidth / 10.0f;
                        if (background) {
                            g.setColor(Color.RED);
                            g.fillRect(xRight - boxWid - 0.15f, yTop, boxWid, h1);
                            g.setColor(cp.foreground);
                        }
                        if (!foreground) break;
                        g.drawRect(xRight - boxWid - 0.15f, yTop, boxWid, h1);
                        break;
                    }
                }
                IGDUnit u = null;
                if (unit instanceof IGDUnit) {
                    u = (IGDUnit)unit;
                }
                if ((u == null || !u.isAgeDerived(true) || u.getAgePercent(true) == 0 || u.getAgePercent(true) == 100 || u.getConfidence(true) == Confidence.CONFIDENT) && unit.hasAges() && unit.getUage() >= (double)block.getAgeLimit(true) && unit.getUage() <= (double)block.getAgeLimit(false)) {
                    boundaryAges.add(new BoundaryAge(unit.getUage().floatValue(), u != null && u.isAgeDerived(true)));
                }
                if ((u == null || !u.isAgeDerived(false) || u.getAgePercent(false) == 0 || u.getAgePercent(false) == 100 || u.getConfidence(false) == Confidence.CONFIDENT) && unit.hasAges() && unit.getLage() >= (double)block.getAgeLimit(true) && unit.getLage() <= (double)block.getAgeLimit(false)) {
                    boundaryAges.add(new BoundaryAge(unit.getLage().floatValue(), u != null && u.isAgeDerived(false)));
                }
                lastX = Math.max(lastX, xLeft + p.hierWidth(unit.getHier() - 1));
            }
            if (!foreground) break block50;
            g.setStroke(0.2f);
            for (UnitForeground f : foregrounds) {
                block51: {
                    Rectangle2D.Float stringBox;
                    String name;
                    block53: {
                        block52: {
                            if (ColourUtils.isSimilarColour((Color)f.getUnitColour(), (Color)cp.foreground)) {
                                g.setColor(cp.background);
                            } else {
                                g.setColor(cp.foreground);
                            }
                            name = p.useAbrs() ? (f.unit instanceof Chron ? (f.unit.getHier() > 1 ? "" : f.unit.getName()) : (f.unit.getAbr() != null && !f.unit.getAbr().isEmpty() ? f.unit.getAbr() : f.unit.getName())) : f.unit.getName();
                            if (name.isEmpty() || cp.key == null && !g.isVisible(f.stringRect.x, f.stringRect.y, f.stringRect.width, f.stringRect.height)) break block51;
                            g.setFontSize(cp.getFontSize(p.fontSize));
                            float pad = 0.5f;
                            stringBox = new Rectangle2D.Float(f.stringRect.x + 0.5f, f.stringRect.y + 0.5f, f.stringRect.width - 1.0f, f.stringRect.height - 1.0f);
                            if (g.drawStringBox(name, name, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 1, f.getUnitColour())) break block51;
                            if (name.indexOf(" ") <= 0) break block52;
                            g.setFontSize(cp.getFontSize(p.fontSize));
                            int spaceIndex = name.lastIndexOf(" ");
                            String splitName = name.substring(0, spaceIndex) + "\n" + name.substring(spaceIndex + 1);
                            if (!g.drawStringBox(splitName, null, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 4, f.getUnitColour())) break block53;
                            break block51;
                        }
                        if (g.drawStringBox(name, null, stringBox.x, stringBox.y, stringBox.width, stringBox.height, p.vertPref, true, 4, f.getUnitColour())) break block51;
                    }
                    if (cp.getKeyData() != null) {
                        int textNo = cp.getKeyData().putText(name);
                        g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(textNo) : ""), stringBox.x, stringBox.y + stringBox.height / 2.0f + g.stringHeightSB() / 2.0f, stringBox.width, 0, true);
                    }
                }
                if (!g.getColor().equals(cp.foreground)) {
                    g.setColor(cp.foreground);
                }
                g.setColor(cp.foreground);
                if (f.unit instanceof IGDUnit && (((IGDUnit)f.unit).getConfidence(true) != Confidence.CONFIDENT || ((IGDUnit)f.unit).getConfidence(false) != Confidence.CONFIDENT)) {
                    PanelIGDScheme.drawBoundary(((IGDUnit)f.unit).getConfidence(true), f.stringRect.x, f.stringRect.x + f.stringRect.width, f.stringRect.y, g, 0.15f);
                    PanelIGDScheme.drawBoundary(((IGDUnit)f.unit).getConfidence(false), f.stringRect.x, f.stringRect.x + f.stringRect.width, f.stringRect.y + f.stringRect.height, g, 0.15f);
                    g.drawLine(f.stringRect.x, f.stringRect.y, f.stringRect.x, f.stringRect.y + f.stringRect.height);
                    g.drawLine(f.stringRect.x + f.stringRect.width, f.stringRect.y, f.stringRect.x + f.stringRect.width, f.stringRect.y + f.stringRect.height);
                    continue;
                }
                g.drawRect(f.stringRect.x, f.stringRect.y, f.stringRect.width, f.stringRect.height);
            }
            g.setFont(cp.font, 0, cp.getFontSizeSmall());
            if (p.includeMaScale() && !boundaryAges.isEmpty()) {
                LinkedList<BoundaryAge> toBeRemoved = new LinkedList<BoundaryAge>();
                Iterator bndIt = boundaryAges.iterator();
                BoundaryAge last = null;
                while (bndIt.hasNext()) {
                    BoundaryAge age = (BoundaryAge)bndIt.next();
                    if (last != null && (double)Math.abs(last.bndAge - age.bndAge) < 1.0E-6) {
                        if (age.derived) {
                            bndIt.remove();
                        } else {
                            toBeRemoved.add(last);
                        }
                        last = null;
                        continue;
                    }
                    last = age;
                }
                boundaryAges.removeAll(toBeRemoved);
                bndIt = boundaryAges.iterator();
                int i = 0;
                float[] agePosition = new float[boundaryAges.size()];
                String[] ageString = new String[boundaryAges.size()];
                while (bndIt.hasNext()) {
                    BoundaryAge age = (BoundaryAge)bndIt.next();
                    Float yAge = Float.valueOf(age.bndAge);
                    agePosition[i] = vertical ? y + bp.scaleAge(yAge.floatValue()) : x + PanelIGDScheme.getXPos(yAge.floatValue(), bp);
                    ageString[i] = (age.derived ? "(" : "") + cp.ageFormat.toAgeString((double)yAge.floatValue(), 2, false) + (age.derived ? ")" : "");
                    ++i;
                }
                float[] movedPositions = new float[agePosition.length];
                System.arraycopy(agePosition, 0, movedPositions, 0, agePosition.length);
                float hPosition = vertical ? y + block.scale(bp.getMin(), BlockProperties.ScaleType.AGE) + g.stringHeightSB() : x;
                float lPosition = vertical ? y + block.scale(bp.getMax(), BlockProperties.ScaleType.AGE) - g.stringHeightSB() : x + maxW;
                PanelIGDScheme.moveSamplePositions(boundaryAges.size(), movedPositions, cp.getFontSizeSmall(), hPosition, lPosition);
                float xLeft = lastX;
                for (int j = 0; j < agePosition.length; ++j) {
                    if (vertical) {
                        g.drawLine(xLeft, agePosition[j], xLeft + 0.5f, agePosition[j]);
                        g.drawLine(xLeft + 0.5f, agePosition[j], xLeft + 1.0f, movedPositions[j]);
                        g.drawLine(xLeft + 1.0f, movedPositions[j], xLeft + 1.5f, movedPositions[j]);
                        g.drawString(ageString[j], xLeft + 1.7f, movedPositions[j] + g.stringHeightSB() / 2.0f);
                        continue;
                    }
                    float maBase = y + p.getMaWidth() + (p.key() ? p.getKeyWidth() : 0.0f);
                    g.drawLine(agePosition[j], maBase, agePosition[j], maBase - 0.5f);
                    g.drawLine(agePosition[j], maBase - 0.5f, movedPositions[j], maBase - 1.0f);
                    g.drawLine(movedPositions[j], maBase - 1.0f, movedPositions[j], maBase - 1.5f);
                    g.drawStringVertical(ageString[j], movedPositions[j] + g.stringHeightSB() / 2.0f, maBase - 2.0f);
                }
                lastX += p.getMaWidth();
                if (!vertical && !p.key()) {
                    g.drawLine(x, y, x + maxW, y);
                }
            }
        }
        if (p.key()) {
            float boxWidth;
            float boxHeight;
            float xpos;
            List unitsX = p.getScheme().getUnitsX();
            Comparator<IGDUnit> comparator = new Comparator<IGDUnit>(){

                @Override
                public int compare(IGDUnit o1, IGDUnit o2) {
                    if (p.useAbrs()) {
                        return o1.getAbr().compareTo(o2.getAbr());
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(unitsX, comparator);
            ListIterator lit = unitsX.listIterator();
            while (lit.hasNext()) {
                IGDUnit u = (IGDUnit)lit.next();
                if (!PanelIGDScheme.plotHier(u.getHier() - 1, colHasData, p)) {
                    lit.remove();
                    continue;
                }
                if (u.hasAges() && !(u.getLage() < (double)bp.getMin()) && !(u.getUage() > (double)bp.getMax())) continue;
                lit.remove();
            }
            float ypos = y;
            float fontSize = cp.getFontSizePanel();
            if (vertical) {
                xpos = x + panelWidth - p.getKeyWidth();
                boxHeight = Math.min(fontSize * 2.0f, (block.scale(y + bp.getMax(), BlockProperties.ScaleType.AGE) - block.scale(y + bp.getMin(), BlockProperties.ScaleType.AGE)) / (float)unitsX.size());
                boxWidth = p.getKeyWidth();
            } else {
                xpos = x;
                boxWidth = Math.min(fontSize * 2.0f, maxW / (float)unitsX.size());
                boxHeight = p.getKeyWidth();
            }
            for (IGDUnit unit : unitsX) {
                if (background) {
                    g.setColor(unit.getColour());
                    g.fillRect(xpos, ypos, boxWidth, boxHeight);
                }
                if (foreground) {
                    g.setColor(cp.foreground);
                    g.drawRect(xpos, ypos, boxWidth, boxHeight);
                    Object s = p.useAbrs() ? unit.getAbr() : unit.getName();
                    s = (String)s + " " + SB.roundToSignificantFigures((double)unit.getUage(), (int)4) + " - " + SB.roundToSignificantFigures((double)unit.getLage(), (int)4);
                    if (ColourUtils.isSimilarColour((Color)unit.getColour(), (Color)cp.foreground)) {
                        g.setColor(cp.background);
                    }
                    PanelIGDScheme.drawString(g, (String)s, xpos + 0.5f, ypos + 0.5f, boxWidth - 1.0f, boxHeight - 1.0f, cp.font, 0, fontSize);
                    if (!g.getColor().equals(cp.foreground)) {
                        g.setColor(cp.foreground);
                    }
                }
                if (vertical) {
                    ypos += boxHeight;
                    continue;
                }
                xpos += boxWidth;
            }
        }
        return lastX;
    }

    private float drawUnitsDepth(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) throws SQLException, SBException {
        if (this.block.getInterp() == null || this.block.getInterp().getLOC() == null) {
            return x;
        }
        ArrayList<SchemeUnitRenderingInfo> zones = new ArrayList<SchemeUnitRenderingInfo>();
        LinkedList[] points = new LinkedList[this.p.getMaxHier()];
        double minAge = this.block.getAgeLimit(true);
        double maxAge = this.block.getAgeLimit(false);
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            if (!this.p.plotHier(i)) continue;
            points[i] = new LinkedList();
        }
        for (IGDUnit unit : this.p.getScheme().getUnits()) {
            if (!this.p.plotHier(unit.getHier() - 1) || !unit.hasAges()) continue;
            LinkedList list = points[unit.getHier() - 1];
            if (unit.getUage() <= minAge && unit.getLage() >= maxAge) {
                list.add(new DepthPoint(this, Math.min(this.block.getInterp().getLOC().getMaxDepth(), (double)bp.getMax()), unit, null));
                continue;
            }
            boolean upperAge = true;
            for (double bndAge : new double[]{unit.getUage(), unit.getLage()}) {
                if (bndAge > minAge && bndAge < maxAge) {
                    Boolean ageIncreasing = null;
                    double[] depths = this.block.getInterp().getLOC().getDepths(bndAge);
                    if (depths == null) continue;
                    for (double depth : depths) {
                        if (depth < (double)bp.getMin() || depth > (double)bp.getMax()) continue;
                        ageIncreasing = ageIncreasing == null ? this.block.getInterp().getLOC().isAgeIncreasing(depth) : Boolean.valueOf(ageIncreasing == false);
                        DepthPoint point = null;
                        for (Object o : list) {
                            DepthPoint dp = (DepthPoint)o;
                            if (!(Math.abs(dp.depth - depth) < 1.0E-5)) continue;
                            point = dp;
                            break;
                        }
                        if (point == null) {
                            point = new DepthPoint(this, depth);
                            list.add(point);
                        }
                        if (upperAge) {
                            if (ageIncreasing.booleanValue()) {
                                point.setBelow(unit);
                                continue;
                            }
                            point.setAbove(unit);
                            continue;
                        }
                        if (ageIncreasing.booleanValue()) {
                            point.setAbove(unit);
                            continue;
                        }
                        point.setBelow(unit);
                    }
                }
                upperAge = !upperAge;
            }
        }
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            if (points[i] == null) continue;
            Collections.sort(points[i]);
        }
        float fontSize = cp.getFontSizePanel();
        g.setFontSize(fontSize);
        g.setColor(cp.foreground);
        float xpos = x;
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            double blockMinAge;
            LinkedList list = points[i];
            if (list == null) continue;
            if (list.isEmpty()) {
                xpos += this.p.hierWidth(i);
                continue;
            }
            if (((DepthPoint)list.getLast()).below != null) {
                DepthPoint depthPoint = new DepthPoint(this, Math.min(this.block.getInterp().getLOC().getMaxDepth(), (double)bp.getMax()), ((DepthPoint)list.getLast()).getBelow(), null);
                list.add(depthPoint);
            }
            float lastY = minAge > (blockMinAge = this.block.getInterp().getLOC().getAge(bp.getMin(), true)) ? y + this.block.scale((float)minAge, BlockProperties.ScaleType.AGE) : y + this.block.scale(bp.getMin(), bp.getScaleType());
            DepthPoint lastPoint = null;
            for (DepthPoint point : list) {
                float ypos = this.block.scale((float)point.depth, BlockProperties.ScaleType.MD) + y;
                if (point.getAbove() != null) {
                    Object name = this.p.useAbrs() && point.getAbove().getAbr() != null && !point.getAbove().getAbr().isEmpty() ? point.getAbove().getAbr() : point.getAbove().getName();
                    if (lastPoint != null && lastPoint.getBelow() != null && lastPoint.getBelow() != point.getAbove()) {
                        String addition = this.p.useAbrs() && lastPoint.getBelow().getAbr() != null && !lastPoint.getBelow().getAbr().isEmpty() ? lastPoint.getBelow().getAbr() : lastPoint.getBelow().getName();
                        name = addition + " - " + (String)name;
                    }
                    SchemeUnitRenderingInfo info = new SchemeUnitRenderingInfo(new FloatRange(lastY, ypos), i + 1, (String)name, point.getAbove().getColour(), (IGDUnitBase)point.getAbove());
                    zones.add(info);
                }
                lastY = ypos;
                lastPoint = point;
            }
            xpos += this.p.hierWidth(i);
        }
        SchemeUnitRenderer r = new SchemeUnitRenderer();
        FloatRange yRange = new FloatRange(y + this.block.scale(bp.getMin(), bp.getScaleType()), y + this.block.scale(bp.getMax(), bp.getScaleType()));
        HashMap<Integer, FloatRange> heirBounds = new HashMap<Integer, FloatRange>();
        float xStart = x;
        float xHighest = x;
        for (int i = 0; i < this.p.nHier(); ++i) {
            if (!this.p.plotHier(i) || !this.colHasData[i]) continue;
            float xEnd = xStart + this.p.hierWidth(i);
            heirBounds.put(i + 1, new FloatRange(xStart, xEnd));
            xStart = xEnd;
            xHighest = Math.max(xHighest, xEnd);
        }
        Rectangle2D.Float chartBounds = new Rectangle2D.Float(x, yRange.getMin(), xHighest - x, yRange.getSize());
        if (this.p.getHideOverflow()) {
            g.setClip(chartBounds.x, chartBounds.y, chartBounds.width, chartBounds.height);
        }
        r.getTextPrefs().setFont(new SBFont(g.getFont().getName(), 0, cp.getFontSize(this.p.fontSize)));
        r.getTextPrefs().setTruncationHandler(new CopyToLegendTruncationHandler(g.getTextMeasurer(), cp));
        r.setFallbackColour(cp.background);
        r.setSpanEmptyHiers(this.p.spanEmptyHiers);
        r.drawSchemeUnitsHeirVertical(g, zones, chartBounds, heirBounds);
        if (this.p.getHideOverflow()) {
            g.setClip(null);
        }
        return xpos;
    }

    @Override
    public float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        try {
            PanelIGDScheme.drawUnitsAge(g, x, y, bp, cp, null, false, true, true, this.block, this.p, this.getWidth(bp), this.colHasData);
        }
        catch (SQLException sql) {
            StackError.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        return this.getWidth(bp);
    }

    static boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            PanelIGDScheme.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return this.p.getScheme().toString();
    }

    private void drawColHeaders(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float total = 0.0f;
        float fontSize = cp.getFontSizeHeader();
        g.setFont(cp.font, 0, fontSize);
        for (int i = 0; i < this.p.getMaxHier(); ++i) {
            if (!this.plotHier(i)) continue;
            float xpos = x + total;
            g.drawStringVertical(IGDIntervalZone.getHierName((int)this.p.getScheme().getIGDType(), (int)(i + 1)), xpos, y + this.getPanelHeaderHeight(cp, mode) - fontSize, this.getMaxSubheaderStringHeight(cp), false, true, Float.valueOf(this.p.hierWidth(i)));
            total += this.p.hierWidth(i);
        }
    }

    private void drawSubheaders(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (mode == Chart.Mode.NO_HEADER) {
            return;
        }
        float fontSize = cp.getFontSize();
        g.setFont(cp.font, 0, fontSize);
        if (this.p.includeMaScale()) {
            g.drawStringVertical("Boundary ages (Ma)", x + this.p.getColumnsWidth(this.colHasData), y + this.getPanelHeaderHeight(cp, mode) - cp.getFontSizeHeader(), this.getMaxSubheaderStringHeight(cp), false, true, Float.valueOf(this.p.getMaWidth()));
        }
        if (this.p.key()) {
            g.drawStringVertical("Alphabetic Key", x + this.p.getColumnsWidth(this.colHasData) + (this.p.includeMaScale() ? this.p.getMaWidth() : 0.0f), y + this.getPanelHeaderHeight(cp, mode) - cp.getFontSizeHeader(), this.getMaxSubheaderStringHeight(cp), false, true, Float.valueOf(this.p.getKeyWidth()));
        }
    }

    @Override
    public float getWidth(BlockProperties bp) {
        if (this.refreshWidth) {
            this.width = this.calcWidth(bp);
            this.refreshWidth = false;
        }
        return this.width;
    }

    @Override
    public void setData(ChartProperties c, double[][] sections) {
        this.width = this.calcWidth(this.block.getProp());
        this.refreshWidth = false;
    }

    float calcWidth(BlockProperties bp) {
        this.setColHasData();
        float w = this.p.getColumnsWidth(this.colHasData);
        if (bp.getScaleType() == BlockProperties.ScaleType.AGE) {
            if (this.p.includeMaScale()) {
                w += this.p.getMaWidth();
            }
            if (this.p.key()) {
                w += this.p.getKeyWidth();
            }
        }
        if (w < 1.0f) {
            return this.p.columnWidth;
        }
        return w;
    }

    private boolean plotHier(int i) {
        return this.p.plotHier(i) && (this.colHasData == null || this.colHasData[i]);
    }

    private static boolean plotHier(int i, boolean[] colHasData, PanelIGDSchemeProperties p) {
        return p.plotHier(i) && (colHasData == null || colHasData[i]);
    }

    @Override
    public PanelIGDSchemeProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties p) {
        if (!(p instanceof PanelIGDSchemeProperties)) {
            throw new IllegalArgumentException("Wrong type of properties for PanelIGDScheme");
        }
        this.p = (PanelIGDSchemeProperties)p;
        this.refreshWidth = true;
    }

    static void drawBoundary(Confidence type, float leftX, float rightX, float ypos, SBGraphics g, float stroke) {
        switch (type) {
            case CONFIDENT: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case PROBABLE: {
                g.setDashStroke(stroke, 2.5f);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case POSSIBLE: {
                g.setDashStroke(stroke, 1.0f);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
        }
        g.setStroke(stroke);
    }

    @Override
    public Set<Integer> getVisibleSchemes(int igdType) {
        if (this.getScheme().getIGDType() == igdType) {
            return new HashSet<Integer>(Arrays.asList(this.getScheme().getID()));
        }
        return Collections.emptySet();
    }

    @Override
    public boolean drawsLines(CorrelationType corrType) {
        return true;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        for (boolean b : this.colHasData) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    static class BoundaryAge
    implements Comparable<BoundaryAge> {
        final float bndAge;
        final boolean derived;

        BoundaryAge(float bndAge, boolean derived) {
            this.bndAge = bndAge;
            this.derived = derived;
        }

        @Override
        public int compareTo(BoundaryAge comp) {
            if ((double)Math.abs(this.bndAge - comp.bndAge) < 1.0E-6) {
                if (this.derived != comp.derived) {
                    return this.derived ? 1 : -1;
                }
                return 0;
            }
            return Float.valueOf(this.bndAge).compareTo(Float.valueOf(comp.bndAge));
        }
    }

    class DepthPoint
    implements Comparable {
        double depth;
        private IGDUnit above;
        private IGDUnit below;

        DepthPoint(PanelIGDScheme this$0, double depth) {
            Objects.requireNonNull(this$0);
            this.depth = depth;
        }

        DepthPoint(PanelIGDScheme this$0, double depth, IGDUnit above, IGDUnit below) {
            Objects.requireNonNull(this$0);
            this.depth = depth;
            this.above = above;
            this.below = below;
        }

        void setAbove(IGDUnit above) throws SBException {
            this.above = above;
        }

        void setBelow(IGDUnit below) throws SBException {
            this.below = below;
        }

        IGDUnit getAbove() {
            return this.above;
        }

        IGDUnit getBelow() {
            return this.below;
        }

        public int compareTo(Object o) {
            DepthPoint comp = (DepthPoint)o;
            if (comp.depth < this.depth) {
                return 1;
            }
            if (comp.depth > this.depth) {
                return -1;
            }
            return 0;
        }
    }
}

