/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataSeries {
    public static final Color UNCOVERED_COLOUR = Color.WHITE;
    public static final Color UNSAMPLED_COLOUR = Color.LIGHT_GRAY;
    private static final Logger LOGGER = Logger.getLogger(DataSeries.class.getName());
    private final float totalDuration;
    private final Map<Integer, Float> durationPerWell = new HashMap<Integer, Float>();
    private final List<DataPoint> data = new LinkedList<DataPoint>();

    public DataSeries(float totalDuration) {
        this.totalDuration = totalDuration;
        this.data.add(new DataPoint(new DataPointHeader(DataPointHeader.UNCOVERED_ID, "Not covered", UNCOVERED_COLOUR)));
        this.data.add(new DataPoint(new DataPointHeader(DataPointHeader.UNSAMPLED_ID, "Unsampled", UNSAMPLED_COLOUR)));
    }

    public void setDurationForWell(int wellID, float duration) {
        if (wellID > 0) {
            this.durationPerWell.put(wellID, Float.valueOf(duration));
        }
    }

    public float getTotalDuration() {
        return this.totalDuration;
    }

    private DataPoint getDataPoint(DataPointHeader header) {
        return this.data.stream().filter(d -> d.header.equals(header)).findAny().orElseGet(() -> {
            DataPoint dp = new DataPoint(header);
            this.data.add(dp);
            return dp;
        });
    }

    public void addData(int wellID, int dataID, String label, Color colour, float duration) {
        this.addIncrementData(wellID, dataID, label, colour, duration);
    }

    public void addData(int wellID, String dataID, String label, Color colour, float duration) {
        this.addIncrementData(wellID, dataID, label, colour, duration);
    }

    private void addIncrementData(int wellID, Object dataID, String label, Color colour, float duration) {
        DataPoint dp = this.getDataPoint(new DataPointHeader(dataID, label, colour));
        dp.increment(wellID, duration);
    }

    private void setDataValue(int wellID, Object dataID, String label, Color colour, float duration) {
        DataPoint dp = this.getDataPoint(new DataPointHeader(dataID, label, colour));
        dp.set(wellID, duration);
    }

    public List<DataPointHeader> getDataHeaders() {
        return this.data.stream().map(dp -> dp.header).sorted().toList();
    }

    public Map<DataPointHeader, Float> getDataForWell(int wellID) {
        float totalDataDurationForWell = this.data.stream().filter(d -> !d.header.isUnsampled()).filter(d -> d.wellData.get(wellID) != null).map(d -> d.wellData.get(wellID)).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        float unsampledDuration = this.getDurationForWell(wellID) - totalDataDurationForWell;
        if (unsampledDuration > 0.0029f) {
            this.setDataValue(wellID, DataPointHeader.UNSAMPLED_ID, null, UNSAMPLED_COLOUR, unsampledDuration);
        }
        float uncoveredDuration = this.totalDuration - this.getDurationForWell(wellID);
        if (this.totalDuration > 0.0f && uncoveredDuration > 0.0029f) {
            this.setDataValue(wellID, DataPointHeader.UNCOVERED_ID, null, UNCOVERED_COLOUR, uncoveredDuration);
        }
        HashMap<DataPointHeader, Float> percentDataForWell = new HashMap<DataPointHeader, Float>();
        float sectionDuration = this.totalDuration > 0.0f ? this.totalDuration : this.getDurationForWell(wellID);
        this.data.forEach(d -> {
            float valueForWell = d.totalForWell(wellID).map(entryFloat -> Float.valueOf(entryFloat.floatValue() / sectionDuration * 100.0f)).orElse(Float.valueOf(0.0f)).floatValue();
            if (percentDataForWell.get(d.header) == null) {
                percentDataForWell.put(d.header, Float.valueOf(valueForWell));
            } else {
                LOGGER.log(Level.WARNING, "Warning: DataSeries percent data for well " + wellID + " would be overwritten by: {0}", Float.valueOf(valueForWell));
            }
        });
        return percentDataForWell;
    }

    float getDurationForWell(int wellID) {
        Float duration = this.durationPerWell.get(wellID);
        if (duration != null) {
            return duration.floatValue();
        }
        return this.totalDuration;
    }

    public static String hexColour(Color colour) {
        return (colour.getRed() > 0 ? Integer.toHexString(colour.getRed()) : "00") + (colour.getGreen() > 0 ? Integer.toHexString(colour.getGreen()) : "00") + (colour.getBlue() > 0 ? Integer.toHexString(colour.getBlue()) : "00");
    }

    private static class DataPoint {
        final DataPointHeader header;
        HashMap<Integer, Float> wellData = new HashMap();

        DataPoint(DataPointHeader header) {
            this.header = header;
        }

        void increment(int wellID, float duration) {
            this.wellData.merge(wellID, Float.valueOf(duration), Float::sum);
        }

        void set(int wellID, float duration) {
            this.wellData.put(wellID, Float.valueOf(duration));
        }

        Optional<Float> totalForWell(int wellID) {
            return Optional.ofNullable(this.wellData.get(wellID));
        }
    }

    public record DataPointHeader(Object id, String label, Color colour) implements Comparable<DataPointHeader>
    {
        public static Object UNCOVERED_ID = new Object();
        public static Object UNSAMPLED_ID = new Object();

        public String hexColour() {
            return DataSeries.hexColour(this.colour);
        }

        boolean isUnsampled() {
            return this.id == UNCOVERED_ID || this.id == UNSAMPLED_ID;
        }

        @Override
        public int compareTo(DataPointHeader o) {
            if (this.id == UNCOVERED_ID) {
                return 1;
            }
            if (o.id == UNCOVERED_ID) {
                return -1;
            }
            if (this.id == UNSAMPLED_ID) {
                return 1;
            }
            if (o.id == UNSAMPLED_ID) {
                return -1;
            }
            Object object = this.id;
            if (object instanceof Integer) {
                Integer numID = (Integer)object;
                object = o.id;
                if (object instanceof Integer) {
                    Integer oNumID = (Integer)object;
                    return -(oNumID - numID);
                }
            }
            return this.id.toString().compareTo(o.toString());
        }

        public String idString() {
            if (this.id == UNCOVERED_ID) {
                return "x";
            }
            if (this.id == UNSAMPLED_ID) {
                return "0";
            }
            return String.valueOf(this.id);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataPointHeader that = (DataPointHeader)o;
            if (that.id == UNCOVERED_ID && this.id != UNCOVERED_ID) {
                return false;
            }
            if (this.id == UNCOVERED_ID && that.id != UNCOVERED_ID) {
                return false;
            }
            if (that.id == UNSAMPLED_ID && this.id != UNSAMPLED_ID) {
                return false;
            }
            if (this.id == UNSAMPLED_ID && that.id != UNSAMPLED_ID) {
                return false;
            }
            return Objects.equals(this.id, that.id);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

