/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.util.ArrayList;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.SBLayerFactory;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class GraticuleLayer
extends SBLayerFactory {
    public GraticuleLayer(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc, block);
    }

    @Override
    public PanelProperties getProperties() {
        return null;
    }

    @Override
    public void setData(ChartProperties cp) {
    }

    @Override
    public String summaryString() {
        return null;
    }

    @Override
    public Layer createLayer(ChartProperties cp) {
        SimpleFeatureType trackFeatureType = this.createTrackFeatureType();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder lineFeatureBuilder = new SimpleFeatureBuilder(trackFeatureType);
        ArrayList<SimpleFeature> lineFeatures = new ArrayList<SimpleFeature>();
        int x1 = -180;
        int x2 = 180;
        int y1 = -91;
        int y2 = 91;
        int d = 5;
        for (int y = y1; y <= y2 + d; y += d) {
            for (int x = x1; x <= x2; x += d) {
                lineFeatures.add(GraticuleLayer.buildLineFeature(lineFeatureBuilder, geometryFactory, x, y, x + d, y));
            }
        }
        for (int x = x1; x <= x2 + d; x += d) {
            for (int y = y1; y <= y2; y += d) {
                lineFeatures.add(GraticuleLayer.buildLineFeature(lineFeatureBuilder, geometryFactory, x, y, x, y + d));
            }
        }
        SimpleFeatureCollection lineFeatureCollection = DataUtilities.collection(lineFeatures);
        Style lineStyle = SLD.createLineStyle((Color)Color.blue, (float)1.0f);
        FeatureLayer l = new FeatureLayer((FeatureCollection)lineFeatureCollection, lineStyle);
        return l;
    }

    public static SimpleFeature buildLineFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, double x1, double y1, double x2, double y2) {
        LineString line = geometryFactory.createLineString(new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)});
        featureBuilder.add((Object)line);
        return featureBuilder.buildFeature(null);
    }

    public SimpleFeatureType createTrackFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Track");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", LineString.class);
        return builder.buildFeatureType();
    }
}

