/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.model3.taxon.Taxon;
import java.awt.Color;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerPresenceAbsenceProperties;
import jsbchart.panel.spatial.SolidPointDataLayer;
import model3.SBEvent;
import model3.Well;
import model3.WellInterp;
import model3.exception.SuppressedSQLException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import util.SBException;

public class LayerPresenceAbsence
extends SolidPointDataLayer {
    private static final String FEATURE_ATTRIBUTE_NAME_PRESABS_COLOUR = "presabs_c";
    private LayerPresenceAbsenceProperties p;
    private Map<Integer, Boolean> wellData;

    public LayerPresenceAbsence(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerPresenceAbsenceProperties)template.getProperties() : new LayerPresenceAbsenceProperties();
    }

    @Override
    String getColourFeatureAttributeName() {
        return "presabs_c_" + this.p.getPresAbsDataType().name() + "_" + this.p.getItemStringValue();
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        boolean hasData;
        Color wellColour;
        if (this.wellData == null || this.wellData.get(well.getWellID()) == null) {
            wellColour = DataSeries.UNSAMPLED_COLOUR;
            hasData = false;
        } else {
            wellColour = this.p.getColour(this.wellData.get(well.getWellID()));
            hasData = true;
        }
        featureBuilder.set("has_data", (Object)hasData);
        featureBuilder.set(this.getColourFeatureAttributeName(), (Object)DataSeries.hexColour(wellColour));
    }

    @Override
    public void setData(ChartProperties cp) {
        this.wellData = new HashMap<Integer, Boolean>();
        this.getBlock().clearLegendForLayer(this.getTemplateID());
        if (this.p.getItem() == null) {
            return;
        }
        this.getBlock().getWellsWithLocation().forEach(well -> this.summariseWellData(this.wellData, (Well)well, cp));
        if (!this.wellData.isEmpty()) {
            this.getBlock().addLegendItem(this.getTemplateID(), this.p.getColour(true), String.valueOf(this.p.getItem()) + " present");
            this.getBlock().addLegendItem(this.getTemplateID(), this.p.getColour(false), String.valueOf(this.p.getItem()) + " absent");
        }
    }

    private void summariseWellData(Map<Integer, Boolean> wellData, Well well, ChartProperties cp) {
        Boolean presence;
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        double totalDuration = scaleConverter.getPlottableDurationAsMeasuredDepth();
        if (!(totalDuration > 0.0)) {
            return;
        }
        switch (this.p.getPresAbsDataType()) {
            default: {
                throw new MatchException(null, null);
            }
            case TAXON: {
                Boolean bl = this.computeTaxonPresence(well, scaleConverter);
                break;
            }
            case EVENT: {
                Boolean bl = presence = this.computeEventPresence(well, scaleConverter);
            }
        }
        if (presence != null) {
            wellData.put(well.getWellID(), presence);
        }
    }

    private Boolean computeTaxonPresence(Well well, ScaleConverter scaleConverter) {
        List analyses;
        try {
            analyses = well.getAnalyses(null, null, 0);
        }
        catch (SQLException sqlE) {
            throw SuppressedSQLException.withoutRollback((SQLException)sqlE);
        }
        catch (SBException sbe) {
            throw new RuntimeException(sbe);
        }
        if (!analyses.isEmpty() && this.p.getItem() instanceof Taxon) {
            Taxon taxon = (Taxon)this.p.getItem();
            return analyses.stream().filter(smpdtl -> scaleConverter.isWithinPlottableRange(smpdtl.getSample().getDepth())).flatMap(smpdtl -> smpdtl.getOccurUnsorted().stream()).anyMatch(taxonOcc -> taxonOcc.getSpecID() == taxon.getSpecID());
        }
        return null;
    }

    private Boolean computeEventPresence(Well well, ScaleConverter scaleConverter) {
        List events;
        try {
            WellInterp interp = well.getInterp(this.getLayerInterpID());
            events = interp.getEvents();
        }
        catch (SBException sbe) {
            throw new RuntimeException(sbe);
        }
        if (!events.isEmpty()) {
            SBEvent sbEvent = (SBEvent)this.p.getItem();
            return events.stream().filter(wellEvent -> scaleConverter.isWithinPlottableRange(wellEvent.getSample().getDepth())).anyMatch(wellEvent -> wellEvent.getEvent().getEvID() == sbEvent.getEvID() && wellEvent.getTypeObj() == this.p.getEventType());
        }
        return null;
    }

    @Override
    public LayerPresenceAbsenceProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerPresenceAbsenceProperties.class;
    }

    @Override
    public String summaryString() {
        StringBuilder s = new StringBuilder(this.p.getPresAbsDataType().toString());
        if (this.p.getItem() != null) {
            s.append(": ");
            s.append(switch (this.p.getPresAbsDataType()) {
                default -> throw new MatchException(null, null);
                case LayerPresenceAbsenceProperties.PresAbsDataType.TAXON -> this.p.getItem();
                case LayerPresenceAbsenceProperties.PresAbsDataType.EVENT -> ((SBEvent)this.p.getItem()).toString(this.p.getEventType(), true, false, false);
            });
        }
        return s.toString();
    }
}

