/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import jsbchart.panel.spatial.MapLabelAttribute;
import jsbchart.panel.spatial.MapLabelPanelPropertyItem;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeDataStoreException;
import jsbchart.panel.spatial.ShapeDataStoreProvider;
import org.geotools.api.data.DataStore;

public class LayerShapeProperties
extends BasicPanelProperties {
    private final PanelPropertyItem<SBShapeStore> shapeStore = PanelPropertyItem.nullable("Data source", SBShapeStore.class);
    private final PanelPropertyItem<String> featureTypeName = PanelPropertyItem.nullable("Feature type name", String.class);
    private final PanelPropertyItem<Color> lineColour = PanelPropertyItem.nullable("Line colour", LINE_COLOUR);
    private final PanelPropertyItem<Color> fillColour = PanelPropertyItem.nullable("Fill colour", FILL_COLOUR);
    private final PanelPropertyItem<Float> lineWidth = PanelPropertyItem.nonNullable("Line width", Float.valueOf(0.1f));
    private final PanelPropertyItem<Float> pointSize = PanelPropertyItem.nonNullable("Point size", Float.valueOf(5.0f));
    private final MapLabelPanelPropertyItem labelAttribute = new MapLabelPanelPropertyItem();
    private static final Color LINE_COLOUR = Color.BLACK;
    private static final Color FILL_COLOUR = Color.CYAN;
    public static final float OPACITY = 1.0f;

    public LayerShapeProperties(String props, SBShapeStore shapeStore) {
        super(PanelType.SHAPE);
        this.items.add(this.shapeStore);
        this.items.add(this.featureTypeName);
        this.items.add(this.lineColour);
        this.lineColour.setNullText("No line");
        this.items.add(this.fillColour);
        this.fillColour.setNullText("No fill");
        this.items.add(this.lineWidth);
        this.items.add(this.pointSize);
        this.items.add(this.labelAttribute);
        this.shapeStore.setValue(shapeStore);
        this.setValuesFromPropertiesString(props);
    }

    public LayerShapeProperties() {
        this(null, null);
    }

    public DataStore getDataStore() throws ShapeDataStoreException {
        if (this.shapeStore.getValue() == null) {
            return null;
        }
        return ShapeDataStoreProvider.getDataStore(this.shapeStore.getValue());
    }

    public boolean longitudeFirst() {
        if (this.shapeStore.getValue() != null) {
            return this.shapeStore.getValue().isLongitudeFirst();
        }
        return true;
    }

    public String getFeatureTypeName() {
        return this.featureTypeName.getValue();
    }

    public Color getLineColour() {
        return this.lineColour.getValue();
    }

    public Color getFillColour() {
        return this.fillColour.getValue();
    }

    public Float getLineWidth() {
        return this.lineWidth.getValue();
    }

    public Float getPointSize() {
        return this.pointSize.getValue();
    }

    public MapLabelAttribute getLabelAttribute() {
        return (MapLabelAttribute)this.labelAttribute.getValue();
    }

    @Override
    public int getShapeStoreID() {
        if (this.shapeStore.getValue() != null) {
            return this.shapeStore.getValue().getShapeStoreID();
        }
        return super.getShapeStoreID();
    }

    public String getShapeStoreName() {
        if (this.shapeStore.getValue() != null) {
            return this.shapeStore.getValue().getName();
        }
        return "no shape store";
    }

    public SBShapeStore getShapeStore() {
        return this.shapeStore.getValue();
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.items.get(nProp) == this.shapeStore && prop != null && prop.getClass() == SBShapeStore.SBShapeStoreWithFeatureTypeName.class) {
            SBShapeStore.SBShapeStoreWithFeatureTypeName shapeStoreWithFeatureTypeName = (SBShapeStore.SBShapeStoreWithFeatureTypeName)prop;
            boolean storeProp = this.setProperty(this.items.indexOf(this.shapeStore), shapeStoreWithFeatureTypeName.store);
            boolean featureTypeProp = this.setProperty(this.items.indexOf(this.featureTypeName), shapeStoreWithFeatureTypeName.getFeatureTypeName());
            return storeProp | featureTypeProp;
        }
        return super.setProperty(nProp, prop);
    }

    @Override
    public PanelProperties copy() {
        LayerShapeProperties p = new LayerShapeProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerShapeProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerShapeProperties rhs = (LayerShapeProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

