/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerTaxonProperties;
import jsbchart.panel.spatial.SBPointDataLayer;
import model3.AnalystHeader;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.Well;
import model3.exception.SuppressedSQLException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import util.SBException;

public class LayerTaxon
extends SBPointDataLayer {
    private static final String FEATURE_NAME_PREFIX = "tx_";
    private static final Logger LOGGER = Logger.getLogger(LayerTaxon.class.getName());
    private LayerTaxonProperties p;
    private DataSeries data;
    private final HashMap<Object, Object> keyData = new HashMap();

    public LayerTaxon(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerTaxonProperties)template.getProperties() : new LayerTaxonProperties();
    }

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
        if (this.data == null) {
            return;
        }
        this.data.getDataHeaders().forEach(dh -> builder.add(FEATURE_NAME_PREFIX + dh.idString(), Float.class));
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        if (this.data == null) {
            return;
        }
        Map<DataSeries.DataPointHeader, Float> dataForWell = this.data.getDataForWell(well.getWellID());
        dataForWell.forEach((header, value) -> {
            featureBuilder.set(FEATURE_NAME_PREFIX + header.idString(), value);
            if (!header.isUnsampled() && value.floatValue() > 0.0f) {
                featureBuilder.set("has_data", (Object)Boolean.TRUE);
            }
        });
    }

    @Override
    public void setData(ChartProperties cp) {
        float blockScaleDuration = 0.0f;
        if (this.getBlock().getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES) {
            blockScaleDuration = this.getBlock().getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX) - this.getBlock().getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN);
        }
        this.keyData.clear();
        this.getBlock().clearLegendForLayer(this.getTemplateID());
        this.data = new DataSeries(blockScaleDuration);
        this.getBlock().getWellsWithLocation().forEach(well -> this.summariseWellData(this.data, (Well)well, cp));
        if (this.p.group() == LayerTaxonProperties.Group.GROUP) {
            if (this.p.groupSet() != null) {
                try {
                    for (TxGroup group2 : this.p.groupSet().getGroups()) {
                        this.keyData.put(group2.getID(), group2);
                    }
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withoutRollback((SQLException)e);
                }
                if (cp.key == null || !cp.key.txGroups) {
                    this.keyData.values().stream().map(o -> (TxGroup)o).forEach(group -> this.getBlock().addLegendItem(this.getTemplateID(), group.getColour(), group.getName()));
                } else {
                    this.getBlock().addLegendItem(this.getTemplateID(), "Group set: " + this.p.groupSet().getName(), "(see chart key)");
                }
            } else {
                this.getBlock().addLegendItem(this.getTemplateID(), "Group set unspecified.", "");
                LOGGER.log(Level.WARNING, "Group set is null in LayerTaxon, when data grouped by groups");
            }
        } else if (this.p.group() == LayerTaxonProperties.Group.CAT) {
            if (cp.key == null || !cp.key.categories) {
                this.keyData.values().stream().map(o -> (Category)o).sorted(Comparator.comparing(Category::getMnemonic)).forEach(category -> this.getBlock().addLegendItem(this.getTemplateID(), category.getColour(), category.getMnemonic()));
            } else {
                this.getBlock().addLegendItem(this.getTemplateID(), "Categories", "(see chart key)");
            }
        } else if (this.p.group() == LayerTaxonProperties.Group.GENUS) {
            this.getBlock().addLegendItem(this.getTemplateID(), this.p.disc().getAdj() + " Genera", "colour coded taxa");
        }
    }

    private void summariseWellData(DataSeries ds, Well well, ChartProperties cp) {
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        ds.setDurationForWell(well.getWellID(), (float)scaleConverter.getPlottableDuration());
        try {
            LinkedList<Smpdtl> intervalAnalyses = new LinkedList<Smpdtl>();
            for (Smpdtl smpdtl : well.getAnalyses(this.p.disc(), null, 0)) {
                double sampleMD;
                if (!smpdtl.isAnalysed() || this.p.isExcludeBarren() && smpdtl.getBarren() || !scaleConverter.isWithinPlottableRange(sampleMD = well.getDepth(smpdtl.getSample(), cp.correctDepths, cp.correctCuttings))) continue;
                intervalAnalyses.add(smpdtl);
            }
            if (intervalAnalyses.isEmpty()) {
                return;
            }
            List<TaxonTrack> tracks = this.getTracks(intervalAnalyses);
            if (tracks.isEmpty()) {
                return;
            }
            double[][] normalisedAnalysisCounts = new double[tracks.size()][intervalAnalyses.size()];
            double[] normalisedCounts = new double[tracks.size()];
            int analyIndex = 0;
            for (Smpdtl smpdtl : intervalAnalyses) {
                AbundanceScheme abnScheme = null;
                AnalystHeader analyHdr = well.getAnalystHeader(smpdtl.getAnalystAbr(), this.p.disc().getChar(), smpdtl.getAnalyNo(), false);
                if (analyHdr != null && analyHdr.getAbnSchID() > 0) {
                    abnScheme = well.getDataModel().getAbundanceSchemeService().findAbundanceScheme(analyHdr.getAbnSchID()).orElse(null);
                }
                int[] trackTotals = new int[tracks.size()];
                for (int i = 0; i < tracks.size(); ++i) {
                    trackTotals[i] = this.getCountForTrack(tracks.get(i), smpdtl, abnScheme);
                }
                int analyTotal = Arrays.stream(trackTotals).sum();
                if (analyTotal > 0) {
                    for (int trackIndex = 0; trackIndex < trackTotals.length; ++trackIndex) {
                        normalisedAnalysisCounts[trackIndex][analyIndex] = (double)trackTotals[trackIndex] / (double)analyTotal;
                    }
                }
                ++analyIndex;
            }
            for (int i = 0; i < tracks.size(); ++i) {
                double intervalTrackTotal = Arrays.stream(normalisedAnalysisCounts[i]).sum();
                normalisedCounts[i] = intervalTrackTotal / (double)intervalAnalyses.size();
            }
            int groupIndex = 0;
            for (TaxonTrack track : tracks) {
                track.addData(ds, well.getWellID(), ds.getDurationForWell(well.getWellID()) * (float)normalisedCounts[groupIndex]);
                ++groupIndex;
            }
        }
        catch (SQLException | SBException sqlex) {
            sqlex.printStackTrace();
        }
    }

    private int getCountForTrack(TaxonTrack track, Smpdtl smpdtl, AbundanceScheme abn) throws SQLException {
        int groupTotal = 0;
        for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
            if (!track.isMember(occ.getTaxon()) || occ.getCaved() || occ.getReworked()) continue;
            groupTotal = (int)((double)groupTotal + occ.getDerivedCount(abn, smpdtl.getCoarse(), smpdtl.getMedium(), smpdtl.getFine()));
        }
        return groupTotal;
    }

    private List<TaxonTrack> getTracks(List<Smpdtl> intervalAnalyses) {
        return switch (this.p.group()) {
            default -> throw new MatchException(null, null);
            case LayerTaxonProperties.Group.GROUP -> this.getGroupTracks();
            case LayerTaxonProperties.Group.CAT -> this.getCategoryTracks(intervalAnalyses);
            case LayerTaxonProperties.Group.GENUS -> this.getGenusTracks(intervalAnalyses);
        };
    }

    private List<TaxonTrack> getGroupTracks() {
        if (this.p.groupSet() == null) {
            return Collections.emptyList();
        }
        LinkedList<TaxonTrack> list = new LinkedList<TaxonTrack>();
        try {
            this.p.groupSet().getGroups().forEach(g -> list.add(new TxGroupTrack(this, (TxGroup)g)));
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback((SQLException)e);
        }
        return list;
    }

    private List<TaxonTrack> getCategoryTracks(List<Smpdtl> intervalAnalyses) {
        HashMap<String, Category> catMap = new HashMap<String, Category>();
        for (Smpdtl smpdtl : intervalAnalyses) {
            for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                Category c = (Category)this.getBlock().getDb().getCategoryService().findCategory(occ.getTaxon().getCatMnem()).get();
                catMap.put(c.getMnemonic(), c);
            }
        }
        return catMap.values().stream().sorted(Comparator.comparing(Category::getMnemonic)).peek(cat -> this.keyData.put(cat.getMnemonic(), cat)).map(cat -> new CategoryTrack((Category)cat)).toList();
    }

    private List<TaxonTrack> getGenusTracks(List<Smpdtl> intervalAnalyses) {
        HashMap<Integer, Genus> genusMap = new HashMap<Integer, Genus>();
        for (Smpdtl smpdtl : intervalAnalyses) {
            for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                Genus g = (Genus)this.getBlock().getDb().getGenusService().findGenus(occ.getTaxon().getGenID()).get();
                genusMap.put(g.getGenID(), g);
            }
        }
        return genusMap.values().stream().peek(genus -> this.keyData.put(genus.getGenID(), genus)).map(genus -> new GenusTrack((Genus)genus)).toList();
    }

    @Override
    public int preferredSize() {
        return 1000;
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        if (this.data == null) {
            return Optional.empty();
        }
        StringBuilder uriBuilder = new StringBuilder("cht=p");
        uriBuilder.append("&chs=500x500");
        uriBuilder.append("&chd=t:");
        this.data.getDataHeaders().forEach(header -> uriBuilder.append("${tx_" + header.idString() + "},"));
        uriBuilder.delete(uriBuilder.length() - 1, uriBuilder.length());
        uriBuilder.append("&chco=").append(this.data.getDataHeaders().stream().map(DataSeries.DataPointHeader::hexColour).collect(Collectors.joining(",")));
        uriBuilder.append("&sb_chtprop_bg=").append(DataSeries.hexColour(cp.background));
        return Optional.of(uriBuilder.toString());
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerTaxonProperties.class;
    }

    @Override
    public String summaryString() {
        return switch (this.p.group()) {
            default -> throw new MatchException(null, null);
            case LayerTaxonProperties.Group.GROUP -> "Group set";
            case LayerTaxonProperties.Group.CAT -> "Categories";
            case LayerTaxonProperties.Group.GENUS -> "Genus";
        };
    }

    @Override
    public void putKeyData(ChartProperties cp) {
        if (cp.key == null) {
            return;
        }
        switch (this.p.group()) {
            case GROUP: {
                if (!cp.key.txGroups) {
                    return;
                }
                this.keyData.values().stream().map(o -> (TxGroup)o).forEach(txGroup -> cp.getKeyData().putTxGroup((TxGroup)txGroup));
                break;
            }
            case CAT: {
                if (!cp.key.categories) {
                    return;
                }
                this.keyData.values().stream().map(o -> (Category)o).forEach(category -> cp.getKeyData().putCategory((Category)category));
            }
        }
    }

    private static abstract class TaxonTrack<T> {
        private TaxonTrack() {
        }

        abstract boolean isMember(Taxon var1);

        abstract void addData(DataSeries var1, int var2, float var3);
    }

    private static class GenusTrack
    extends TaxonTrack<Genus> {
        final Genus genus;

        GenusTrack(Genus genus) {
            this.genus = genus;
        }

        @Override
        boolean isMember(Taxon taxon) {
            return taxon.getGenID() == this.genus.getGenID();
        }

        @Override
        void addData(DataSeries ds, int wellID, float duration) {
            ds.addData(wellID, DataSeries.hexColour(this.genus.getColour()), this.genus.toString(true), this.genus.getColour(), duration);
        }
    }

    private static class CategoryTrack
    extends TaxonTrack<Category> {
        final Category category;

        CategoryTrack(Category category) {
            this.category = category;
        }

        @Override
        boolean isMember(Taxon taxon) {
            return taxon.getCatMnem().equals(this.category.getMnemonic());
        }

        @Override
        void addData(DataSeries ds, int wellID, float duration) {
            ds.addData(wellID, this.category.getMnemonic(), this.category.getName(), this.category.getColour(), duration);
        }
    }

    private class TxGroupTrack
    extends TaxonTrack<TxGroup> {
        final TxGroup group;
        final /* synthetic */ LayerTaxon this$0;

        TxGroupTrack(LayerTaxon layerTaxon, TxGroup group) {
            LayerTaxon layerTaxon2 = layerTaxon;
            Objects.requireNonNull(layerTaxon2);
            this.this$0 = layerTaxon2;
            this.group = group;
        }

        @Override
        boolean isMember(Taxon taxon) {
            try {
                return this.group.isMember(taxon.getSpecID(), this.this$0.p.getSynSchID());
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback((SQLException)e);
            }
        }

        @Override
        void addData(DataSeries ds, int wellID, float duration) {
            ds.addData(wellID, this.group.getID(), this.group.getName(), this.group.getColour(), duration);
        }
    }
}

