/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.LayerWellLocationProperties;
import jsbchart.panel.spatial.SBPointDataLayer;
import jsbchart.util.GeotoolsUtils;
import model3.Well;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public class LayerWellLocation
extends SBPointDataLayer {
    private LayerWellLocationProperties p;

    public LayerWellLocation(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc == null ? new PanelOcc(template.getID()) : panelOcc, block);
        this.p = template != null ? (LayerWellLocationProperties)template.getProperties() : new LayerWellLocationProperties();
    }

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder builder) {
    }

    @Override
    public void setData(ChartProperties cp) {
    }

    @Override
    public Collection<Symbolizer> getDataNotSetSymbolizers(ChartProperties cp) {
        return List.of(this.createPointSymbolizer());
    }

    @Override
    public Collection<Symbolizer> getAllFeaturesSymbolizers(ChartProperties cp) {
        LinkedList<Symbolizer> symbolizers = new LinkedList<Symbolizer>();
        if (this.p.showLabels()) {
            symbolizers.add(this.createTextSymbolizer(cp));
        }
        if (this.p.showCorrelation()) {
            symbolizers.add(this.createLineSymbolizer(cp));
        }
        return symbolizers;
    }

    @Override
    public int preferredSize() {
        return -1;
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        return Optional.ofNullable(null);
    }

    private Symbolizer createPointSymbolizer() {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        PropertyName fillColour = this.p.pinColour() != null ? ff.literal((Object)this.p.pinColour()) : ff.property("well_c");
        Fill fill = sf.fill(null, (Expression)fillColour, (Expression)ff.literal(1.0));
        ArrayList<Mark> symbols = new ArrayList<Mark>();
        symbols.add(sf.mark((Expression)ff.literal((Object)"circle"), fill, null));
        Expression opacity = null;
        Literal size = ff.literal(10);
        Expression rotation = null;
        AnchorPoint anchor = null;
        Displacement displacement = null;
        Graphic wellGraphic = sf.graphic(symbols, opacity, (Expression)size, rotation, anchor, displacement);
        return sf.pointSymbolizer("point", (Expression)ff.property("the_geom"), null, null, wellGraphic);
    }

    private Symbolizer createLineSymbolizer(ChartProperties cp) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Stroke stroke = sf.getDefaultStroke();
        stroke.setWidth((Expression)ff.literal(0.5));
        stroke.setColor((Expression)ff.literal((Object)cp.foreground));
        return sf.createLineSymbolizer(stroke, "line_geom");
    }

    private Symbolizer createTextSymbolizer(ChartProperties cp) {
        String labelAttributeName = switch (this.p.getLabelType()) {
            default -> "well_name";
            case LayerWellLocationProperties.WellLabel.CODE -> "well_code";
            case LayerWellLocationProperties.WellLabel.ALT -> "well_alt_name";
            case LayerWellLocationProperties.WellLabel.NAMECODE -> "well_namecode";
            case LayerWellLocationProperties.WellLabel.NAMEALT -> "well_namealt";
        };
        int fontSize = Math.round(cp.getFontSize() / 0.3527f);
        return GeotoolsUtils.createTextSymbolizer(labelAttributeName, cp.foreground, cp.font, fontSize);
    }

    @Override
    public LayerWellLocationProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerWellLocationProperties.class;
    }

    @Override
    public String summaryString() {
        LinkedList<String> strings = new LinkedList<String>();
        strings.add(this.p.showLabels() ? "labels" : "no labels");
        strings.add(this.p.getLabelType().toString());
        return String.join((CharSequence)", ", strings);
    }
}

