/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;

public class LayerWellLocationProperties
extends BasicPanelProperties {
    private final PanelPropertyItem<Boolean> labels = PanelPropertyItem.nonNullable("Labels", true);
    private final PanelPropertyItem<WellLabel> labelType = PanelPropertyItem.nonNullable("Label type", WellLabel.NAME);
    private final PanelPropertyItem<Color> pinColour = PanelPropertyItem.nonNullable("Pin colour", Color.BLUE);
    private final PanelPropertyItem<Boolean> correlation = PanelPropertyItem.nonNullable("Connect chart wells", false);

    public LayerWellLocationProperties() {
        super(PanelType.PIN);
        this.items.add(this.labels);
        this.items.add(this.labelType);
        this.items.add(this.pinColour);
        this.items.add(this.correlation);
    }

    public LayerWellLocationProperties(String props) {
        super(PanelType.PIN);
        this.items.add(this.labels);
        this.items.add(this.labelType);
        this.items.add(this.pinColour);
        this.items.add(this.correlation);
        this.setValuesFromPropertiesString(props);
    }

    public void setPinColour(Color c) {
        this.pinColour.setValue(c);
    }

    public void setShowCorrelation(boolean value) {
        this.correlation.setValue(value);
    }

    public boolean showLabels() {
        return this.labels.getValue();
    }

    public boolean showCorrelation() {
        return this.correlation.getValue();
    }

    public WellLabel getLabelType() {
        return this.labelType.getValue();
    }

    public Color pinColour() {
        return this.pinColour.getValue();
    }

    @Override
    public boolean allowNull(int nProp) {
        return ((PanelPropertyItem)this.items.get(nProp)).isNullable();
    }

    @Override
    public PanelProperties copy() {
        LayerWellLocationProperties p = new LayerWellLocationProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerWellLocationProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerWellLocationProperties rhs = (LayerWellLocationProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static enum WellLabel {
        NAME("Well name"),
        CODE("Well code"),
        ALT("Alternate name"),
        NAMECODE("Name and code"),
        NAMEALT("Name and alternate");

        final String description;

        private WellLabel(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

