/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeDataStoreException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FileDataStoreFinder;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryType;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.util.Version;

public class ShapeDataStoreProvider {
    public static final String TEMP_DIR_NAME = "sbugs_shapefiles";
    private static final HashMap<String, DataStore> DATA = new HashMap();
    private static final Version VERSION = new Version("1.0.0");

    public static DataStore getDataStore(SBShapeStore shapeStore) throws ShapeDataStoreException {
        String key = ShapeDataStoreProvider.deriveStoreKey(shapeStore);
        if (DATA.containsKey(key)) {
            return DATA.get(key);
        }
        DataStore dataStore = ShapeDataStoreProvider.initDataStore(shapeStore);
        DATA.put(key, dataStore);
        return dataStore;
    }

    public static List<String> getFeatureTypeNames(SBShapeStore shapeStore) throws ShapeDataStoreException, IOException {
        DataStore dataStore = ShapeDataStoreProvider.getDataStore(shapeStore);
        return Arrays.asList(dataStore.getTypeNames());
    }

    public static DataStore testDataStore(SBShapeStore shapeStore) throws ShapeDataStoreException {
        return ShapeDataStoreProvider.initDataStore(shapeStore);
    }

    private static String deriveStoreKey(SBShapeStore shapeStore) {
        return shapeStore.getUrl();
    }

    private static DataStore initDataStore(SBShapeStore shapeStore) throws ShapeDataStoreException {
        switch (shapeStore.getStoreType()) {
            case WFS: {
                return ShapeDataStoreProvider.initWFSDataStore(shapeStore.getUrl());
            }
            case FILE: {
                return ShapeDataStoreProvider.initFileDataStore(shapeStore.getUrl());
            }
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static DataStore initWFSDataStore(String url) throws ShapeDataStoreException {
        try {
            URL wfsUrl = new URL(url);
            String getCapabilities = WFSDataStoreFactory.createGetCapabilitiesRequest((URL)wfsUrl, (Version)VERSION).toString();
            HashMap<String, Object> connectionParameters = new HashMap<String, Object>();
            connectionParameters.put(WFSDataStoreFactory.URL.key, getCapabilities);
            connectionParameters.put("WFSDataStoreFactory:TIMEOUT", 10000);
            WFSDataStoreFactory dsf = new WFSDataStoreFactory();
            return dsf.createDataStore(connectionParameters);
        }
        catch (IOException ioe) {
            throw new ShapeDataStoreException(ioe);
        }
    }

    private static DataStore initFileDataStore(String filename) throws ShapeDataStoreException {
        File file = ShapeDataStoreProvider.getFileFromShapeStoreURL(filename);
        try {
            return FileDataStoreFinder.getDataStore((File)file);
        }
        catch (IOException ioe) {
            throw new ShapeDataStoreException(ioe);
        }
    }

    public static File getFileFromShapeStoreURL(String shapeStoreURL) throws ShapeDataStoreException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempShapeFileDir = new File(tempDir, TEMP_DIR_NAME);
        if (!tempShapeFileDir.exists()) {
            throw new ShapeDataStoreException("Temporary shapefile directory not initialised");
        }
        File shapeFileDir = new File(tempShapeFileDir, shapeStoreURL);
        if (!shapeFileDir.exists()) {
            throw new ShapeDataStoreException("Temporary shapefile directory for shapefile '" + shapeStoreURL + "' not initialised");
        }
        File file = new File(shapeFileDir, shapeStoreURL + ".shp");
        if (!file.exists()) {
            throw new ShapeDataStoreException("Shapefile does not exist: " + file.getAbsolutePath());
        }
        return file;
    }

    public static List<String> getFeatureTypeAttributes(SBShapeStore shapeStore, String featureTypeName) throws ShapeDataStoreException, IOException {
        if (shapeStore == null || featureTypeName == null) {
            return null;
        }
        DataStore dataStore = ShapeDataStoreProvider.getDataStore(shapeStore);
        if (dataStore == null) {
            return null;
        }
        SimpleFeatureType sft = dataStore.getSchema(featureTypeName);
        if (sft == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeDescriptor ad : sft.getAttributeDescriptors()) {
            if (ad.getType() instanceof GeometryType) continue;
            names.add(ad.getName().getLocalPart());
        }
        Collections.sort(names);
        return names;
    }
}

