/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.util.Objects;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import jsbchart.panel.spatial.LayerWellLocationProperties;

public class SidetrackLayerProperties
extends BasicPanelProperties {
    private final PanelPropertyItem<Boolean> showLabels = PanelPropertyItem.nonNullable("Labels", true);
    private final PanelPropertyItem<LayerWellLocationProperties.WellLabel> labelType = PanelPropertyItem.nonNullable("Label type", LayerWellLocationProperties.WellLabel.NAME);
    private final PanelPropertyItem<Float> lineWidth = PanelPropertyItem.nonNullable("Line width", Float.valueOf(0.5f));

    public SidetrackLayerProperties() {
        super(PanelType.SIDETRACKLAYER);
        this.items.add(this.showLabels);
        this.items.add(this.labelType);
        this.items.add(this.lineWidth);
    }

    public SidetrackLayerProperties(String props) {
        super(PanelType.SIDETRACKLAYER);
        this.items.add(this.showLabels);
        this.items.add(this.labelType);
        this.items.add(this.lineWidth);
        this.setValuesFromPropertiesString(props);
    }

    public Boolean getShowLabels() {
        return this.showLabels.getValue();
    }

    public float getLineWidth() {
        return this.lineWidth.getValue().floatValue();
    }

    public LayerWellLocationProperties.WellLabel getLabelType() {
        return this.labelType.getValue();
    }

    public void setShowLabels(boolean b) {
        this.showLabels.setValue(b);
    }

    public void setLineWidth(float w) {
        this.lineWidth.setValue(Float.valueOf(w));
    }

    public void setLabelType(LayerWellLocationProperties.WellLabel value) {
        this.labelType.setValue(value);
    }

    @Override
    public PanelProperties copy() {
        SidetrackLayerProperties p = new SidetrackLayerProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties other) {
        if (!(other instanceof SidetrackLayerProperties)) {
            throw new IllegalArgumentException("SidetrackLayerProperties cannot copy " + String.valueOf(other));
        }
        SidetrackLayerProperties rhs = (SidetrackLayerProperties)other;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidetrackLayerProperties that = (SidetrackLayerProperties)o;
        return Objects.equals(this.showLabels.getValue(), that.showLabels.getValue()) && Objects.equals((Object)this.labelType.getValue(), (Object)that.labelType.getValue()) && Objects.equals(this.lineWidth.getValue(), that.lineWidth.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.showLabels.getValue(), this.lineWidth.getValue());
    }
}

