/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.tag;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.MapBlock;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.IZoomManager;
import jsbchart.data.ScaleConverter;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartPropertyChangedNotification;
import jsbchart.tag.ChartTagButton;
import jsbchart.tag.ChartTagButtonType;
import jsbchart.tag.ChartTagProperties;
import org.geotools.geometry.Position2D;
import util.MoveableRect;
import util.RectUtils;
import util.SimpleCoordinates;

public class ChartTag
extends MoveableRect {
    private static final Logger LOGGER = Logger.getLogger(ChartTag.class.getName());
    public static final float ACTIVE_AREA_SIZE = 5.0f;
    public static final float MAP_BLOCK_PADDING = 10.0f;
    private int order;
    private ChartBlockBase anchorBlock;
    private Float depth;
    private SimpleCoordinates coords;
    private Point2D.Float target;
    private Float targetDepth;
    private SimpleCoordinates targetCoords;
    private String text;
    private final ChartTagProperties properties;
    private boolean isActive = false;
    private boolean isSelected = false;

    public ChartTag(ChartBlockBase anchorBlock, int order, Rectangle2D.Float area, Float depth, SimpleCoordinates coords, Point2D.Float target, Float targetDepth, SimpleCoordinates targetCoords, String text, String props) {
        super(area);
        this.anchorBlock = anchorBlock;
        this.order = order;
        this.depth = depth;
        this.coords = coords;
        this.target = target;
        this.targetDepth = targetDepth;
        this.targetCoords = targetCoords;
        this.text = text;
        this.properties = new ChartTagProperties();
        this.properties.loadProperties(props);
    }

    public ChartTag(ChartBlockBase anchorBlock, int order, Rectangle2D.Float area, Float depth, SimpleCoordinates coords, Point2D.Float target, Float targetDepth, SimpleCoordinates targetCoords, String text, ChartProperties.FontSizeExtended selectedFontSize) {
        super(area);
        this.anchorBlock = anchorBlock;
        this.order = order;
        this.depth = depth;
        this.coords = coords;
        this.target = target;
        this.targetDepth = targetDepth;
        this.targetCoords = targetCoords;
        this.text = text;
        this.properties = new ChartTagProperties();
        this.properties.setFontSize(selectedFontSize);
    }

    public String getText() {
        return this.text;
    }

    public String getPropertiesString() {
        return this.properties.buildPropertiesString();
    }

    public Rectangle2D.Float getArea() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }

    public boolean hasTargetSet() {
        return this.target != null;
    }

    public Point2D.Float getTarget() {
        return this.target;
    }

    public Float getDepth() {
        return this.depth;
    }

    public Float getTargetDepth() {
        return this.targetDepth;
    }

    public ChartProperties.FontSizeExtended getFontSize() {
        return this.properties.getFontSize();
    }

    public ChartTagProperties getProperties() {
        return this.properties;
    }

    public ChartBlockBase getAnchorBlock() {
        return this.anchorBlock;
    }

    public SimpleCoordinates getCoords() {
        return this.coords;
    }

    public SimpleCoordinates getTargetCoords() {
        return this.targetCoords;
    }

    public int getOrder() {
        return this.order;
    }

    public Point2D.Float getPosition() {
        return new Point2D.Float(this.x, this.y);
    }

    public void clearCoords() {
        this.coords = null;
    }

    public void shiftXDirection(float ammount) {
        this.x += ammount;
        if (this.target != null) {
            this.target.x += ammount;
        }
    }

    public void updateYPosFromDepth(Chart c, Point2D.Float blockPosition) {
        LOGGER.log(Level.FINE, "updateYPosFromDepth, blockPosition = {0}, y (before update) = {1}", new Object[]{blockPosition, Float.valueOf(this.y)});
        if (this.anchorBlock == null) {
            return;
        }
        if (this.anchorBlock != null && this.anchorBlock instanceof WellBlock) {
            float panelPos;
            WellBlock wb = (WellBlock)this.anchorBlock;
            if (this.depth != null) {
                panelPos = this.calcPanelPosFromValue(wb, this.depth.floatValue());
                this.y = blockPosition.y + panelPos + wb.getHeaderHeight(c.getProperties());
            }
            if (this.targetDepth != null && this.target != null) {
                panelPos = this.calcPanelPosFromValue(wb, this.targetDepth.floatValue());
                this.target.y = blockPosition.y + panelPos + wb.getHeaderHeight(c.getProperties());
            }
        } else if (this.anchorBlock != null && this.anchorBlock instanceof MapBlock) {
            Point2D.Float pos;
            MapBlock mBlock = (MapBlock)this.anchorBlock;
            Rectangle2D.Float anchorBlockRect = this.getAnchorBlockRect(blockPosition, c.getProperties());
            if (this.coords != null && anchorBlockRect != null) {
                pos = mBlock.getMMPosFromLatLonRelativeToChartOrigin(this.coords.getLongitude(), this.coords.getLatitude());
                LOGGER.log(Level.CONFIG, "coords = {0}, pos = {1} ", new Object[]{this.coords, pos});
                if (pos != null) {
                    Rectangle2D.Float newArea = new Rectangle2D.Float(pos.x, pos.y, this.width, this.height);
                    boolean stillWithinAnchorBlock = newArea.intersects(anchorBlockRect);
                    if (stillWithinAnchorBlock) {
                        this.x = pos.x;
                        this.y = pos.y;
                    } else {
                        Point2D.Float posNextToAnchorBlock = RectUtils.moveRectNextToTarget((Rectangle2D.Float)anchorBlockRect, (Rectangle2D.Float)newArea, (float)10.0f);
                        this.x = posNextToAnchorBlock.x;
                        this.y = posNextToAnchorBlock.y;
                        LOGGER.log(Level.FINE, "updated pos, x = {0}, y = {1} coords {2}", new Object[]{Float.valueOf(this.x), Float.valueOf(this.y), this.coords});
                    }
                }
            }
            if (this.targetCoords != null && (pos = mBlock.getMMPositionFromLonLat(this.targetCoords.getLongitude(), this.targetCoords.getLatitude())) != null && this.target != null) {
                this.target.x = pos.x;
                this.target.y = pos.y;
                LOGGER.log(Level.FINE, "updated target pos, target.x = {0}, target.y = {1}", new Object[]{Float.valueOf(this.target.x), Float.valueOf(this.target.y)});
            }
            LOGGER.log(Level.CONFIG, "updateYPosFromDepth,  y (after update) = {0}", new Object[]{Float.valueOf(this.y)});
        }
    }

    public void updateDepthFromYPos(Chart c, Point2D.Float blockPosition) {
        LOGGER.log(Level.FINE, "updateDepthFromYPos, blockPosition = {0}", new Object[]{blockPosition});
        if (this.anchorBlock != null && this.anchorBlock instanceof WellBlock && c.getProperties() != null) {
            WellBlock wellBlock = (WellBlock)this.anchorBlock;
            float panelPos = this.y - blockPosition.y - wellBlock.getHeaderHeight(c.getProperties());
            this.depth = Float.valueOf(this.calcValueFromPanelPos(wellBlock, panelPos));
            if (this.target != null) {
                float targetPanelPos = this.target.y - blockPosition.y - wellBlock.getHeaderHeight(c.getProperties());
                this.targetDepth = Float.valueOf(this.calcValueFromPanelPos(wellBlock, targetPanelPos));
            }
        } else if (this.anchorBlock != null && this.anchorBlock instanceof MapBlock && c.getProperties() != null) {
            MapBlock mBlock = (MapBlock)this.anchorBlock;
            Position2D pos = mBlock.getWGS84FromMMRelativeToChart(this.x, this.y);
            Rectangle2D.Float anchorBlockRect = this.getAnchorBlockRect(blockPosition, c.getProperties());
            if (anchorBlockRect != null && this.intersects(anchorBlockRect)) {
                this.coords = new SimpleCoordinates((float)pos.y, (float)pos.x);
            }
            if (this.target != null) {
                Position2D targetPos = mBlock.getWGS84FromMMRelativeToChart(this.target.x, this.target.y);
                this.targetCoords = new SimpleCoordinates((float)targetPos.y, (float)targetPos.x);
            }
        } else {
            this.depth = null;
            this.targetDepth = null;
        }
    }

    private Rectangle2D.Float getAnchorBlockRect(Point2D.Float blockPosition, ChartProperties cp) {
        if (this.anchorBlock != null) {
            return new Rectangle2D.Float(blockPosition.x, blockPosition.y, this.anchorBlock.getWidth(cp), this.anchorBlock.getHeight());
        }
        return null;
    }

    private BlockProperties.ScaleType findOldScaleType(ChartEvent e) {
        ChartPropertyChangedNotification changeNotification;
        if (e != null && e.getArg() != null && e.getArg() instanceof ChartPropertyChangedNotification && (changeNotification = (ChartPropertyChangedNotification)e.getArg()).getOldPropertyValue() instanceof BlockProperties.ScaleType && changeNotification.getNewPropertyValue() instanceof BlockProperties.ScaleType) {
            BlockProperties.ScaleType oldScaleType = (BlockProperties.ScaleType)((Object)changeNotification.getOldPropertyValue());
            return oldScaleType;
        }
        return null;
    }

    public void updateDepthIfScaleTypeChanged(Chart c, ChartEvent e) {
        if (e == null || e.getSource() == null) {
            return;
        }
        BlockProperties.ScaleType oldScaleType = this.findOldScaleType(e);
        if (oldScaleType != null && this.anchorBlock != null && this.anchorBlock instanceof WellBlock) {
            WellBlock wb = (WellBlock)this.anchorBlock;
            if (e.getSource().equals(wb)) {
                if (this.depth != null) {
                    this.depth = Float.valueOf(this.convertValueFromOldType(wb, this.depth.floatValue(), oldScaleType));
                }
                if (this.targetDepth != null) {
                    this.targetDepth = Float.valueOf(this.convertValueFromOldType(wb, this.targetDepth.floatValue(), oldScaleType));
                }
            }
        }
    }

    private float convertValueFromOldType(WellBlock wb, float value, BlockProperties.ScaleType oldScaleType) {
        if (wb.getWell() == null) {
            return value;
        }
        ScaleConverter converter = wb.getScaleConverter();
        BlockProperties.ScaleType newScaleType = wb.getProp().getScaleType();
        double newValue = converter.convert(value, oldScaleType, newScaleType);
        return (float)newValue;
    }

    private float calcValueFromPanelPos(WellBlock wb, float panelPos) {
        if (wb.getProp().getScaleType() == BlockProperties.ScaleType.AGE) {
            float age = wb.getProp().getAge(panelPos);
            if (Float.isNaN(age)) {
                age = 0.0f;
            }
            return age;
        }
        return wb.getDepth(panelPos);
    }

    public float calcPanelPosFromValue(WellBlock wb, float depth) {
        float value = wb.scale(depth, wb.getProp().getScaleType());
        return value;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean value) {
        this.isActive = value;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setTarget(Point2D.Float target) {
        this.target = target;
    }

    public void setText(String text) {
        if (text.length() > 1400) {
            text = text.substring(0, 1400);
        }
        this.text = text;
    }

    public void setFontSize(ChartProperties.FontSizeExtended newFontSize) {
        this.properties.setFontSize(newFontSize);
    }

    public void setAnchorBlock(ChartBlockBase newBlock) {
        this.anchorBlock = newBlock;
    }

    public void setSelected(boolean value) {
        this.isSelected = value;
    }

    public void setOrder(int value) {
        this.order = value;
    }

    public Rectangle2D.Float getTargetArea() {
        if (this.target == null) {
            return null;
        }
        return new Rectangle2D.Float(this.target.x - 5.0f, this.target.y - 5.0f, 10.0f, 10.0f);
    }

    public List<ChartTagButton> getButtons(IZoomManager zm) {
        float xPos;
        float yPos;
        ChartTagButtonType type;
        int i;
        float buttonWidth;
        List<ChartTagButtonType> leftButtons = this.target == null ? Arrays.asList(ChartTagButtonType.ADD_POINTER) : Arrays.asList(ChartTagButtonType.REMOVE_POINTER);
        List<ChartTagButtonType> rightButtons = Arrays.asList(ChartTagButtonType.REMOVE_TAG);
        float buttonHeight = buttonWidth = zm.scalePixels(ChartTagButton.BUTTON_SIZE);
        float buttonPadding = zm.scalePixels(ChartTagButton.BUTTON_PADDING);
        int numButtons = leftButtons.size() + rightButtons.size();
        if (this.width < (float)numButtons * buttonWidth + (float)(numButtons - 1) * buttonPadding) {
            leftButtons = new ArrayList<ChartTagButtonType>(leftButtons);
            leftButtons.addAll(rightButtons);
            rightButtons = new ArrayList<ChartTagButtonType>();
        }
        ArrayList<ChartTagButton> buttons = new ArrayList<ChartTagButton>();
        for (i = 0; i < leftButtons.size(); ++i) {
            type = leftButtons.get(i);
            yPos = this.y - buttonHeight - buttonPadding;
            xPos = this.x + (buttonWidth + buttonPadding) * (float)i;
            buttons.add(new ChartTagButton(type, xPos, yPos, buttonWidth, buttonHeight));
        }
        for (i = 0; i < rightButtons.size(); ++i) {
            type = rightButtons.get(i);
            yPos = this.y - buttonHeight - buttonPadding;
            xPos = this.x + this.width - buttonWidth - (buttonWidth + buttonPadding) * (float)i;
            buttons.add(new ChartTagButton(type, xPos, yPos, buttonWidth, buttonHeight));
        }
        return buttons;
    }
}

