/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.tag;

import java.awt.Color;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.core.ChartProperties;
import util.ColourUtils;

public class ChartTagProperties {
    public static final Float LINE_WEIGHT_MIN = Float.valueOf(0.1f);
    public static final Float LINE_WEIGHT_MAX = Float.valueOf(5.0f);
    private static final Logger LOGGER = Logger.getLogger(ChartTagProperties.class.getName());
    private ChartProperties.FontSizeExtended fontSize = ChartProperties.FontSizeExtended.PANEL;
    private Color fillColour;
    private Color lineColour;
    private boolean fillBackground = true;
    private float lineWeight = 0.3f;
    private static final int PROP_FONT = 0;
    private static final int PROP_COLOUR_FILL = 1;
    private static final int PROP_COLOUR_LINE = 2;
    private static final int PROP_FILL = 3;
    private static final int PROP_WEIGHT = 4;

    public ChartProperties.FontSizeExtended getFontSize() {
        return this.fontSize;
    }

    public Color getFillColour() {
        return this.fillColour;
    }

    public void setFillColour(Color fillColour) {
        this.fillColour = fillColour;
    }

    public Color getLineColour() {
        return this.lineColour;
    }

    public void setLineColour(Color lineColour) {
        this.lineColour = lineColour;
    }

    public void setFontSize(ChartProperties.FontSizeExtended fontSize) {
        this.fontSize = fontSize;
    }

    public boolean getFillBackground() {
        return this.fillBackground;
    }

    public void setFillBackground(boolean fillBackground) {
        this.fillBackground = fillBackground;
    }

    public float getLineWeight() {
        return this.lineWeight;
    }

    public void setLineWeight(float lineWeight) {
        if (lineWeight < LINE_WEIGHT_MIN.floatValue()) {
            lineWeight = LINE_WEIGHT_MIN.floatValue();
        } else if (lineWeight > LINE_WEIGHT_MAX.floatValue()) {
            lineWeight = LINE_WEIGHT_MAX.floatValue();
        }
        this.lineWeight = lineWeight;
    }

    public void loadProperties(String properties) {
        String[] s = properties.split("\\|");
        block7: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.fontSize = this.getFontSizeFromString(s[i]);
                    continue block7;
                }
                case 1: {
                    this.fillColour = this.getColourFromString(s[i]);
                    continue block7;
                }
                case 2: {
                    this.lineColour = this.getColourFromString(s[i]);
                    continue block7;
                }
                case 3: {
                    this.fillBackground = Integer.parseInt(s[i]) == 1;
                    continue block7;
                }
                case 4: {
                    this.lineWeight = Float.parseFloat(s[i]);
                }
            }
        }
    }

    public String buildPropertiesString() {
        Object string = new String();
        String[] props = new String[]{this.fontSize.toString().toUpperCase(), ColourUtils.DBColourString((Color)this.fillColour, (boolean)true, (boolean)false), ColourUtils.DBColourString((Color)this.lineColour, (boolean)true, (boolean)false), "" + (this.fillBackground ? 1 : 0), "" + this.lineWeight};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    private ChartProperties.FontSizeExtended getFontSizeFromString(String s) {
        String trimmedString = s.trim().toUpperCase();
        for (ChartProperties.FontSizeExtended value : ChartProperties.FontSizeExtended.values()) {
            if (!trimmedString.equals(value.toString().toUpperCase())) continue;
            return value;
        }
        return ChartProperties.FontSizeExtended.PANEL;
    }

    private Color getColourFromString(String s) {
        if ("NULL".equals(s)) {
            return null;
        }
        try {
            return ColourUtils.getDBColour((String)s);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.INFO, "Error decoding chart tag colour: {0}", e.getMessage());
            return null;
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode((Object)this.fontSize);
        hash = 89 * hash + Objects.hashCode(this.fillColour);
        hash = 89 * hash + Objects.hashCode(this.lineColour);
        hash = 89 * hash + (this.fillBackground ? 1 : 0);
        hash = 89 * hash + Float.floatToIntBits(this.lineWeight);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartTagProperties other = (ChartTagProperties)obj;
        if (this.fillBackground != other.fillBackground) {
            return false;
        }
        if (Float.floatToIntBits(this.lineWeight) != Float.floatToIntBits(other.lineWeight)) {
            return false;
        }
        if (this.fontSize != other.fontSize) {
            return false;
        }
        if (!Objects.equals(this.fillColour, other.fillColour)) {
            return false;
        }
        return Objects.equals(this.lineColour, other.lineColour);
    }
}

