/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.tag;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import jsbchart.block.ChartBlockBase;
import jsbchart.core.Chart;
import jsbchart.tag.ChartTag;
import util.SimpleCoordinates;

public class ChartTagTemplate {
    private int chartId;
    private Integer blockNo;
    private int order;
    private float width;
    private float height;
    private float posX;
    private float posY;
    private Float posDepth;
    private Float posLat;
    private Float posLon;
    private Float targetX;
    private Float targetY;
    private Float targetDepth;
    private Float targetLat;
    private Float targetLon;
    private String text;
    private String properties;

    public ChartTagTemplate(int chartId, Integer blockNo, int order, float width, float height, float posX, float posY, Float posDepth, Float posLat, Float posLon, Float targetX, Float targetY, Float targetDepth, Float targetLat, Float targetLon, String text, String properties) {
        this.chartId = chartId;
        this.blockNo = blockNo;
        this.order = order;
        this.width = width;
        this.height = height;
        this.posX = posX;
        this.posY = posY;
        this.posDepth = posDepth;
        this.posLat = posLat;
        this.posLon = posLon;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetDepth = targetDepth;
        this.targetLat = targetLat;
        this.targetLon = targetLon;
        this.text = text;
        this.properties = properties;
    }

    public ChartTagTemplate(int chartId, ChartTag tag, Chart c) {
        this.chartId = chartId;
        this.blockNo = tag.getAnchorBlock() != null && c.getBlocks().contains(tag.getAnchorBlock()) ? Integer.valueOf(c.getBlocks().indexOf(tag.getAnchorBlock())) : null;
        this.order = tag.getOrder();
        this.width = tag.width;
        this.height = tag.height;
        this.posX = tag.x;
        this.posY = tag.y;
        this.posDepth = tag.getDepth();
        if (tag.getCoords() != null) {
            this.posLat = Float.valueOf(tag.getCoords().getLatitude());
            this.posLon = Float.valueOf(tag.getCoords().getLongitude());
        }
        if (tag.getTarget() != null) {
            this.targetX = Float.valueOf(tag.getTarget().x);
            this.targetY = Float.valueOf(tag.getTarget().y);
        }
        if (tag.getTargetDepth() != null) {
            this.targetDepth = tag.getTargetDepth();
        }
        if (tag.getTargetCoords() != null) {
            this.targetLat = Float.valueOf(tag.getTargetCoords().getLatitude());
            this.targetLon = Float.valueOf(tag.getTargetCoords().getLongitude());
        }
        this.text = tag.getText();
        this.properties = tag.getPropertiesString();
    }

    public ChartTag buildTag(Chart c) {
        ChartBlockBase b = null;
        if (this.blockNo != null && c.getBlocks() != null && c.getBlocks().size() > this.blockNo) {
            b = c.getBlocks().get(this.blockNo);
        }
        SimpleCoordinates tagCoords = null;
        if (this.posLat != null && this.posLon != null) {
            tagCoords = new SimpleCoordinates(this.posLat.floatValue(), this.posLon.floatValue());
        }
        Point2D.Float targetPoint = null;
        if (this.targetX != null && this.targetY != null) {
            targetPoint = new Point2D.Float(this.targetX.floatValue(), this.targetY.floatValue());
        }
        SimpleCoordinates targetCoords = null;
        if (this.targetLat != null && this.targetLon != null) {
            targetCoords = new SimpleCoordinates(this.targetLat.floatValue(), this.targetLon.floatValue());
        }
        return new ChartTag(b, this.order, new Rectangle2D.Float(this.posX, this.posY, this.width, this.height), this.posDepth, tagCoords, targetPoint, this.targetDepth, targetCoords, this.text, this.properties);
    }

    public int getChartId() {
        return this.chartId;
    }

    public Integer getBlockNo() {
        return this.blockNo;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public Float getPosDepth() {
        return this.posDepth;
    }

    public Float getPosLat() {
        return this.posLat;
    }

    public Float getPosLon() {
        return this.posLon;
    }

    public Float getTargetX() {
        return this.targetX;
    }

    public Float getTargetY() {
        return this.targetY;
    }

    public Float getTargetDepth() {
        return this.targetDepth;
    }

    public Float getTargetLat() {
        return this.targetLat;
    }

    public Float getTargetLon() {
        return this.targetLon;
    }

    public String getText() {
        return this.text;
    }

    public int getOrder() {
        return this.order;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setChartId(int chartId) {
        this.chartId = chartId;
    }

    public void setBlockNo(Integer blockNo) {
        this.blockNo = blockNo;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setPosX(float posX) {
        this.posX = posX;
    }

    public void setPosY(float posY) {
        this.posY = posY;
    }

    public void setPosDepth(Float posDepth) {
        this.posDepth = posDepth;
    }

    public void setPosLat(Float posLat) {
        this.posLat = posLat;
    }

    public void setPosLon(Float posLon) {
        this.posLon = posLon;
    }

    public void setTargetX(Float targetX) {
        this.targetX = targetX;
    }

    public void setTargetY(Float targetY) {
        this.targetY = targetY;
    }

    public void setTargetDepth(Float targetDepth) {
        this.targetDepth = targetDepth;
    }

    public void setTargetLat(Float targetLat) {
        this.targetLat = targetLat;
    }

    public void setTargetLon(Float targetLon) {
        this.targetLon = targetLon;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setOrder(int value) {
        this.order = value;
    }

    public ChartTagTemplate getCopy() {
        return new ChartTagTemplate(this.chartId, this.blockNo, this.order, this.width, this.height, this.posX, this.posY, this.posDepth, this.posLat, this.posLon, this.targetX, this.targetY, this.targetDepth, this.targetLat, this.targetLon, this.text, this.properties);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.chartId;
        hash = 97 * hash + Objects.hashCode(this.blockNo);
        hash = 97 * hash + this.order;
        hash = 97 * hash + Float.floatToIntBits(this.width);
        hash = 97 * hash + Float.floatToIntBits(this.height);
        hash = 97 * hash + Float.floatToIntBits(this.posX);
        hash = 97 * hash + Float.floatToIntBits(this.posY);
        hash = 97 * hash + Objects.hashCode(this.posDepth);
        hash = 97 * hash + Objects.hashCode(this.posLat);
        hash = 97 * hash + Objects.hashCode(this.posLon);
        hash = 97 * hash + Objects.hashCode(this.targetX);
        hash = 97 * hash + Objects.hashCode(this.targetY);
        hash = 97 * hash + Objects.hashCode(this.targetDepth);
        hash = 97 * hash + Objects.hashCode(this.targetLat);
        hash = 97 * hash + Objects.hashCode(this.targetLon);
        hash = 97 * hash + Objects.hashCode(this.text);
        hash = 97 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartTagTemplate other = (ChartTagTemplate)obj;
        if (this.chartId != other.chartId) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        if (Float.floatToIntBits(this.width) != Float.floatToIntBits(other.width)) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (Float.floatToIntBits(this.posX) != Float.floatToIntBits(other.posX)) {
            return false;
        }
        if (Float.floatToIntBits(this.posY) != Float.floatToIntBits(other.posY)) {
            return false;
        }
        if (!Objects.equals(this.text, other.text)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        if (!Objects.equals(this.blockNo, other.blockNo)) {
            return false;
        }
        if (!Objects.equals(this.posDepth, other.posDepth)) {
            return false;
        }
        if (!Objects.equals(this.posLat, other.posLat)) {
            return false;
        }
        if (!Objects.equals(this.posLon, other.posLon)) {
            return false;
        }
        if (!Objects.equals(this.targetX, other.targetX)) {
            return false;
        }
        if (!Objects.equals(this.targetY, other.targetY)) {
            return false;
        }
        if (!Objects.equals(this.targetDepth, other.targetDepth)) {
            return false;
        }
        if (!Objects.equals(this.targetLat, other.targetLat)) {
            return false;
        }
        return Objects.equals(this.targetLon, other.targetLon);
    }
}

