/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import jsbchart.core.ChartProperties;
import model3.TVDList;
import model3.WellHeader;

public class ChartDatumOffsetCalculator {
    public float calculateMDOffset(ChartProperties.ChartDatum chartDatum, WellHeader h) {
        switch (chartDatum) {
            case RT: {
                return -1.0f * h.getRTDepth();
            }
            case SL: {
                return -1.0f * h.getSLDepth();
            }
            case SB: {
                return -1.0f * h.getSBDepth();
            }
        }
        return 0.0f;
    }

    public float calculateTVDOffset(ChartProperties.ChartDatum chartDatum, WellHeader h, TVDList tvdList) {
        if (h == null || tvdList == null) {
            return 0.0f;
        }
        switch (chartDatum) {
            case RT: {
                return -1.0f * tvdList.getTVD((double)h.getRTDepth()).getTVDepth().floatValue();
            }
            case SL: {
                return -1.0f * tvdList.getTVD((double)h.getSLDepth()).getTVDepth().floatValue();
            }
            case SB: {
                return -1.0f * tvdList.getTVD((double)h.getSBDepth()).getTVDepth().floatValue();
            }
        }
        return 0.0f;
    }
}

