/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.image.ImageUtils;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.swing.ImageIcon;

public class ChartImage
implements ImageObserver {
    private ChartImageObserver observer;
    private Image image;
    private float origTop;
    private float movedTop;
    private Object object;
    private double depth;
    private float width = -1.0f;
    private float height = -1.0f;
    private float maxImageSizeMm;
    private ImageLoader imageLoader;
    private ImageRecord imageRecord;
    private SoftReference<Image> highResImage;

    public ChartImage(ImageIcon icon, float origTop, float width, float height) {
        this.origTop = origTop;
        this.width = width;
        this.height = height;
        this.setImage(icon);
    }

    public ChartImage(int imageSetID, float origTop, float maxImageSizeMm, ImageRecordService imageRecordService, ImageLoader imageLoader) {
        this.origTop = origTop;
        this.maxImageSizeMm = maxImageSizeMm;
        this.imageLoader = imageLoader;
        List imageRecords = imageRecordService.getImageRecords(imageSetID);
        if (!imageRecords.isEmpty()) {
            this.imageRecord = (ImageRecord)imageRecords.get(0);
            Image fullImage = imageLoader.getImage(this.imageRecord);
            if (fullImage != null) {
                fullImage.getWidth(this);
            } else {
                this.width = maxImageSizeMm;
                this.height = maxImageSizeMm;
            }
        }
    }

    public void setObserver(ChartImageObserver observer) {
        this.observer = observer;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x40) != 0) {
            return false;
        }
        if ((infoflags & 0x20) != 0) {
            float scale = 10.0f;
            if (this.image == null) {
                int w = img.getWidth(null);
                int h = img.getHeight(null);
                Dimension maxImageDimensions = new Dimension((int)(this.maxImageSizeMm * scale), (int)(this.maxImageSizeMm * scale));
                this.width = this.maxImageSizeMm;
                this.height = (float)h / ((float)w / this.maxImageSizeMm);
                if (w > maxImageDimensions.width) {
                    this.image = ImageUtils.buildResizedImage((Image)img, (int)maxImageDimensions.width, (int)maxImageDimensions.height);
                    this.image.getWidth(this);
                } else {
                    this.image = img;
                    if (this.observer != null) {
                        this.observer.imageLoaded();
                        this.observer = null;
                    }
                }
            } else if (this.observer != null) {
                this.observer.imageLoaded();
                this.observer = null;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    private void setImage(ImageIcon icon) {
        this.image = (float)icon.getIconWidth() > this.width * 100.0f || (float)icon.getIconHeight() > this.height * 100.0f ? icon.getImage().getScaledInstance((int)(this.width * 100.0f), (int)(this.height * 100.0f), 2) : icon.getImage();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public double getDepth() {
        return this.depth;
    }

    public float getOrigTop() {
        return this.origTop;
    }

    public Object getObject() {
        return this.object;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getImage(boolean requestHighResolution) {
        if (!requestHighResolution) {
            this.highResImage = null;
            return this.image;
        }
        if (this.highResImage != null && this.highResImage.get() != null) {
            if (this.highResImage.get().getWidth(null) > 0 && this.highResImage.get().getHeight(null) > 0) {
                return this.highResImage.get();
            }
        } else {
            this.loadHighResImage();
        }
        return this.image;
    }

    private void loadHighResImage() {
        if (this.image != null) {
            Image fullImage = this.imageLoader.getImage(this.imageRecord);
            Image scaledImage = fullImage.getScaledInstance((int)(this.width * 100.0f), -1, 2);
            this.highResImage = new SoftReference<Image>(scaledImage);
        }
    }

    public float getMovedTop() {
        return this.movedTop;
    }

    public void setMovedTop(float movedTop) {
        this.movedTop = movedTop;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setOrigTop(float origTop) {
        this.origTop = origTop;
    }

    public static interface ChartImageObserver
    extends ImageObserver {
        public void imageLoaded();

        public void setTotalImages(int var1);
    }
}

