/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import jsbchart.graphics.SBGraphics;

public class DrawingUtils {
    public static final float STD_BND_STROKE = 0.15f;
    public static final float BND_POSS_DASH = 1.0f;
    public static final float BND_PROB_DASH = 2.5f;

    private DrawingUtils() {
    }

    public static void drawBoundary(int type, float leftX, float rightX, float ypos, SBGraphics g, float stroke) {
        float h = 1.75f;
        switch (type) {
            case 3: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case 2: {
                g.setDashStroke(stroke, 2.5f);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case 1: {
                g.setDashStroke(stroke, 1.0f);
                g.drawLine(leftX, ypos, rightX, ypos);
                break;
            }
            case 4: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                g.appendUnconf(p, leftX, rightX, ypos, false, true, true, false);
                g.drawShape(p);
                break;
            }
            case 5: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                Shape s = g.appendUnconf(p, leftX, rightX, ypos, true, true, true, false);
                g.drawShape(p);
                g.fillShape(s, g.getColor());
                break;
            }
            case 6: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                float w1 = 0.8f;
                g.setStroke(stroke * 1.5f);
                g.drawLine(leftX + (rightX - leftX) / 2.0f, ypos, leftX + (rightX - leftX) / 2.0f, ypos - h);
                g.fillEllipse(leftX + (rightX - leftX) / 2.0f - w1 / 2.0f, ypos - h, w1, w1, g.getColor());
                g.setStroke(stroke);
                break;
            }
            case 7: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                float w2 = 0.8f;
                g.setStroke(stroke * 1.5f);
                g.drawLine(leftX + (rightX - leftX) / 2.0f, ypos, leftX + (rightX - leftX) / 2.0f, ypos - h);
                g.fillEllipse(leftX + (rightX - leftX) / 2.0f - w2 / 2.0f, ypos - h, w2, w2, g.getColor());
                Font font = g.getFont();
                g.setFont(font.getName(), font.getStyle(), 2.2f);
                g.drawString("?", leftX + (rightX - leftX) / 2.0f - 2.2f, ypos - 0.25f);
                g.setFont(font);
                g.setStroke(stroke);
                break;
            }
            case 8: {
                g.setStroke(stroke);
                g.drawLine(leftX, ypos, rightX, ypos);
                float w = 3.5f;
                float h1 = h * 0.4f;
                g.fillRect(leftX + (rightX - leftX) / 2.0f - w / 2.0f, ypos - h1, w, h1);
                break;
            }
        }
    }

    public static void drawUnconfBoundary(int type, float leftX, float rightX, float ypos, SBGraphics g, float stroke, boolean flatStart, boolean flatEnd, boolean forceUp) {
        switch (type) {
            case 4: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                g.appendUnconf(p, leftX, rightX, ypos, false, flatStart, flatEnd, forceUp);
                g.drawShape(p);
                break;
            }
            case 5: {
                g.setStroke(stroke);
                GeneralPath p = SBGraphics.createGeneralPath(leftX, ypos);
                Shape s = g.appendUnconf(p, leftX, rightX, ypos, true, flatStart, flatEnd, forceUp);
                g.drawShape(p);
                g.fillShape(s, g.getColor());
                break;
            }
        }
    }

    public static void drawSampleSymbol(String sampleString, SBGraphics g, float xposi, float ypos1) {
        switch (sampleString) {
            case "CO": {
                g.fillEllipse(xposi + 2.0f, ypos1 - 0.5f, 1.0f, 1.0f, g.getColor());
                break;
            }
            case "SC": {
                float[] xp = new float[]{xposi, xposi + 3.0f, xposi + 3.0f};
                float[] yp = new float[]{ypos1, ypos1 - 0.5f, ypos1 + 0.5f};
                g.fillPolygon(xp, yp, 3);
            }
        }
    }
}

