/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.LocalName;
import org.geotools.api.util.NameSpace;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Utilities;

public abstract class GenericName
implements org.geotools.api.util.GenericName,
Serializable {
    private static final long serialVersionUID = 8685047583179337259L;
    public static final char DEFAULT_SEPARATOR = ':';
    private transient NameSpace namespace;

    protected GenericName() {
    }

    static CharSequence validate(CharSequence name) {
        return name == null || name instanceof InternationalString ? name : name.toString();
    }

    @Override
    public NameSpace scope() {
        if (this.namespace == null) {
            this.namespace = new NameSpace(){

                @Override
                public boolean isGlobal() {
                    return false;
                }

                @Override
                public org.geotools.api.util.GenericName name() {
                    return GenericName.this.getInternalScope();
                }
            };
        }
        return this.namespace;
    }

    protected abstract org.geotools.api.util.GenericName getInternalScope();

    @Override
    public int depth() {
        return this.getParsedNames().size();
    }

    public abstract List<LocalName> getParsedNames();

    @Override
    public LocalName head() {
        List<LocalName> names = this.getParsedNames();
        return names.get(0);
    }

    @Override
    public LocalName tip() {
        List<LocalName> names = this.getParsedNames();
        return names.get(names.size() - 1);
    }

    char getSeparator() {
        return ':';
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        List<LocalName> parsedNames = this.getParsedNames();
        char separator = this.getSeparator();
        for (LocalName parsedName : parsedNames) {
            if (buffer.length() != 0) {
                buffer.append(separator);
            }
            buffer.append(parsedName);
        }
        return buffer.toString();
    }

    @Override
    public InternationalString toInternationalString() {
        return new International(this.getParsedNames(), this.getSeparator());
    }

    @Override
    public int compareTo(org.geotools.api.util.GenericName that) {
        Iterator<LocalName> thisNames = this.getParsedNames().iterator();
        Iterator<? extends LocalName> thatNames = that.getParsedNames().iterator();
        while (thisNames.hasNext()) {
            if (!thatNames.hasNext()) {
                return 1;
            }
            LocalName thisNext = thisNames.next();
            LocalName thatNext = thatNames.next();
            if (thisNext == this && thatNext == that) {
                throw new IllegalStateException();
            }
            int compare = thisNext.compareTo(thatNext);
            if (compare == 0) continue;
            return compare;
        }
        return thatNames.hasNext() ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GenericName that = (GenericName)object;
            return Utilities.equals(this.getParsedNames(), that.getParsedNames()) && this.getSeparator() == that.getSeparator();
        }
        return false;
    }

    public int hashCode() {
        return 0xF4C4EE2B ^ this.getParsedNames().hashCode();
    }

    private static final class International
    extends AbstractInternationalString
    implements Serializable {
        private static final long serialVersionUID = -4234089612436334148L;
        private final List<? extends LocalName> parsedNames;
        private final char separator;

        public International(List<? extends LocalName> parsedNames, char separator) {
            this.parsedNames = parsedNames;
            this.separator = separator;
        }

        @Override
        public String toString(Locale locale) {
            StringBuilder buffer = new StringBuilder();
            for (LocalName localName : this.parsedNames) {
                if (buffer.length() != 0) {
                    buffer.append(this.separator);
                }
                buffer.append(localName.toInternationalString().toString(locale));
            }
            return buffer.toString();
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                International that = (International)object;
                return Utilities.equals(this.parsedNames, that.parsedNames) && this.separator == that.separator;
            }
            return false;
        }

        public int hashCode() {
            return 0x3F8F99BC ^ this.parsedNames.hashCode();
        }
    }
}

