/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collections;
import java.util.List;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.NameSpace;
import org.geotools.api.util.ScopedName;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.GenericName;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;

public class LocalName
extends GenericName
implements org.geotools.api.util.LocalName {
    private static final long serialVersionUID = -5627125375582385822L;
    private final ScopedName asScopedName;
    private final CharSequence name;
    private transient String asString;
    private transient InternationalString asInternationalString;
    private transient List<org.geotools.api.util.LocalName> parsedNames;

    public LocalName(CharSequence name) {
        this(null, name);
    }

    LocalName(ScopedName asScopedName, CharSequence name) {
        this.asScopedName = asScopedName;
        this.name = LocalName.validate(name);
        AbstractInternationalString.ensureNonNull("name", name);
    }

    @Override
    protected org.geotools.api.util.GenericName getInternalScope() {
        NameSpace scope;
        if (this.asScopedName != null && (scope = this.asScopedName.scope()) != null) {
            return scope.name();
        }
        return null;
    }

    @Override
    public NameSpace scope() {
        return this.asScopedName != null ? this.asScopedName.scope() : super.scope();
    }

    @Override
    public int depth() {
        return 1;
    }

    @Override
    public List<org.geotools.api.util.LocalName> getParsedNames() {
        if (this.parsedNames == null) {
            this.parsedNames = Collections.singletonList(this);
        }
        return this.parsedNames;
    }

    @Override
    public org.geotools.api.util.LocalName head() {
        return this;
    }

    @Override
    public org.geotools.api.util.LocalName tip() {
        return this;
    }

    @Override
    public org.geotools.api.util.GenericName toFullyQualifiedName() {
        if (this.asScopedName == null) {
            return this;
        }
        return this.asScopedName;
    }

    @Override
    public ScopedName push(org.geotools.api.util.GenericName scope) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String toString() {
        if (this.asString == null) {
            this.asString = this.name instanceof InternationalString ? ((InternationalString)this.name).toString(null) : this.name.toString();
        }
        return this.asString;
    }

    @Override
    public InternationalString toInternationalString() {
        if (this.asInternationalString == null) {
            this.asInternationalString = this.name instanceof InternationalString ? (InternationalString)this.name : new SimpleInternationalString(this.name.toString());
        }
        return this.asInternationalString;
    }

    @Override
    public int compareTo(org.geotools.api.util.GenericName object) {
        return this.toString().compareToIgnoreCase(object.toString());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            LocalName that = (LocalName)object;
            return Utilities.equals(this.getInternalScope(), that.getInternalScope()) && Utilities.equals(this.name, that.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = -506246814;
        if (this.name != null) {
            code ^= this.name.hashCode();
        }
        return code;
    }
}

