/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconnect;

import com.stratadata.model3.db.ModelVersion;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sbconnect.DialogConnection;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import model3.SBdb;

public class DialogConnectionManager
extends JDialog {
    private final ResourceBundle resources = ResourceBundle.getBundle("locale/UiText");
    private final ModelVersion modelVersion;
    boolean hasChanged = false;
    private List<ConnectionParameters> sbConns;
    private final DefaultListModel model = new DefaultListModel();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonCopy;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JLabel jLabel1;
    private JList jListConnections;
    private JScrollPane jScrollPane1;

    public DialogConnectionManager(Window parent, boolean modal, ModelVersion modelVersion) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        if (modelVersion == null) {
            modelVersion = SBdb.MODEL_VERSION;
        }
        this.modelVersion = modelVersion;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle(String.format(this.resources.getString("DialogConnectionManager.title"), this.modelVersion.toString()));
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.sbConns = ConnectionParameters.getConnections(this.modelVersion);
        Iterator<ConnectionParameters> it = this.sbConns.iterator();
        this.model.clear();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.jListConnections.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListConnections = new JList();
        this.jLabel1 = new JLabel();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonCopy = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 200));
        this.jListConnections.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jListConnections.setModel(this.model);
        this.jListConnections.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogConnectionManager this$0;
            {
                DialogConnectionManager dialogConnectionManager = this$0;
                Objects.requireNonNull(dialogConnectionManager);
                this.this$0 = dialogConnectionManager;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jListConnectionsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListConnections);
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jLabel1.setText(bundle.getString("DialogConnectionManager.savedConnections.label"));
        this.jButtonAdd.setText(bundle.getString("button.add"));
        this.jButtonAdd.setToolTipText(bundle.getString("DialogConnectionManager.jButtonAdd.tooltip"));
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnectionManager this$0;
            {
                DialogConnectionManager dialogConnectionManager = this$0;
                Objects.requireNonNull(dialogConnectionManager);
                this.this$0 = dialogConnectionManager;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText(bundle.getString("button.edit"));
        this.jButtonEdit.setToolTipText(bundle.getString("DialogConnectionManager.jButtonEdit.tooltip"));
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnectionManager this$0;
            {
                DialogConnectionManager dialogConnectionManager = this$0;
                Objects.requireNonNull(dialogConnectionManager);
                this.this$0 = dialogConnectionManager;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText(bundle.getString("button.delete"));
        this.jButtonDelete.setToolTipText(bundle.getString("DialogConnectionManager.jButtonDelete.tooltip"));
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnectionManager this$0;
            {
                DialogConnectionManager dialogConnectionManager = this$0;
                Objects.requireNonNull(dialogConnectionManager);
                this.this$0 = dialogConnectionManager;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText(bundle.getString("button.close"));
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnectionManager this$0;
            {
                DialogConnectionManager dialogConnectionManager = this$0;
                Objects.requireNonNull(dialogConnectionManager);
                this.this$0 = dialogConnectionManager;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonCopy.setText(bundle.getString("button.copy"));
        this.jButtonCopy.setToolTipText(bundle.getString("DialogConnectionManager.jButtonEdit.tooltip"));
        this.jButtonCopy.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConnectionManager this$0;
            {
                DialogConnectionManager dialogConnectionManager = this$0;
                Objects.requireNonNull(dialogConnectionManager);
                this.this$0 = dialogConnectionManager;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCopyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCopy, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 210, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        ConnectionParameters parms;
        if (this.jListConnections.getSelectedValuesList().size() < 1) {
            this.getToolkit().beep();
        }
        if ((parms = (ConnectionParameters)this.jListConnections.getSelectedValue()) != null) {
            int opt = JOptionPane.showConfirmDialog(this, this.resources.getString("DialogConnectionManager.jButtonDelete.confirmMessage"), this.resources.getString("DialogConnectionManager.jButtonDelete.confirmMessage.title"), 2);
            if (opt != 0) {
                return;
            }
            parms.clear();
        }
        this.hasChanged = true;
        this.init();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListConnections.getSelectedIndex() < 0) {
            this.getToolkit().beep();
            return;
        }
        ConnectionParameters parms = (ConnectionParameters)this.jListConnections.getSelectedValue();
        if (parms != null) {
            DialogConnection dialog = new DialogConnection(this, true, this.sbConns, parms, this.modelVersion);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.hasChanged = true;
            }
        }
        this.init();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogConnection dialog = new DialogConnection(this, true, this.sbConns, null, this.modelVersion);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.hasChanged = true;
        }
        this.init();
    }

    private void jButtonCopyActionPerformed(ActionEvent evt) {
        if (this.jListConnections.getSelectedIndex() < 0) {
            this.getToolkit().beep();
            return;
        }
        ConnectionParameters parmsOrig = (ConnectionParameters)this.jListConnections.getSelectedValue();
        ConnectionParameters parms = parmsOrig.copy();
        DialogConnection dialog = new DialogConnection(this, true, this.sbConns, parms, this.modelVersion);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.hasChanged = true;
        }
        this.init();
    }

    private void jListConnectionsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }
}

