/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.script;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.user.Userdef;
import com.stratadata.util.script.DialogSQLResults;
import com.stratadata.util.script.DialogSQQueryLstrat;
import com.stratadata.util.script.QueryResult;
import com.stratadata.util.script.SbugsQuery;
import com.stratadata.util.script.ScriptRunner;
import com.stratadata.util.ui.SwingTextFieldUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import model3.ConnectionProvider;
import model3.SBdb;
import util.SBException;

public class DialogSQLQuery
extends JDialog {
    private static final String DEFAULT_TEXT = "Enter your query here...";
    private final SBdb db;
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JButton jButtonClose;
    private JButton jButtonRun;
    private JComboBox jComboBoxQuery;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaSql;
    private JTextField jTextFieldTimeout;

    public DialogSQLQuery(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("StrataBugs Query");
        this.getRootPane().setDefaultButton(this.jButtonRun);
        this.initSqlField();
        this.model.addElement("");
        SbugsQuery.getAllQueries().forEach(query -> this.model.addElement(query));
        this.jComboBoxQuery.repaint();
        this.jComboBoxQuery.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogSQLQuery this$0;
            {
                DialogSQLQuery dialogSQLQuery = this$0;
                Objects.requireNonNull(dialogSQLQuery);
                this.this$0 = dialogSQLQuery;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item;
                if (e.getStateChange() == 1 && (item = e.getItem()) instanceof SbugsQuery) {
                    SbugsQuery query = (SbugsQuery)item;
                    this.this$0.jTextAreaSql.setForeground(Color.BLACK);
                    SwingUtilities.invokeLater(() -> {
                        String queryText;
                        block8: {
                            if (!query.supportsPlatform(this.this$0.db.getDBType())) {
                                JOptionPane.showMessageDialog(this.this$0, "This query will not run on your current database platform (" + this.this$0.db.getDBType().getName() + ").", "Unsupported Query", 2);
                            }
                            if (item == SbugsQuery.getQuery_DeepestEvent()) {
                                String wellName = JOptionPane.showInputDialog(this.this$0, "Well name search prefix", "Query", 1);
                                queryText = query.getQuery((ConnectionProvider)this.this$0.db, wellName);
                            } else if (item == SbugsQuery.getQuery_Lithostrat()) {
                                try {
                                    DialogSQQueryLstrat dialog = new DialogSQQueryLstrat(this.this$0, true, this.this$0.db);
                                    dialog.setLocationRelativeTo(this.this$0);
                                    dialog.setVisible(true);
                                    if (dialog.isOK()) {
                                        queryText = query.getQuery((ConnectionProvider)this.this$0.db, dialog.getUnitName(), dialog.getProjectName());
                                        break block8;
                                    }
                                    queryText = "";
                                }
                                catch (SQLException | SBException ex) {
                                    ex.printStackTrace();
                                    queryText = "";
                                }
                            } else {
                                queryText = query.getQuery((ConnectionProvider)this.this$0.db, new String[0]);
                            }
                        }
                        this.this$0.jTextAreaSql.setText(queryText);
                    });
                }
            }
        });
        if (this.db.getTablePrefix() != null && this.db.getTablePrefix().length() > 0) {
            if (this.db.getDBType() == DBType.ORACLE) {
                try {
                    System.out.println("Altering session for table prefix...");
                    this.db.getDatabase().createStatement().executeUpdate("ALTER SESSION SET CURRENT_SCHEMA=" + this.db.getTablePrefix());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.db.getDBType() == DBType.POSTGRESQL) {
                try {
                    System.out.println("Setting schema for table prefix...");
                    this.db.getDatabase().createStatement().executeUpdate("SET SCHEMA '" + this.db.getTablePrefix() + "'");
                    this.db.commit();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void initSqlField() {
        this.jTextAreaSql.setForeground(Color.gray);
        this.jTextAreaSql.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSQLQuery this$0;
            {
                DialogSQLQuery dialogSQLQuery = this$0;
                Objects.requireNonNull(dialogSQLQuery);
                this.this$0 = dialogSQLQuery;
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (this.this$0.jTextAreaSql.getText().equals(DialogSQLQuery.DEFAULT_TEXT)) {
                    this.this$0.jTextAreaSql.setText("");
                }
                this.this$0.jTextAreaSql.setForeground(Color.black);
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.this$0.jTextAreaSql.getText().equals("")) {
                    this.this$0.jTextAreaSql.setForeground(Color.gray);
                    this.this$0.jTextAreaSql.setText(DialogSQLQuery.DEFAULT_TEXT);
                }
                super.focusLost(e);
            }
        });
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jButtonRun = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaSql = new JTextArea();
        this.jLabel2 = new JLabel();
        this.jComboBoxQuery = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextFieldTimeout = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 300));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQLQuery this$0;
            {
                DialogSQLQuery dialogSQLQuery = this$0;
                Objects.requireNonNull(dialogSQLQuery);
                this.this$0 = dialogSQLQuery;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRun.setText("Run...");
        this.jButtonRun.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQLQuery this$0;
            {
                DialogSQLQuery dialogSQLQuery = this$0;
                Objects.requireNonNull(dialogSQLQuery);
                this.this$0 = dialogSQLQuery;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRunActionPerformed(evt);
            }
        });
        this.jTextAreaSql.setColumns(20);
        this.jTextAreaSql.setFont(new Font("Monospaced", 0, 12));
        this.jTextAreaSql.setRows(5);
        this.jTextAreaSql.setText(DEFAULT_TEXT);
        this.jScrollPane1.setViewportView(this.jTextAreaSql);
        this.jLabel2.setText("Or choose prepared query:");
        this.jComboBoxQuery.setModel(this.model);
        this.jComboBoxQuery.setFocusable(false);
        this.jLabel4.setText("Query timeout (seconds): ");
        this.jTextFieldTimeout.setText("30");
        this.jTextFieldTimeout.setToolTipText("Use a value of zero for no timeout");
        this.jTextFieldTimeout.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogSQLQuery this$0;
            {
                DialogSQLQuery dialogSQLQuery = this$0;
                Objects.requireNonNull(dialogSQLQuery);
                this.this$0 = dialogSQLQuery;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTimeoutKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldTimeout, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 363, Short.MAX_VALUE).addComponent(this.jButtonRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxQuery, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 328, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxQuery, -2, -1, -2).addComponent(this.jLabel2)).addGap(12, 12, 12).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonRun).addComponent(this.jLabel4).addComponent(this.jTextFieldTimeout, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonRunActionPerformed(ActionEvent evt) {
        String queryStack = this.jTextAreaSql.getText();
        if (queryStack.isEmpty() || queryStack.equals(DEFAULT_TEXT)) {
            JOptionPane.showMessageDialog(this, "No query entered", this.getTitle(), 2);
            return;
        }
        boolean isSuperUser = Userdef.isSuperUser((int)this.db.getUser().getPriv());
        final ScriptRunner scriptRunner = new ScriptRunner(queryStack, (ConnectionProvider)this.db, null, this, isSuperUser);
        scriptRunner.setCommitMode(ScriptRunner.CommitMode.WITH_CONFIRM);
        try {
            int timeout = Integer.parseInt(this.jTextFieldTimeout.getText());
            scriptRunner.setQueryTimeout(timeout);
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(DialogSQLQuery.class.getName()).log(Level.WARNING, "Error parsing query timeout: {0}", ex.getMessage());
        }
        scriptRunner.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ DialogSQLQuery this$0;
            {
                DialogSQLQuery dialogSQLQuery = this$0;
                Objects.requireNonNull(dialogSQLQuery);
                this.this$0 = dialogSQLQuery;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName())) {
                    SwingWorker.StateValue newState = (SwingWorker.StateValue)((Object)evt.getNewValue());
                    switch (newState) {
                        case STARTED: {
                            return;
                        }
                        case DONE: {
                            this.this$0.setCursor(Cursor.getDefaultCursor());
                            try {
                                List results = (List)scriptRunner.get();
                                if (results.isEmpty() && !scriptRunner.hasConfirmed()) {
                                    JOptionPane.showMessageDialog(this.this$0, "Script ran to completion", "Run Script", 1);
                                    break;
                                }
                                int locX = this.this$0.getX();
                                int locY = this.this$0.getY();
                                for (QueryResult result : results) {
                                    if (result.nRows() == 0) {
                                        JOptionPane.showMessageDialog(this.this$0, "Query produced no results", "Run Script", 1);
                                        continue;
                                    }
                                    DialogSQLResults dialog = new DialogSQLResults((Frame)this.this$0.getParent(), this.this$0.db, result);
                                    if (dialog.displayCancelled()) continue;
                                    dialog.setLocation(locX += 30, locY += 30);
                                    dialog.setVisible(true);
                                }
                                break;
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        });
        this.setCursor(Cursor.getPredefinedCursor(3));
        scriptRunner.execute();
    }

    private void jTextFieldTimeoutKeyTyped(KeyEvent evt) {
        if (SwingTextFieldUtils.intFieldVal(this.jTextFieldTimeout, 3, evt, false)) {
            this.getToolkit().beep();
        }
    }
}

