/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.script;

import com.stratadata.util.io.FileChooserUtils;
import com.stratadata.util.script.QueryResult;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import model3.Lastval;
import model3.SBdb;
import util.table.ColumnsAutoSizer;

public class DialogSQLResults
extends JDialog {
    private final SBdb db;
    private final TableModelSQLResults model;
    private boolean displayCancelled = false;
    private QueryResult.Initialiser resultInitialiser = null;
    private JButton jButtonClose;
    private JButton jButtonSaveAs;
    private JLabel jLabelNRows;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneQuery;
    private JTable jTableSQLResults;
    private JTextArea jTextAreaQuery;

    public DialogSQLResults(Frame parent, SBdb db, QueryResult queryResult) {
        super(parent, false);
        this.db = db;
        this.model = new TableModelSQLResults(queryResult);
        this.init();
    }

    private void init() {
        this.setTitle("Building query results...");
        this.setMinimumSize(new Dimension(400, 250));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogSQLResults this$0;
            {
                DialogSQLResults dialogSQLResults = this$0;
                Objects.requireNonNull(dialogSQLResults);
                this.this$0 = dialogSQLResults;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.resultInitialiser = this.model.data.getInitialiser(() -> {
            this.initComponents();
            this.postInit();
        });
        if (this.model.data.isOverLargeTableThreshold()) {
            int opt = JOptionPane.showConfirmDialog(this.getParent(), "The query produced " + this.model.data.nRows() + " rows. Do you still want to display them?", "SQL Query", 0, 3);
            if (opt == 1) {
                this.displayCancelled = true;
                return;
            }
            new Thread((Runnable)this.resultInitialiser, "SQL-Results-Thread").start();
        } else {
            this.resultInitialiser.run();
        }
    }

    private void postInit() {
        this.setTitle("StrataBugs Query Results");
        this.jTextAreaQuery.setText(this.model.data.query());
        TableUtils.setTableHeaderBold(this.jTableSQLResults);
        this.jTableSQLResults.setRowSorter(new TableRowSorter<TableModelSQLResults>(this.model));
        new ColumnSortResetHandler(this.jTableSQLResults).attach();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableSQLResults.getColumnModel().getColumn(i).setHeaderValue(this.model.data.columnName(i));
        }
        this.model.fireTableDataChanged();
        ColumnsAutoSizer.sizeColumnsToFit((JTable)this.jTableSQLResults);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jLabelNRows.setText("Number of rows: " + this.model.data.nRows());
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSQLResults = new JTable();
        this.jButtonSaveAs = new JButton();
        this.jLabelNRows = new JLabel();
        this.jScrollPaneQuery = new JScrollPane();
        this.jTextAreaQuery = new JTextArea();
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(400, 250));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogSQLResults this$0;
            {
                DialogSQLResults dialogSQLResults = this$0;
                Objects.requireNonNull(dialogSQLResults);
                this.this$0 = dialogSQLResults;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQLResults this$0;
            {
                DialogSQLResults dialogSQLResults = this$0;
                Objects.requireNonNull(dialogSQLResults);
                this.this$0 = dialogSQLResults;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableSQLResults.setModel(this.model);
        this.jTableSQLResults.setGridColor(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.jTableSQLResults);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the current list as a text file");
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSQLResults this$0;
            {
                DialogSQLResults dialogSQLResults = this$0;
                Objects.requireNonNull(dialogSQLResults);
                this.this$0 = dialogSQLResults;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jLabelNRows.setText("Number of rows selected: ");
        this.jTextAreaQuery.setEditable(false);
        this.jTextAreaQuery.setBackground(new Color(204, 204, 204));
        this.jTextAreaQuery.setColumns(20);
        this.jTextAreaQuery.setFont(new Font("Monospaced", 0, 12));
        this.jTextAreaQuery.setRows(3);
        this.jScrollPaneQuery.setViewportView(this.jTextAreaQuery);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelNRows, -2, 443, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonSaveAs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 789, Short.MAX_VALUE).addComponent(this.jScrollPaneQuery)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPaneQuery, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 488, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonSaveAs).addComponent(this.jLabelNRows)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        String[] extensions = new String[]{"txt", "csv"};
        String[] descriptions = new String[]{"TAB delimited text files", "Commas Separated Values text files"};
        File file = FileChooserUtils.chooseFileToWrite(this.db, this, "JLISTFILE", "JLISTFILE", extensions, descriptions, null);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        if (file != null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                char delim = '\t';
                Object fileName = file.getPath();
                if (!((String)fileName).toLowerCase().endsWith(".txt")) {
                    if (((String)fileName).endsWith(".csv")) {
                        delim = ',';
                    } else {
                        fileName = (String)fileName + ".txt";
                    }
                }
                try (FileWriter out = new FileWriter((String)fileName);){
                    out.write("StrataBugs output: " + df.format(date) + "\r\n\r\n");
                    Enumeration<TableColumn> en = this.jTableSQLResults.getColumnModel().getColumns();
                    while (en.hasMoreElements()) {
                        TableColumn column = en.nextElement();
                        out.write(String.valueOf(column.getHeaderValue()) + delim);
                    }
                    out.write("\r\n");
                    for (String[] data : this.model.data.getRows()) {
                        out.write("\r\n");
                        for (int col = 0; col < data.length; ++col) {
                            out.write(String.valueOf(col > 0 ? Character.valueOf(delim) : "") + (data[col] != null ? data[col] : ""));
                        }
                    }
                    out.write("\r\n");
                }
                if (JOptionPane.showConfirmDialog(this, "File '" + (String)fileName + "' written", "File Saved", 2) == 0) {
                    try {
                        Lastval.putString((SBdb)this.db, (String)"JLISTFILE", (String)fileName);
                        this.db.commit();
                    }
                    catch (SQLException sql) {
                        sql.printStackTrace();
                    }
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error writing file: " + ex.getMessage());
                ex.printStackTrace();
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.resultInitialiser != null) {
            this.resultInitialiser.stop();
        }
        this.dispose();
    }

    public boolean displayCancelled() {
        return this.displayCancelled;
    }

    private static class TableModelSQLResults
    extends AbstractTableModel {
        final QueryResult data;

        public TableModelSQLResults(QueryResult data) {
            this.data = data;
        }

        @Override
        public int getRowCount() {
            return this.data.nRows();
        }

        @Override
        public int getColumnCount() {
            return this.data.nColumns();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.getData(rowIndex, columnIndex);
        }
    }
}

