/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.ui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class SwingTextFieldUtils {
    private SwingTextFieldUtils() {
    }

    public static boolean intFieldVal(JTextField field, int len, KeyEvent evt, boolean allowNegative) {
        int selectedLenth;
        char c = evt.getKeyChar();
        boolean beep = false;
        if (!(c >= '0' && c <= '9' || c == '-' && allowNegative && !field.getText().contains("-") || c == '+' && !field.getText().contains("+") || c == '\b' || c == '\u007f')) {
            beep = true;
            evt.consume();
        }
        String str = field.getText();
        int n = selectedLenth = field.getSelectedText() != null ? field.getSelectedText().length() : 0;
        if (str.length() - selectedLenth >= len) {
            beep = true;
            evt.consume();
        }
        return beep;
    }

    public static void enableDefaultValue(final JTextField tf, final String defaultValue) {
        tf.setText(defaultValue);
        tf.setForeground(Color.gray);
        tf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (tf.getText().equals(defaultValue)) {
                    tf.setForeground(Color.black);
                    tf.setText("");
                }
                super.focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (tf.getText().equals("")) {
                    tf.setForeground(Color.gray);
                    tf.setText(defaultValue);
                }
                super.focusLost(e);
            }
        });
    }
}

