/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.util.ui.table;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableUtils {
    public static int[] getSelectedModelRows(JTable table) {
        int[] selectedRows = table.getSelectedRows();
        int[] modelRows = new int[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            modelRows[i] = table.convertRowIndexToModel(selectedRows[i]);
        }
        return modelRows;
    }

    public static void setPrefferedWidths(JTable table, int ... widths) {
        TableColumnModel cm = table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            cm.getColumn(i).setPreferredWidth(widths[i % widths.length]);
        }
    }

    public static void updateTableColumnNames(JTable table) {
        TableModel tableModel = table.getModel();
        TableColumnModel cm = table.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            int modelIndex = table.convertColumnIndexToModel(i);
            cm.getColumn(i).setHeaderValue(tableModel.getColumnName(modelIndex));
        }
        table.getTableHeader().repaint();
    }

    public static void hideColumn(TableColumn column) {
        column.setMinWidth(0);
        column.setMaxWidth(0);
    }

    public static void setTableHeaderBold(JTable table) {
        Font font = table.getTableHeader().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        table.getTableHeader().setFont(font);
        table.setGridColor(new Color(230, 230, 230));
    }
}

