/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.db;

import com.stratadata.model3.db.ConnectionDetails;
import com.stratadata.model3.db.DBDriverType;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import util.EnvironmentVariableProvider;

public class ConnectionDetailsHelper {
    private static final Logger LOGGER = Logger.getLogger(ConnectionDetailsHelper.class.getName());

    public static ConnectionDetails getConnectionDetails(DBDriverType driverType, String hostName, boolean allowCreateEmpty, String instanceName, String instanceLogin, String password, String newPassword, boolean encrypt) throws IllegalArgumentException {
        return ConnectionDetailsHelper.getConnectionDetails(driverType, hostName, allowCreateEmpty, instanceName, instanceLogin, password, newPassword, new EnvironmentVariableProvider(), encrypt);
    }

    static ConnectionDetails getConnectionDetails(DBDriverType driverType, String hostName, boolean allowCreateEmpty, String instanceName, String instanceLogin, String password, String newPassword, EnvironmentVariableProvider evp, boolean encrypt) throws IllegalArgumentException {
        LOGGER.log(Level.INFO, "Registered drivers: {0}", DriverManager.drivers().collect(Collectors.toList()).toString());
        ConnectionDetails connDetails = switch (driverType) {
            case DBDriverType.H2 -> ConnectionDetailsHelper.getH2driverString(hostName, allowCreateEmpty, instanceLogin, password);
            case DBDriverType.SQLSERVER -> ConnectionDetailsHelper.getSqlServerDriverString(hostName, instanceName, instanceLogin, password, encrypt);
            case DBDriverType.ORACLE, DBDriverType.ORACLE_OCI -> ConnectionDetailsHelper.getOracleDriverString(instanceName, driverType, hostName, instanceLogin, password, newPassword);
            case DBDriverType.POSTGRESQL -> ConnectionDetailsHelper.getPostgresDriverString(instanceName, hostName, instanceLogin, password, evp, encrypt);
            case DBDriverType.MYSQL -> ConnectionDetailsHelper.getMySqlDriverString(hostName, instanceName, instanceLogin, password);
            default -> throw new IllegalArgumentException("Cannot connect with driver type: " + String.valueOf((Object)driverType));
        };
        return connDetails;
    }

    private static ConnectionDetails getOracleDriverString(String instanceName, DBDriverType driverType, String hostName, String instanceLogin, String password, String newPassword) {
        Properties props = null;
        String tablePrefix = null;
        if (instanceName.contains(".")) {
            tablePrefix = instanceName.substring(instanceName.lastIndexOf(46) + 1);
            instanceName = instanceName.substring(0, instanceName.lastIndexOf("."));
        }
        Object driverString = switch (driverType) {
            case DBDriverType.ORACLE -> "jdbc:oracle:thin:";
            case DBDriverType.ORACLE_OCI -> "jdbc:oracle:oci:";
            default -> throw new IllegalStateException("not Oracle type: " + String.valueOf((Object)driverType));
        };
        if (hostName.toUpperCase().contains("DESCRIPTION")) {
            driverString = (String)driverString + "@" + hostName;
            tablePrefix = instanceName;
            instanceName = "";
        } else if (instanceName != null && !instanceName.isEmpty()) {
            switch (instanceName.charAt(0)) {
                case ':': {
                    driverString = (String)driverString + "@" + hostName + instanceName;
                    break;
                }
                case '/': {
                    driverString = (String)driverString + "@//" + hostName + instanceName;
                    break;
                }
                default: {
                    driverString = (String)driverString + "@//" + hostName + "/" + instanceName;
                    break;
                }
            }
        } else {
            driverString = (String)driverString + "@//" + hostName;
        }
        props = new Properties();
        if (instanceLogin != null && !instanceLogin.isEmpty() && password != null && !password.isEmpty()) {
            props.put("user", instanceLogin);
            props.put("password", password);
            if (newPassword != null && !newPassword.isEmpty()) {
                props.put("OCINewPassword", newPassword);
            }
        }
        String fetchSize = "256";
        LOGGER.log(Level.INFO, "Setting preFetch size to: " + fetchSize);
        props.put("defaultRowPrefetch", fetchSize);
        props.put("cachePrepStmts", "true");
        props.put("prepStmtCacheSize", "250");
        props.put("prepStmtCacheSqlLimit", "2048");
        return new ConnectionDetails((String)driverString, props, instanceLogin, password, tablePrefix);
    }

    private static ConnectionDetails getH2driverString(String hostName, boolean allowCreateEmpty, String instanceLogin, String password) {
        String driverString = "jdbc:h2:" + hostName;
        if (!allowCreateEmpty) {
            driverString = driverString + ";IFEXISTS=TRUE";
        }
        return new ConnectionDetails(driverString, null, instanceLogin, password, null);
    }

    private static ConnectionDetails getPostgresDriverString(String instanceName, String hostName, String instanceLogin, String password, EnvironmentVariableProvider envProvider, boolean encrypt) {
        Properties props = null;
        String tablePrefix = null;
        if (instanceName.contains(".")) {
            tablePrefix = instanceName.substring(instanceName.lastIndexOf(46) + 1);
            instanceName = instanceName.substring(0, instanceName.lastIndexOf("."));
        }
        String driverString = "jdbc:postgresql://" + hostName + "/" + instanceName;
        driverString = driverString + "?autosave=always";
        String sslPrefix = envProvider.getenv("JSBUGS30_SSLPATH");
        if (sslPrefix != null) {
            String sslPassword = envProvider.getenv("JSBUGS30_SSLPASSWORD");
            if (sslPassword == null) {
                sslPassword = "";
            }
            props = new Properties();
            props.put("user", instanceLogin);
            props.put("password", password);
            props.put("ssl", (Object)true);
            props.put("sslmode", "verify-ca");
            props.put("sslcert", sslPrefix + "client-cert.pem");
            props.put("sslkey", sslPrefix + "client-key.der");
            props.put("sslrootcert", sslPrefix + "server-ca.pem");
            props.put("sslpassword", sslPassword);
        } else if (encrypt) {
            props = new Properties();
            props.put("user", instanceLogin);
            props.put("password", password);
            props.put("ssl", "true");
            props.put("sslmode", "require");
        }
        return new ConnectionDetails(driverString, props, instanceLogin, password, tablePrefix);
    }

    private static ConnectionDetails getSqlServerDriverString(String hostName, String instanceName, String instanceLogin, String password, boolean encrypt) {
        Properties props = null;
        props = new Properties();
        if (StringUtils.isNotBlank((CharSequence)instanceLogin)) {
            props.put("user", instanceLogin);
        }
        if (StringUtils.isNotBlank((CharSequence)password)) {
            props.put("password", password);
        }
        if (encrypt) {
            props.put("encrypt", "true");
            props.put("trustServerCertificate", "true");
        } else {
            props.put("encrypt", "false");
        }
        return new ConnectionDetails("jdbc:sqlserver://" + hostName + ";databaseName=" + instanceName, props, instanceLogin, password, null);
    }

    private static ConnectionDetails getMySqlDriverString(String hostName, String instanceName, String instanceLogin, String password) {
        return new ConnectionDetails("jdbc:mysql://" + hostName + "/" + instanceName, null, instanceLogin, password, null);
    }
}

