/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.image;

import com.stratadata.model3.db.DBType;
import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.PicPathImageLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import model3.SBdb;

public class ImageLoaderDbImpl
implements ImageLoader {
    private final SBdb conn;

    public ImageLoaderDbImpl(SBdb conn) {
        this.conn = conn;
    }

    public Image getImage(ImageRecord ir) {
        try {
            Image image;
            if (ir.imageID() == 0) {
                return PicPathImageLoader.loadImageFromPicPath(ir);
            }
            if (this.conn.storeImage()) {
                image = this.loadImageFromResultDatabase(ir);
                if (image == null) {
                    image = PicPathImageLoader.loadImageFromPicPath(ir);
                }
            } else {
                image = PicPathImageLoader.loadImageFromPicPath(ir);
                if (image == null) {
                    this.loadImageFromResultDatabase(ir);
                }
            }
            return image;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Image loadImageFromResultDatabase(ImageRecord ir) throws SQLException, IOException {
        byte[] by = null;
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            String sql = "SELECT " + ir.getDataColumnName() + " FROM " + this.conn.DBTableName(ir.getTableName()) + " WHERE " + ir.getIdColumnName() + "=" + ir.imageID();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                if (this.conn.getDBType() != DBType.MSSQLSERVER) {
                    by = rs.getBytes(ir.getDataColumnName());
                } else {
                    InputStream ios = rs.getBinaryStream(ir.getDataColumnName());
                    if (ios != null) {
                        int b;
                        ByteArrayOutputStream bio = new ByteArrayOutputStream();
                        while ((b = ios.read()) >= 0) {
                            bio.write(b);
                        }
                        by = bio.toByteArray();
                    }
                }
            }
            if (by != null) {
                Image image = Toolkit.getDefaultToolkit().createImage(by);
                return image;
            }
        }
        return null;
    }
}

