/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.slidestore;

import com.stratadata.model3.slidestore.Cabinet;
import com.stratadata.model3.slidestore.Drawer;
import com.stratadata.model3.slidestore.SlideBox;
import com.stratadata.model3.slidestore.SlideCell;
import com.stratadata.model3.slidestore.SlideStoreService;
import com.stratadata.model3.slidestore.Specimen;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import model3.SBdb;
import model3.exception.SuppressedSQLException;

public class SlideStoreServiceDbImpl
implements SlideStoreService {
    private final SBdb db;

    public SlideStoreServiceDbImpl(SBdb db) {
        this.db = db;
    }

    public List<Cabinet> getCabinets() {
        String sql = "SELECT cabinet_id, name, comments FROM " + this.db.DBTableName("cabinet") + " ORDER by NAME";
        LinkedList<Cabinet> list = new LinkedList<Cabinet>();
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int cabinetID = rs.getInt("cabinet_id");
                String name = rs.getString("name");
                String comments = rs.getString("comments");
                list.add(new Cabinet(cabinetID, name, comments));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<Drawer> findDrawers(int cabinetID) {
        String sql = "SELECT drawer_id, drawer_number FROM " + this.db.DBTableName("drawer") + " WHERE cabinet_id = " + cabinetID + " ORDER by drawer_number";
        LinkedList<Drawer> list = new LinkedList<Drawer>();
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int drawerID = rs.getInt("drawer_id");
                int drawerNo = rs.getInt("drawer_number");
                list.add(new Drawer(drawerID, cabinetID, drawerNo));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<SlideBox> findSlideBoxes(int drawerID) {
        String sql = "SELECT slidebox_id, celltype, name, collection FROM " + this.db.DBTableName("slidebox") + " WHERE drawer_id = " + drawerID + " ORDER by name";
        LinkedList<SlideBox> list = new LinkedList<SlideBox>();
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int slideboxID = rs.getInt("slidebox_id");
                String celltype = rs.getString("celltype");
                String name = rs.getString("name");
                String collection = rs.getString("collection");
                list.add(new SlideBox(slideboxID, drawerID, celltype, name, collection));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<SlideCell> findSlideCells(int slideBoxID) {
        String sql = "SELECT c.slideCell_id, c.cell_number, s.specimen_id, s.spec_id, s.comments, s.author FROM " + this.db.DBTableName("slidecell") + " c LEFT JOIN " + this.db.DBTableName("specimen") + " s ON s.slidecell_id=c.slidecell_id WHERE c.slideBox_id=" + slideBoxID + " ORDER BY cell_number";
        LinkedList<SlideCell> list = new LinkedList<SlideCell>();
        SlideCell slideCell = null;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int slideCellID = rs.getInt("slidecell_id");
                int cellNumber = rs.getInt("cell_number");
                int specimenID = rs.getInt("specimen_id");
                int specID = rs.getInt("spec_id");
                String comments = rs.getString("comments");
                String author = rs.getString("author");
                slideCell = new SlideCell(slideBoxID, slideCellID, cellNumber);
                list.add(slideCell);
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<SlideStoreService.SpecimenSlide> findSlideCellSpecimens(Cabinet cabinet, Drawer drawer, SlideBox slideBox) {
        String sql = "SELECT c.slideCell_id, c.cell_number, s.specimen_id, s.spec_id, s.comments, s.author FROM " + this.db.DBTableName("slidecell") + " c LEFT JOIN " + this.db.DBTableName("specimen") + " s ON s.slidecell_id=c.slidecell_id WHERE c.slideBox_id=" + slideBox.getSlideBoxID() + " ORDER BY cell_number";
        LinkedList<SlideStoreService.SpecimenSlide> list = new LinkedList<SlideStoreService.SpecimenSlide>();
        try (Statement stmt = this.db.getDatabase().createStatement();
             PreparedStatement pStmt = this.db.getDatabase().prepareStatement("SELECT count(specimen_image_id) AS nImages FROM " + this.db.DBTableName("specimen_image") + " WHERE specimen_id=?");){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int slideCellID = rs.getInt("slidecell_id");
                int cellNumber = rs.getInt("cell_number");
                int specimenID = rs.getInt("specimen_id");
                int specID = rs.getInt("spec_id");
                String comments = rs.getString("comments");
                String author = rs.getString("author");
                Specimen specimen = null;
                int nImages = 0;
                if (specimenID > 0) {
                    specimen = new Specimen(specimenID, slideCellID, comments, author, specID);
                    pStmt.setInt(1, specimen.getSpecimenID());
                    ResultSet rs2 = pStmt.executeQuery();
                    if (rs2.next()) {
                        nImages = rs2.getInt("nImages");
                    }
                }
                list.add(new SlideStoreService.SpecimenSlide(cabinet, drawer, slideBox, new SlideCell(slideBox.getSlideBoxID(), slideCellID, cellNumber), specimen, nImages));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<SlideStoreService.SpecimenSlide> findSlideCellSpecimens(String searchString) {
        String sql = "SELECT cb.cabinet_id, cb.name, cb.comments, d.drawer_id, d.drawer_number, b.slidebox_id, b.celltype, b.name, b.collection, c.slideCell_id, c.cell_number, s.specimen_id, s.spec_id, s.comments, s.author FROM " + this.db.DBTableName("cabinet") + " cb JOIN " + this.db.DBTableName("drawer") + " d ON cb.cabinet_id=d.cabinet_id JOIN " + this.db.DBTableName("slidebox") + " b ON d.drawer_id=b.drawer_id JOIN " + this.db.DBTableName("slidecell") + " c ON b.slidebox_id=c.slidebox_id LEFT JOIN " + this.db.DBTableName("specimen") + " s ON s.slidecell_id=c.slidecell_id WHERE  upper(b.collection) like '" + searchString.toUpperCase() + "'  ORDER BY cell_number";
        LinkedList<SlideStoreService.SpecimenSlide> list = new LinkedList<SlideStoreService.SpecimenSlide>();
        try (Statement stmt = this.db.getDatabase().createStatement();
             PreparedStatement pStmt = this.db.getDatabase().prepareStatement("SELECT count(specimen_image_id) AS nImages FROM " + this.db.DBTableName("specimen_image") + " WHERE specimen_id=?");){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int cabinetID = rs.getInt("cabinet_id");
                String name = rs.getString("name");
                String comments = rs.getString("comments");
                Cabinet cabinet = new Cabinet(cabinetID, name, comments);
                int drawerID = rs.getInt("drawer_id");
                int drawerNo = rs.getInt("drawer_number");
                Drawer drawer = new Drawer(drawerID, cabinetID, drawerNo);
                int slideBoxID = rs.getInt("slidebox_id");
                String celltype = rs.getString("celltype");
                name = rs.getString("name");
                String collection = rs.getString("collection");
                SlideBox slideBox = new SlideBox(slideBoxID, drawerID, celltype, name, collection);
                int slideCellID = rs.getInt("slidecell_id");
                int cellNumber = rs.getInt("cell_number");
                int specimenID = rs.getInt("specimen_id");
                int specID = rs.getInt("spec_id");
                comments = rs.getString("comments");
                String author = rs.getString("author");
                Specimen specimen = null;
                int nImages = 0;
                if (specimenID > 0) {
                    specimen = new Specimen(specimenID, slideCellID, comments, author, specID);
                    pStmt.setInt(1, specimen.getSpecimenID());
                    ResultSet rs2 = pStmt.executeQuery();
                    if (rs2.next()) {
                        nImages = rs2.getInt("nImages");
                    }
                }
                list.add(new SlideStoreService.SpecimenSlide(cabinet, drawer, slideBox, new SlideCell(slideBox.getSlideBoxID(), slideCellID, cellNumber), specimen, nImages));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<SlideStoreService.SpecimenSlide> findSpecimenSlides(int specID) {
        LinkedList<SlideStoreService.SpecimenSlide> list = new LinkedList<SlideStoreService.SpecimenSlide>();
        String sql = "SELECT cb.cabinet_id, cb.name, cb.comments, d.drawer_id, d.drawer_number, b.slidebox_id, b.celltype, b.name, b.collection, c.slideCell_id, c.cell_number, s.specimen_id, s.spec_id, s.comments, s.author FROM " + this.db.DBTableName("cabinet") + " cb," + this.db.DBTableName("drawer") + " d," + this.db.DBTableName("slidebox") + " b," + this.db.DBTableName("slidecell") + " c, " + this.db.DBTableName("specimen") + " s WHERE cb.cabinet_id=d.cabinet_id AND d.drawer_id=b.drawer_id AND b.slidebox_id=c.slidebox_id AND c.slidecell_id=s.slidecell_id AND s.spec_id=" + specID + " ORDER BY cb.name, d.drawer_number, b.name, c.cell_number";
        try (Statement stmt = this.db.getDatabase().createStatement();
             PreparedStatement pStmt = this.db.getDatabase().prepareStatement("SELECT count(specimen_image_id) AS nImages FROM " + this.db.DBTableName("specimen_image") + " WHERE specimen_id=?");){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int cabinetID = rs.getInt("cabinet_id");
                String name = rs.getString("name");
                String comments = rs.getString("comments");
                Cabinet cabinet = new Cabinet(cabinetID, name, comments);
                int drawerID = rs.getInt("drawer_id");
                int drawerNo = rs.getInt("drawer_number");
                Drawer drawer = new Drawer(drawerID, cabinetID, drawerNo);
                int slideBoxID = rs.getInt("slidebox_id");
                String celltype = rs.getString("celltype");
                name = rs.getString("name");
                String collection = rs.getString("collection");
                SlideBox slideBox = new SlideBox(slideBoxID, drawerID, celltype, name, collection);
                int slideCellID = rs.getInt("slidecell_id");
                int cellNumber = rs.getInt("cell_number");
                int specimenID = rs.getInt("specimen_id");
                comments = rs.getString("comments");
                String author = rs.getString("author");
                SlideCell slideCell = new SlideCell(slideBoxID, slideCellID, cellNumber);
                Specimen specimen = new Specimen(specimenID, slideCellID, comments, author, specID);
                int nImages = 0;
                pStmt.setInt(1, specimen.getSpecimenID());
                ResultSet rs2 = pStmt.executeQuery();
                if (rs2.next()) {
                    nImages = rs2.getInt("nImages");
                }
                list.add(new SlideStoreService.SpecimenSlide(cabinet, drawer, slideBox, slideCell, specimen, nImages));
            }
            sql = "SELECT s.specimen_id, s.spec_id, s.comments, s.author FROM " + this.db.DBTableName("specimen") + " s WHERE s.spec_id=" + specID + " AND (s.slidecell_id=0 OR s.slidecell_id is null)";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int specimenID = rs.getInt("specimen_id");
                String comments = rs.getString("comments");
                String author = rs.getString("author");
                Specimen specimen = new Specimen(specimenID, 0, comments, author, specID);
                System.out.println("Querying specimen_image for  specimenID: " + specimen.getSpecimenID());
                int nImages = 0;
                pStmt.setInt(1, specimen.getSpecimenID());
                ResultSet rs2 = pStmt.executeQuery();
                if (rs2.next()) {
                    nImages = rs2.getInt("nImages");
                }
                list.add(new SlideStoreService.SpecimenSlide(null, null, null, null, specimen, nImages));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback(e);
        }
        return list;
    }

    public List<Integer> getAllSlideStoreSpecies() {
        LinkedList<Integer> linkedList;
        block9: {
            String sql = "SELECT distinct(spec_id) FROM " + this.db.DBTableName("SPECIMEN") + " WHERE spec_id is not null AND slidecell_id > 0";
            Statement stmt = this.db.getDatabase().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                LinkedList<Integer> specIDs = new LinkedList<Integer>();
                while (rs.next()) {
                    int specID = rs.getInt("spec_id");
                    specIDs.add(specID);
                }
                linkedList = specIDs;
                if (stmt == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw SuppressedSQLException.withoutRollback(e);
                }
            }
            stmt.close();
        }
        return linkedList;
    }
}

