/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.user;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.SBTables;
import com.stratadata.model3.user.User;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.Audit;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellInterp;
import org.jdom2.Element;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SbugsLink;
import util.status.SbugsStatus;

public final class Userdef
implements SbugsStatus,
Comparable,
SbugsLink {
    public static final int USRIDLEN = 5;
    private static final String NO_PWD = "NOPASSWORD";
    private final SBdb sbdb;
    private final User user;
    private String sys_name = "";
    private String pwd = "NOPASSWORD";
    private Userdef link;
    private int priv = 0;
    private Audit audit = new Audit();
    private static final Logger LOGGER = Logger.getLogger(Userdef.class.getName());
    public static final int STBROWSE = 1;
    public static final int STUPDATE = 2;
    public static final int STDISCONLY = 4;
    public static final int STADDUSR = 64;
    public static final int STKEYUSR = 1024;
    public static final int STEXPORT = 16384;

    public Userdef getLink() {
        return this.link;
    }

    public String getLinkString() {
        Object strg = this.getNameID();
        if (this.link != null) {
            strg = !this.link.getNameID().equalsIgnoreCase((String)strg) ? "\u2794 " + (String)strg + " [\u2794 " + this.link.getLinkString() + "]" : "\u2794 " + (String)strg;
        }
        return strg;
    }

    private Userdef(SBdb sbdb, int userID) {
        this.sbdb = sbdb;
        this.user = new User(userID);
    }

    public static Userdef copyToWorkspace(SBdb ws, Userdef dbUser) throws SQLException {
        if (ws.isConnected() || !dbUser.sbdb.isConnected()) {
            throw new IllegalArgumentException("Attempt to copy userdef to connected workspace");
        }
        Userdef wsUser = ws.getUser(dbUser.getAbr());
        if (wsUser == null) {
            wsUser = new Userdef(ws, dbUser.getUserID());
            wsUser.user.setAbr(dbUser.getAbr());
            wsUser.user.setName(dbUser.getName());
            wsUser.user.setDiscipline(dbUser.getDiscipline());
            wsUser.link = dbUser;
            wsUser.priv = 3;
            ws.putUser(wsUser);
        }
        return wsUser;
    }

    public Discipline getDiscipline() {
        return this.user.getDiscipline();
    }

    public int getPriv() {
        return this.priv;
    }

    public boolean isReadOnly() {
        return (this.priv & 2) == 0;
    }

    public Color getColour() {
        return this.user.getColour();
    }

    public User getUserCopy() {
        return User.copy((User)this.user);
    }

    public static boolean isDisciplineRestricted(int priv) {
        return (priv & 4) > 0;
    }

    public static boolean isKeyUser(int priv) {
        return (priv & 0x400) > 0;
    }

    public static boolean isSuperUser(int priv) {
        return (priv & 0x40) > 0;
    }

    public static boolean isStandardUser(int priv) {
        return (priv & 2) > 0;
    }

    public static boolean canExportData(int priv) {
        return (priv & 0x4000) <= 0;
    }

    public static boolean canReadData(int priv) {
        return (priv & 1) > 0;
    }

    public Userdef(SBdb sbdb, int userID, String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv, Audit audit) {
        this.sbdb = sbdb;
        this.user = new User(userID);
        this.user.setAbr(abr != null ? abr.toUpperCase() : "");
        if (name.length() > 40) {
            name = name.substring(0, 40);
        }
        this.user.setName(name);
        this.sys_name = sysName;
        this.user.setColour(colour);
        this.priv = priv;
        this.user.setDiscipline(discID);
        this.pwd = pwd == null || pwd.isEmpty() ? NO_PWD : pwd;
        if (audit != null) {
            this.audit = audit;
        }
    }

    public Userdef(SBdb SB2, String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        this.sbdb = SB2;
        int usrID = this.sbdb.nextControl("USERDEF", "USER_ID");
        this.user = new User(usrID);
        this.user.setAbr(abr);
        this.user.setName(name);
        this.user.setColour(colour);
        this.user.setDiscipline(discID);
        this.sys_name = sysName;
        this.priv = priv;
        if (pwd != null) {
            this.pwd = SB.crypt((boolean)true, (String)"SBPW", (String)pwd);
        }
        this.store(usrID);
    }

    public void setFromLink() {
        if (this.link == null) {
            return;
        }
        this.user.setAbr(this.link.getAbr());
    }

    public void update(String abr, String name, String sysName, Discipline discID, Color colour, String pwd, int priv) throws SQLException, SBException {
        if (discID == null) {
            throw new SBException("Can't update Userdef to null discipline");
        }
        if (abr == null || abr.isEmpty()) {
            throw new SBException("Can't update Userdef to empty abr");
        }
        if (name == null) {
            name = abr;
        }
        Audit temp = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("USERDEF") + " SET name='" + name + "',abr='" + abr + "',sys_name='" + sysName + "',disc='" + Discipline.getChar((Discipline)discID) + "',user_priv=" + priv + ",colour=" + ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)true);
        if (this.sbdb.hasUserPassword()) {
            sql = sql + ",password='" + (pwd == null ? NO_PWD : SB.crypt((boolean)true, (String)"SBPW", (String)pwd)) + "'";
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            sql = sql + "," + temp.sqlUpdate(this.sbdb, stmt, false);
            sql = sql + " WHERE user_id=" + this.getUserID();
            if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1 && this.sbdb.getDBType() != DBType.MYSQL) {
                throw new SBException("Update statement failed: " + sql);
            }
        }
        this.user.setAbr(abr);
        this.user.setName(name);
        this.user.setColour(colour);
        this.user.setDiscipline(discID);
        this.sys_name = sysName;
        this.priv = priv;
        this.pwd = pwd != null ? SB.crypt((boolean)true, (String)"SBPW", (String)pwd) : null;
        this.audit = temp;
    }

    public String toString() {
        Object strg = this.getName();
        strg = (String)strg + " (" + this.getAbr() + ")";
        return strg;
    }

    public String getName() {
        return this.user.getName();
    }

    public String getNameID() {
        return this.getName() + " (" + this.getAbr() + ")";
    }

    public String getAbr() {
        return this.user.getAbr();
    }

    public int getUsrID() {
        return this.user.getUserID();
    }

    public int getUserID() {
        return this.user.getUserID();
    }

    public String getSysName() {
        return this.sys_name;
    }

    public String getPwd() {
        String retVal = null;
        if (this.pwd != null && !this.pwd.equals(NO_PWD)) {
            try {
                retVal = SB.crypt((boolean)false, (String)"SBPW", (String)this.pwd);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.WARNING, "Cannot decrypt password for: {0}, password was: {1}", new Object[]{this.toString(), this.pwd});
            }
        }
        return retVal;
    }

    public void setLink(Userdef user) {
        this.link = user;
    }

    private void store(int userID) throws SQLException {
        String sql = "INSERT INTO " + this.sbdb.DBTableName("USERDEF") + " (user_id,name,abr,sys_name,disc,user_priv,colour";
        if (this.sbdb.hasUserPassword()) {
            sql = sql + ",password";
        }
        sql = sql + "," + Audit.sqlFieldString();
        sql = sql + ") VALUES (" + userID + ",'" + this.getName() + "','" + this.getAbr() + "'," + SB.DBString((String)this.sys_name) + ",'" + Discipline.getChar((Discipline)this.getDiscipline()) + "'," + this.priv;
        if (this.getColour() == null) {
            this.user.setColour(Color.BLACK);
        }
        sql = sql + "," + ColourUtils.DBColourString((Color)this.getColour(), (boolean)false, (boolean)true);
        if (this.sbdb.hasUserPassword()) {
            sql = sql + ",'" + (this.pwd == null ? NO_PWD : this.pwd) + "'";
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            sql = sql + "," + this.audit.sqlInsert(this.sbdb, stmt);
            sql = sql + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWellIGDInterps(Well well) throws SQLException, SBException {
        well.loadInterps();
        String sql = "SELECT DISTINCT i.interp_id FROM " + this.sbdb.DBTableName("IGD") + " i WHERE (i.top_analy=" + this.getUserID() + " OR i.base_analy=" + this.getUserID() + ") AND well_id=" + well.getWellID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            ArrayList<WellInterp> occs = new ArrayList<WellInterp>();
            while (rs.next()) {
                int interpID = rs.getInt("interp_id");
                occs.add(well.getInterp(interpID));
            }
            ArrayList<WellInterp> arrayList = occs;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWellBiocomInterps(Well well) throws SQLException, SBException {
        well.loadInterps();
        String sql = "SELECT DISTINCT interp_id FROM " + this.sbdb.DBTableName("BCMMNTS") + " WHERE analyst=" + this.getUserID() + " AND well_id=" + well.getWellID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            ArrayList<WellInterp> occs = new ArrayList<WellInterp>();
            while (rs.next()) {
                int interpID = rs.getInt("interp_id");
                occs.add(well.getInterp(interpID));
            }
            ArrayList<WellInterp> arrayList = occs;
            return arrayList;
        }
    }

    public List getWellAnalyses(Well well) throws SQLException, SBException {
        LinkedList<Smpdtl> analyses = new LinkedList<Smpdtl>();
        well.loadAnalyses();
        for (Sample sample : well.getSamples()) {
            for (Smpdtl smpdtl : sample.getSmpdtls()) {
                if (smpdtl.getHeader().getAnalystUsrid() != this.getUserID()) continue;
                analyses.add(smpdtl);
            }
        }
        return analyses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWellOccs() throws SQLException, SBException {
        LinkedList<Integer> wellIDs = new LinkedList<Integer>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            Integer wellID;
            String sql = "SELECT DISTINCT (well_id) FROM " + this.sbdb.DBTableName("analy_hdr") + " WHERE analyst=" + this.getUserID();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellIDs.add(rs.getInt("well_id"));
            }
            sql = "SELECT DISTINCT (well_id) FROM " + this.sbdb.DBTableName("igd") + " WHERE top_analy=" + this.getUserID() + " OR base_analy=" + this.getUserID();
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellID = rs.getInt("well_id");
                if (wellIDs.contains(wellID)) continue;
                wellIDs.add(wellID);
            }
            sql = "SELECT DISTINCT (well_id) FROM " + this.sbdb.DBTableName("bcmmnts") + " WHERE analyst=" + this.getUserID();
            rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                wellID = rs.getInt("well_id");
                if (wellIDs.contains(wellID)) continue;
                wellIDs.add(wellID);
            }
            LinkedList<Well> wells = new LinkedList<Well>();
            Iterator it = wellIDs.iterator();
            while (it.hasNext()) {
                wells.add(this.sbdb.getWell((Integer)it.next()));
            }
            LinkedList<Well> linkedList = wells;
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Well> getAnalystHeaders() throws SQLException, SBException {
        ArrayList<Well> suites = new ArrayList<Well>();
        String sql = "SELECT DISTINCT(w.well_id) FROM " + this.sbdb.DBTableName("ANALY_HDR") + " a," + this.sbdb.DBTableName("WELLS") + " w WHERE a.analyst=" + this.getUserID() + " AND a.well_id=w.well_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                Well well = this.sbdb.getWell(wellID);
                well.getAnalystHeaders();
                suites.add(well);
            }
            ArrayList<Well> arrayList = suites;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnalyses() throws SQLException {
        String sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("analy_hdr") + " WHERE analyst=" + this.getUserID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            boolean hasData = false;
            if (rs.next()) {
                hasData = true;
            }
            boolean bl = hasData;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIGD() throws SQLException {
        boolean hasData = false;
        String sql = "SELECT DISTINCT (top_analy) FROM " + this.sbdb.DBTableName("igd") + " WHERE top_analy=" + this.getUserID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                hasData = true;
            }
            if (!hasData && (rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (base_analy) FROM " + this.sbdb.DBTableName("igd") + " WHERE base_analy=" + this.getUserID()))).next()) {
                hasData = true;
            }
            if (!hasData && (rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("bcmmnts") + " WHERE analyst=" + this.getUserID()))).next()) {
                hasData = true;
            }
            if (!hasData && (rs = stmt.executeQuery(this.sbdb.modQuery(sql = "SELECT DISTINCT (analyst) FROM " + this.sbdb.DBTableName("events") + " WHERE analyst=" + this.getUserID()))).next()) {
                hasData = true;
            }
            boolean bl = hasData;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountAudit() throws SQLException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        int nAudits = 0;
        String[] fields = new String[]{"updater", "modifier", "creator"};
        try {
            for (String table : SBTables.auditTables()) {
                for (String field : fields) {
                    String sql = "SELECT count(" + field + ") as n FROM " + this.sbdb.DBTableName(table) + " WHERE " + field + "=" + this.getUserID();
                    ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    if (rs.next()) {
                        nAudits += rs.getInt("n");
                    }
                    rs.close();
                }
            }
            int n = nAudits;
            return n;
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String[] fields = new String[]{"updater", "modifier", "creator"};
            for (String table : SBTables.auditTables()) {
                for (String field : fields) {
                    String sql = "UPDATE " + this.sbdb.DBTableName(table) + " SET " + field + "=null WHERE " + field + "=" + this.getUserID();
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
            String sql = "DELETE FROM " + this.sbdb.DBTableName("PREF_USER") + " WHERE user_id=" + this.getUserID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("CHTPREF_BLK") + " WHERE user_id=" + this.getUserID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("USERDEF") + " WHERE user_id=" + this.getUserID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Userdef> getUsers(SBdb sbdb) throws SQLException {
        LinkedList<Userdef> list = new LinkedList<Userdef>();
        Object sql = "SELECT user_id,name,abr,sys_name,disc,user_priv,colour,";
        if (sbdb.hasUserPassword()) {
            sql = (String)sql + "password,";
        }
        sql = (String)sql + Audit.sqlFieldString();
        sql = (String)sql + " FROM " + sbdb.DBTableName("USERDEF") + " ORDER BY abr";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery((String)sql));
            while (rs.next()) {
                try {
                    int priv;
                    int usrID = rs.getInt("user_id");
                    String name = rs.getString("name");
                    String abr = rs.getString("abr");
                    if (abr == null) {
                        throw new SBException("User ID is null for user: " + name);
                    }
                    String sys_name = rs.getString("sys_name");
                    String strg = rs.getString("disc");
                    Discipline discID = Discipline.MICRO;
                    if (strg != null && strg.length() > 0) {
                        discID = Discipline.getDisc((String)strg);
                    }
                    if (((priv = rs.getInt("user_priv")) & 0x40) > 0) {
                        if ((priv & 0x4000) > 0) {
                            LOGGER.log(Level.FINE, "Setting export priv for super-user");
                            priv ^= 0x4000;
                        }
                        if ((priv & 4) > 0) {
                            LOGGER.log(Level.FINE, "Setting discipline priv for super-user");
                            priv ^= 4;
                        }
                        if ((priv & 0x400) == 0) {
                            priv |= 0x400;
                        }
                    }
                    Color colour = Color.BLACK;
                    try {
                        colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    String pwd = "";
                    if (sbdb.hasUserPassword()) {
                        assert (abr != null);
                        pwd = rs.getString("password");
                    }
                    Audit audit = new Audit(rs);
                    list.add(new Userdef(sbdb, usrID, abr, name, sys_name, discID, colour, pwd, priv, audit));
                }
                catch (SBException sbe) {
                    LOGGER.log(Level.WARNING, sbe.getMessage());
                }
            }
        }
        return list;
    }

    static boolean checkUsrid(List users, String usrid) {
        for (Userdef user : users) {
            if (!user.getAbr().equalsIgnoreCase(usrid)) continue;
            return true;
        }
        return false;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public String statusString() {
        return this.getNameID();
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException, SQLException {
        String ind1 = SB.getXMLIndent((int)indent);
        String ind = SB.getXMLIndent((int)(indent + 3));
        Userdef user = this;
        out.write(ind1 + "<User Name=\"" + SB.getXMLstring((String)user.getName()) + "\">\n");
        out.write(ind + "<UserID>" + user.getUsrID() + "</UserID>\n");
        out.write(ind + "<UserName>" + SB.getXMLstring((String)user.getName()) + "</UserName>\n");
        out.write(ind + "<Abbreviation>" + user.getAbr() + "</Abbreviation>\n");
        out.write(ind + "<DisciplineID>" + user.getDiscipline().getChar() + "</DisciplineID>\n");
        out.write(ind1 + "</User>\n");
    }

    public Userdef(SBdb db, Element xml) throws SBException {
        this.sbdb = db;
        String strgID = xml.getChildTextNormalize("UserID");
        if (strgID == null) {
            throw new SBException("User ID null in XML - invalid");
        }
        this.user = new User(Integer.parseInt(strgID));
        this.user.setName(xml.getChildText("UserName"));
        this.user.setAbr(xml.getChildTextNormalize("Abbreviation"));
        String discipline = xml.getChildTextNormalize("DisciplineID");
        if (discipline != null && discipline.length() > 0) {
            this.user.setDiscipline(Discipline.getDisc((String)discipline));
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Userdef) {
            return this.getAbr().compareTo(((Userdef)o).getAbr());
        }
        return 0;
    }

    public Audit getAudit() {
        return this.audit;
    }
}

