/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well;

import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellHeader;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.ConnectionProvider;
import org.apache.commons.lang3.StringUtils;
import util.InvalidFieldException;
import util.SB;

public class WellSearchService {
    private final ConnectionProvider conn;

    public WellSearchService(ConnectionProvider conn) {
        this.conn = conn;
    }

    public List<WellHeader> search(WellHeader params) throws SQLException {
        String sql = "SELECT well_id,well_name,well_alt_name,well_code,country,field,basin,area,operator,client,county,loc_state,type,acm FROM " + this.conn.DBTableName("WELLS") + " w ";
        LinkedList<CallSite> sqlWhere = new LinkedList<CallSite>();
        if (params.getWellName().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ( ucase(well_name) like '" + params.getWellName().toUpperCase() + "' OR ucase(well_alt_name) like '" + params.getWellName().toUpperCase() + "' )")));
        }
        if (params.getWellCode().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)("ucase(w.well_code) like '" + params.getWellCode().toUpperCase() + "'")));
        }
        if (params.getCountry().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)("ucase(country) like '" + params.getCountry().toUpperCase() + "'")));
        }
        if (params.getField().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)("ucase(field) like '" + params.getField().toUpperCase() + "'")));
        }
        if (params.getBasin().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ucase(basin) like '" + params.getBasin().toUpperCase() + "'")));
        }
        if (params.getArea().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ucase(area) like '" + params.getArea().toUpperCase() + "'")));
        }
        if (params.getLocState().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ucase(locState) like '" + params.getLocState().toUpperCase() + "'")));
        }
        if (params.getCounty().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ucase(county) like '" + params.getCounty().toUpperCase() + "'")));
        }
        if (params.getOperator().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ucase(operator) like '" + params.getOperator().toUpperCase() + "'")));
        }
        if (params.getClient().compareTo("%") > 0) {
            sqlWhere.add((CallSite)((Object)(" ucase(client) like '" + params.getClient().toUpperCase() + "'")));
        }
        if (params.getSectionType() != null) {
            sqlWhere.add((CallSite)((Object)(" type='" + params.getSectionType().charType + "'")));
        }
        if (!sqlWhere.isEmpty()) {
            sql = sql + " WHERE " + StringUtils.join(sqlWhere, (String)" AND ");
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(w.well_code),ucase(country),ucase(field)";
        ArrayList<WellHeader> results = new ArrayList<WellHeader>();
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                WellHeader result = new WellHeader(wellID);
                result.setWellName(rs.getString("well_name"));
                result.setWellAltName(rs.getString("well_alt_name"));
                result.setWellCode(rs.getString("well_code"));
                result.setCountry(rs.getString("country"));
                result.setField(rs.getString("field"));
                result.setBasin(rs.getString("basin"));
                result.setArea(rs.getString("area"));
                result.setOperator(rs.getString("operator"));
                result.setClient(rs.getString("client"));
                result.setCounty(rs.getString("county"));
                result.setLocState(rs.getString("loc_state"));
                result.setSectionType(SectionType.getSectionType((char)SB.getDBChar((ResultSet)rs, (String)"type")));
                result.setAcm(rs.getInt("acm"));
                results.add(result);
            }
        }
        try {
            Collections.sort(results);
        }
        catch (RuntimeException ex) {
            Logger.getLogger(WellSearchService.class.getName()).log(Level.WARNING, "Error sorting well search results", ex);
        }
        return results;
    }

    public List<WellHeader> searchMaster(String wellName, String wellCode, String country) throws SQLException, InvalidFieldException {
        boolean clauseAdded = false;
        String sql = "SELECT well_name,well_code,country FROM " + this.conn.DBTableName("WELLS_MASTER") + " WHERE ";
        if (wellName.compareTo("%") > 0) {
            clauseAdded = true;
            sql = sql + " ucase(well_name) like '" + wellName.trim().toUpperCase() + "'";
        }
        if (wellCode.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = sql + " AND ";
            }
            clauseAdded = true;
            sql = sql + " ucase(well_code) like '" + wellCode.trim().toUpperCase() + "'";
        }
        if (country.compareTo("%") > 0) {
            if (clauseAdded) {
                sql = sql + " AND ";
            }
            clauseAdded = true;
            sql = sql + " ucase(country) like '" + country.trim().toUpperCase() + "'";
        }
        if (!clauseAdded) {
            throw new InvalidFieldException("No search terms specified.");
        }
        sql = sql + " ORDER BY ucase(well_name),ucase(well_code),ucase(country)";
        ArrayList<WellHeader> results = new ArrayList<WellHeader>();
        try (Statement stmt = this.conn.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.conn.modQuery(sql));
            while (rs.next()) {
                WellHeader result = new WellHeader(0);
                result.setWellName(rs.getString("well_name"));
                result.setWellCode(rs.getString("well_code"));
                result.setCountry(rs.getString("country"));
                results.add(result);
            }
        }
        return results;
    }
}

