/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.User;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import model3.AnalystHeader;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.Well;
import org.apache.commons.lang3.StringUtils;

public class AbundanceSchemeInformationService {
    private final SBdb db;
    private final UserService userService;

    public AbundanceSchemeInformationService(SBdb db, UserService userService) {
        this.db = db;
        this.userService = userService;
    }

    public List<Usage> getOccs(int abnSchID) throws SQLException {
        String sql = "SELECT t.WELL_ID, w.WELL_NAME, w.WELL_CODE, h.DISC_ID, h.ANALYST, h.ANALY_NO, t.ABUND, count(t.ABUND) as COUNT\nFROM $TAXONOCC t\nLEFT JOIN $ANALY_HDR h on (t.WELL_ID=h.WELL_ID AND t.ANALY_ID=h.ANALY_ID)\nLEFT JOIN $WELLS w on t.WELL_ID=w.WELL_ID\nWHERE h.ABNSCH_ID=$SCHID and t.ABUND is not null\nGROUP BY t.WELL_ID, w.WELL_NAME, w.WELL_CODE, h.DISC_ID, h.ANALYST, h.ANALY_NO, t.ABUND\nORDER BY w.WELL_NAME".replace("$TAXONOCC", this.db.DBTableName("TAXONOCC")).replace("$ANALY_HDR", this.db.DBTableName("ANALY_HDR")).replace("$WELLS", this.db.DBTableName("WELLS")).replace("$SCHID", "" + abnSchID);
        LinkedList<Usage> occs = new LinkedList<Usage>();
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                int wellID = rs.getInt("WELL_ID");
                String wellName = rs.getString("WELL_NAME");
                String wellCode = rs.getString("WELL_CODE");
                Discipline disc = Discipline.parseDisc((String)rs.getString("DISC_ID"));
                int userID = rs.getInt("ANALYST");
                int analyNo = rs.getInt("ANALY_NO");
                String abund = rs.getString("ABUND");
                int count = rs.getInt("COUNT");
                Usage.AbrUsage abrUsage = new Usage.AbrUsage(abund, count);
                if (!occs.isEmpty() && ((Usage)occs.getLast()).wellID == wellID && ((Usage)occs.getLast()).analyst.getUserID() == userID && ((Usage)occs.getLast()).analyNo == analyNo && ((Usage)occs.getLast()).discipline == disc) {
                    ((Usage)occs.getLast()).usages().add(abrUsage);
                    continue;
                }
                occs.add(new Usage(wellID, wellName, wellCode, disc, this.userService.findUser(userID).orElse(new User(0)), analyNo, new ArrayList<Usage.AbrUsage>(List.of(abrUsage))));
            }
        }
        return occs;
    }

    public int countAnalystHeaderUsages(int abnSchID) throws SQLException {
        if (abnSchID == 0) {
            return 0;
        }
        String sql = "SELECT count(analy_id) as nOcc FROM " + this.db.DBTableName("ANALY_HDR") + " WHERE abnsch_id=" + abnSchID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            int nOccs = 0;
            if (rs.next()) {
                nOccs = rs.getInt("nOcc");
            }
            int n = nOccs;
            return n;
        }
    }

    public HashMap<String, Integer> getUpdatedClassOccurrences(AbundanceScheme originalScheme, AbundanceScheme newScheme) throws SQLException {
        HashMap<String, Integer> changedClassOccurrences = new HashMap<String, Integer>();
        for (AbundanceScheme.AbundanceSchemeEntry entry : originalScheme.getEntries()) {
            boolean existsInNewScheme = newScheme.getEntries().stream().anyMatch(e -> e.abr().equalsIgnoreCase(entry.abr()));
            if (existsInNewScheme) continue;
            changedClassOccurrences.put(entry.abr(), this.getAbrOccs(originalScheme.getAbnSchID(), entry.abr()));
        }
        return changedClassOccurrences;
    }

    private int getAbrOccs(int abnSchID, String abr) throws SQLException {
        int nOccs = 0;
        String sql = "SELECT count(abund) AS nOccs FROM " + this.db.DBTableName("taxonocc") + " t, " + this.db.DBTableName("analy_hdr") + " h WHERE h.abnsch_id=" + abnSchID + " AND t.analy_id=h.analy_id AND h.well_id=t.well_id AND t.abund='" + abr + "'";
        try (Statement stmt = this.db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            if (rs.next()) {
                nOccs = rs.getInt("nOccs");
            }
            int n = nOccs;
            return n;
        }
    }

    public boolean hasAbnSchemeOccs(int abnSchID) throws SQLException {
        if (abnSchID < 1) {
            return false;
        }
        Iterator<Well> wit = this.db.getWellIterator();
        while (wit.hasNext()) {
            Well well = wit.next();
            LinkedList<AnalystHeader> selectedAnalystHeaders = new LinkedList<AnalystHeader>();
            Iterator<AnalystHeader> ait = well.getAnalystHeaderIterator();
            while (ait.hasNext()) {
                AnalystHeader header = ait.next();
                if (header.getAbnSchID() != abnSchID) continue;
                selectedAnalystHeaders.add(header);
            }
            for (Sample sample : well.getSamples()) {
                for (Smpdtl smpdtl : sample.getSmpdtls()) {
                    boolean process = false;
                    for (AnalystHeader header : selectedAnalystHeaders) {
                        if (header != smpdtl.getHeader()) continue;
                        process = true;
                        break;
                    }
                    if (!process) continue;
                    for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                        if (occ.getSubAbund() == null || occ.getSubAbund().length() <= 0 || occ.getSubAbund().equals("+")) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public record Usage(int wellID, String wellName, String wellCode, Discipline discipline, User analyst, int analyNo, List<AbrUsage> usages) {
        @Override
        public String toString() {
            return this.wellName + "/" + this.wellCode + ": " + this.discipline.getAbr(false) + "/" + this.analyst.getAbr() + "/" + this.analyNo + " (" + (String)(this.usages.isEmpty() ? "no usages" : StringUtils.join(this.usages, (String)", ") + ")");
        }

        public record AbrUsage(String abr, int nOccs) {
            @Override
            public String toString() {
                return this.abr;
            }
        }
    }
}

