/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.well.analysis.hdr;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.user.UserService;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeService;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import model3.SBRestrictable;
import model3.SBdb;
import model3.exception.SuppressedSQLException;
import util.SB;

public class AbundanceSchemeServiceDbImpl
implements AbundanceSchemeService {
    private final SBdb sbdb;
    private HashMap<Integer, AbundanceScheme> abundanceSchemes;

    public AbundanceSchemeServiceDbImpl(SBdb sbdb) {
        this.sbdb = sbdb;
    }

    public List<AbundanceScheme> getAllAbundanceSchemes() {
        this.initList();
        ArrayList<AbundanceScheme> schemes = new ArrayList<AbundanceScheme>(this.abundanceSchemes.values());
        Collections.sort(schemes);
        return schemes;
    }

    private void initList() {
        if (this.abundanceSchemes == null) {
            try {
                this.loadAll();
            }
            catch (SQLException e) {
                throw SuppressedSQLException.withoutRollback(e);
            }
        }
    }

    private void loadAll() throws SQLException {
        String sql = "SELECT s.SCHEME_ID as SCH_ID, s.NAME as SCH_NAME," + model3.Audit.sqlFieldStringNoAlias("s") + ", m.ENTRY_NO, m.ENTRY_NAME, m.ABR, m.MIN, m.OUTPUT_VAL FROM " + this.sbdb.DBTableName("ABNSCHME") + " s LEFT JOIN " + this.sbdb.DBTableName("ABNSCHMBR") + " m on s.SCHEME_ID = m.SCHEME_ID ORDER BY s.SCHEME_ID, m.ENTRY_NO";
        ArrayList<AbundanceSchemeImpl> schemes = new ArrayList<AbundanceSchemeImpl>();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            AbundanceSchemeImpl abundanceScheme = null;
            while (rs.next()) {
                Integer entryNo;
                int abnSchID = rs.getInt("SCH_ID");
                if (abundanceScheme == null || abnSchID != abundanceScheme.getAbnSchID()) {
                    AuditImpl audit = model3.Audit.getAuditFromResultSet(rs);
                    abundanceScheme = new AbundanceSchemeImpl(abnSchID, audit, Collections.emptyList());
                    abundanceScheme.setName(rs.getString("SCH_NAME"));
                    schemes.add(abundanceScheme);
                }
                if ((entryNo = rs.getObject("ENTRY_NO", Integer.class)) == null) continue;
                AbundanceScheme.AbundanceSchemeEntry entry = new AbundanceScheme.AbundanceSchemeEntry(rs.getString("ENTRY_NAME"), rs.getString("ABR"), rs.getInt("MIN"), rs.getInt("OUTPUT_VAL"));
                abundanceScheme.addEntry(entry);
            }
            Collections.sort(schemes);
            this.abundanceSchemes = new HashMap();
            schemes.forEach(scheme -> this.abundanceSchemes.put(scheme.getAbnSchID(), (AbundanceScheme)scheme));
        }
    }

    public int getAbundanceSchemeCount() {
        this.initList();
        return this.abundanceSchemes.size();
    }

    public AbundanceScheme addAbundanceScheme(AbundanceScheme scheme) {
        AbundanceSchemeImpl abundanceSchemeImpl;
        block10: {
            this.initList();
            if (scheme.getAbnSchID() != 0) {
                throw new IllegalStateException("Attempt to store abnScheme for pre-existing ID");
            }
            if (!SBRestrictable.canWrite(this.sbdb)) {
                throw new IllegalStateException(SBRestrictable.getDeniedReason(true));
            }
            int newID = this.sbdb.nextControl("ABNSCHME", "SCHEME_ID");
            Statement stmt = this.sbdb.getDatabase().createStatement();
            try {
                AuditImpl audit = AuditImpl.getAuditUpdate((Audit)scheme.getAudit(), (UserService)this.sbdb.getUserService(), (Instant)model3.Audit.getDatabaseServerDate(this.sbdb, stmt).toInstant(), (boolean)false);
                String sql = "INSERT INTO " + this.sbdb.DBTableName("ABNSCHME") + " ( scheme_id, name, " + model3.Audit.sqlFieldString() + " ) VALUES (" + newID + ",'" + scheme.getName() + "'," + model3.Audit.sqlInsert((Audit)audit) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                this.storeSchemeEntries(stmt, scheme.getEntries(), newID);
                this.sbdb.commit();
                AbundanceSchemeImpl storedScheme = new AbundanceSchemeImpl(newID, audit, scheme.getEntries());
                storedScheme.setName(scheme.getName());
                this.abundanceSchemes.put(storedScheme.getAbnSchID(), (AbundanceScheme)storedScheme);
                abundanceSchemeImpl = storedScheme;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw SuppressedSQLException.withRollback("Error storing abundance scheme", ex, this.sbdb);
                }
            }
            stmt.close();
        }
        return abundanceSchemeImpl;
    }

    private void storeSchemeEntries(Statement stmt, List<AbundanceScheme.AbundanceSchemeEntry> entries, int abnSchID) throws SQLException {
        for (int i = 0; i < entries.size(); ++i) {
            AbundanceScheme.AbundanceSchemeEntry entry = entries.get(i);
            String sql = "INSERT INTO " + this.sbdb.DBTableName("ABNSCHMBR") + " (scheme_id, entry_no, entry_name, abr, min, output_val) VALUES (" + abnSchID + "," + (i + 1) + ",'" + entry.entryName() + "','" + entry.abr() + "'," + entry.lowBound() + "," + entry.outputVal() + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public Optional<AbundanceScheme> findAbundanceScheme(int abnSchID) {
        this.initList();
        return Optional.ofNullable(this.abundanceSchemes.get(abnSchID));
    }

    public void updateAbundanceScheme(AbundanceSchemeImpl updatedScheme) {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new IllegalStateException(SBRestrictable.getDeniedReason(true));
        }
        this.initList();
        updatedScheme.validateEntries();
        updatedScheme.sortEntries();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            AuditImpl tempAudit = AuditImpl.getAuditUpdate((Audit)updatedScheme.getAudit(), (UserService)this.sbdb.getUserService(), (Instant)model3.Audit.getDatabaseServerDate(this.sbdb, stmt).toInstant(), (boolean)false);
            String sql = "UPDATE " + this.sbdb.DBTableName("ABNSCHME") + " SET name=" + SB.DBString((String)updatedScheme.getName()) + "," + model3.Audit.sqlUpdate((Audit)tempAudit) + " WHERE scheme_id=" + updatedScheme.getAbnSchID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("ABNSCHMBR") + " WHERE scheme_id=" + updatedScheme.getAbnSchID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            this.storeSchemeEntries(stmt, updatedScheme.getEntries(), updatedScheme.getAbnSchID());
            this.sbdb.commit();
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error updating abundance scheme", ex, this.sbdb);
        }
        this.abundanceSchemes.put(updatedScheme.getAbnSchID(), (AbundanceScheme)updatedScheme);
    }

    public void deleteAbundanceScheme(int abnSchID) {
        if (abnSchID == 0) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new IllegalStateException(SBRestrictable.getDeniedReason(true));
        }
        AbundanceScheme scheme = this.abundanceSchemes.get(abnSchID);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            List<CallSite> sql = List.of("UPDATE " + this.sbdb.DBTableName("ANALY_HDR") + " set abnsch_id=null WHERE abnsch_id=" + abnSchID, "DELETE FROM " + this.sbdb.DBTableName("ABNSCHMBR") + " WHERE scheme_id=" + abnSchID, "DELETE FROM " + this.sbdb.DBTableName("ABNSCHME") + " WHERE scheme_id=" + abnSchID);
            for (String string : sql) {
                stmt.executeUpdate(this.sbdb.modQuery(string));
            }
            this.sbdb.updateAuditTrail("ABNSCHEME", "DELETE " + String.valueOf(scheme != null ? scheme.getName() : Integer.valueOf(abnSchID)) + " [" + abnSchID + "]");
            this.sbdb.commit();
            this.abundanceSchemes.remove(abnSchID);
        }
        catch (SQLException ex) {
            throw SuppressedSQLException.withRollback("Error deleting abundance scheme", ex, this.sbdb);
        }
    }

    public void refreshAbundanceSchemes() throws SQLException {
        if (this.abundanceSchemes == null) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT scheme_id,updated FROM " + this.sbdb.DBTableName("ABNSCHME");
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashSet<Integer> keys = new HashSet<Integer>();
            while (rs.next()) {
                int key = rs.getInt("scheme_id");
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                AbundanceScheme abundanceScheme = this.abundanceSchemes.get(key);
                if (abundanceScheme != null) {
                    if (time == null || !abundanceScheme.getAudit().getUpdated().isBefore(((Date)time).toInstant())) continue;
                    this.load(key);
                    continue;
                }
                this.load(key);
            }
            if (keys.size() < this.abundanceSchemes.size()) {
                this.abundanceSchemes.keySet().retainAll(keys);
            }
        }
    }

    private void load(int abnSchID) throws SQLException {
        String sql = "SELECT s.NAME as SCH_NAME," + model3.Audit.sqlFieldStringNoAlias("s") + ", m.ENTRY_NO, m.ENTRY_NAME, m.ABR, m.MIN, m.OUTPUT_VAL FROM " + this.sbdb.DBTableName("ABNSCHME") + " s LEFT JOIN " + this.sbdb.DBTableName("ABNSCHMBR") + " m on s.SCHEME_ID = m.SCHEME_ID WHERE s.scheme_id=" + abnSchID + " ORDER BY m.ENTRY_NO";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            AbundanceSchemeImpl abundanceScheme = null;
            while (rs.next()) {
                Integer entryNo;
                if (abundanceScheme == null) {
                    AuditImpl audit = model3.Audit.getAuditFromResultSet(rs);
                    abundanceScheme = new AbundanceSchemeImpl(abnSchID, audit, Collections.emptyList());
                    abundanceScheme.setName(rs.getString("SCH_NAME"));
                }
                if ((entryNo = rs.getObject("ENTRY_NO", Integer.class)) == null) continue;
                AbundanceScheme.AbundanceSchemeEntry entry = new AbundanceScheme.AbundanceSchemeEntry(rs.getString("ENTRY_NAME"), rs.getString("ABR"), rs.getInt("MIN"), rs.getInt("OUTPUT_VAL"));
                abundanceScheme.addEntry(entry);
            }
            if (abundanceScheme != null) {
                this.abundanceSchemes.put(abnSchID, (AbundanceScheme)abundanceScheme);
            }
        }
    }
}

