/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.ws;

import com.stratadata.model3.audit.Audit;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.model3.taxon.process.TaxonAdd;
import com.stratadata.model3.user.User;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.ws.Workspace;
import com.stratadata.model3.ws.reader.ParsedWorkspace;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TxGroup;
import model3.Well;
import util.SBException;
import util.SBPermissionException;

public class LinkedWorkspace {
    private static final Logger LOGGER = Logger.getLogger(LinkedWorkspace.class.getName());
    private final ParsedWorkspace parsedWorkspace;
    public final Workspace sourceModel;
    public final SBdb targetModel;
    private final HashMap<Integer, Integer> userLink = new HashMap();
    private final HashMap<Integer, Integer> taxonLink = new HashMap();
    private final HashMap<Integer, Integer> abundanceSchemeLink = new HashMap();

    public LinkedWorkspace(ParsedWorkspace workspace, SBdb targetModel) {
        this.parsedWorkspace = workspace;
        this.sourceModel = workspace.getWorkspace();
        this.targetModel = targetModel;
        this.init();
    }

    private void init() {
        if (this.sourceModel.isConnected()) {
            throw new IllegalStateException("Source model connected in Linked Workspace");
        }
        if (!this.targetModel.isConnected()) {
            throw new IllegalStateException("Target model not connected in Linked Workspace");
        }
        this.sourceModel.getUserService().getAllUsers().forEach(user -> this.userLink.put(user.getUserID(), null));
        this.sourceModel.getTaxonService().getAllTaxa().forEach(taxon -> this.taxonLink.put(taxon.getSpecID(), null));
        this.sourceModel.getAbundanceSchemeService().getAllAbundanceSchemes().forEach(abundanceScheme -> this.abundanceSchemeLink.put(abundanceScheme.getAbnSchID(), null));
    }

    public boolean isLinked(Object o) {
        if (o instanceof User) {
            User u = (User)o;
            return this.userLink.get(u.getUserID()) != null;
        }
        if (o instanceof Taxon) {
            Taxon t = (Taxon)o;
            return this.taxonLink.get(t.getSpecID()) != null;
        }
        if (o instanceof AbundanceScheme) {
            AbundanceScheme abundanceScheme = (AbundanceScheme)o;
            return this.abundanceSchemeLink.get(abundanceScheme.getAbnSchID()) != null;
        }
        return false;
    }

    public void matchUnmatchedUsers() {
        for (User sourceUser : this.sourceModel.getUserService().getAllUsers()) {
            if (this.userLink.get(sourceUser.getUserID()) != null) continue;
            this.targetModel.getUserService().findUserByAbr(sourceUser.getAbr()).ifPresent(targetUser -> this.userLink.put(sourceUser.getUserID(), targetUser.getUserID()));
        }
    }

    public void addUnmatchedUsers() throws SQLException, SBException {
        for (User sourceUser : this.sourceModel.getUserService().getAllUsers()) {
            if (this.userLink.get(sourceUser.getUserID()) != null) continue;
            this.targetModel.getUserService().findUserByAbr(sourceUser.getAbr()).ifPresent(targetUser -> this.userLink.put(sourceUser.getUserID(), targetUser.getUserID()));
            if (this.userLink.get(sourceUser.getUserID()) != null || sourceUser.getName() == null || sourceUser.getDiscipline() == null) continue;
            this.userLink.put(sourceUser.getUserID(), this.targetModel.addUser(sourceUser.getAbr(), sourceUser.getName(), null, sourceUser.getDiscipline(), sourceUser.getColour(), null, 0).getUserID());
        }
    }

    public void setUserLink(int sourceUserID, Integer targetUserID) {
        this.sourceModel.getUserService().findUser(sourceUserID).orElseThrow(() -> new IllegalStateException("User not found in source model"));
        if (targetUserID != null) {
            this.targetModel.getUserService().findUser(targetUserID.intValue()).orElseThrow(() -> new IllegalStateException("User not found in target model"));
            this.userLink.put(sourceUserID, targetUserID);
        } else {
            this.userLink.remove(sourceUserID);
        }
    }

    public Optional<User> getUserLink(User sourceUser) {
        Integer targetUserID = this.userLink.get(sourceUser.getUserID());
        if (targetUserID != null) {
            return this.targetModel.getUserService().findUser(targetUserID.intValue());
        }
        return Optional.empty();
    }

    public boolean hasUnmatchedUsers() {
        return this.userLink.entrySet().stream().anyMatch(entry -> entry.getValue() == null);
    }

    private void checkUserLinks() {
        if (this.hasUnmatchedUsers()) {
            throw new IllegalStateException("Users not matched");
        }
    }

    public void setTaxonLink(int sourceSpecID, Integer targetSpecID) {
        this.sourceModel.getTaxonService().findTaxon(sourceSpecID).orElseThrow(() -> new IllegalStateException("Taxon not found in source model"));
        if (targetSpecID != null) {
            this.targetModel.getTaxonService().findTaxon(targetSpecID.intValue()).orElseThrow(() -> new IllegalStateException("Taxon not found in target model"));
            this.taxonLink.put(sourceSpecID, targetSpecID);
        } else {
            this.taxonLink.remove(sourceSpecID);
        }
    }

    public Optional<Taxon> getTaxonLink(Taxon sourceTaxon) {
        Integer targetSpecID = this.taxonLink.get(sourceTaxon.getSpecID());
        if (targetSpecID != null) {
            return this.targetModel.getTaxonService().findTaxon(targetSpecID.intValue());
        }
        return Optional.empty();
    }

    public String getDonorString(int specID) {
        return this.parsedWorkspace.getParsedTaxonInfo(specID).map(ParsedWorkspace.ParsedTaxonInfo::donorString).orElse("");
    }

    public void matchUnmatchedTaxa(boolean ignoreUnknownCategories) {
        for (Taxon wsTx : this.sourceModel.getTaxonService().getAllTaxa()) {
            if (this.taxonLink.get(wsTx.getSpecID()) != null) continue;
            Category cat = wsTx.getGenus().getCategory();
            if (cat.getMnemonic().isEmpty()) {
                cat = null;
            } else if (this.targetModel.getCategoryService().findCategory(cat.getMnemonic()).isEmpty()) {
                if (!ignoreUnknownCategories) continue;
                cat = null;
            }
            Taxon copy = Taxon.copy((Taxon)wsTx);
            copy.setGenus(Genus.copy((Genus)wsTx.getGenus()));
            copy.getGenus().setCategory(cat);
            List matchingTaxa = this.targetModel.getTaxonService().findMatchingTaxa(copy, null, SearchMode.LOOKUP);
            if (matchingTaxa.isEmpty() && !wsTx.getSpecies().isEmpty() && !wsTx.getSpecies().startsWith("sp.") && wsTx.getSubSpecies().isEmpty()) {
                String[] s = wsTx.getSpecies().split("\\s+");
                if (s.length > 1) {
                    String species = s[0];
                    int l = 1;
                    Object subSpec = s[l++];
                    while (l < s.length) {
                        subSpec = (String)subSpec + " " + s[l++];
                    }
                    copy.setSpecies(species);
                    copy.setSubSpecies((String)subSpec);
                    matchingTaxa = this.targetModel.getTaxonService().findMatchingTaxa(copy, null, SearchMode.LOOKUP);
                }
            } else if (matchingTaxa.isEmpty() && !wsTx.getSpecies().isEmpty() && !wsTx.getSubSpecies().isEmpty()) {
                String species = wsTx.getSpecies() + " " + wsTx.getSubSpecies();
                copy.setSpecies(species);
                copy.setSubSpecies("");
                matchingTaxa = this.targetModel.getTaxonService().findMatchingTaxa(copy, null, SearchMode.LOOKUP);
            }
            if (matchingTaxa.isEmpty()) continue;
            Taxon match = (Taxon)matchingTaxa.get(0);
            this.taxonLink.put(wsTx.getSpecID(), match.getSpecID());
            this.targetModel.getTaxonImageService().hasTypeImage(match.getSpecID());
        }
    }

    public int addUnmatchedTaxa() {
        this.checkUserLinks();
        this.matchUnmatchedTaxa(false);
        List<Integer> unmatchedSpecIDs = this.taxonLink.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).toList();
        int unknownCategory = 0;
        for (Integer specID : unmatchedSpecIDs) {
            Taxon sourceTaxon = (Taxon)this.sourceModel.getTaxonService().findTaxon(specID.intValue()).get();
            Optional<Category> category = this.targetModel.getCategoryService().findCategory(sourceTaxon.getGenus().getCategory().getMnemonic());
            if (category.isEmpty()) {
                Genus query = Genus.copy((Genus)sourceTaxon.getGenus());
                query.setCategory(null);
                List matchingGenera = this.targetModel.getGenusService().findMatchingGenera(query, SearchMode.LOOKUP);
                if (matchingGenera.size() == 1) {
                    category = Optional.of(((Genus)matchingGenera.get(0)).getCategory());
                }
            }
            if (category.isEmpty()) {
                ++unknownCategory;
                continue;
            }
            Genus targetGenus = new Genus(0, this.getAuditForTarget(sourceTaxon.getGenus().getAudit()));
            Genus.copyFields((Genus)targetGenus, (Genus)sourceTaxon.getGenus(), (boolean)false);
            Taxon targetTaxon = new Taxon(0, this.getAuditForTarget(sourceTaxon.getAudit()));
            Taxon.copyFields((Taxon)targetTaxon, (Taxon)sourceTaxon, (boolean)false);
            targetTaxon.setGenus(targetGenus);
            TaxonAdd txAdd = TaxonAdd.attemptAddWithoutConfirmations((TaxonService)this.targetModel.getTaxonService(), (GenusService)this.targetModel.getGenusService(), (Taxon)targetTaxon);
            if (txAdd.succeeded()) {
                this.taxonLink.put(specID, txAdd.getSpecID());
                continue;
            }
            LOGGER.log(Level.WARNING, "Failed taxon add: " + txAdd.getResult().resultMessage());
        }
        return unknownCategory;
    }

    private AuditImpl getAuditForTarget(Audit sourceAudit) {
        AuditImpl targetAudit = new AuditImpl();
        targetAudit.copyFields(sourceAudit);
        targetAudit.setCreatorID(this.userLink.get(sourceAudit.getCreatorID()).intValue());
        if (sourceAudit.getCreatorID() > 0) {
            targetAudit.setModifierID(this.userLink.get(sourceAudit.getModifierID()).intValue());
        }
        return targetAudit;
    }

    public void excludeTaxa(List<model3.Taxon> taxa) {
        try {
            Iterator<Well> it = this.sourceModel.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<Sample> sit = well.getSamples().iterator();
                while (sit.hasNext()) {
                    for (Smpdtl dtl : sit.next().getSmpdtls()) {
                        dtl.excludeOccur(taxa);
                    }
                }
            }
            for (TxGroup group : this.sourceModel.getTxGroups()) {
                group.deleteTaxa(taxa);
            }
        }
        catch (SBPermissionException pe) {
            throw new RuntimeException("Unexpected permission exception deleting taxa from group in workspace", pe);
        }
        catch (SQLException sql) {
            throw new RuntimeException("Unexpected exception loading samples in workspace", sql);
        }
        this.sourceModel.getTaxonService().deleteTaxa(taxa.stream().map(model3.Taxon::getSpecID).toList());
        taxa.forEach(taxon -> this.taxonLink.remove(taxon.getSpecID()));
    }
}

